/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.topn;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.TopNRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class TopNRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private TopNRecipeService service;
    private static Logger logger = Logger.getLogger((String)"dip.recipe.topn.status.computer");

    public TopNRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public TopNRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(authCtx, new StatusInitializer(), true);
    }

    private TopNRecipeStatus getEngineIndependentBaseStatus(AuthCtx authCtx, StatusInitializer init) throws IOException {
        TopNRecipePayloadParams params;
        TopNRecipeStatus status = new TopNRecipeStatus();
        try {
            FlowRecipe flowRecipe = new FlowRecipe(this.recipe);
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(flowRecipe));
            init.recipe = flowRecipe;
            params = this.service.loadParams(this.payload, this.recipe);
            assert (params != null);
            status.params = params;
            status.engineParams = params.engineParams;
            init.inputDS = init.activity.getSubgraph().getSingleSourceDataset().getMandatoryUnsafe(this.datasetsDAO);
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        this.checkParams(init, params, status);
        return status;
    }

    private TopNRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx, StatusInitializer init, boolean reportUnknownErrorsToStatus) throws IOException {
        TopNRecipePayloadParams params;
        TopNRecipeStatus status;
        block12: {
            RecipeEnginesPreferenceConfig repc;
            block11: {
                status = this.getEngineIndependentBaseStatus(authCtx, init);
                params = status.params;
                repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, params.enginesPreferences);
                try {
                    this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
                    this.performBasicCDEChecks(status, authCtx);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Find top matches in-database, then streaming of rows");
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    if (status.isInvalid()) break block11;
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
            if (!status.isInvalid()) {
                try {
                    this.makeRecipeSpecificEnginesStatus(authCtx, init, status);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Find top matches in-database, then streaming of rows");
                    if (status.selectedEngine == null && !status.isInvalid()) {
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No engine selected", new Object[0]);
                        return status;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    return status;
                }
                if (status.getSelectedSQLBasedEngine().queryBased) {
                    try {
                        init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
                        status.sql = this.service.generateSQL(init.activity, init.recipe, init.dialect, init.inputDS, params, "main", true);
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to generate SQL", (Throwable)e);
                        init.error = ExceptionUtils.getMessageWithCauses((Throwable)e);
                        if (!reportUnknownErrorsToStatus) break block12;
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to generate SQL: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                }
            }
        }
        if (!status.isInvalid() && params.preFilter != null && params.preFilter.enabled) {
            status.preFilter = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkFilter(params.preFilter, init.inputDS, init.dialect, status.preFilter, false);
        }
        if (!status.isInvalid() && params.computedColumns != null && !params.computedColumns.isEmpty()) {
            status.computedColumns = new RecipeStatus.StepStatus();
            boolean mustLowercaseColumns = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, status.getSelectedSQLBasedEngine());
            this.visualRecipesService.checkComputedColumns(params.computedColumns, init.inputDS.getSchema(), status.getSelectedSQLBasedEngine(), init.dialect, mustLowercaseColumns, status.computedColumns);
        }
        return status;
    }

    private void checkParams(StatusInitializer init, TopNRecipePayloadParams params, TopNRecipeStatus status) throws IOException {
        status.topn = new RecipeStatus.StepStatus();
        if (params.firstRows < 0 || params.lastRows < 0) {
            status.topn.withFatal(RecipeCodes.ERR_RECIPE_TOPN_NEGATIVE_ROW_NB, "Top N and Bottom M values cannot be negative.");
        }
        if (params.firstRows == 0 && params.lastRows == 0) {
            status.topn.withWarning(RecipeCodes.WARN_RECIPE_TOPN_ZERO_ROWS, "Both Top N and Bottom M are set to 0, there will be no rows in the main output.");
        }
        if (params.orders == null || params.orders.isEmpty()) {
            status.topn.withFatal(RecipeCodes.ERR_RECIPE_TOPN_NO_ORDER, "At least one order column must be set.");
        }
        status.retrievedColumns = new RecipeStatus.StepStatus();
        if (params.retrievedColumnsSelectionMode == TopNRecipePayloadParams.RetrievedColumnsSelectionMode.EXPLICIT && (params.retrievedColumns == null || params.retrievedColumns.isEmpty())) {
            status.retrievedColumns.withWarning(RecipeCodes.WARN_RECIPE_TOPN_NO_RETRIEVED_COLS, "No column selected to retrieve");
        }
        if (params.retrievedColumnsSelectionMode == TopNRecipePayloadParams.RetrievedColumnsSelectionMode.EXPLICIT) {
            Set<String> allPartitionColumns = this.getPartitionColumns(init, params, "main");
            if (this.service.hasRejectsOutput(this.recipe)) {
                allPartitionColumns.addAll(this.getPartitionColumns(init, params, "rejects"));
            }
            if (!allPartitionColumns.isEmpty()) {
                status.retrievedColumns.withWarning(RecipeCodes.WARN_RECIPE_TOPN_PARTITION_DIM_NOT_RETRIEVED, "Some partition columns ('" + StringUtils.join(allPartitionColumns, (String)"','") + "') are chosen not to be retrieved, by default all partition columns will be retrieved anyway.");
            }
        }
    }

    private Set<String> getPartitionColumns(StatusInitializer init, TopNRecipePayloadParams params, String role) throws IOException {
        Partition part;
        HashSet allPartitionColumns = Sets.newHashSet();
        Dataset outputDataset = this.service.getDatasetFromRole(this.recipe, role);
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDataset) && (part = init.activity.getSubgraph().getTargetPartition(init.activity.getSubgraph().getTargetDataset(outputDataset.getFullName()))) != null && !part.isNP() && !part.isAll() && outputDataset.getPartitioningSchema().isPartitioned()) {
            PartitioningScheme targetPartitionScheme = outputDataset.getPartitioningSchema();
            for (String col : targetPartitionScheme.getDimensionNames()) {
                if (params.retrievedColumnsSelectionMode != TopNRecipePayloadParams.RetrievedColumnsSelectionMode.ALL && params.retrievedColumns.contains(col)) continue;
                allPartitionColumns.add(col);
            }
        }
        return allPartitionColumns;
    }

    @Override
    public VisualSQLRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        TopNRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(authCtx, init, true);
            if (status.isInvalid()) {
                logger.warn((Object)"Recipe status is invalid. Try to generate query anyway:");
            }
            status.sql = this.service.generateSQL(init.activity, init.recipe, init.dialect, init.inputDS, status.params, "main", true);
        }
        return status;
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        boolean lowerCaseColumnsNames;
        TopNRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(authCtx, init, false);
            if (status.isInvalid()) {
                this.fixupStatusOutputInvalid(status);
                TopNRecipeStatus topNRecipeStatus = status;
                return topNRecipeStatus;
            }
        }
        TopNRecipePayloadParams params = status.params;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        Dataset inputDS = init.inputDS;
        SQLDialect dialect = init.dialect;
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(selectedEngine, params);
        }
        String preFilterSQLExpression = null;
        if (params.preFilter != null && params.preFilter.enabled) {
            status.preFilter = new RecipeStatus.StepStatus();
            boolean translateFully = selectedEngine.queryBased && !selectedEngine.type.equals("DSS");
            preFilterSQLExpression = this.visualRecipesService.checkFilter(params.preFilter, inputDS, dialect, status.preFilter, translateFully);
        }
        try {
            lowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, selectedEngine);
            status.outputSchemaBeforeOverride = this.service.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute output schema", (Throwable)e);
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute output schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return status;
        }
        if (status.isInvalid()) {
            this.fixupStatusOutputInvalid(status);
            return status;
        }
        this.checkOutputSchema(status, params, lowerCaseColumnsNames);
        if (this.needToComputeExecutionPlan(selectedEngine, status, request)) {
            boolean executionPlanFailed = false;
            String executionPlanErrMsg = null;
            try {
                status.executionPlan = this.getExecutionPlan(authCtx, inputDS, selectedEngine, status.sql, params.engineParams);
            }
            catch (ExecutionPlanService.HiveTableNotFound e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan, table not found in Hive metastore %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            catch (Exception e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                logger.info((Object)("Query:\n" + status.sql));
                executionPlanFailed = true;
                executionPlanErrMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan: %s", new Object[]{executionPlanErrMsg});
            }
            if (executionPlanFailed) {
                try {
                    this.investigateExecutionPlanFailure(status, init, executionPlanErrMsg, authCtx, preFilterSQLExpression);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to determe error cause", (Throwable)e);
                }
            }
        }
        if (init.error != null && !status.isInvalid()) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Unknown error: %s", new Object[]{init.error});
        }
        this.fixupStatusOutputInvalid(status);
        return status;
    }

    private void fixupStatusOutputInvalid(VisualSQLRecipeStatus status) {
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Failed to validate all recipe steps");
        }
    }

    private void makeRecipeSpecificEnginesStatus(AuthCtx authCtx, StatusInitializer init, TopNRecipeStatus status) {
        logger.info((Object)"Computing engine status for topn recipe");
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            if (!engine.isSelectable || !engine.queryBased) continue;
            try {
                SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
                this.service.generateSQL(init.activity, init.recipe, dialect, init.inputDS, status.params, "main", false);
            }
            catch (Exception e) {
                if (engine.type.equals("DSS")) {
                    RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    continue;
                }
                RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
            }
        }
    }

    private void checkOutputSchema(TopNRecipeStatus status, TopNRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        if (status.outputSchemaBeforeOverride != null) {
            status.outputSchema = new Schema(status.outputSchemaBeforeOverride);
            if (params.outputColumnNameOverrides != null) {
                HashSet<String> usedNames = new HashSet<String>();
                for (SchemaColumn sc : status.outputSchema.columns) {
                    String colName = sc.getName();
                    String overrideName = params.outputColumnNameOverrides.get(sc.getName());
                    if (StringUtils.isNotBlank((CharSequence)overrideName)) {
                        colName = lowerCaseColumnsNames ? overrideName.toLowerCase() : overrideName;
                        sc.setName(overrideName);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(colName = colName.toLowerCase())) && usedNames.contains(colName)) {
                        status.output.withFatal(RecipeCodes.ERR_RECIPE_TOPN_DUPLICATE_OUTPUT, "Duplicate name: '" + colName + "'");
                    }
                    usedNames.add(colName);
                }
            }
            if (status.outputSchema.columns.isEmpty()) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_EMPTY_OUTPUT_SCHEMA, "Empty output schema");
            }
        }
    }

    private void investigateExecutionPlanFailure(TopNRecipeStatus status, StatusInitializer init, String executionPlanErrMsg, AuthCtx authCtx, String preFilterSQLExpression) throws Exception {
        if (status.selectedEngine.type.equals("HIVE")) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, executionPlanErrMsg);
            return;
        }
        boolean errorOriginFound = false;
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(init.inputDS, init.dialect, status.params.engineParams);
        if (preFilterSQLExpression != null) {
            SelectQueryBuilder qb = new SelectQueryBuilder();
            qb.from(table, null);
            qb.where(ef.expr(preFilterSQLExpression));
            String sql = qb.toSQL(init.dialect);
            try {
                this.getExecutionPlan(authCtx, init.inputDS, status.getSelectedSQLBasedEngine(), sql, status.params.engineParams);
            }
            catch (Exception e) {
                logger.error((Object)"Prefilter execution failed:", (Throwable)e);
                logger.error((Object)sql);
                status.preFilter.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_TOPN_INVALID_FILTER, (String)this.formatDatabaseErrorMsg(e.getMessage(), init.dialect)).withPos(1, 0));
                errorOriginFound = true;
            }
        }
        if (!errorOriginFound) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
        }
    }

    private static class StatusInitializer {
        public Dataset inputDS;
        public SQLDialect dialect;
        public JobActivity activity;
        public FlowRecipe recipe;
        public String error;

        private StatusInitializer() {
        }
    }

    public static class TopNRecipeStatus
    extends VisualSQLRecipeStatus {
        RecipeStatus.StepStatus preFilter;
        RecipeStatus.StepStatus computedColumns;
        RecipeStatus.StepStatus topn;
        RecipeStatus.StepStatus retrievedColumns;
        TopNRecipePayloadParams params;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.preFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.preFilter);
            }
            if (this.computedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.computedColumns);
            }
            if (this.topn != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.topn);
            }
            if (this.retrievedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.retrievedColumns);
            }
            ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }
    }
}

