/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class LastBuildView
extends AbstractFlowTool.FlowView {
    @Autowired
    private ReadWriteJobsInternalDB jobsDBService;
    private LastBuildViewState state;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.lastBuild");

    public LastBuildView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized LastBuildViewState computeState() throws Exception {
        String nodeId;
        List retrievableKnowledges;
        List evaluationStores;
        List models;
        List folders;
        List<String> datasets;
        this.state = new LastBuildViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            datasets = this.datasetsDAO.listUsedNames(this.projectKey);
            folders = this.managedFolderDAO.listUnsafe(this.projectKey);
            models = this.savedModelsDAO.listUnsafe(this.projectKey);
            evaluationStores = this.modelEvaluationStoresDAO.listUnsafe(this.projectKey);
            retrievableKnowledges = this.retrievableKnowledgeDAO.listUnsafe(this.projectKey);
        }
        for (String datasetName : datasets) {
            FutureProgressState.checkInterrupt();
            nodeId = GraphIds.forDataset(this.projectKey, datasetName);
            this.computeTaggableObjectState(nodeId, ITaggingService.TaggableType.DATASET, datasetName);
        }
        for (ManagedFolder folder : folders) {
            FutureProgressState.checkInterrupt();
            nodeId = GraphIds.forManagedFolder(this.projectKey, folder.id);
            this.computeTaggableObjectState(nodeId, ITaggingService.TaggableType.MANAGED_FOLDER, folder.id);
        }
        for (SavedModel model : models) {
            FutureProgressState.checkInterrupt();
            nodeId = GraphIds.forSavedModel(this.projectKey, model.id);
            this.computeTaggableObjectState(nodeId, ITaggingService.TaggableType.SAVED_MODEL, model.id);
        }
        for (ModelEvaluationStore evaluationStore : evaluationStores) {
            FutureProgressState.checkInterrupt();
            nodeId = GraphIds.forModelEvaluationStore(this.projectKey, evaluationStore.id);
            this.computeTaggableObjectState(nodeId, ITaggingService.TaggableType.MODEL_EVALUATION_STORE, evaluationStore.id);
        }
        for (RetrievableKnowledge retrievableKnowledge : retrievableKnowledges) {
            FutureProgressState.checkInterrupt();
            nodeId = GraphIds.forRetrievableKnowledge(this.projectKey, retrievableKnowledge.id);
            this.computeTaggableObjectState(nodeId, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE, retrievableKnowledge.id);
        }
        return this.state;
    }

    private void computeTaggableObjectState(String nodeId, ITaggingService.TaggableType type, String objectId) {
        try {
            TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(this.projectKey, type, objectId);
            ReadOnlyJobsInternalDB.ObjectBuild lastBuild = this.jobsDBService.getLatestBuildForObject(ref);
            this.add(nodeId, lastBuild);
        }
        catch (Exception e) {
            logger.info((Object)String.format("Failed to get %s last build", type.toHumanReadableString()), (Throwable)e);
        }
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(String nodeId, ReadOnlyJobsInternalDB.ObjectBuild lastBuild) {
        this.state.valueByNode.put(nodeId, lastBuild);
    }

    public class LastBuildViewState
    implements AbstractFlowTool.FlowState {
        Map<String, ReadOnlyJobsInternalDB.ObjectBuild> valueByNode = new HashMap<String, ReadOnlyJobsInternalDB.ObjectBuild>();
        public Collection<String> focused = new HashSet<String>();
    }
}

