/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RecipesCodeEnvsView
extends AbstractFlowTool.FlowView {
    private RecipesCodeEnvsViewState state;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.codeenvs");

    public RecipesCodeEnvsView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized RecipesCodeEnvsViewState computeState() throws Exception {
        this.state = new RecipesCodeEnvsViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            CodeEnvSelector envSelector = new CodeEnvSelector();
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                String nodeId = GraphIds.forRecipe(sr.name);
                try {
                    RecipeCodeEnvsViewState codeEnv = this.getCodeEnvState(sr, envSelector);
                    if (codeEnv == null) continue;
                    this.state.valueByNode.put(nodeId, codeEnv);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get recipe settings", (Throwable)e);
                }
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private RecipeCodeEnvsViewState getCodeEnvState(SerializedRecipe sr, CodeEnvSelector envSelector) throws Exception {
        RecipeMeta meta = RecipeRegistry.getMeta(sr);
        if (meta instanceof MetaWithSelectableCodeEnv) {
            MetaWithSelectableCodeEnv metaWithSelectableCodeEnv = (MetaWithSelectableCodeEnv)((Object)meta);
            ParamsWithSelectableCodeEnv paramsWithSelectableCodeEnv = (ParamsWithSelectableCodeEnv)((Object)sr.getParamsAs(meta.paramsClass()));
            CodeEnvSelection envSelection = paramsWithSelectableCodeEnv.getCodeEnvSelection();
            RecipeCodeEnvsViewState state = new RecipeCodeEnvsViewState();
            state.envLang = metaWithSelectableCodeEnv.getEnvLang();
            state.envMode = envSelection.envMode;
            state.envName = envSelection.envName;
            try {
                state.selectedEnvName = envSelector.selectForRecipe(this.projectKey, metaWithSelectableCodeEnv.getEnvLang(), envSelection);
                state.preventedByProjectSettings = false;
            }
            catch (IllegalArgumentException e) {
                state.preventedByProjectSettings = true;
            }
            return state;
        }
        return null;
    }

    public class RecipesCodeEnvsViewState
    implements AbstractFlowTool.FlowState {
        Map<String, RecipeCodeEnvsViewState> valueByNode = new HashMap<String, RecipeCodeEnvsViewState>();
        public Collection<String> focused = new HashSet<String>();
    }

    public class RecipeCodeEnvsViewState {
        public CodeEnvModel.EnvLang envLang;
        public CodeEnvSelection.EnvMode envMode;
        public String envName;
        public boolean preventedByProjectSettings;
        public String selectedEnvName;
    }
}

