/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.utils.ColumnOrderedProcessorOutput;
import com.dataiku.dip.datalayer.utils.ColumnRebalanceApproximateProcessorOutput;
import com.dataiku.dip.datalayer.utils.ColumnSamplingProcessorOutput;
import com.dataiku.dip.datalayer.utils.FilterProcessorOutput;
import com.dataiku.dip.datalayer.utils.LimitProcessorOutput;
import com.dataiku.dip.datalayer.utils.RandomRatioSamplingProcessorOutput;
import com.dataiku.dip.datasets.AbstractSingleThreadPusher;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetOrdering;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.input.stream.StreamOrientedDatasetHandler;
import com.dataiku.dip.input.utils.CountingProcessorOutput;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Logger;

public class UniversalSingleThreadPusher
extends AbstractSingleThreadPusher {
    private StreamableDatasetSelection originalSelection;
    private TranslationService translationService;
    private static Logger logger = Logger.getLogger((String)"dku.input.push");

    public UniversalSingleThreadPusher(AuthCtx authCtx, Dataset dataset, ProcessorOutput finalOutput, ColumnFactory cf, RowFactory rf) {
        this(authCtx, dataset, finalOutput, cf, rf, false);
    }

    public UniversalSingleThreadPusher(AuthCtx authCtx, Dataset dataset, ProcessorOutput finalOutput, ColumnFactory cf, RowFactory rf, boolean count) {
        super(authCtx, dataset, cf, rf, count);
        this.finalOutput = finalOutput;
        this.translationService = (TranslationService)SpringUtils.getBean(TranslationService.class);
    }

    public static boolean push(AuthCtx authCtx, Dataset dataset, ProcessorOutput output, ColumnFactory cf, RowFactory rf) throws Exception {
        UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(authCtx, dataset, output, cf, rf);
        return pusher.push();
    }

    public static boolean push(AuthCtx authCtx, Dataset dataset, ProcessorOutput output, ColumnFactory cf, RowFactory rf, boolean count) throws Exception {
        UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(authCtx, dataset, output, cf, rf, count);
        return pusher.push();
    }

    public static boolean push(AuthCtx authCtx, Dataset dataset, StreamableDatasetSelection selection, ProcessorOutput output, ColumnFactory cf, RowFactory rf, WarningsContext warningsContext) throws Exception {
        UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(authCtx, dataset, output, cf, rf);
        pusher.setWarningsContext(warningsContext);
        pusher.setDatasetSelection(selection);
        return pusher.push();
    }

    public static boolean push(AuthCtx authCtx, Dataset dataset, StreamableDatasetSelection selection, ProcessorOutput output, ColumnFactory cf, RowFactory rf) throws Exception {
        UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(authCtx, dataset, output, cf, rf);
        pusher.setDatasetSelection(selection);
        return pusher.push();
    }

    public static UniversalSingleThreadPusher prepareForCount(AuthCtx authCtx, Dataset dataset, StreamableDatasetSelection selection, ProcessorOutput output, ColumnFactory cf, RowFactory rf) throws Exception {
        UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(authCtx, dataset, output, cf, rf, true);
        pusher.setDatasetSelection(selection);
        return pusher;
    }

    /*
     * Loose catch block
     */
    public boolean push() throws Exception {
        assert (this.finalOutput != null);
        if (this.originalSelection == null) {
            this.originalSelection = StreamableDatasetSelection.full();
        }
        DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(this.dataset);
        if (!this.originalSelection.ordering.enabled && meta.supportsReadOrdering()) {
            this.originalSelection.ordering = (DatasetOrdering)JSON.deepCopy((Object)this.dataset.getModel().readWriteOptions.defaultReadOrdering);
            logger.info((Object)("Using ordering from dataset: " + JSON.log((Object)this.originalSelection.ordering)));
        }
        try (DatasetHandler handler = DatasetHandlerFactory.build(this.authCtx, this.dataset);){
            InputFilter ifilter = this.buildInputFilter(this.originalSelection);
            FilterProcessorOutput filterOutput = null;
            List splits = null;
            if (ifilter != null) {
                FilterResultWithSplits result = handler.getFilterSplits(ifilter);
                if (result.getSplits().size() == 0) {
                    boolean bl = true;
                    return bl;
                }
                splits = result.getSplits();
                filterOutput = this.buildUnpluggedFilterOutput(ifilter, result);
            } else if (handler instanceof RowOrientedDatasetHandler) {
                splits = Lists.newArrayList((Object[])new RowsInputSplit[]{((RowOrientedDatasetHandler)handler).getSingleSplit()});
            } else if (handler instanceof StreamOrientedDatasetHandler) {
                splits = Lists.newArrayList((Object[])new InputSplit[]{((StreamOrientedDatasetHandler)handler).getSingleSplit()});
            } else {
                throw new Error("Impossible");
            }
            Object pushOutput = null;
            ExtractionLimit pushLimit = new ExtractionLimit(this.originalSelection.maxRecords, this.originalSelection.maxReadUncompressedBytes);
            pushLimit.ordering = this.originalSelection.ordering;
            pushLimit.samplingMethod = this.originalSelection.samplingMethod;
            pushLimit.samplingRatio = this.originalSelection.targetRatio;
            pushLimit.samplingSeed = this.originalSelection.seed;
            Object flushAfterPush = null;
            logger.info((Object)("USTP: push selection.method=" + String.valueOf(this.originalSelection.samplingMethod) + " records=" + this.originalSelection.maxRecords + " ratio=" + this.originalSelection.targetRatio + " col=" + this.originalSelection.column));
            switch (this.originalSelection.samplingMethod) {
                case COLUMN_BASED: {
                    pushLimit.maxRecords = -1L;
                    Object samplerToFinal = this.buildOutputForColumnBased(this.originalSelection, ifilter, this.finalOutput);
                    ((ColumnSamplingProcessorOutput)((Object)samplerToFinal)).setWarningsContext(this.warningsContext);
                    pushOutput = UniversalSingleThreadPusher.filterIfNeeded(filterOutput, (ProcessorOutput)samplerToFinal);
                    break;
                }
                case RANDOM_FIXED_NB: {
                    Object samplerToFinal;
                    if (handler.handlesSamplingMethodDuringPush(pushLimit)) {
                        this.wasSamplingPushedDownToDB = true;
                        samplerToFinal = this.finalOutput;
                    } else {
                        pushLimit.maxRecords = -1L;
                        samplerToFinal = this.buildOutputForRandomNb(this.originalSelection, ifilter, this.finalOutput);
                    }
                    pushOutput = UniversalSingleThreadPusher.filterIfNeeded(filterOutput, (ProcessorOutput)samplerToFinal);
                    break;
                }
                case RANDOM_FIXED_RATIO: {
                    Object samplerToFinal;
                    pushLimit.maxRecords = -1L;
                    if (handler.handlesSamplingMethodDuringPush(pushLimit)) {
                        this.wasSamplingPushedDownToDB = true;
                        samplerToFinal = this.finalOutput;
                    } else {
                        samplerToFinal = new RandomRatioSamplingProcessorOutput(this.finalOutput, this.originalSelection.targetRatio, this.originalSelection.seed);
                    }
                    pushOutput = UniversalSingleThreadPusher.filterIfNeeded(filterOutput, (ProcessorOutput)samplerToFinal);
                    break;
                }
                case HEAD_SEQUENTIAL: {
                    if (filterOutput != null) {
                        pushLimit.maxRecords = -1L;
                        filterOutput.setDownstream((ProcessorOutput)new LimitProcessorOutput(this.finalOutput, this.originalSelection.maxRecords));
                        pushOutput = filterOutput;
                        break;
                    }
                    pushOutput = this.finalOutput;
                    break;
                }
                case FULL: {
                    pushLimit.maxRecords = -1L;
                    pushOutput = UniversalSingleThreadPusher.filterIfNeeded(filterOutput, this.finalOutput);
                    break;
                }
                case CLASS_REBALANCE_TARGET_NB_APPROX: {
                    pushLimit.maxRecords = -1L;
                    CountMap<String> map = UniversalSingleThreadPusher.buildCountMap(this.authCtx, this.dataset, ifilter, -1L, this.originalSelection.column);
                    ColumnRebalanceApproximateProcessorOutput samplerToFinal = new ColumnRebalanceApproximateProcessorOutput(this.finalOutput, this.cf, this.originalSelection.column, this.originalSelection.maxRecords, map, this.originalSelection.seed);
                    pushOutput = UniversalSingleThreadPusher.filterIfNeeded(filterOutput, (ProcessorOutput)samplerToFinal);
                    break;
                }
                case CLASS_REBALANCE_TARGET_RATIO_APPROX: {
                    pushLimit.maxRecords = -1L;
                    CountMap<String> map = UniversalSingleThreadPusher.buildCountMap(this.authCtx, this.dataset, ifilter, -1L, this.originalSelection.column);
                    ColumnRebalanceApproximateProcessorOutput samplerToFinal = new ColumnRebalanceApproximateProcessorOutput(this.finalOutput, this.cf, this.originalSelection.column, this.originalSelection.targetRatio, map, this.originalSelection.seed);
                    pushOutput = UniversalSingleThreadPusher.filterIfNeeded(filterOutput, (ProcessorOutput)samplerToFinal);
                    break;
                }
                case COLUMN_ORDERED: {
                    Object samplerToFinal;
                    pushLimit.maxRecords = -1L;
                    if (this.originalSelection.maxRecords < 0L) {
                        pushOutput = UniversalSingleThreadPusher.filterIfNeeded(filterOutput, this.finalOutput);
                        break;
                    }
                    flushAfterPush = samplerToFinal = new ColumnOrderedProcessorOutput(this.finalOutput, this.dataset, this.cf, this.rf, this.originalSelection);
                    pushOutput = UniversalSingleThreadPusher.filterIfNeeded(filterOutput, (ProcessorOutput)samplerToFinal);
                    break;
                }
                case TAIL_SEQUENTIAL: 
                case STRATIFIED_TARGET_NB_EXACT: 
                case STRATIFIED_TARGET_RATIO_EXACT: 
                case RANDOM_FIXED_NB_EXACT: 
                case RANDOM_FIXED_RATIO_EXACT: {
                    throw new IllegalArgumentException("can't perform sampling of type " + String.valueOf(this.originalSelection.samplingMethod) + "  with streamable push");
                }
            }
            assert (pushOutput != null);
            String stateName = this.translationService.translate("UNIVERSAL_SINGLE_THREAD_PUSHER.LABEL.READING_RECORDS", "Reading records", new Object[0]);
            FutureProgressState state = this.originalSelection.maxRecords > 0L ? FutureProgress.pushState((String)stateName, (double)pushLimit.maxRecords, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.RECORDS) : FutureProgress.pushState((String)stateName, (double)-1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE);
            try {
                if (this.countProcessedRows) {
                    pushOutput = new CountingProcessorOutput((ProcessorOutput)pushOutput);
                }
                boolean pushSplits = this.pushSplits(handler, (ProcessorOutput)pushOutput, state, splits, pushLimit);
                if (flushAfterPush != null) {
                    ((ColumnOrderedProcessorOutput)flushAfterPush).flush();
                }
                if (this.countProcessedRows) {
                    this.processedRowCount = ((CountingProcessorOutput)((Object)pushOutput)).getCount();
                }
                boolean bl = pushSplits;
                return bl;
            }
            catch (Exception e) {
                logger.error((Object)"Push failed, cleanup resources", (Throwable)e);
                pushOutput.cancel();
                throw e;
            }
            finally {
                FutureProgress.popState();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public void setDatasetSelection(StreamableDatasetSelection selection) throws Exception {
        this.originalSelection = selection;
    }
}

