/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import org.apache.commons.lang.StringUtils;

public class AzureBlobDatasetTestHandler
extends FSLikeDatasetTestHandler {
    private final PasswordEncryptionService symetricCryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
    private static DKULogger logger = DKULogger.getLogger((String)"dku.input.azure");

    public AzureBlobDatasetTestHandler(AuthCtx authCtx, AbstractFSDatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) {
        super(authCtx, handlerForData, handlerForName, dataset);
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult result) throws Exception {
        try {
            BuiltinFSDatasets.AzureBlobDatasetConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.AzureBlobDatasetConfig.class);
            AzureConnection cnx = ConnectionsDAO.get().getMandatoryConnectionAs(this.handlerForData.authCtx, config.connection, AzureConnection.class);
            try (FSTestProvider testProvider = FSProviderFactory.getTestProvider(this.handlerForData.authCtx, "Azure", config, cnx);){
                result.connectionMetadata.putAll(testProvider.test(false));
            }
            if (StringUtils.isNotBlank((String)cnx.params.chcontainer) || StringUtils.isNotBlank((String)config.container)) {
                InputSplit sampleSplit = this.handlerForData.getSampleSplit();
                if (sampleSplit instanceof StreamsInputSplit) {
                    result.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
                }
                result.connectionOK = true;
                return sampleSplit;
            }
            logger.error((Object)"No container defined in Azure blob ! ");
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Azure blob container not defined");
        }
        catch (Exception e) {
            result.connectionError = new SerializedError((Throwable)e, false);
            logger.error((Object)"Error During connection to Azure blob : ", (Throwable)e);
            return null;
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        AzureBlobDatasetHandler handler = (AzureBlobDatasetHandler)this.handlerForData;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try {
            if (handler.getProvider().stat(newDatasetName) != null) {
                ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_MANAGED_UNSAFE_NAME, "Objects already already exists under key '%s', they may get overwritten", new Object[]{newDatasetName});
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to check if the new dataset name is safe", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Failed to check if the new dataset name is safe, there could be a problem with the database: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }
}

