/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.AmazonS3OutputStream;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.RetryingWrappedInputStream;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.logging.LimitedLogContext;
import com.dataiku.dip.logging.LimitedLogFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.DKUNumberUtils;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUTracedAction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.ClosedInputStream;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.exception.AwsServiceException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.regions.Region;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.S3Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.CommonPrefix;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.Delete;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.GetObjectRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.S3Exception;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.S3Object;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class S3FSProvider
implements BlobLikeFSProvider,
PathToURIConverter {
    public static final int MAX_LISTING = 3000;
    public static final int DEFAULT_UPLOAD_CHUNK_SIZE = 0xA00000;
    private static final Map<Pair<String, String>, String> cachedBucketLocation = Collections.synchronizedMap(Maps.newHashMap());
    private final EC2Connection conn;
    private final String bucket;
    private final String pathInBucket;
    private final AuthCtx authCtx;
    private final int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
    private S3Client s3Client;
    private static boolean brokenPithosS3 = !ApplicationConfigurator.isInSparkDriver() && "pithos".equals(ApplicationConfigurator.getProperty((String)"s3.provider", (String)""));
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fs.s3");
    private static DKULogger actionsLogger = DKULogger.getLogger((String)"dku.fs.s3.actions");

    private static Pair<String, String> getCachedBucketLocationKey(String connectionName, String bucket) {
        return new Pair((Object)connectionName, (Object)bucket);
    }

    private static String getCachedBucketLocation(String connectionName, String bucket) {
        return cachedBucketLocation.get(S3FSProvider.getCachedBucketLocationKey(connectionName, bucket));
    }

    private static boolean isBucketLocationCached(String connectionName, String bucket) {
        return cachedBucketLocation.containsKey(S3FSProvider.getCachedBucketLocationKey(connectionName, bucket));
    }

    private static void setCachedBucketLocation(String connectionName, String bucket, String location) {
        cachedBucketLocation.put(S3FSProvider.getCachedBucketLocationKey(connectionName, bucket), location);
    }

    private IOException transformIntoIOException(S3Exception access, String path) {
        if (S3FSProvider.isFileNotFound(access)) {
            return new FileNotFoundException(path);
        }
        if (access.awsErrorDetails() != null) {
            return new IOException("Failed to getObject: status=" + access.statusCode() + " code=" + access.awsErrorDetails().errorCode() + " message=" + access.getMessage(), access);
        }
        return new IOException("Failed to getObject: status=" + access.statusCode() + " message=" + access.getMessage(), access);
    }

    public S3FSProvider(AuthCtx authCtx, DSSConnection conn, String pathInBucket, String bucket) throws IOException, DKUSecurityException {
        this.authCtx = authCtx;
        assert (conn instanceof EC2Connection);
        this.conn = (EC2Connection)conn;
        this.bucket = bucket;
        this.s3Client = this.initClientIfNeeded();
        if (!S3FSProvider.isBucketLocationCached(conn.name, bucket) && this.conn.params.switchToRegionFromBucket) {
            this.getBucketLocation();
        }
        if (StringUtils.isBlank((String)bucket)) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_INVALID_CONFIG, "Bucket to read is not defined");
        }
        if ((pathInBucket = StringUtils.trimToEmpty((String)pathInBucket)).equals("..") || pathInBucket.contains("../") || pathInBucket.contains("/..")) {
            logger.error((Object)("Forbidden '..' segment in S3 filesystem path, path='" + pathInBucket + "'"));
            throw new DKUSecurityException("Forbidden '..' segment in S3 filesystem path").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        this.pathInBucket = PathUtils.makeLeadingNoTrailing((String)PathUtils.canonical((String)ChrootUtils.getChrootedPath(this.conn.params.chroot, pathInBucket, false)));
        logger.info((Object)("Created S3 FS provider bucket=" + bucket + " path=" + this.pathInBucket));
    }

    private IOException tryCode(String message, Exception e) {
        if (e instanceof CodedIOException) {
            return (CodedIOException)e;
        }
        if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"The specified bucket does not exist")) {
            return new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_BUCKET_DOES_NOT_EXIST, message, (Throwable)e);
        }
        return new IOException(message, e);
    }

    @Override
    public String getRootWithinBucket() {
        return this.pathInBucket;
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, DKUSecurityException {
        HashMap ret = Maps.newHashMap();
        ret.put("bucket", this.bucket);
        ret.put("root", this.pathInBucket);
        if (withSensitiveInfo && this.conn.detailsReadableBy(this.authCtx)) {
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = this.conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            ret.put("accessKey", cred.accessKey);
            ret.put("secretKey", cred.secretKey);
            ProxyUtils.applyProxySettings((ProxySettings)this.conn.getProxySettings(), (Map)ret);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized S3Client initClientIfNeeded() throws IOException {
        if (this.s3Client != null) {
            return this.s3Client;
        }
        logger.debug((Object)"No S3 client found, creating one");
        try (TracedAWSAction taa = new TracedAWSAction("createS3Client.atInit");){
            String candidateCachedLocation;
            if (S3FSProvider.isBucketLocationCached(this.conn.name, this.bucket) && this.conn.params.switchToRegionFromBucket && EC2Connection.Params.isRegion(candidateCachedLocation = S3FSProvider.getCachedBucketLocation(this.conn.name, this.bucket))) {
                logger.info((Object)("Using region for S3 client instantiation: " + candidateCachedLocation));
                this.s3Client = this.conn.getS3Client(this.authCtx, Region.of((String)candidateCachedLocation));
                logger.debug((Object)"Done creating S3 client");
                S3Client s3Client = this.s3Client;
                return s3Client;
            }
            this.s3Client = this.conn.getS3Client(this.authCtx);
            logger.debug((Object)"Done creating S3 client");
            S3Client s3Client = this.s3Client;
            return s3Client;
        }
        catch (Exception e) {
            throw this.tryCode("Failed to connect to S3", e);
        }
    }

    @Nullable
    protected FSPath getObject(String path, String prefix) throws IOException {
        block15: {
            assert (!path.startsWith("/"));
            assert (!path.isEmpty());
            String cleanPrefix = "/".equals(prefix) ? "" : prefix;
            int prefixLength = cleanPrefix.length();
            S3Client client = this.initClientIfNeeded();
            try {
                HeadObjectResponse meta = null;
                try (TracedAWSAction taa = new TracedAWSAction("getObjectMetadata.forGetObject", this.bucket, path);){
                    meta = client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(path).build());
                }
                if (!path.endsWith("/")) {
                    FSPath ret = new FSPath("/" + path.substring(Math.min(prefixLength, path.length())), meta.contentLength().longValue());
                    if (meta.lastModified() != null) {
                        ret.setLastModified(meta.lastModified().toEpochMilli());
                    }
                    return ret;
                }
            }
            catch (S3Exception e) {
                if (e.statusCode() == 404) break block15;
                if (brokenPithosS3 && e.statusCode() == 500) {
                    try {
                        client.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucket).build());
                    }
                    catch (NoSuchBucketException e1) {
                        return null;
                    }
                }
                throw this.tryCode("Failed to getObjectMetadata from S3 bucket=" + this.bucket + " path=" + path, (Exception)((Object)e));
            }
        }
        return null;
    }

    private ListObjectsV2Response createNextListing(S3Client s3Client, ListObjectsV2Request.Builder request, ListObjectsV2Response currentListing) {
        return s3Client.listObjectsV2((ListObjectsV2Request)request.continuationToken(currentListing.nextContinuationToken()).build());
    }

    private boolean isListingTruncated(ListObjectsV2Response listing) {
        return Boolean.TRUE.equals(listing.isTruncated());
    }

    public FSBrowsePath browse(String path, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException, CodedException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        FSBrowsePath ret = FSBrowsePath.makeRoot((String)path, (boolean)false);
        ret.exists = true;
        S3Client client = this.initClientIfNeeded();
        try {
            String fullPathInBucket;
            if (strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY || strategy == FSProvider.FSBrowseStrategy.FILE) {
                FSPath p;
                fullPathInBucket = this.makePath(path, false);
                FSPath fSPath = p = StringUtils.isNotBlank((String)fullPathInBucket) ? this.getObject(fullPathInBucket, this.pathInBucket) : null;
                if (p != null) {
                    ret.size = p.getSize();
                    ret.directory = false;
                    ret.lastModified = p.getLastModified();
                    return ret;
                }
            }
            int totalSize = 0;
            if (strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY || strategy == FSProvider.FSBrowseStrategy.DIRECTORY) {
                fullPathInBucket = this.makePath(path, true);
                String prefix = PathUtils.slashes((String)this.pathInBucket, (Boolean)false, (Boolean)true, (boolean)true, (String)"/");
                logger.info((Object)("Start S3 Browse ON bucketPath=" + this.pathInBucket + " prefix=" + prefix + " fullPath=" + fullPathInBucket + " strategy=" + strategy.name()));
                ListObjectsV2Request.Builder listRequestBuilder = ListObjectsV2Request.builder().bucket(this.bucket).delimiter("/");
                if ("/".equals(fullPathInBucket)) {
                    fullPathInBucket = "";
                }
                if (StringUtils.isNotBlank((String)fullPathInBucket)) {
                    listRequestBuilder.prefix(fullPathInBucket);
                }
                ListObjectsV2Response listing = null;
                try (TracedAWSAction taa = new TracedAWSAction("listObjects.forBrowse", fullPathInBucket);){
                    listing = client.listObjectsV2((ListObjectsV2Request)listRequestBuilder.build());
                }
                while (true) {
                    String relPath;
                    totalSize += listing.commonPrefixes().size() + listing.contents().size();
                    for (CommonPrefix folder : listing.commonPrefixes()) {
                        relPath = PathUtils.makeNotLeadingNoTrailing((String)folder.prefix().substring(fullPathInBucket.length()));
                        if ("/".equals(relPath) || relPath.isEmpty()) continue;
                        ret.children.add(FSBrowsePath.makeChild((FSBrowsePath)ret, (String)relPath, (boolean)true, (long)0L, (long)-1L));
                    }
                    for (S3Object sum : listing.contents()) {
                        relPath = PathUtils.makeNotLeadingNoTrailing((String)sum.key().substring(fullPathInBucket.length()));
                        if ("/".equals(relPath) || relPath.isEmpty()) continue;
                        long lastModified = this.getLastModified(sum, client);
                        ret.children.add(FSBrowsePath.makeChild((FSBrowsePath)ret, (String)relPath, (boolean)false, (long)sum.size(), (long)lastModified));
                    }
                    if (totalSize > 3000) {
                        logger.warn((Object)"Truncated S3 listing to 3000 files ...");
                        ret.truncated = true;
                        return ret;
                    }
                    if (!this.isListingTruncated(listing)) break;
                    listing = this.createNextListing(client, listRequestBuilder, listing);
                }
                logger.info((Object)"S3 enumeration done");
            }
            if (totalSize > 0) {
                ret.directory = true;
            } else {
                ret = new FSBrowsePath();
            }
            return ret;
        }
        catch (Exception e) {
            throw this.tryCode("Failed to browse S3 files", e);
        }
    }

    public S3FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings settings) {
        try {
            PathUtils.ensurePathStaysWithinRoot((String)prefix);
            List<FSPath> paths = this.enumerateFilesystem(prefix, settings);
            if (paths == null) {
                return S3FSEnumerationResult.fromNonExistingPrefix();
            }
            return S3FSEnumerationResult.fromPaths(settings.filter(paths));
        }
        catch (Exception e) {
            return S3FSEnumerationResult.fromError(e);
        }
    }

    public List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings settings) throws IOException {
        FSPath rootP;
        String fullPrefixInBucket = this.makePath(prefix, false);
        boolean bucketRoot = fullPrefixInBucket.isEmpty();
        String cleanPathInBucket = PathUtils.slashes((String)this.pathInBucket, (Boolean)false, (Boolean)true, (boolean)true, (String)"/");
        S3Client client = this.initClientIfNeeded();
        ArrayList<FSPath> ret = new ArrayList<FSPath>();
        FSPath fSPath = rootP = bucketRoot ? null : this.getObject(fullPrefixInBucket, cleanPathInBucket);
        if (rootP != null) {
            ret.add(rootP);
            return ret;
        }
        fullPrefixInBucket = this.makePath(prefix, true);
        try (LimitedLogContext pathIgnoredLogger = LimitedLogFactory.get((DKULogger)logger, (String)"s3IgnoredPath");){
            Object object;
            logger.info((Object)("Start S3 Enumeration ON bucketPath=" + cleanPathInBucket + " prefix=" + prefix + " fullPath=" + fullPrefixInBucket));
            ListObjectsV2Response listing = null;
            ListObjectsV2Request.Builder listObjectRequestBuilder = ListObjectsV2Request.builder().bucket(this.bucket);
            ListObjectsV2Request request = bucketRoot ? (ListObjectsV2Request)listObjectRequestBuilder.build() : (ListObjectsV2Request)listObjectRequestBuilder.prefix(fullPrefixInBucket).build();
            try (TracedAWSAction taa = new TracedAWSAction("listObjects.forEnumerate", this.bucket, fullPrefixInBucket);){
                listing = client.listObjectsV2(request);
            }
            long totalSize = 0L;
            while (true) {
                long chunkSize;
                if ((chunkSize = this.enumerateListing(settings, cleanPathInBucket, ret, totalSize, pathIgnoredLogger, listing, client)) >= 0L && this.isListingTruncated(listing)) {
                    totalSize += chunkSize;
                    try (TracedAWSAction taa = new TracedAWSAction("listNextBatchOfObjects.forEnumerate");){
                        listing = this.createNextListing(client, request.toBuilder(), listing);
                    }
                } else {
                    if (chunkSize < 0L) break;
                    totalSize += chunkSize;
                    break;
                }
                logger.info((Object)("continued, have " + ret.size() + " items, " + totalSize + " bytes"));
            }
            logger.info((Object)("S3 enumeration done, found " + ret.size() + " items, " + totalSize + " bytes"));
            if (ret.isEmpty() && !bucketRoot) {
                List<FSPath> chunkSize = null;
                return chunkSize;
            }
            FSPath exactPathFile = null;
            for (FSPath p : ret) {
                if (!p.path().equals(prefix)) continue;
                exactPathFile = p;
            }
            if (exactPathFile != null) {
                object = Lists.newArrayList((Object[])new FSPath[]{exactPathFile});
                return object;
            }
            object = ret;
            return object;
        }
    }

    private long enumerateListing(FSEnumerationSettings settings, String pathInBucket, List<FSPath> ret, long totalSize, LimitedLogContext pathIgnoredLogger, ListObjectsV2Response listing, S3Client client) throws CodedIOException {
        long chunkSize = 0L;
        List objectSummaries = listing.contents();
        for (S3Object obj : objectSummaries) {
            String relPath = obj.key().substring(pathInBucket.length() - 1);
            if (logger.isTraceEnabled()) {
                logger.traceV("enumerate from pathInBucket=%s - found objKey=%s relPath=%s", new Object[]{pathInBucket, obj.key(), relPath});
            }
            if (this.shouldSkipFile(relPath, settings)) continue;
            String filename = (relPath = PathUtils.slashes((String)relPath, (Boolean)true, (Boolean)false, (boolean)false, (String)"/")).substring(relPath.lastIndexOf(47) + 1);
            if (FSDatasetUtils.isBadFile(filename, settings.showHiddenFiles) || FSDatasetUtils.isBadPath(relPath)) {
                pathIgnoredLogger.log("Ignoring path " + relPath);
                continue;
            }
            FSPath fsPath = this.filePath(relPath, obj, client);
            if (fsPath.getSize() == 0L && settings.firstNonEmpty) continue;
            if (ret.size() + 1 > this.enumerationLimit) {
                throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this S3 location (> %d). Enumeration aborted.", this.enumerationLimit));
            }
            ret.add(fsPath);
            if (!settings.shouldStopEnumeration(ret, totalSize + (chunkSize += fsPath.getSize()))) continue;
            return -1L;
        }
        return chunkSize;
    }

    private boolean shouldSkipFile(String relPath, FSEnumerationSettings settings) {
        if (relPath.endsWith("/") || relPath.isEmpty()) {
            return true;
        }
        String relPathNoSlash = PathUtils.slashes((String)relPath, (Boolean)false, (Boolean)false, (boolean)true, (String)"");
        return !settings.selectionRules.includes(relPathNoSlash);
    }

    protected FSPath filePath(String relPath, S3Object summary, S3Client client) {
        long lastModified = this.getLastModified(summary, client);
        return new FSPath(relPath, summary.size().longValue(), lastModified);
    }

    private long getLastModified(S3Object summary, S3Client client) {
        long lastModified;
        if (summary.lastModified() != null) {
            lastModified = summary.lastModified().toEpochMilli();
        } else {
            try (TracedAWSAction taa = new TracedAWSAction("HeadObjectRequest.forGetLastModified", this.bucket, summary.key());){
                HeadObjectResponse meta = client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(summary.key()).build());
                lastModified = meta.lastModified() != null ? meta.lastModified().toEpochMilli() : 0L;
            }
        }
        return lastModified;
    }

    public FSPathOrDirectory stat(String path) throws IOException, CodedException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        String fullPathInBucket = this.makePath(path, false);
        String cleanPathInBucket = PathUtils.slashes((String)this.pathInBucket, (Boolean)false, (Boolean)true, (boolean)true, (String)"/");
        S3Client client = this.initClientIfNeeded();
        if (StringUtils.isEmpty((String)fullPathInBucket)) {
            return new FSPathOrDirectory(PathUtils.makeLeadingNoTrailing((String)path), 0L, -1L, true);
        }
        try {
            FSPath p = this.getObject(fullPathInBucket, cleanPathInBucket);
            if (p != null) {
                return new FSPathOrDirectory(p.path(), p.getSize(), p.getLastModified(), false);
            }
            fullPathInBucket = this.makePath(path, true);
            ListObjectsV2Request.Builder listRequestBuilder = ListObjectsV2Request.builder().bucket(this.bucket).delimiter("/");
            if ("/".equals(fullPathInBucket)) {
                fullPathInBucket = "";
            }
            if (StringUtils.isNotBlank((String)fullPathInBucket)) {
                listRequestBuilder.prefix(fullPathInBucket);
            }
            ListObjectsV2Response listing = null;
            try (TracedAWSAction taa = new TracedAWSAction("listObjects.forStat", this.bucket, fullPathInBucket);){
                listing = client.listObjectsV2((ListObjectsV2Request)listRequestBuilder.build());
            }
            if (listing.commonPrefixes().isEmpty() && listing.contents().isEmpty()) {
                return null;
            }
            return new FSPathOrDirectory(PathUtils.makeLeadingNoTrailing((String)path), 0L, -1L, true);
        }
        catch (Exception e) {
            throw this.tryCode("Failed to stat S3 path", e);
        }
    }

    private String makePath(String path, boolean isDir) {
        String cleanPath = PathUtils.concatLNT((String[])new String[]{this.pathInBucket, path});
        if (!cleanPath.startsWith(this.pathInBucket)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + this.pathInBucket));
        }
        return PathUtils.slashes((String)cleanPath, (Boolean)false, (Boolean)(isDir ? Boolean.valueOf(true) : null), (boolean)true, (String)"");
    }

    public EnrichedInputStream read(String prefix) throws IOException, CodedException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        String path = this.makePath(prefix, false);
        S3Client client = this.initClientIfNeeded();
        logger.info((Object)("Getting S3 stream on " + path));
        FSPath object = this.getObject(path, this.pathInBucket);
        if (object == null) {
            throw new IOException("No file at " + path);
        }
        return new S3LimitedEnrichedInputStream(client, prefix, object);
    }

    public OutputStream write(String path) throws IOException, CodedException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        String fullPathInBucket = this.makePath(path, false);
        int partSize = this.getPartSize();
        S3Client client = this.initClientIfNeeded();
        logger.info((Object)String.format("Writing S3 stream on %s with a part size of %s", fullPathInBucket, DKUNumberUtils.printSmartBytesSize(partSize)));
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.conn.name);
        boolean addCannedACL = this.conn.getDkuPropertiesAsParams().getBoolParam("dku.connection.s3.addBucketOwnerCannedACL", false);
        return new AmazonS3OutputStream(client, this.bucket, fullPathInBucket, partSize, addCannedACL, this.conn.params.encryptionMode.sseAlgorithm, this.conn.params.encryptionKeyId);
    }

    private DeleteObjectsRequest createDeleteObjectsRequest(String bucket, List<ObjectIdentifier> keys) {
        return (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete((Delete)Delete.builder().quiet(Boolean.valueOf(true)).objects(keys).build()).build();
    }

    public boolean deleteFile(String path) throws IOException, CodedException, DKUSecurityException {
        block7: {
            PathUtils.ensurePathStaysWithinRoot((String)path);
            ConnectionUtils.checkConnectionWritable(this.authCtx, this.conn.name);
            String fullPathInBucket = this.makePath(path, false);
            S3Client client = this.initClientIfNeeded();
            try {
                FSPath p = this.getObject(fullPathInBucket, this.pathInBucket);
                if (p == null) break block7;
                logger.info((Object)("Clearing S3 bucket " + this.bucket + " single-file " + fullPathInBucket));
                ArrayList<ObjectIdentifier> keys = new ArrayList<ObjectIdentifier>();
                keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(fullPathInBucket).build());
                DeleteObjectsRequest deleteReq = this.createDeleteObjectsRequest(this.bucket, keys);
                try (TracedAWSAction taa = new TracedAWSAction("deleteObjects.forDeleteRecursive1", this.bucket);){
                    client.deleteObjects(deleteReq);
                }
                return true;
            }
            catch (Exception e) {
                throw this.tryCode("Failed to delete S3 file, bucket=" + this.bucket + " path=" + fullPathInBucket, e);
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean deleteDirectory(String path) throws IOException, CodedException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.conn.name);
        fullPathInBucket = this.makePath(path, true);
        client = this.initClientIfNeeded();
        try {
            S3FSProvider.logger.info((Object)("Clearing S3 bucket " + this.bucket + " under " + fullPathInBucket));
            listing = null;
            listObjectRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket).prefix(fullPathInBucket).build();
            taa = new TracedAWSAction(new Object[]{"listObjects.forDeleteRecursive", this.bucket, fullPathInBucket});
            try {
                listing = client.listObjectsV2(listObjectRequest);
            }
            finally {
                taa.close();
            }
            n = 0;
            while (true) lbl-1000:
            // 3 sources

            {
                keys = new ArrayList<ObjectIdentifier>();
                for (S3Object obj : listing.contents()) {
                    keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(obj.key()).build());
                    ++n;
                }
                S3FSProvider.logger.info((Object)("Deleting " + keys.size() + " entries"));
                if (!keys.isEmpty()) {
                    deleteReq = this.createDeleteObjectsRequest(this.bucket, keys);
                    taa = new TracedAWSAction(new Object[]{"deleteObjects.forDeleteRecursive2", this.bucket});
                    try {
                        client.deleteObjects(deleteReq);
                    }
                    finally {
                        taa.close();
                    }
                }
                if (!this.isListingTruncated(listing)) ** break;
                S3FSProvider.logger.info((Object)"Continuing S3 enumeration");
                taa = new TracedAWSAction(new Object[]{"listNextBatchOfObjects.forDeleteRecursive2", this.bucket});
                try {
                    listing = this.createNextListing(client, listObjectRequest.toBuilder(), listing);
                }
                finally {
                    taa.close();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            S3FSProvider.logger.info((Object)("Done clearing: deleted " + n + " entries"));
        }
        catch (Exception e) {
            throw this.tryCode("Failed to delete S3 path, bucket=" + this.bucket + " path=" + fullPathInBucket, e);
        }
        return true;
    }

    public void deleteRecursive(String path) throws IOException, CodedException, DKUSecurityException {
        if (this.deleteFile(path)) {
            return;
        }
        this.deleteDirectory(path);
    }

    private void copy(S3Client client, String fromBucket, String fromFile, String toBucket, String toFile) {
        CopyObjectRequest.Builder req = CopyObjectRequest.builder().sourceBucket(fromBucket).sourceKey(fromFile).destinationBucket(toBucket).destinationKey(toFile);
        if (this.conn.params.encryptionMode == S3DatasetHandler.EncryptionMode.SSE_KMS && StringUtils.isNotBlank((String)this.conn.params.encryptionKeyId)) {
            req.ssekmsKeyId(this.conn.params.encryptionKeyId);
            req.serverSideEncryption(this.conn.params.encryptionMode.sseAlgorithm.toString());
        }
        client.copyObject((CopyObjectRequest)req.build());
    }

    public void move(String from, String to, boolean isDirectory) throws IOException, CodedException, DKUSecurityException {
        block8: {
            PathUtils.ensurePathStaysWithinRoot((String)from);
            PathUtils.ensurePathStaysWithinRoot((String)to);
            String fullFromPathInBucket = this.makePath(from, isDirectory);
            String fullToPathInBucket = this.makePath(to, isDirectory);
            if (fullFromPathInBucket.equals(fullToPathInBucket)) {
                return;
            }
            FSDatasetUtils.checkDestPathDoesNotExist(to, this.stat(to), isDirectory);
            S3Client client = this.initClientIfNeeded();
            try {
                FSPath p = this.getObject(fullFromPathInBucket, this.pathInBucket);
                if (p != null) {
                    this.copy(client, this.bucket, fullFromPathInBucket, this.bucket, fullToPathInBucket);
                    client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket).key(fullFromPathInBucket).build());
                    break block8;
                }
                ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket).prefix(fullFromPathInBucket).build();
                ListObjectsV2Response listing = client.listObjectsV2(listObjectsV2Request);
                List objects = listing.contents();
                if (objects.isEmpty()) {
                    return;
                }
                while (true) {
                    ArrayList<ObjectIdentifier> keys = new ArrayList<ObjectIdentifier>();
                    logger.info((Object)("Renaming " + objects.size() + " objects"));
                    for (S3Object obj : objects) {
                        this.copy(client, this.bucket, obj.key(), this.bucket, fullToPathInBucket + obj.key().substring(fullFromPathInBucket.length()));
                        keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(obj.key()).build());
                    }
                    DeleteObjectsRequest deleteReq = this.createDeleteObjectsRequest(this.bucket, keys);
                    client.deleteObjects(deleteReq);
                    if (this.isListingTruncated(listing)) {
                        logger.info((Object)"Continuing S3 renaming");
                        listing = this.createNextListing(client, listObjectsV2Request.toBuilder(), listing);
                        objects = listing.contents();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw this.tryCode("Failed to move S3 path", e);
            }
        }
    }

    public void moveDirectory(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.move(from, to, true);
    }

    public void moveFile(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.move(from, to, false);
    }

    public void setLastModified(String path, long lastModified) throws IOException {
        throw new UnsupportedOperationException("Set last modified on S3 is not supported");
    }

    public synchronized void close() {
        if (this.s3Client != null) {
            logger.debug((Object)"Closing s3 client");
            this.s3Client.close();
            this.s3Client = null;
        }
    }

    @Override
    public boolean fileExists(String path) throws IOException {
        boolean bl;
        String fullPathInBucket = this.makePath(path, false);
        S3Client client = this.initClientIfNeeded();
        TracedAWSAction taa = new TracedAWSAction("getObjectMetadata.forFileExists", this.bucket, fullPathInBucket);
        try {
            client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(fullPathInBucket).build());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    taa.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (S3Exception access) {
                if (!S3FSProvider.isFileNotFound(access)) {
                    throw access;
                }
                return false;
            }
        }
        taa.close();
        return bl;
    }

    @Override
    public void waitUntilReadable(String path) throws IOException, CodedException {
        long started = System.currentTimeMillis();
        while (true) {
            logger.info((Object)("Waiting for S3 write to complete, path=" + path));
            if (this.fileExists(path)) {
                return;
            }
            if (System.currentTimeMillis() - started >= 10000L) {
                throw new IOException("timeout waiting for S3 write to complete, path=" + path);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("interrupted while waiting for S3 write to complete, path=" + path, e);
            }
        }
    }

    static boolean isFileNotFound(S3Exception e) {
        if (e.statusCode() != 404) {
            return false;
        }
        if (e.getMessage().contains("Not Found")) {
            return true;
        }
        if (e.awsErrorDetails() == null || e.awsErrorDetails().errorCode() == null) {
            return brokenPithosS3;
        }
        return e instanceof NoSuchKeyException || e instanceof NoSuchBucketException;
    }

    public String getBucketLocation() throws IOException {
        String bucketLocation;
        if (this.conn.params.hasCustomEndpoint()) {
            return null;
        }
        if (this.conn.params.hasRegion() && !this.conn.params.switchToRegionFromBucket) {
            return this.conn.params.regionOrEndpoint;
        }
        if (S3FSProvider.isBucketLocationCached(this.conn.name, this.bucket)) {
            return S3FSProvider.getCachedBucketLocation(this.conn.name, this.bucket);
        }
        S3Client client = this.initClientIfNeeded();
        try (TracedAWSAction taa = new TracedAWSAction("getBucketLocation.atInit", this.bucket);){
            logger.info((Object)"Retrieving location from bucket");
            bucketLocation = client.getBucketLocation((GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(this.bucket).build()).locationConstraintAsString();
        }
        catch (AwsServiceException awsException) {
            logger.warn((Object)("Failed to get bucket location due to AWS Exception: " + ExceptionUtils.getMessageWithCauses((Throwable)awsException)));
            S3FSProvider.setCachedBucketLocation(this.conn.name, this.bucket, null);
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"Error setting endpoint to bucket location", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)bucketLocation)) {
            logger.info((Object)"Bucket location is US, using us-east-1");
            S3FSProvider.setCachedBucketLocation(this.conn.name, this.bucket, Region.US_EAST_1.id());
            return Region.US_EAST_1.id();
        }
        if (bucketLocation.equals("EU")) {
            logger.info((Object)"Bucket location is EU, using eu-west-1");
            S3FSProvider.setCachedBucketLocation(this.conn.name, this.bucket, Region.EU_WEST_1.id());
            return Region.EU_WEST_1.id();
        }
        logger.info((Object)("Bucket is in location " + bucketLocation));
        S3FSProvider.setCachedBucketLocation(this.conn.name, this.bucket, bucketLocation);
        return bucketLocation;
    }

    public String convertPathToURI(String path) {
        String scheme = this.conn.params.hdfsInterface == S3DatasetHandler.HDFSInterface.EMRFS ? "s3://" : "s3a://";
        return scheme + this.bucket + PathUtils.slashes((String)(this.pathInBucket + "/" + path), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
    }

    private int getPartSize() {
        int partSize = ApplicationConfigurator.getProperty((String)"dku.s3.upload.multipart.chunk.size", (int)0xA00000);
        if (partSize < 0x500000) {
            throw new IllegalArgumentException("Invalid value found in 'dku.s3.upload.multipart.chunk.size' property. Expected a value equal to or larger than 5242880 (5 MB) but found: " + partSize);
        }
        return partSize;
    }

    static class TracedAWSAction
    extends DKUTracedAction {
        TracedAWSAction(Object ... objects) {
            this.init(actionsLogger, "dku.fs.s3.actions", "S3", objects);
        }
    }

    static class S3FSEnumerationResult
    extends AbstractFSEnumerationResult {
        public S3FSEnumerationResult() {
        }

        public S3FSEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public S3FSEnumerationResult(Throwable error) {
            super(error);
        }

        private static S3FSEnumerationResult fromError(Throwable error) {
            return new S3FSEnumerationResult(error);
        }

        private static S3FSEnumerationResult fromPaths(List<FSPath> paths) {
            return new S3FSEnumerationResult(paths);
        }

        private static S3FSEnumerationResult fromNonExistingPrefix() {
            return new S3FSEnumerationResult();
        }
    }

    class S3LimitedEnrichedInputStream
    extends AutoEnrichedInputStream {
        private final String path;
        private final S3Client s3Client;

        public S3LimitedEnrichedInputStream(S3Client s3Client, String pathWithinProvider, FSPath path) throws IOException {
            super(path.getSize(), pathWithinProvider, FilenameUtils.getName((String)path.path()), path.path(), () -> path.getLastModified());
            this.s3Client = s3Client;
            this.path = PathUtils.slashes((String)(S3FSProvider.this.pathInBucket + "/" + String.valueOf(path)), (Boolean)false, (Boolean)false, (boolean)true, (String)"/");
            logger.info((Object)("Path to read " + S3FSProvider.this.pathInBucket + "|" + String.valueOf(path) + " -> " + this.path));
        }

        protected InputStream getBasicInputStream() throws IOException, CodedException {
            return this.getBasicHeadInputStream(this.size());
        }

        protected InputStream getBasicHeadInputStream(long requestSize) throws IOException, CodedException {
            RetryingWrappedInputStream retryingWrappedInputStream;
            S3FSProvider.this.initClientIfNeeded();
            if (requestSize == 0L) {
                try (TracedAWSAction taa = new TracedAWSAction("getObjectMetadata.forBasicHeadInputStream", S3FSProvider.this.bucket, this.path);){
                    this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(S3FSProvider.this.bucket).key(this.path).build());
                }
                catch (S3Exception access) {
                    throw S3FSProvider.this.transformIntoIOException(access, this.path);
                }
                return new ClosedInputStream();
            }
            final GetObjectRequest.Builder getObjectRequestBuilder = GetObjectRequest.builder().bucket(S3FSProvider.this.bucket).key(this.path);
            Long rangeMax = null;
            try {
                long len = this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(S3FSProvider.this.bucket).key(this.path).build()).contentLength();
                if (len == 0L) {
                    return new ClosedInputStream();
                }
                if (requestSize > 0L) {
                    rangeMax = Math.min(requestSize, len) - 1L;
                    String range = String.format("bytes=%d-%d", 0, rangeMax);
                    getObjectRequestBuilder.range(range);
                }
            }
            catch (S3Exception access) {
                throw S3FSProvider.this.transformIntoIOException(access, this.path);
            }
            TracedAWSAction taa = new TracedAWSAction("getObjectContent.forBasicHeadInputStream", getObjectRequestBuilder);
            try {
                final String rangeMaxStr = rangeMax == null ? "" : Long.toString(rangeMax);
                retryingWrappedInputStream = new RetryingWrappedInputStream(){

                    @Override
                    protected InputStream streamFrom(Long pos) {
                        logger.info((Object)("read with pos=" + pos));
                        return pos == null ? S3LimitedEnrichedInputStream.this.s3Client.getObject((GetObjectRequest)getObjectRequestBuilder.build()) : S3LimitedEnrichedInputStream.this.s3Client.getObject((GetObjectRequest)getObjectRequestBuilder.range(String.format("bytes=%d-%s", pos, rangeMaxStr)).build());
                    }
                };
            }
            catch (Throwable throwable) {
                try {
                    try {
                        taa.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (S3Exception access) {
                    throw S3FSProvider.this.transformIntoIOException(access, this.path);
                }
            }
            taa.close();
            return retryingWrappedInputStream;
        }
    }
}

