/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.mongodb;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.mongodb.MongoDBConnectionWrapper;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.bson.json.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;

public class MongoDBDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private TransactionService transactionService;
    private MongoDBDatasetHandler handler;
    private final AuthCtx authCtx;
    private static final Pattern startWithAlphanumOrUnderscore = Pattern.compile("^[a-zA-Z_]");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.mongodb");

    public MongoDBDatasetTestHandler(AuthCtx authCtx, MongoDBDatasetHandler handler) {
        this.authCtx = authCtx;
        this.handler = handler;
    }

    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            finally {
                this.handler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TestResult test(String projectKey, Dataset dataset, boolean connectionOnly, boolean forConsistencyCheck, boolean inferStorageTypes) throws Exception {
        if (!MongoDBDatasetHandler.META.getType().equals(dataset.getType())) {
            throw new IllegalArgumentException("Incorrect dataset type");
        }
        logger.info((Object)("Testing, dataset = " + dataset.getName() + " connectionOnly = " + connectionOnly));
        TestResult result = new TestResult();
        result.testedConnectionOnly = true;
        try (DatasetHandler dhForName = DatasetHandlerFactory.build(this.authCtx, dataset);){
            result.suggestedName = DatasetInspector.slufigyAndUnicize(projectKey, dhForName.suggestName(), this.dao, this.transactionService);
        }
        MongoDBDatasetHandler.Config config = dataset.getParamsAs(MongoDBDatasetHandler.Config.class);
        if (StringUtils.isBlank((String)config.connection)) {
            throw new IllegalArgumentException("missing connection name");
        }
        if (StringUtils.isBlank((String)config.collection) && dataset.isManaged()) {
            throw new IllegalArgumentException("missing collection name");
        }
        try (MongoDBConnectionWrapper mongoConn = null;){
            Object queryParam;
            try {
                mongoConn = MongoDBConnectionWrapper.get(this.authCtx, config.connection);
                if (!dataset.isManaged()) {
                    ArrayList<String> collectionList = new ArrayList<String>();
                    for (String coll : mongoConn.db.listCollectionNames()) {
                        if (coll.startsWith("system.")) continue;
                        collectionList.add(coll);
                    }
                    result.collectionList = collectionList;
                } else {
                    mongoConn.test();
                }
                if (!StringUtils.isBlank((String)config.collection)) {
                    result.collectionExists = MongoDBDatasetHandler.collectionExists(mongoConn, config.collection);
                }
                result.connectionOK = true;
            }
            catch (MongoCommandException e) {
                result.connectionErrorMsg = e.getErrorMessage();
                logger.warn((Object)("Server connection error for connection " + config.connection + " : " + e.getMessage()));
                TestResult testResult = result;
                if (mongoConn != null) {
                    mongoConn.close();
                }
                return testResult;
            }
            catch (MongoException e) {
                TestResult testResult;
                block32: {
                    result.connectionErrorMsg = e.getMessage();
                    logger.warn((Object)("Server connection failed for connection " + config.connection + " : " + e.getMessage()));
                    testResult = result;
                    if (mongoConn == null) break block32;
                    mongoConn.close();
                }
                return testResult;
            }
            if (!dataset.isManaged() && (queryParam = config.query) != null && !((String)queryParam).isEmpty()) {
                try {
                    JSON.parse((String)queryParam, Object.class);
                }
                catch (JsonParseException e) {
                    result.filterErrorMsg = e.getMessage();
                    logger.warn((Object)("invalid JSON query : " + (String)queryParam + " : " + e.getMessage()));
                }
            }
            if (connectionOnly || !result.collectionExists || result.filterErrorMsg != null) {
                queryParam = result;
                return queryParam;
            }
            result.testedConnectionOnly = false;
            logger.info((Object)"Gathering collection preview");
            try {
                Pair<SchemaDetection.SchemaDetectionResult, MemTable> res = inferStorageTypes ? DatasetUtils.detectSchemaWithStorageTypeInference(this.authCtx, dataset, forConsistencyCheck) : DatasetUtils.simpleDetectSchema(this.authCtx, dataset, forConsistencyCheck);
                ((SchemaDetection.SchemaDetectionResult)res.first).makesSenseToInferStorageTypes = true;
                result.schemaDetection = (SchemaDetection.SchemaDetectionResult)res.first;
                SerializedMemTableSimple smt = new SerializedMemTableSimple();
                smt.fromMemTable((MemTable)res.second, 0, ((MemTable)res.second).nrows());
                result.preview = smt;
            }
            catch (MongoCommandException e) {
                logger.warn((Object)("Error getting preview for collection " + config.collection + " : " + e.getMessage()));
                result.previewErrorMsg = e.getErrorMessage();
            }
            catch (MongoException e) {
                logger.warn((Object)("Failed to get preview for collection " + config.collection + " : " + e.getMessage()));
                result.previewErrorMsg = e.getMessage();
            }
            TestResult testResult = result;
            return testResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        TestResult result = this.test(this.handler.getDataset().getProjectKey(), this.handler.getDataset(), false, true, false);
        ret.empty = !result.collectionExists;
        ret.result = result.schemaDetection;
        return ret;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (StringUtils.isBlank((String)newDatasetName)) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name is empty");
            return ret;
        }
        if (newDatasetName.contains("$")) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name should not contain '$'");
        }
        if (newDatasetName.contains("\u0000")) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name should not contain a null character");
        }
        if (newDatasetName.toLowerCase().startsWith("system.")) {
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Dataset name should not start with 'system'");
        }
        if (!startWithAlphanumOrUnderscore.matcher(newDatasetName).find()) {
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Dataset name should start with a letter or '_'");
        }
        try {
            if (!StringUtils.isBlank((String)this.handler.config.collection) && MongoDBDatasetHandler.collectionExists(this.handler.getNewConnection(), this.handler.config.collection)) {
                ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_MANAGED_UNSAFE_NAME, "A collection named '%s' already exists, it may get overwritten", new Object[]{this.handler.config.collection});
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to check if the new dataset name is safe", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Failed to check if the new dataset name is safe, there could be a problem with mongodb: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }

    public static class TestResult {
        public boolean testedConnectionOnly;
        public String suggestedName;
        public boolean connectionOK;
        public String connectionErrorMsg;
        public List<String> collectionList;
        public boolean collectionExists;
        public String filterErrorMsg;
        public String previewErrorMsg;
        public SchemaDetection.SchemaDetectionResult schemaDetection;
        public SerializedMemTableSimple preview;
    }
}

