/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.sync.AutoFastPathConnector;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToSynapse;
import com.dataiku.dip.dataflow.exec.sync.AzureToTrino;
import com.dataiku.dip.dataflow.exec.sync.DatabricksVolumeToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.GCSToBigQuery;
import com.dataiku.dip.dataflow.exec.sync.GcsToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.GcsToTrino;
import com.dataiku.dip.dataflow.exec.sync.S3ToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.S3ToRedshift;
import com.dataiku.dip.dataflow.exec.sync.S3ToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.S3ToTrino;
import com.dataiku.dip.dataflow.exec.sync.WASBToSnowflake;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.datasets.sql.CanShareSQLConnection;
import com.dataiku.dip.datasets.sql.SQLViaCloudAutoFastPathOutputWriter;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;

public class SQLViaCloudAutoFastPathOutput
implements Output,
CanShareSQLConnection {
    private final AbstractSQLTableDatasetHandler handler;
    private final Dataset finalDataset;
    private final AuthCtx authCtx;
    private final Dataset virtualDataset;
    private final Partition targetPartition;
    private final Map<String, String> targetPartitionValues = Maps.newHashMap();
    private final WarningsContext warnContext;
    private CanShareSQLConnection.SQLConnectionShare connectionShare;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.output.sql.autofastpath");

    public SQLViaCloudAutoFastPathOutput(AuthCtx authCtx, AbstractSQLTableDatasetHandler handler, Dataset finalDataset, Partition targetPartition, WarningsContext warnContext, AbstractCloudStorageConnection intermediateConnection, String pathInIntermediateConnection) throws IOException, DKUSecurityException {
        this.authCtx = authCtx;
        this.handler = handler;
        assert (DatasetInspector.isSQL(finalDataset));
        if (finalDataset.getSchema() == null) {
            throw ErrorContext.iaef((String)"Cannot write to a SQLTable dataset with no schema: %s", (Object)finalDataset.getName(), (Object[])new Object[0]);
        }
        if (!DatasetInspector.isSQLTable(finalDataset)) {
            throw ErrorContext.iaef((String)"Cannot write to a SQL dataset in 'query' mode: %s", (Object)finalDataset.getName(), (Object[])new Object[0]);
        }
        this.finalDataset = finalDataset;
        this.targetPartition = targetPartition;
        this.warnContext = warnContext;
        if (targetPartition != null && targetPartition.getDimensionValues().size() > 0) {
            Schema schema = finalDataset.getSchema();
            if (schema == null) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Empty dataset schema");
            }
            for (String dimensionName : finalDataset.getPartitioningSchema().getDimensionNames()) {
                DimensionValue dimensionValue = (DimensionValue)targetPartition.getDimensionValues().get(dimensionName);
                if (dimensionValue == null) {
                    this.targetPartitionValues.put(dimensionName, null);
                    continue;
                }
                SchemaColumn partitionColumn = finalDataset.getSchema().getColumn(dimensionName);
                if (partitionColumn == null) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Dataset '" + finalDataset.getName() + "' does not contain the partitioning column: " + dimensionName);
                }
                Type partitionColumnType = partitionColumn.getType();
                this.targetPartitionValues.put(dimensionName, ExpressionUtils.getStringForDimensionValue(dimensionValue, partitionColumnType));
            }
        }
        this.virtualDataset = new Dataset();
        this.virtualDataset.setManaged(true);
        this.virtualDataset.getModel().name = "virtualautofastpath" + SecretKeyGenerator.generate((int)16);
        this.virtualDataset.getModel().projectKey = finalDataset.getProjectKey();
        this.virtualDataset.setFullName(this.virtualDataset.getModel().getFullName());
        if (BuiltinSQLDatasets.TRINO_META.getType().equalsIgnoreCase(finalDataset.getType())) {
            ManagedDatasetsCreationService.setFormat(this.virtualDataset, ManagedDatasetsCreationService.FormatOptionId.PARQUET_HIVE);
        } else {
            ManagedDatasetsCreationService.setFormat(this.virtualDataset, ManagedDatasetsCreationService.FormatOptionId.CSV_EXCEL_GZIP);
            if (BuiltinSQLDatasets.BIGQUERY_META.getType().equals(finalDataset.getType())) {
                this.virtualDataset.getFormatParamsAs(CSVFormatConfig.class).dateSerializationFormat = CSVFormatConfig.DateSerializationFormat.ISO_FORCED_UTC;
            } else if (BuiltinSQLDatasets.SNOWFLAKE_META.getType().equals(finalDataset.getType()) || BuiltinSQLDatasets.SYNAPSE_META.getType().equals(finalDataset.getType())) {
                this.virtualDataset.getFormatParamsAs(CSVFormatConfig.class).dateSerializationFormat = CSVFormatConfig.DateSerializationFormat.ISO_STRICT;
            }
        }
        AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig config = switch (intermediateConnection.type) {
            case "EC2" -> {
                this.virtualDataset.setType("S3");
                yield new BuiltinFSDatasets.S3DatasetConfig();
            }
            case "Azure" -> {
                this.virtualDataset.setType("Azure");
                yield new BuiltinFSDatasets.AzureBlobDatasetConfig();
            }
            case "GCS" -> {
                this.virtualDataset.setType("GCS");
                yield new BuiltinFSDatasets.GCSDatasetConfig();
            }
            case "DatabricksVolume" -> {
                this.virtualDataset.setType("DatabricksVolume");
                yield new BuiltinFSDatasets.DatabricksVolumeDatasetConfig();
            }
            default -> throw new IllegalArgumentException("Can't use connection type " + intermediateConnection.type + " for auto fastpath");
        };
        config.connection = intermediateConnection.name;
        config.path = PathUtils.concatLNT((String[])new String[]{pathInIntermediateConnection, "tmp." + SecretKeyGenerator.generate((int)16)});
        this.virtualDataset.setParams(config);
        if (finalDataset.getPartitioningSchema().isPartitioned()) {
            ManagedDatasetsHelper.copyPartitioning(null, finalDataset, this.virtualDataset);
        }
        ManagedDatasetsHelper.copySchema(authCtx, finalDataset.getSchema(), this.virtualDataset);
    }

    @Override
    public void shareSQLConnection(CanShareSQLConnection.SQLConnectionShare share) throws DKUSecurityException {
        this.connectionShare = share;
    }

    public static AutoFastPathConnector buildAutoFastPathConnector(Dataset finalDataset, Dataset virtualDataset) {
        switch (finalDataset.getType()) {
            case "Snowflake": {
                logger.info((Object)("Starting Cloud->Snowflake with targetDataset: " + JSON.log((Object)finalDataset)));
                switch (virtualDataset.getType()) {
                    case "S3": {
                        return new S3ToSnowflake();
                    }
                    case "GCS": {
                        return new GcsToSnowflake();
                    }
                    case "Azure": {
                        return new WASBToSnowflake();
                    }
                }
                throw new IllegalArgumentException("Unsupported auto-fast-path cloud: " + virtualDataset.getType());
            }
            case "Databricks": {
                logger.info((Object)("Starting Cloud->Databricks with targetDataset: " + JSON.log((Object)finalDataset)));
                switch (virtualDataset.getType()) {
                    case "S3": {
                        return new S3ToDatabricks();
                    }
                    case "Azure": {
                        return new AzureBlobToDatabricks();
                    }
                    case "DatabricksVolume": {
                        return new DatabricksVolumeToDatabricks();
                    }
                }
                throw new IllegalArgumentException("Unsupported auto-fast-path cloud: " + virtualDataset.getType());
            }
            case "Redshift": {
                logger.info((Object)("Starting Cloud->Redshift with targetDataset: " + JSON.log((Object)finalDataset)));
                if (!"S3".equals(virtualDataset.getType())) {
                    throw new IllegalArgumentException("Wrong auto-fast-path setup: intermediate is of type: " + virtualDataset.getType());
                }
                return new S3ToRedshift();
            }
            case "Synapse": 
            case "FabricWarehouse": {
                logger.info((Object)("Starting Cloud->" + finalDataset.getType() + " with targetDataset: " + JSON.log((Object)finalDataset)));
                if (!"Azure".equals(virtualDataset.getType())) {
                    throw new IllegalArgumentException("Wrong auto-fast-path setup: intermediate is of type: " + virtualDataset.getType());
                }
                return new AzureBlobToSynapse(null);
            }
            case "BigQuery": {
                logger.info((Object)("Starting Cloud->BigQuery with targetDataset: " + JSON.prettyLog((Object)finalDataset)));
                if (!"GCS".equals(virtualDataset.getType())) {
                    throw new IllegalArgumentException("Wrong auto-fast-path setup: intermediate is of type: " + virtualDataset.getType());
                }
                return new GCSToBigQuery();
            }
            case "Trino": {
                logger.info((Object)("Starting Cloud->Trino with targetDataset: " + JSON.log((Object)finalDataset)));
                switch (virtualDataset.getType()) {
                    case "S3": {
                        return new S3ToTrino();
                    }
                    case "Azure": {
                        return new AzureToTrino();
                    }
                    case "GCS": {
                        return new GcsToTrino();
                    }
                }
                throw new IllegalArgumentException("Unsupported auto-fast-path cloud: " + virtualDataset.getType());
            }
        }
        throw new IllegalArgumentException("Unsupported auto-fast-path target: " + finalDataset.getType());
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException {
        CanShareSQLConnection.SQLConnectionShare connectionShareToUse = this.connectionShare == null ? new CanShareSQLConnection.SQLConnectionShare(this.handler.getConnectionData()) : this.connectionShare;
        return new SQLViaCloudAutoFastPathOutputWriter(this.authCtx, this.finalDataset, this.virtualDataset, this.targetPartition, connectionShareToUse, this.warnContext, mode);
    }
}

