/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker;

import com.dataiku.dip.deployer.apideployer.datamodel.actual.AbstractFullyManagedDeploymentSummary;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.SageMakerEndpoint;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.SageMakerEndpointConfig;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.SageMakerModel;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deploymentinfo.SageMakerDeploymentInfo;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import java.io.IOException;

public class SageMakerDeploymentSummary
extends AbstractFullyManagedDeploymentSummary {
    public String awsRegion;
    public SageMakerModel model;
    public SageMakerEndpointConfig endpointConfig;
    public SageMakerEndpoint endpoint;

    public SageMakerModel refreshModel_NT(SageMakerClient sageMakerClient, String modelName) {
        this.model = SageMakerModel.SageMakerModelBuilder.buildFromRemoteConfig_NT(sageMakerClient, modelName);
        return this.model;
    }

    public SageMakerEndpointConfig refreshEndpointConfig_NT(SageMakerClient sageMakerClient, String endpointConfigName) {
        this.endpointConfig = SageMakerEndpointConfig.SageMakerEndpointConfigBuilder.buildFromRemoteConfig_NT(sageMakerClient, endpointConfigName);
        return this.endpointConfig;
    }

    public SageMakerEndpoint refreshEndpoint_NT(SageMakerClient sageMakerClient, String endpointName) {
        this.endpoint = SageMakerEndpoint.SageMakerEndpointBuilder.buildFromRemoteConfig_NT(sageMakerClient, endpointName);
        return this.endpoint;
    }

    public SageMakerDeploymentInfo asDeploymentInfo() {
        return new SageMakerDeploymentInfo(this.infraId, this.deploymentId, this.awsRegion, this.model.name, this.endpointConfig.name, this.endpoint.name, this.endpoint.resourceDescription.map(DescribeEndpointResponse::endpointArn).orElse(null), this.model.resourceDescription.map(r -> r.primaryContainer().image()).orElse(null));
    }

    private SageMakerDeploymentSummary() {
    }

    private SageMakerDeploymentSummary(String infraId, String deploymentId) {
        super(infraId, deploymentId);
    }

    public static class SageMakerDeploymentSummaryBuilder {
        private SageMakerDeploymentSummaryBuilder() {
        }

        public static SageMakerDeploymentSummary buildFromRemoteConfig_NT(SageMakerClient sageMakerClient, SageMakerDeploymentInfo deploymentInfo) {
            SageMakerDeploymentSummary deploymentConfig = new SageMakerDeploymentSummary(deploymentInfo.infraId, deploymentInfo.deploymentId);
            deploymentConfig.awsRegion = deploymentInfo.awsRegion;
            deploymentConfig.model = SageMakerModel.SageMakerModelBuilder.buildFromRemoteConfig_NT(sageMakerClient, deploymentInfo.sageMakerModelName);
            deploymentConfig.endpointConfig = SageMakerEndpointConfig.SageMakerEndpointConfigBuilder.buildFromRemoteConfig_NT(sageMakerClient, deploymentInfo.sageMakerEndpointConfigName);
            deploymentConfig.endpoint = SageMakerEndpoint.SageMakerEndpointBuilder.buildFromRemoteConfig_NT(sageMakerClient, deploymentInfo.sageMakerEndpointName);
            return deploymentConfig;
        }

        public static SageMakerDeploymentSummary buildFromLocalConfig(AuthCtx authCtx, SageMakerAPIDeployment deployment, SageMakerAPIDeploymentInfra infra, VariablesContext vc, SageMakerDeploymentInfo deploymentInfo) throws IOException, DKUSecurityException {
            SageMakerDeploymentSummary deploymentConfig = new SageMakerDeploymentSummary(infra.id, deployment.id);
            deploymentConfig.awsRegion = deploymentInfo.awsRegion;
            deploymentConfig.model = SageMakerModel.SageMakerModelBuilder.buildFromLocalConfig(deployment, infra, vc, deploymentInfo.sageMakerModelName, deploymentInfo.containerImageUri);
            deploymentConfig.endpointConfig = SageMakerEndpointConfig.SageMakerEndpointConfigBuilder.buildFromLocalConfig(authCtx, deployment, infra, vc, deploymentInfo.sageMakerEndpointConfigName, deploymentInfo.sageMakerModelName);
            deploymentConfig.endpoint = SageMakerEndpoint.SageMakerEndpointBuilder.buildFromLocalConfig(deployment, infra, vc, deploymentInfo.sageMakerEndpointName, deploymentInfo.sageMakerEndpointConfigName, deploymentInfo.sageMakerModelName);
            return deploymentConfig;
        }
    }
}

