/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.comparator;

import com.dataiku.dip.deployer.apideployer.datamodel.actual.AbstractFullyManagedResourceWithTagsComparator;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.SageMakerEndpoint;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.SageMakerEndpointConfig;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentResourceComparator;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CapacitySize;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DeploymentConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class SageMakerEndpointComparator
extends AbstractFullyManagedResourceWithTagsComparator {
    @Nonnull
    private final SageMakerEndpoint endpoint;

    public SageMakerEndpointComparator(@Nonnull SageMakerEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public Map<String, String> getStoredTags() {
        return this.endpoint.tags;
    }

    public boolean isOutOfSync(SageMakerEndpoint deployedEndpoint, SageMakerEndpointConfig deployedEndpointConfig) {
        boolean outOfSync = false;
        if (deployedEndpoint.resourceDescription.isPresent() && !deployedEndpoint.isDescriptionTransient) {
            String deployedVariantName = deployedEndpoint.getVariantName();
            String deployedEndpointConfigName = deployedEndpoint.getEndpointConfigName();
            String expectedVariantName = "";
            String expectedEndpointConfigName = "";
            if (deployedEndpointConfig.resourceDescription.isPresent()) {
                expectedVariantName = ((DescribeEndpointConfigResponse)deployedEndpointConfig.resourceDescription.get()).productionVariants().stream().findFirst().map(ProductionVariant::variantName).orElse("");
                expectedEndpointConfigName = deployedEndpointConfig.name;
            }
            DeploymentConfig deployedDeploymentConfig = ((DescribeEndpointResponse)deployedEndpoint.resourceDescription.get()).lastDeploymentConfig();
            DeploymentConfig storedDeploymentConfig = null;
            if (this.endpoint.resourceDescription.isPresent()) {
                storedDeploymentConfig = ((DescribeEndpointResponse)this.endpoint.resourceDescription.get()).lastDeploymentConfig();
            }
            outOfSync = !deployedVariantName.equals(expectedVariantName) || !deployedEndpointConfigName.equals(expectedEndpointConfigName) || !Objects.equals(deployedDeploymentConfig, storedDeploymentConfig);
        }
        return outOfSync;
    }

    private Set<String> reportOutOfSyncDeploymentConfigFields(SageMakerEndpoint deployedEndpoint) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (this.endpoint.resourceDescription.isPresent() && deployedEndpoint.resourceDescription.isPresent()) {
            boolean storedDeploymentConfigIsEnabled;
            DescribeEndpointResponse storedEndpointDescription = (DescribeEndpointResponse)this.endpoint.resourceDescription.get();
            DescribeEndpointResponse deployedEndpointDescription = (DescribeEndpointResponse)deployedEndpoint.resourceDescription.get();
            DeploymentConfig storedDeploymentConfig = storedEndpointDescription.lastDeploymentConfig();
            DeploymentConfig deployedDeploymentConfig = deployedEndpointDescription.lastDeploymentConfig();
            boolean deployedDeploymentConfigIsEnabled = deployedEndpointDescription.lastDeploymentConfig() != null;
            boolean bl = storedDeploymentConfigIsEnabled = storedEndpointDescription.lastDeploymentConfig() != null;
            if (deployedDeploymentConfigIsEnabled && storedDeploymentConfigIsEnabled) {
                Integer storedMaximumExecutionTimeoutInSeconds = storedDeploymentConfig.blueGreenUpdatePolicy().maximumExecutionTimeoutInSeconds();
                Integer deployedMaximumExecutionTimeoutInSeconds = deployedDeploymentConfig.blueGreenUpdatePolicy().maximumExecutionTimeoutInSeconds();
                if (!Objects.equals(deployedMaximumExecutionTimeoutInSeconds, storedMaximumExecutionTimeoutInSeconds)) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Maximum execution timeout", deployedMaximumExecutionTimeoutInSeconds, storedMaximumExecutionTimeoutInSeconds));
                }
                Integer storedTerminationWaitInSeconds = storedDeploymentConfig.blueGreenUpdatePolicy().terminationWaitInSeconds();
                Integer deployedTerminationWaitInSeconds = deployedDeploymentConfig.blueGreenUpdatePolicy().terminationWaitInSeconds();
                if (!Objects.equals(deployedTerminationWaitInSeconds, storedTerminationWaitInSeconds)) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Termination wait", deployedTerminationWaitInSeconds, storedTerminationWaitInSeconds));
                }
                String storedTrafficRoutingConfigType = storedDeploymentConfig.blueGreenUpdatePolicy().trafficRoutingConfiguration().type().toString();
                String deployedTrafficRoutingConfigType = deployedDeploymentConfig.blueGreenUpdatePolicy().trafficRoutingConfiguration().type().toString();
                if (!StringUtils.equalsOrBothBlank((String)deployedTrafficRoutingConfigType, (String)storedTrafficRoutingConfigType)) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Traffic routing strategy", deployedTrafficRoutingConfigType, storedTrafficRoutingConfigType));
                } else {
                    Integer storedWaitIntervalInSeconds = storedDeploymentConfig.blueGreenUpdatePolicy().trafficRoutingConfiguration().waitIntervalInSeconds();
                    Integer deployedWaitIntervalInSeconds = deployedDeploymentConfig.blueGreenUpdatePolicy().trafficRoutingConfiguration().waitIntervalInSeconds();
                    if (!Objects.equals(deployedWaitIntervalInSeconds, storedWaitIntervalInSeconds)) {
                        outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Wait interval", deployedWaitIntervalInSeconds, storedWaitIntervalInSeconds));
                    }
                    CapacitySize storedCapacitySize = null;
                    CapacitySize deployedCapacitySize = null;
                    switch (deployedTrafficRoutingConfigType) {
                        case "CANARY": {
                            storedCapacitySize = storedDeploymentConfig.blueGreenUpdatePolicy().trafficRoutingConfiguration().canarySize();
                            deployedCapacitySize = deployedDeploymentConfig.blueGreenUpdatePolicy().trafficRoutingConfiguration().canarySize();
                            break;
                        }
                        case "LINEAR": {
                            storedCapacitySize = storedDeploymentConfig.blueGreenUpdatePolicy().trafficRoutingConfiguration().linearStepSize();
                            deployedCapacitySize = deployedDeploymentConfig.blueGreenUpdatePolicy().trafficRoutingConfiguration().linearStepSize();
                            break;
                        }
                    }
                    if (storedCapacitySize != null && deployedCapacitySize != null) {
                        String storedCapacitySizeType = storedCapacitySize.type().toString();
                        String deployedCapacitySizeType = deployedCapacitySize.type().toString();
                        if (!StringUtils.equalsOrBothBlank((String)deployedCapacitySizeType, (String)storedCapacitySizeType)) {
                            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Capacity type", deployedCapacitySizeType, storedCapacitySizeType));
                        }
                        Integer storedCapacitySizeValue = storedCapacitySize.value();
                        Integer deployedCapacitySizeValue = deployedCapacitySize.value();
                        if (!Objects.equals(deployedCapacitySizeValue, storedCapacitySizeValue)) {
                            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Capacity size", deployedCapacitySizeValue, storedCapacitySizeValue));
                        }
                    }
                }
            } else if (deployedDeploymentConfigIsEnabled != storedDeploymentConfigIsEnabled) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Enable blue/green update policy", deployedDeploymentConfig, storedDeploymentConfig));
            }
        }
        return outOfSyncFields;
    }

    public Set<String> reportOutOfSyncFields(SageMakerEndpoint deployedEndpoint) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (this.endpoint.resourceDescription.isPresent() && deployedEndpoint.resourceDescription.isPresent() && !deployedEndpoint.isDescriptionTransient) {
            String storedEndpointConfigName;
            String deployedEndpointConfigName;
            outOfSyncFields.addAll(this.reportOutOfSyncDeploymentConfigFields(deployedEndpoint));
            String deployedVariantName = deployedEndpoint.getVariantName();
            String storedVariantName = this.endpoint.getVariantName();
            if (!deployedVariantName.equals(storedVariantName)) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Model reference in endpoint", deployedVariantName, storedVariantName));
            }
            if (!(deployedEndpointConfigName = deployedEndpoint.getEndpointConfigName()).equals(storedEndpointConfigName = this.endpoint.getEndpointConfigName())) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Endpoint config reference in endpoint", deployedEndpointConfigName, storedEndpointConfigName));
            }
            outOfSyncFields.addAll(this.reportOutOfSyncNonDSSTags(deployedEndpoint.tags));
            outOfSyncFields.addAll(this.reportMissingDSSTags(deployedEndpoint.tags));
        }
        return outOfSyncFields;
    }
}

