/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfigBase;
import com.dataiku.lambda.model.serverconfig.ServiceState;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFullyManagedAPIDeployment
extends AbstractAPIServiceDockerDeployment {
    protected static final Set<LambdaEndpointConfig.EndpointType> COMPATIBLE_ENDPOINT_TYPES = Sets.newHashSet((Object[])new LambdaEndpointConfig.EndpointType[]{LambdaEndpointConfig.EndpointType.STD_PREDICTION, LambdaEndpointConfig.EndpointType.STD_CLUSTERING, LambdaEndpointConfig.EndpointType.STD_CAUSAL_PREDICTION, LambdaEndpointConfig.EndpointType.CUSTOM_PREDICTION, LambdaEndpointConfig.EndpointType.PY_FUNCTION});
    @Nullable
    public String endpointId;
    @Nonnull
    private List<SimpleKeyValue> deploymentTags = new ArrayList<SimpleKeyValue>();

    public Collection<SimpleKeyValue> getDeploymentTags(AbstractFullyManagedAPIDeploymentInfra infra) {
        return AbstractFullyManagedAPIDeployment.getSimpleKeyValues(this.deploymentTags, infra.tags, infra.allowOverrideTags);
    }

    protected AbstractFullyManagedAPIDeployment() {
    }

    protected AbstractFullyManagedAPIDeployment(String id, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag, @Nullable String endpointId) {
        super(id, infraId, publishedServiceId, version, enabled, creationTag);
        this.auth.authMode = AbstractAPIServiceDeployment.APIAuthSettings.DeployedAuthenticationMode.PUBLIC;
        this.apiNodeLogging.redirectToPod = true;
        this.endpointId = endpointId;
    }

    protected AbstractFullyManagedAPIDeployment(AbstractAPIServiceDeployment existingDeployment, String deploymentId, String infraId, boolean enabled, VersionTag creationTag, @Nullable String endpointId) {
        super(existingDeployment, deploymentId, infraId, enabled, creationTag);
        this.auth.authMode = AbstractAPIServiceDeployment.APIAuthSettings.DeployedAuthenticationMode.PUBLIC;
        if (existingDeployment instanceof AbstractFullyManagedAPIDeployment) {
            AbstractFullyManagedAPIDeployment fullyManagedExistingDeployment = (AbstractFullyManagedAPIDeployment)existingDeployment;
            this.apiNodeLogging.redirectToPod = fullyManagedExistingDeployment.apiNodeLogging.redirectToPod;
            this.endpointId = (String)StringUtils.defaultIfBlank((CharSequence)endpointId, (CharSequence)fullyManagedExistingDeployment.endpointId);
            this.deploymentTags = fullyManagedExistingDeployment.deploymentTags;
        } else {
            this.apiNodeLogging.redirectToPod = true;
            this.endpointId = endpointId;
        }
    }

    public static AbstractFullyManagedAPIDeployment createDeployment(String id, AbstractFullyManagedAPIDeploymentInfra infra, String publishedServiceId, String version, @Nullable String endpointId, boolean enabled, VersionTag creationTag) {
        if (infra instanceof AzureMLAPIDeploymentInfra) {
            return new AzureMLAPIDeployment(id, (AzureMLAPIDeploymentInfra)infra, publishedServiceId, version, endpointId, enabled, creationTag);
        }
        if (infra instanceof DatabricksAPIDeploymentInfra) {
            return new DatabricksAPIDeployment(id, (DatabricksAPIDeploymentInfra)infra, publishedServiceId, version, endpointId, enabled, creationTag);
        }
        if (infra instanceof SageMakerAPIDeploymentInfra) {
            return new SageMakerAPIDeployment(id, (SageMakerAPIDeploymentInfra)infra, publishedServiceId, version, endpointId, enabled, creationTag);
        }
        if (infra instanceof VertexAIAPIDeploymentInfra) {
            return new VertexAIAPIDeployment(id, (VertexAIAPIDeploymentInfra)infra, publishedServiceId, version, endpointId, enabled, creationTag);
        }
        if (infra instanceof SnowparkAPIDeploymentInfra) {
            return new SnowparkAPIDeployment(id, (SnowparkAPIDeploymentInfra)infra, publishedServiceId, version, endpointId, enabled, creationTag);
        }
        throw ErrorContext.iae((String)("Unsupported infra type: " + String.valueOf((Object)infra.getInfraType())));
    }

    public static AbstractFullyManagedAPIDeployment copyDeployment(AbstractAPIServiceDeployment existingDeployment, AbstractFullyManagedAPIDeploymentInfra infra, String newDeploymentId, List<AbstractAPIServiceDeployment> otherDeployments, @Nullable String endpointId, boolean enabled, VersionTag creationTag) {
        if (infra instanceof AzureMLAPIDeploymentInfra) {
            List<AzureMLAPIDeployment> otherAzureMLDeployments = AbstractFullyManagedAPIDeployment.filterDeployments(otherDeployments, AzureMLAPIDeployment.class);
            return new AzureMLAPIDeployment(existingDeployment, otherAzureMLDeployments, newDeploymentId, (AzureMLAPIDeploymentInfra)infra, endpointId, enabled, creationTag);
        }
        if (infra instanceof DatabricksAPIDeploymentInfra) {
            List<DatabricksAPIDeployment> otherDatabricksDeployments = AbstractFullyManagedAPIDeployment.filterDeployments(otherDeployments, DatabricksAPIDeployment.class);
            return new DatabricksAPIDeployment(existingDeployment, otherDatabricksDeployments, newDeploymentId, (DatabricksAPIDeploymentInfra)infra, endpointId, enabled, creationTag);
        }
        if (infra instanceof SageMakerAPIDeploymentInfra) {
            List<SageMakerAPIDeployment> otherSageMakerDeployments = AbstractFullyManagedAPIDeployment.filterDeployments(otherDeployments, SageMakerAPIDeployment.class);
            return new SageMakerAPIDeployment(existingDeployment, otherSageMakerDeployments, newDeploymentId, (SageMakerAPIDeploymentInfra)infra, endpointId, enabled, creationTag);
        }
        if (infra instanceof VertexAIAPIDeploymentInfra) {
            List<VertexAIAPIDeployment> otherVertexAIDeployments = AbstractFullyManagedAPIDeployment.filterDeployments(otherDeployments, VertexAIAPIDeployment.class);
            return new VertexAIAPIDeployment(existingDeployment, otherVertexAIDeployments, newDeploymentId, (VertexAIAPIDeploymentInfra)infra, endpointId, enabled, creationTag);
        }
        if (infra instanceof SnowparkAPIDeploymentInfra) {
            List<SnowparkAPIDeployment> otherSnowparkDeployments = AbstractFullyManagedAPIDeployment.filterDeployments(otherDeployments, SnowparkAPIDeployment.class);
            return new SnowparkAPIDeployment(existingDeployment, otherSnowparkDeployments, newDeploymentId, (SnowparkAPIDeploymentInfra)infra, endpointId, enabled, creationTag);
        }
        throw ErrorContext.iae((String)("Unsupported infra type: " + String.valueOf((Object)infra.getInfraType())));
    }

    public String getActiveGeneration() {
        assert (this.generationsMapping != null && this.generationsMapping.getEntries().size() == 1) : "For the moment cloud deployments shall have only one generation";
        GenerationsMapping.MappingEntry mappingEntry = this.generationsMapping.getEntries().get(0);
        return mappingEntry.generation;
    }

    public void verifyPackageCompatibility(@Nonnull PublishedApiServicePackageInfo packageInfo) {
        if (!this.isPackageCompatible(packageInfo)) {
            throw new UnsupportedOperationException(String.format("Cannot use the endpoint %s in the service generation %s to deploy into this infrastructure. It only supports endpoints of type Prediction, Clustering, Custom prediction (Python), causal prediction or Python Function and without enrichment.", this.endpointId, packageInfo.id));
        }
    }

    public boolean isPackageCompatible(@Nonnull PublishedApiServicePackageInfo packageInfo) {
        Optional<LambdaEndpointConfig> endpointConfig = packageInfo.endpoints.stream().filter(endpoint -> endpoint.id.equals(this.endpointId)).findFirst();
        if (!endpointConfig.isPresent()) {
            throw new UnsupportedOperationException(String.format("DSS endpoint %s not found in version %s.", this.endpointId, packageInfo.id));
        }
        return AbstractFullyManagedAPIDeployment.isEndpointCompatible(endpointConfig.get());
    }

    public static boolean isEndpointCompatible(@Nonnull LambdaEndpointConfig endpointConfig) {
        if (endpointConfig instanceof PredictionEndpointConfigBase && !((PredictionEndpointConfigBase)endpointConfig).enrichMapping.isEmpty()) {
            return false;
        }
        return COMPATIBLE_ENDPOINT_TYPES.contains((Object)endpointConfig.type);
    }

    @Override
    public void additionalInitForDeploymentType(File contextDir) throws IOException {
        File installDir = new File(System.getenv("DKUINSTALLDIR"));
        FileUtils.copyFileToDirectory((File)DKUFileUtils.getWithin((File)installDir, (String[])new String[]{"resources", "container-exec", "deploy_anywhere_wrapper.sh"}), (File)contextDir);
        File additionalTargetInit = new File(contextDir, "Docker.additional_init_deployment_type");
        DKUFileUtils.writeFileUTF8((File)additionalTargetInit, (String)"COPY deploy_anywhere_wrapper.sh /home/dataiku/data/bin/\n");
    }

    @Override
    public void additionalFinalizeForDeploymentType(File contextDir, AbstractAPIDeploymentInfra infra) throws IOException {
        File additionalFinalize = new File(contextDir, "Docker.additional_finalize_deployment_type");
        String uid_gid = DKUApp.getContainerUIDGID();
        StringBuilder builder = new StringBuilder();
        builder.append("USER " + uid_gid + "\n");
        builder.append("RUN cd /home/dataiku/data && sed -i \"s/port =.*/port = 8080/g\" install.ini && ./bin/dssadmin regenerate-config\n");
        builder.append("USER " + uid_gid + "\n");
        builder.append("WORKDIR /home/dataiku\n");
        builder.append("ENTRYPOINT [\"/home/dataiku/data/bin/deploy_anywhere_wrapper.sh\"]\n");
        builder.append("EXPOSE 8080\n");
        DKUFileUtils.writeFileUTF8((File)additionalFinalize, (String)builder.toString());
    }

    @Override
    public ServiceState getDefaultServiceState() {
        ServiceState state = super.getDefaultServiceState();
        state.mainEndpointId = this.endpointId;
        return state;
    }

    private static <T extends AbstractAPIServiceDeployment> List<T> filterDeployments(List<AbstractAPIServiceDeployment> deployments, Class<T> clazz) {
        return deployments.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    @Override
    public void prepareInstallIni(AbstractAPIDockerDeploymentInfra infra, File contextDir) throws IOException {
        File installFolder = new File(contextDir, "install-details");
        DKUFileUtils.mkdirs((File)installFolder);
        Object installIni = "";
        AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging nodeLogging = this.getNodeLogging(infra);
        if (nodeLogging.redirectToPod) {
            installIni = (String)installIni + "\n\n";
            installIni = (String)installIni + "[logs]\n";
            installIni = (String)installIni + "redirect_to_supervisor_stdout = true\n";
        }
        DKUFileUtils.writeFileUTF8((File)new File(installFolder, "install.ini.add"), (String)installIni);
    }
}

