/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.deployer.apideployer.infra.AzureMLInfraManager;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.externalinfras.azureml.AzureMLInputValidator;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AzureMLAPIDeploymentInfra
extends AbstractFullyManagedAPIDeploymentInfra {
    public String azSubscription = "";
    public String azResourceGroup = "";
    public String azWorkspace = "";
    @Nonnull
    public String instanceType = "Standard_DS3_v2";
    public int instanceCount = 1;
    public boolean publicInboundNetworkAccess = true;
    public boolean publicOutboundNetworkAccess = true;
    public AzureMLOnlineDeployment.ProbeSettings livenessProbe = new AzureMLOnlineDeployment.ProbeSettings();
    public AzureMLOnlineDeployment.ProbeSettings readinessProbe = new AzureMLOnlineDeployment.ProbeSettings();
    public boolean appInsightsEnabled = false;
    public boolean allowOverrideEndpointName = false;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.datamodel.config");

    private AzureMLAPIDeploymentInfra() {
        this.prePushMode = ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode.ACR;
    }

    AzureMLAPIDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
        this.prePushMode = ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode.ACR;
    }

    @Override
    public AbstractFullyManagedAPIDeploymentInfra.EndpointType getEndpointType() {
        return AbstractFullyManagedAPIDeploymentInfra.EndpointType.REAL_TIME;
    }

    @Override
    public AbstractDeploymentInfra.InfraType getInfraType() {
        return AbstractDeploymentInfra.InfraType.AZURE_ML;
    }

    @Override
    public ApiNodeInfraManager getInfraManager(DKULogger logger) {
        return new AzureMLInfraManager(this);
    }

    @Override
    public void trySetDefaultValues_NT() {
        Map<Object, Object> azConfig = new HashMap();
        try (AzureMLUtils.AzureSession session = AzureMLUtils.loginOrCheckAzure_NT(null, "");){
            session.getDefaultSubscription().ifPresent(subscription -> {
                this.azSubscription = subscription.id;
            });
        }
        catch (Exception e) {
            logger.error((Object)("Unable to retrieve default Azure subscription for AzureML infra " + this.id), (Throwable)e);
        }
        try {
            azConfig = AzureMLUtils.getDefaultsConfig_NT();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to retrieve Azure defaults for AzureML infra " + this.id), (Throwable)e);
        }
        if (azConfig.containsKey("group")) {
            this.azResourceGroup = (String)azConfig.get("group");
        } else {
            logger.warn((Object)("Default group not defined for AzureML infra " + this.id));
        }
        if (azConfig.containsKey("workspace")) {
            this.azWorkspace = (String)azConfig.get("workspace");
        } else {
            logger.warn((Object)("Default workspace not defined for AzureML infra " + this.id));
        }
        if (azConfig.containsKey("acr")) {
            String acrName = (String)azConfig.get("acr");
            if (StringUtils.isNotBlank((CharSequence)acrName)) {
                this.setRegistryHost(acrName + ".azurecr.io");
            }
        } else {
            logger.warn((Object)("Default ACR not defined for AzureML infra " + this.id));
        }
    }

    @Override
    public void verifyFields(AuthCtx authCtx, AbstractDeploymentInfra oldInfra) throws IOException {
        super.verifyFields(authCtx, oldInfra);
        APIServiceDeploymentsService apiServiceDeploymentsService = (APIServiceDeploymentsService)SpringUtils.getBean(APIServiceDeploymentsService.class);
        if (oldInfra instanceof AzureMLAPIDeploymentInfra) {
            AzureMLAPIDeploymentInfra oldAzureMLInfra = (AzureMLAPIDeploymentInfra)oldInfra;
            if (apiServiceDeploymentsService.hasDeploymentForInfra(this.id)) {
                this.verifyFieldExistingDeployments(oldAzureMLInfra.azSubscription, this.azSubscription, "Subscription Id");
                this.verifyFieldExistingDeployments(oldAzureMLInfra.azResourceGroup, this.azResourceGroup, "Resource Group");
                this.verifyFieldExistingDeployments(oldAzureMLInfra.azWorkspace, this.azWorkspace, "Workspace");
            }
        } else {
            throw ErrorContext.iaef((String)"Old infra with id %s is not an AzureML infra.", (Object)oldInfra.id, (Object[])new Object[0]);
        }
        AzureMLInputValidator.validateWorkspace(this.azWorkspace);
        AzureMLInputValidator.validateSubscriptionId(this.azSubscription);
        AzureMLInputValidator.validateResourceGroup(this.azResourceGroup);
    }
}

