/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.externalinfras.vertexai.VertexAIInputValidator;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIMachineConfig;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.StringTransmogrifier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class VertexAIAPIDeployment
extends AbstractFullyManagedAPIDeployment {
    @Nonnull
    public VertexAIAPIDeploymentOverrideMask overrideSettings = new VertexAIAPIDeploymentOverrideMask();
    @Nullable
    private String customEndpointId;
    @Nonnull
    private VertexAIMachineConfig machineConfig = new VertexAIMachineConfig();

    @Nullable
    public String getCustomEndpointId(VertexAIAPIDeploymentInfra infra) {
        if (infra.allowOverrideEndpointId) {
            return this.customEndpointId;
        }
        return null;
    }

    @Nonnull
    public VertexAIMachineConfig getMachineConfig(VertexAIAPIDeploymentInfra infra) {
        if (infra.allowOverrideSizeAndScaling && this.overrideSettings.sizeAndScaling) {
            return this.machineConfig;
        }
        return infra.machineConfig;
    }

    private VertexAIAPIDeployment() {
    }

    protected VertexAIAPIDeployment(String id, VertexAIAPIDeploymentInfra infra, String publishedServiceId, String version, String endpointId, boolean enabled, VersionTag creationTag) {
        super(id, infra.id, publishedServiceId, version, enabled, creationTag, endpointId);
    }

    protected VertexAIAPIDeployment(AbstractAPIServiceDeployment existingDeployment, List<VertexAIAPIDeployment> otherDeployments, String deploymentId, VertexAIAPIDeploymentInfra infra, @Nullable String endpointId, boolean enabled, VersionTag creationTag) {
        super(existingDeployment, deploymentId, infra.id, enabled, creationTag, endpointId);
        if (existingDeployment instanceof VertexAIAPIDeployment) {
            VertexAIAPIDeployment vertexAIExistingDeployment = (VertexAIAPIDeployment)existingDeployment;
            if (vertexAIExistingDeployment.customEndpointId != null) {
                StringTransmogrifier transmogrifier = new StringTransmogrifier("-", 0, Integer.valueOf(63), true, false);
                for (VertexAIAPIDeployment otherDeployment : otherDeployments) {
                    transmogrifier.addAlreadyTransmogrifiedAcceptDupes(otherDeployment.customEndpointId);
                }
                this.customEndpointId = transmogrifier.transmogrify(vertexAIExistingDeployment.customEndpointId);
            }
            this.overrideSettings = vertexAIExistingDeployment.overrideSettings;
            this.machineConfig = vertexAIExistingDeployment.machineConfig;
        }
    }

    @Override
    public AbstractDeploymentBasicInfo.VertexAIDeploymentBasicInfo basicInfoUnsafe() {
        AbstractDeploymentBasicInfo.VertexAIDeploymentBasicInfo deploymentBasicInfo = new AbstractDeploymentBasicInfo.VertexAIDeploymentBasicInfo();
        deploymentBasicInfo.id = this.id;
        deploymentBasicInfo.enabled = this.enabled;
        deploymentBasicInfo.publishedServiceId = this.publishedServiceId;
        deploymentBasicInfo.deployedServiceId = this.deployedServiceId;
        deploymentBasicInfo.infraId = this.infraId;
        deploymentBasicInfo.generationsMapping = this.generationsMapping;
        deploymentBasicInfo.tags = this.tags;
        deploymentBasicInfo.creationTag = this.creationTag;
        deploymentBasicInfo.versionTag = this.versionTag;
        deploymentBasicInfo.deploymentTag = this.deploymentTag;
        deploymentBasicInfo.endpointId = this.endpointId;
        return deploymentBasicInfo;
    }

    @Override
    @Nonnull
    public VertexAIAPIDeploymentOverrideMask getOverrideSettings() {
        return this.overrideSettings;
    }

    @Override
    public void verifyFields(AbstractDeploymentInfra infra, AbstractDeployment oldDeployment, boolean isDeployed) {
        VertexAIAPIDeploymentInfra vertexAPIDeploymentInfra;
        super.verifyFields(infra, oldDeployment, isDeployed);
        if (oldDeployment instanceof VertexAIAPIDeployment && infra instanceof VertexAIAPIDeploymentInfra) {
            vertexAPIDeploymentInfra = (VertexAIAPIDeploymentInfra)infra;
            VertexAIAPIDeployment vertexOldAPIDeployment = (VertexAIAPIDeployment)oldDeployment;
            if (isDeployed) {
                VertexAIAPIDeployment.verifyImmutableField(vertexOldAPIDeployment.getCustomEndpointId(vertexAPIDeploymentInfra), this.getCustomEndpointId(vertexAPIDeploymentInfra), "Custom endpoint id");
            }
        } else {
            throw ErrorContext.iaef((String)"Old deployment with id %s is not an Vertex AI deployment.", (Object)oldDeployment.id, (Object[])new Object[0]);
        }
        this.verifyCustomEndpointIdFormat(vertexAPIDeploymentInfra);
    }

    private void verifyCustomEndpointIdFormat(VertexAIAPIDeploymentInfra infra) {
        String endpointId = this.getCustomEndpointId(infra);
        if (StringUtils.isBlank((String)endpointId)) {
            return;
        }
        VertexAIInputValidator.validateEndpointId(endpointId);
    }

    public static class VertexAIAPIDeploymentOverrideMask
    extends AbstractAPIServiceDockerDeployment.APIServiceDockerDeploymentOverrideMask {
        boolean sizeAndScaling;
    }
}

