/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.APIDeployerImageBuilderService;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentHelper;
import com.dataiku.dip.deployer.apideployer.deployments.AbstractAPIServiceDockerDeploymentConfigManager;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.joda.time.Instant;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class FullyManagedAPIServiceDeploymentConfigManager
extends AbstractAPIServiceDockerDeploymentConfigManager {
    public static final String DSS_VERSION_TAG_KEY = "dss_version";
    public static final String DSS_INSTANCE_ID_TAG_KEY = "dss_instance_id";
    public static final String SERVICE_ID_TAG_KEY = "dss_service_id";
    public static final String GENERATION_TAG_KEY = "dss_generation";
    public static final String DEPLOYMENT_ID_TAG_KEY = "dss_deployment_id";
    public static final String ENDPOINT_ID_TAG_KEY = "dss_endpoint_id";
    public static final Set<String> DSS_TAG_KEYS = Sets.newHashSet((Object[])new String[]{"dss_version", "dss_instance_id", "dss_service_id", "dss_generation", "dss_deployment_id", "dss_endpoint_id"});
    public static final String DEFAULT_DSS_RESOURCE_PREFIX = "dss";
    public static final String DEFAULT_DSS_RESOURCE_SEPARATOR = "-";
    private static final String REPOSITORY_IMAGE_TAG_FORMAT = "dss-%s-%s-%s-r-%s";
    private static final int IMAGE_NAME_MAX_LENGTH = 256;
    private static final int IMAGE_TAG_MAX_LENGTH = 128;
    private static final Pattern IMAGE_PREFIX_PATTERN = Pattern.compile("^([a-z0-9][a-z0-9-_./]*)?[a-z0-9]$");
    private final VariablesContext vc;

    @Override
    protected abstract AbstractFullyManagedAPIDeployment getDeployment();

    @Override
    protected abstract AbstractFullyManagedAPIDeploymentInfra getInfra();

    protected FullyManagedAPIServiceDeploymentConfigManager(VariablesContext vc) {
        this.vc = vc;
    }

    protected VariablesContext getVC() {
        return this.vc;
    }

    public String generateDeploymentConfigName(int maxLength, String prefix, String separator) {
        return this.generateDeploymentConfigName(maxLength, prefix, separator, DEFAULT_DSS_RESOURCE_SEPARATOR);
    }

    public String generateDeploymentConfigName(int maxLength, String prefix, String separator, String replacement) {
        return FullyManagedAPIServiceDeploymentConfigManager.generateDefaultName(this.getDeployment().id, maxLength, prefix, separator, replacement);
    }

    public static String generateDefaultName(@Nonnull String baseName, int maxLength, String prefix, String separator, String replacement) {
        if (StringUtils.isNotBlank((String)prefix)) {
            prefix = (String)prefix + separator;
        }
        String now = Long.toString(Instant.now().getMillis());
        int availableChars = maxLength - ((String)prefix).length() - now.length() - separator.length();
        String name = baseName.replaceAll("[^A-Za-z0-9]", replacement).toLowerCase(Locale.ENGLISH);
        name = name.substring(0, Math.min(name.length(), availableChars));
        return String.format("%s%s%s%s", prefix, name, separator, now);
    }

    public String generateDeploymentConfigNameWithoutTimestamp(int maxLength) {
        return FullyManagedAPIServiceDeploymentConfigManager.generateDefaultNameWithoutTimestamp(this.getDeployment().id, maxLength);
    }

    public static String generateDefaultNameWithoutTimestamp(@Nonnull String baseName, int maxLength) {
        String prefix = "dss-";
        int availableChars = maxLength - "dss-".length();
        String name = baseName.replaceAll("[^A-Za-z0-9]", DEFAULT_DSS_RESOURCE_SEPARATOR).toLowerCase(Locale.ENGLISH);
        String substrToUse = name.substring(0, Math.min(name.length(), availableChars));
        return String.format("%s%s", "dss-", substrToUse);
    }

    @Override
    public String getImageName() throws IllegalConfigurationException {
        String infraImagesNamePrefix = this.getInfra().imagesNamePrefix;
        if (StringUtils.isNotBlank((String)infraImagesNamePrefix) && !IMAGE_PREFIX_PATTERN.matcher(infraImagesNamePrefix).matches()) {
            throw ErrorContext.icef((String)"The images prefix '%s' is not valid. It may contain lowercase letters, digits and separators. A separator is defined as a period, one or two underscores, or one or more hyphens. The image prefix may not start or end with a separator. Components can be separated using slashes.", (Object)infraImagesNamePrefix, (Object[])new Object[0]);
        }
        String imageName = (String)(StringUtils.isBlank((String)infraImagesNamePrefix) ? "" : infraImagesNamePrefix + "/") + "apimodel-" + APIDeployerImageBuilderService.sanitizeDeploymentId(this.getDeployment().id);
        int totalChars = imageName.length();
        if (totalChars >= 256) {
            int flexibleChars = StringUtils.length((String)infraImagesNamePrefix) + this.getDeployment().id.length();
            int charsToUpdate = FullyManagedAPIServiceDeploymentConfigManager.getRemainingCharacters(totalChars, flexibleChars, 256);
            throw ErrorContext.icef((String)"The combination of the image prefix '%s' plus the deployment id '%s' is too long, you need to change them. There should be less than %s characters in total.", (Object)FullyManagedAPIServiceDeploymentConfigManager.ellipsesInMiddle(infraImagesNamePrefix, 40), (Object[])new Object[]{FullyManagedAPIServiceDeploymentConfigManager.ellipsesInMiddle(this.getDeployment().id, 40), charsToUpdate});
        }
        return imageName;
    }

    @Override
    public String generateImageVersion() throws IllegalConfigurationException {
        String imageVersion = String.format(REPOSITORY_IMAGE_TAG_FORMAT, APIServiceDeploymentHelper.getSanitizedDSSVersionForImages(), this.getDeployment().publishedServiceId, this.getDeployment().getActiveGeneration(), DKUDateUtils.isoFormatFileFriendlyLocalNow());
        String sanitizedImageVersion = this.sanitizeImageTag(imageVersion);
        int totalChars = sanitizedImageVersion.length();
        if (totalChars >= 128) {
            int flexibleChars = this.getDeployment().publishedServiceId.length() + this.getDeployment().getActiveGeneration().length();
            int charsToUpdate = FullyManagedAPIServiceDeploymentConfigManager.getRemainingCharacters(totalChars, flexibleChars, 128);
            throw ErrorContext.icef((String)"The combination of the service id '%s' plus the generation name '%s' is too long, you need to change them. There should be less than %s characters in total.", (Object)FullyManagedAPIServiceDeploymentConfigManager.ellipsesInMiddle(this.getDeployment().publishedServiceId, 40), (Object[])new Object[]{FullyManagedAPIServiceDeploymentConfigManager.ellipsesInMiddle(this.getDeployment().getActiveGeneration(), 40), charsToUpdate});
        }
        return sanitizedImageVersion;
    }

    private static int getRemainingCharacters(int totalChars, int flexibleChars, int maxChars) {
        int incompressibleChars = totalChars - flexibleChars;
        return maxChars - incompressibleChars;
    }

    @Nonnull
    private static String ellipsesInMiddle(@Nullable String message, int maxLength) {
        String ellipsis = "\u2026";
        if (message == null) {
            return "";
        }
        if (message.length() >= maxLength) {
            int halfLength = (maxLength - "\u2026".length()) / 2;
            return message.substring(0, halfLength) + "\u2026" + message.substring(message.length() - halfLength);
        }
        return message;
    }

    protected String sanitizeImageTag(String tag) {
        String sanitizedTag = tag.replaceAll("[^\\x00-\\x7F]", "");
        return sanitizedTag.replaceAll("[^a-zA-Z0-9.\\-_]", DEFAULT_DSS_RESOURCE_SEPARATOR);
    }

    @Nonnull
    public Map<String, String> prepareTags() {
        HashMap<String, String> tagsMap = new HashMap<String, String>();
        AbstractFullyManagedAPIDeployment deployment = this.getDeployment();
        tagsMap.put(DSS_VERSION_TAG_KEY, DKUApp.getDSSVersion().product_version);
        tagsMap.put(DSS_INSTANCE_ID_TAG_KEY, DKUApp.getInstallId());
        tagsMap.put(SERVICE_ID_TAG_KEY, deployment.publishedServiceId);
        if (StringUtils.isBlank((String)deployment.endpointId)) {
            throw ErrorContext.ice((String)"The 'Endpoint id' is not defined in the deployment settings.");
        }
        tagsMap.put(ENDPOINT_ID_TAG_KEY, deployment.endpointId);
        if (deployment.generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        String generations = deployment.generationsMapping.getEntries().stream().map(mappingEntry -> mappingEntry.generation).collect(Collectors.joining(","));
        tagsMap.put(GENERATION_TAG_KEY, generations);
        tagsMap.put(DEPLOYMENT_ID_TAG_KEY, deployment.id);
        for (SimpleKeyValue tag : deployment.getDeploymentTags(this.getInfra())) {
            tagsMap.put(tag.key, this.getVC().expand(tag.value));
        }
        return tagsMap;
    }

    @Nonnull
    public List<SimpleKeyValue> getEnvironmentVariablesList() {
        return this.getInfra().environmentVars.stream().map(s -> new SimpleKeyValue(s.key, this.getVC().expand(s.value))).collect(Collectors.toList());
    }

    @Nonnull
    public Map<String, String> getEnvironmentVariablesMap() {
        return this.getEnvironmentVariablesList().stream().collect(Collectors.toMap(s -> s.key, s -> s.value));
    }
}

