/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.infra;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.config.StaticAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.deployer.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.deployer.apideployer.monitoring.ApiDeploymentSystemMonitoringService;
import com.dataiku.dip.deployer.apideployer.monitoring.ApiEndpointActivityMonitoringService;
import com.dataiku.dip.deployer.apideployer.monitoring.SystemMetric;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.lambda.client.LambdaAdminAPIClient;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiNodeStaticInfraManager
implements ApiNodeInfraManager {
    private final StaticAPIDeploymentInfra infra;
    @Autowired
    private ApiEndpointActivityMonitoringService apiEndpointActivityMonitoringService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private ApiDeploymentSystemMonitoringService apiDeploymentSystemMonitoringService;
    private final DKULogger logger;

    public ApiNodeStaticInfraManager(StaticAPIDeploymentInfra infra, DKULogger logger) {
        this.infra = infra;
        this.logger = logger;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public InfoMessage.InfoMessages checkInfraStatus_NT(AuthCtx authCtx) {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        int healthyNodes = 0;
        for (StaticAPIDeploymentInfra.APINodeRef apiNode : this.infra.apiNodes) {
            try (LambdaAdminAPIClient client = new LambdaAdminAPIClient(apiNode.url, this.passwordEncryptionService.decryptIfEncrypted(apiNode.adminAPIKey), this.infra.shouldTrustAllCertificates(), null, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());){
                boolean healthy;
                JsonObject isAliveJson = client.isAlive(true);
                if (isAliveJson.get("alive").getAsBoolean()) {
                    healthy = true;
                } else {
                    healthy = false;
                    this.logger.warn((Object)("API node " + apiNode.url + ": state has been forced to \"not alive\""));
                }
                if (!isAliveJson.has("adminChecked")) {
                    this.logger.warnV("DSS Version of API node %s does not support checking of admin permissions of API key", new Object[]{apiNode.url});
                    messages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_OLD_VERSION, "Upgrade the DSS API node at " + apiNode.url + " to verify the API key");
                } else {
                    try {
                        if (!isAliveJson.get("adminChecked").getAsBoolean()) {
                            messages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_BAD_ADMIN_APIKEY, "API key for " + apiNode.url + " is invalid");
                            healthy = false;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Error while reading adminChecked field of isAlive reply", (Throwable)e);
                    }
                }
                if (!healthy) continue;
                ++healthyNodes;
            }
            catch (Exception e) {
                this.logger.warn((Object)("Get Status on API node " + apiNode.url + " failed"), (Throwable)e);
            }
        }
        if (this.infra.apiNodes.isEmpty()) {
            messages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_NO_APINODES, "There are no configured API nodes");
        } else if (healthyNodes == 0) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_UNHEALTHY_NODES, "All nodes are unhealthy");
        } else if (healthyNodes < this.infra.apiNodes.size()) {
            messages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_UNHEALTHY_NODES, this.infra.apiNodes.size() - healthyNodes + "  nodes are unhealthy");
        }
        return messages;
    }

    @Override
    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getActivityMetrics_NT(AuthCtx authCtx, int connectTimeout, int socketTimeout, String overridingConnectionName) {
        TransactionContext.assertNoAttachedTransaction();
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint = new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint();
        for (StaticAPIDeploymentInfra.APINodeRef apiNode : this.infra.apiNodes) {
            try (LambdaAdminAPIClient client = new LambdaAdminAPIClient(apiNode.url, this.passwordEncryptionService.decryptIfEncrypted(apiNode.adminAPIKey), this.infra.shouldTrustAllCertificates(), null, connectTimeout, socketTimeout);){
                String graphitePayload = client.getActivityMetrics();
                List<ApiEndpointActivityMonitoringService.GraphiteLine> graphiteLines = this.apiEndpointActivityMonitoringService.parseAndCheckGraphitePayload(authCtx, graphitePayload, ActivityMonitoringSettings.Pull.class);
                this.apiEndpointActivityMonitoringService.mergeGraphiteLines(graphiteLines, timeAndMetricsByDeploymentAndEndpoint);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Get activity metrics on API node " + apiNode.url + " failed"), (Throwable)e);
            }
        }
        return timeAndMetricsByDeploymentAndEndpoint;
    }

    @Override
    public SystemMetric.TimeAndMetricsByDeployment getSystemMetrics_NT(AuthCtx authCtx, int connectTimeout, int socketTimeout, String overridingConnectionName) {
        TransactionContext.assertNoAttachedTransaction();
        this.logger.traceV("Fetching system metrics from static API node infrastructure: %s", new Object[]{this.infra.id});
        long nowSeconds = DateTime.now().getMillis() / 1000L;
        List<ApiDeploymentSystemMonitoringService.GraphiteLine> graphiteLines = this.getSystemMetricsGraphiteLines(connectTimeout, socketTimeout);
        return ApiDeploymentSystemMonitoringService.mergeGraphiteLines(graphiteLines, nowSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ApiDeploymentSystemMonitoringService.GraphiteLine> getSystemMetricsGraphiteLines(int connectTimeout, int socketTimeout) {
        List futures;
        if (this.infra.apiNodes.isEmpty()) {
            return List.of();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(this.infra.apiNodes.size(), 4), new ThreadFactoryBuilder().setNameFormat("getSystemMetricsGraphiteLines-%d").build());
        List tasks = this.infra.apiNodes.stream().map(apiNode -> this.taskForApiNode((StaticAPIDeploymentInfra.APINodeRef)apiNode, connectTimeout, socketTimeout)).collect(Collectors.toList());
        try {
            futures = executorService.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            this.logger.warnV((Throwable)e, "Failed to fetch system metrics from static API node infrastructure: %s", new Object[]{this.infra.id});
            List<ApiDeploymentSystemMonitoringService.GraphiteLine> list = List.of();
            return list;
        }
        finally {
            executorService.shutdown();
        }
        return futures.stream().map(future -> {
            try {
                return (List)future.get();
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @VisibleForTesting
    public List<ApiDeploymentSystemMonitoringService.GraphiteLine> getInfraSystemMetricsGraphiteLines(StaticAPIDeploymentInfra.APINodeRef apiNodeRef, int connectTimeout, int socketTimeout) {
        String graphitePayload;
        try (LambdaAdminAPIClient client = new LambdaAdminAPIClient(apiNodeRef.url, this.passwordEncryptionService.decryptIfEncrypted(apiNodeRef.adminAPIKey), this.infra.shouldTrustAllCertificates(), null, connectTimeout, socketTimeout);){
            graphitePayload = client.getSystemMetrics();
        }
        catch (Exception e) {
            this.logger.warnV((Throwable)e, "Failed to fetch system metrics from API node %s", new Object[]{apiNodeRef.url});
            return null;
        }
        if (StringUtils.isEmpty((String)graphitePayload)) {
            return null;
        }
        return this.apiDeploymentSystemMonitoringService.parseAndCheckGraphitePayload(graphitePayload);
    }

    private Callable<List<ApiDeploymentSystemMonitoringService.GraphiteLine>> taskForApiNode(StaticAPIDeploymentInfra.APINodeRef apiNode, int connectTimeout, int socketTimeout) {
        return () -> this.getInfraSystemMetricsGraphiteLines(apiNode, connectTimeout, socketTimeout);
    }
}

