/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.projectdeployer.deployments;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.deployments.AbstractDeploymentManager;
import com.dataiku.dip.deployer.common.deployments.AbstractDeploymentsService;
import com.dataiku.dip.deployer.common.engine.DeploymentReport;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.BundleOriginInfo;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsDAO;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.deployer.projectdeployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.logging.AutoClosableAppenderWrapper;
import com.dataiku.dip.nodeclients.AutomationNodeClient;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.BundleActivator;
import com.dataiku.dip.projects.importexport.BundleCodes;
import com.dataiku.dip.projects.importexport.BundlePreloader;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.model.BundleActivationTestResult;
import com.dataiku.dip.scheduler.scenarios.TestingStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ScenarioReportsService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProjectDeploymentManager<R extends ProjectDeploymentReport>
extends AbstractDeploymentManager<AbstractProjectDeployment, AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo, AbstractProjectDeploymentInfra, R> {
    public static final Set<String> neverEverDeployed = Collections.synchronizedSet(new HashSet());
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private ProjectDeploymentsDAO projectDeploymentsDAO;
    @Autowired
    private ProjectDeploymentsService projectDeploymentsService;
    @Autowired
    private AutomationNodeInfrasService automationNodeInfrasService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    protected final String targetProjectKey;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.automation.manager");

    protected AbstractProjectDeploymentManager(@Nonnull AuthCtx authCtx, AbstractProjectDeployment deployment) {
        super(authCtx);
        this.targetProjectKey = deployment.getTargetProjectKey();
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Nonnull
    protected abstract List<ScenarioRunsByNode> retrieveScenarioRunsWithinDateRange_NT(String var1, String var2) throws IOException, CodedException;

    @Nonnull
    protected abstract InfoMessage.InfoMessages synchronisationPreparation() throws CodedException;

    @Nonnull
    protected abstract BundlePreloader.BundlePreloadingReport bundlePreloading(DKUtils.SmartLogTailBuilder var1) throws InterruptedException;

    @Nonnull
    protected abstract BundleActivationTestResult activationChecking_NT() throws InterruptedException;

    protected boolean isProjectStandardsFeatureAllowed() {
        return this.licenseEnforcementService.getFeaturesStatus().projectStandardsAllowed;
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected AbstractDeploymentsService<AbstractProjectDeployment, AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo, AbstractProjectDeploymentInfra> getDeploymentsService() {
        return this.projectDeploymentsService;
    }

    @Override
    protected int numberOfDeploymentSteps() {
        return 4;
    }

    @Override
    @Nonnull
    protected String getDeploymentPrettyName() {
        return "activation of the bundle";
    }

    @Override
    protected void preDeploymentActions(@Nonnull ProjectDeploymentReport report, @Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) throws InterruptedException, CodedException {
        if (this.isProjectStandardsFeatureAllowed()) {
            report.mergeFromProjectStandardsCheckReport(this.projectDeploymentsService.verifyProjectStandards(this.automationNodeInfrasService.basicInfoUnsafe((AbstractProjectDeploymentInfra)this.getInfra()), (AbstractProjectDeployment)this.getDeployment(), this.authCtx, true));
            FutureProgress.incrementState((double)1.0);
            if (AbstractProjectDeploymentManager.hasFatalOrErrorMessages(report)) {
                return;
            }
        }
        report.mergeFromSynchronisationPreparationReport(this.synchronisationPreparation());
        FutureProgress.incrementState((double)1.0);
        if (AbstractProjectDeploymentManager.hasFatalOrErrorMessages(report)) {
            return;
        }
        report.mergeFromBundlePreloadingReport(this.bundlePreloading(logTailBuilder));
        FutureProgress.incrementState((double)1.0);
        if (AbstractProjectDeploymentManager.hasFatalOrErrorMessages(report)) {
            return;
        }
        report.mergeFromActivationCheckingReport(this.activationChecking_NT());
        FutureProgress.incrementState((double)1.0);
        if (!AbstractProjectDeploymentManager.hasFatalOrErrorMessages(report)) {
            logger.infoV("Activate bundle %s on automation node project %s for infra %s", new Object[]{((AbstractProjectDeployment)this.getDeployment()).bundleId, this.targetProjectKey, ((AbstractProjectDeploymentInfra)this.getInfra()).id});
            logger.info((Object)("Performing activate for deployment " + ((AbstractProjectDeployment)this.getDeployment()).id));
        }
    }

    @Override
    protected void postDeploymentActions(@Nonnull ProjectDeploymentReport report) {
        if (report.preDeploymentActionsSucceeded()) {
            if (report.getBundleActivationReport() == null || report.getBundleActivationReport().isEmpty()) {
                logger.info((Object)"Report for activate is empty");
            } else {
                logger.infoV("activate report: %s", new Object[]{report.getBundleActivationReport().report("\n")});
            }
        }
        logger.infoV("preload-activate report: %s", new Object[]{report.report()});
    }

    @Override
    @Nonnull
    protected FuturePayload getDeploymentPayload() {
        return FuturePayload.newSimple((String)"start_single_step_project_deployment", (String)("Single-step sync of project deployment: " + ((AbstractProjectDeployment)this.getDeployment()).id));
    }

    @Nonnull
    protected InfoMessage.InfoMessages prepareSyncOnAutomationNode(NodeConnection nodeConnection) {
        InfoMessage.InfoMessages report = new InfoMessage.InfoMessages();
        try (AutomationNodeClient adminClient = this.automationNodeAdminClient(nodeConnection);
             AutomationNodeClient userClient = this.automationNodeProxyUserClient(nodeConnection);){
            List<String> projectKeysOnAutomation = adminClient.getProjectKeys();
            boolean projectExists = false;
            boolean needsImport = true;
            if (projectKeysOnAutomation.contains(this.targetProjectKey)) {
                logger.infoV("Project %s already exists on automation node %s, checking if bundle needs import", new Object[]{this.targetProjectKey, nodeConnection.getUrlWithIdIfExists()});
                projectExists = true;
                CommonBundleUtils.BundleInfoList bundleInfoList = userClient.listBundles(this.targetProjectKey);
                for (CommonBundleUtils.BundleInfoBase bundleInfo : bundleInfoList.bundles) {
                    if (!((AbstractProjectDeployment)this.getDeployment()).bundleId.equals(bundleInfo.bundleId)) continue;
                    logger.infoV("Bundle %s already exists in project %s on automation node %s, no need to import", new Object[]{((AbstractProjectDeployment)this.getDeployment()).bundleId, this.targetProjectKey, nodeConnection.getUrlWithIdIfExists()});
                    needsImport = false;
                    break;
                }
            }
            if (needsImport) {
                File bundle = this.publishedProjectsService.getPublishedPackageFileMandatory(((AbstractProjectDeployment)this.getDeployment()).publishedProjectKey, ((AbstractProjectDeployment)this.getDeployment()).bundleId);
                if (projectExists) {
                    logger.infoV("Importing bundle %s in project %s on automation node %s", new Object[]{((AbstractProjectDeployment)this.getDeployment()).bundleId, this.targetProjectKey, nodeConnection.getUrlWithIdIfExists()});
                    userClient.importBundle(bundle, this.targetProjectKey, this.shouldAllowProjectKeyMismatchWhenImporting());
                } else {
                    logger.infoV("Project %s does not exist on automation node %s, creating project with initial bundle %s", new Object[]{this.targetProjectKey, nodeConnection.getUrlWithIdIfExists(), ((AbstractProjectDeployment)this.getDeployment()).bundleId});
                    userClient.createWithInitialBundle(bundle, this.targetProjectKey, ((AbstractProjectDeployment)this.getDeployment()).projectFolderId, ((AbstractProjectDeploymentInfra)this.getInfra()).permissionsPropagationPolicy);
                }
            }
        }
        catch (APIError.APIErrorException e) {
            this.handleErrorException((Exception)((Object)e), report, "upload", nodeConnection);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Upload bundle %s to project %s on automation node %s failed", new Object[]{((AbstractProjectDeployment)this.getDeployment()).bundleId, this.targetProjectKey, nodeConnection.getUrlWithIdIfExists()});
            report.withFatal((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_UPLOAD_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return report;
    }

    private boolean shouldAllowProjectKeyMismatchWhenImporting() throws IOException {
        BundleOriginInfo bundleOriginInfo = this.publishedProjectsService.getBundleOriginInfo(((AbstractProjectDeployment)this.getDeployment()).publishedProjectKey, ((AbstractProjectDeployment)this.getDeployment()).bundleId);
        if (bundleOriginInfo != null && bundleOriginInfo.designNodeInfo != null) {
            return !this.targetProjectKey.equals(bundleOriginInfo.designNodeInfo.projectKey);
        }
        logger.infoV("Unable to get the original project key of bundle %s in project %s, therefore allowing project key mismatches by default", new Object[]{((AbstractProjectDeployment)this.getDeployment()).bundleId, ((AbstractProjectDeployment)this.getDeployment()).publishedProjectKey});
        return true;
    }

    private void handleErrorException(Exception ex, InfoMessage.InfoMessages report, String action, NodeConnection nodeConnection) {
        String message = String.format("Automation node %s returned an error when trying to %s bundle %s on project %s", nodeConnection.getExternalUrlWithIdIfExists(), action, ((AbstractProjectDeployment)this.getDeployment()).bundleId, this.targetProjectKey);
        logger.warnV((Throwable)ex, message, new Object[0]);
        report.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_REMOTE_ERROR, message + ": %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)ex)});
    }

    private void prefixInfoMessagesWithAutomationNodeDetails(InfoMessage.InfoMessages messages, NodeConnection nodeConnection) {
        if (nodeConnection.automationNodeId == null) {
            messages.prefixMessageDetails(String.format("Message from automation node (infra: '%s'): ", ((AbstractProjectDeploymentInfra)this.getInfra()).id));
        } else {
            messages.prefixMessageDetails(String.format("Message from automation node (infra: '%s', automation node: %s): ", ((AbstractProjectDeploymentInfra)this.getInfra()).id, nodeConnection.automationNodeId));
        }
    }

    @Nonnull
    protected BundlePreloader.BundlePreloadingReport preloadOnAutomationNode(NodeConnection nodeConnection, DKUtils.SmartLogTailBuilder logTailBuilder) throws InterruptedException {
        BundlePreloader.BundlePreloadingReport report = new BundlePreloader.BundlePreloadingReport();
        try (AutomationNodeClient client = this.automationNodeProxyUserClient(nodeConnection);){
            this.saveSettings(client);
            this.setLocalVariables(client);
            AbstractBundleService.BundlePreloadOptions preloadOptions = new AbstractBundleService.BundlePreloadOptions();
            preloadOptions.async = true;
            FutureResponse futureResponse = client.startPreload(this.targetProjectKey, ((AbstractProjectDeployment)this.getDeployment()).bundleId, preloadOptions);
            futureResponse = client.waitCompletion(futureResponse, (TypeToken)new TypeToken<FutureResponse<BundlePreloader.BundlePreloadingReport>>(){}, logTailBuilder, this.getAutomationNodeLogTailPrefix(nodeConnection));
            report = (BundlePreloader.BundlePreloadingReport)((Object)futureResponse.result);
            this.prefixInfoMessagesWithAutomationNodeDetails(report, nodeConnection);
        }
        catch (InterruptedException e) {
            logger.warnV((Throwable)e, "project bundle preload interrupted", new Object[0]);
            throw e;
        }
        catch (Exception e) {
            this.handleErrorException(e, report, "preload", nodeConnection);
        }
        return report;
    }

    protected String getAutomationNodeLogTailPrefix(NodeConnection nodeConnection) {
        if (nodeConnection.automationNodeId == null) {
            return String.format("[Automation node %s]: ", ((AbstractProjectDeploymentInfra)this.getInfra()).id);
        }
        return String.format("[Infra %s, Automation node %s]: ", ((AbstractProjectDeploymentInfra)this.getInfra()).id, nodeConnection.automationNodeId);
    }

    @Nonnull
    protected BundleActivationTestResult activateCheckOnAutomationNode_NT(NodeConnection nodeConnection) throws InterruptedException {
        BundleActivationTestResult report = new BundleActivationTestResult();
        try (AutomationNodeClient client = this.automationNodeProxyUserClient(nodeConnection);
             AutoClosableAppenderWrapper ignored1 = this.getDeploymentsService().appendThreadLogsToDeploymentLogFile((AbstractProjectDeployment)this.getDeployment());
             AutoClosableAppenderWrapper ignored2 = this.getDeploymentsService().appendThreadLogsToUpdateLogFile((AbstractProjectDeploymentInfra)this.getInfra(), (AbstractProjectDeployment)this.getDeployment());){
            BundleActivationTestResult activationReport = client.activateCheck(this.targetProjectKey, ((AbstractProjectDeployment)this.getDeployment()).bundleId);
            this.prefixInfoMessagesWithAutomationNodeDetails(activationReport, nodeConnection);
            report.mergeFrom(activationReport);
        }
        catch (InterruptedException e) {
            Object message = "project bundle activate check interrupted";
            if (nodeConnection.automationNodeId != null) {
                message = (String)message + " on node " + nodeConnection.automationNodeId;
            }
            logger.warnV((Throwable)e, (String)message, new Object[0]);
            throw e;
        }
        catch (Exception e) {
            this.handleErrorException(e, report, "activate-check", nodeConnection);
        }
        return report;
    }

    @Nonnull
    protected AbstractBundleService.BundleActivationOptions buildBundleActivationOptions(InfoMessage.InfoMessages additionalMessages) {
        AbstractBundleService.BundleActivationOptions bundleActivationOptions = new AbstractBundleService.BundleActivationOptions();
        bundleActivationOptions.async = true;
        bundleActivationOptions.scenariosActiveOnActivation = ImmutableMap.copyOf(((AbstractProjectDeployment)this.getDeployment()).scenariosToActivate);
        if (((AbstractProjectDeploymentInfra)this.getInfra()).overrideRunAsUser) {
            bundleActivationOptions.setRunAsUser = ((AbstractProjectDeploymentInfra)this.getInfra()).getRunAsUserForTargetProject(((AbstractProjectDeployment)this.getDeployment()).getTargetProjectKey());
            if (StringUtils.isEmpty((String)bundleActivationOptions.setRunAsUser)) {
                additionalMessages.withWarning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_INFRA_CONFIGURATION, "Override of run as user activated, but no user configured for project " + ((AbstractProjectDeployment)this.getDeployment()).getTargetProjectKey());
            }
        }
        bundleActivationOptions.restartWebApps = ((AbstractProjectDeploymentInfra)this.getInfra()).restartWebAppsOnUpdate;
        return bundleActivationOptions;
    }

    @Nonnull
    protected BundleActivator.BundleActivationReport doDeploymentOnAutomationNode(NodeConnection nodeConnection, AbstractBundleService.BundleActivationOptions bundleActivationOptions, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        BundleActivator.BundleActivationReport report = new BundleActivator.BundleActivationReport();
        try (AutomationNodeClient client = this.automationNodeProxyUserClient(nodeConnection);){
            String log = "Starting activation of bundle " + ((AbstractProjectDeployment)this.getDeployment()).bundleId + ", requested by user " + this.authCtx.getIdentifier();
            if (nodeConnection.automationNodeId != null) {
                log = log + ", on node " + nodeConnection.automationNodeId;
            }
            if (StringUtils.isNotBlank((String)bundleActivationOptions.setRunAsUser)) {
                log = log + ". Activation will be performed as " + bundleActivationOptions.setRunAsUser + " on automation node.";
            }
            logger.info((Object)log);
            FutureResponse fr = client.startActivate(this.targetProjectKey, ((AbstractProjectDeployment)this.getDeployment()).bundleId, bundleActivationOptions);
            fr = client.waitCompletion(fr, (TypeToken)new TypeToken<FutureResponse<BundleActivator.BundleActivationReport>>(){}, logTailBuilder, this.getAutomationNodeLogTailPrefix(nodeConnection));
            report.mergeFrom((InfoMessage.InfoMessages)fr.result);
            String endOfActivationMessage = "End of activation of bundle " + ((AbstractProjectDeployment)this.getDeployment()).bundleId;
            if (nodeConnection.automationNodeId != null) {
                endOfActivationMessage = endOfActivationMessage + " on node " + nodeConnection.automationNodeId;
            }
            logger.info((Object)endOfActivationMessage);
            this.saveSettings(client);
            this.prefixInfoMessagesWithAutomationNodeDetails(report, nodeConnection);
        }
        catch (InterruptedException e) {
            logger.warnV((Throwable)e, "project bundle activate interrupted", new Object[0]);
            throw e;
        }
        catch (Exception e) {
            this.handleErrorException(e, report, "activate", nodeConnection);
        }
        return report;
    }

    public abstract TestingStatus getTestingStatus(@Nullable String var1, @Nullable String var2) throws IOException, CodedException;

    public abstract TestingStatus runTestScenarios(@Nullable String var1) throws CodedException, IOException;

    @Override
    protected VersionTag updateDeploymentTag() throws IOException {
        VersionTag updatedDeploymentTag;
        try (RWTransaction tr = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            String identifier = this.authCtx.getIdentifier();
            AbstractProjectDeployment deployment = (AbstractProjectDeployment)this.projectDeploymentsService.getDeploymentDAO().getMandatory(((AbstractProjectDeployment)this.getDeployment()).id);
            deployment.deploymentTag = updatedDeploymentTag = VersionTag.increment(deployment.deploymentTag, identifier);
            String deployAsUserForTargetProject = ((AbstractProjectDeploymentInfra)this.getInfra()).getDeployAsUserForTargetProject(((AbstractProjectDeployment)this.getDeployment()).getTargetProjectKey());
            if (deployAsUserForTargetProject != null && !StringUtils.equals((String)deployAsUserForTargetProject, (String)identifier)) {
                deployment.deploymentTag.putExtendedProperty("deployedAsUser", deployAsUserForTargetProject);
            }
            this.projectDeploymentsDAO.save(deployment);
            tr.commit("Updated deploymentTag");
        }
        return updatedDeploymentTag;
    }

    protected boolean isProjectPresentOnAutomationNode(NodeConnection nodeConnection) {
        boolean bl;
        block8: {
            AutomationNodeClient client = this.automationNodeProxyUserClient(nodeConnection);
            try {
                bl = client.getProjects().stream().anyMatch(p -> p.projectKey.equals(this.targetProjectKey));
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Unable to retrieve projects from automation node id %s", new Object[]{nodeConnection.automationNodeId});
                    return false;
                }
            }
            client.close();
        }
        return bl;
    }

    private void saveSettings(AutomationNodeClient client) throws IOException {
        JsonObject settings = client.getSettings(this.targetProjectKey);
        settings.add("bundleContainerSettings", JSON.toJsonElement((Object)((AbstractProjectDeployment)this.getDeployment()).getBundleContainerSettings((AbstractProjectDeploymentInfra)this.getInfra())));
        SerializedProject.ProjectSettings projectSettings = (SerializedProject.ProjectSettings)JSON.parse((JsonElement)settings.get("settings"), SerializedProject.ProjectSettings.class);
        projectSettings.disableAutomaticTriggers = ((AbstractProjectDeployment)this.getDeployment()).disableAutomaticTriggers;
        settings.add("settings", JSON.toJsonElement((Object)projectSettings));
        client.saveSettings(this.targetProjectKey, settings);
    }

    private void setLocalVariables(AutomationNodeClient client) throws IOException {
        VariablesService.ProjectVariables variables = client.getVariables(this.targetProjectKey);
        for (String variableName : ((AbstractProjectDeployment)this.getDeployment()).localVariables.keySet()) {
            variables.local.add(variableName, ((AbstractProjectDeployment)this.getDeployment()).localVariables.get(variableName));
        }
        client.saveVariables(this.targetProjectKey, variables);
    }

    private static boolean hasFatalOrErrorMessages(InfoMessage.InfoMessages infoMessages) {
        return infoMessages.anyFatal() || infoMessages.maxSeverity == InfoMessage.Severity.ERROR;
    }

    private AutomationNodeClient automationNodeAdminClient(NodeConnection nodeConnection) throws CodedException {
        return AutomationNodeClient.automationNodeClient(nodeConnection, null, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }

    protected AutomationNodeClient automationNodeProxyUserClient(NodeConnection nodeConnection) throws CodedException {
        return AutomationNodeClient.automationNodeOverridableProxyUserClient(this.authCtx, (AbstractProjectDeploymentInfra)this.getInfra(), nodeConnection, this.targetProjectKey, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }

    public static abstract class ProjectDeploymentReport
    extends DeploymentReport {
        private final boolean projectStandardsAllowed;
        protected InfoMessage.InfoMessages projectStandardsCheckReport;

        public abstract InfoMessage.InfoMessages getSynchronisationPreparationReport();

        public abstract InfoMessage.InfoMessages getBundlePreloadingReport();

        public abstract BundleActivationTestResult getActivationCheckingReport();

        public abstract BundleActivator.BundleActivationReport getBundleActivationReport();

        public abstract void mergeFromSynchronisationPreparationReport(@Nonnull InfoMessage.InfoMessages var1);

        public abstract void mergeFromBundlePreloadingReport(@Nonnull InfoMessage.InfoMessages var1);

        public abstract void mergeFromActivationCheckingReport(@Nonnull BundleActivationTestResult var1);

        public ProjectDeploymentReport(boolean projectStandardsAllowed) {
            this.projectStandardsAllowed = projectStandardsAllowed;
        }

        public void mergeFromProjectStandardsCheckReport(@Nonnull InfoMessage.InfoMessages report) {
            this.projectStandardsCheckReport = report;
            this.mergeFrom(report);
        }

        public InfoMessage.InfoMessages getProjectStandardsCheckReport() {
            return this.projectStandardsCheckReport;
        }

        public boolean isProjectStandardsFeatureAllowed() {
            return this.projectStandardsAllowed;
        }

        @Override
        public InfoMessage.Severity getMaxSeverity() {
            if (this.getSynchronisationPreparationReport() == null || this.getBundlePreloadingReport() == null || this.getActivationCheckingReport() == null || this.getBundleActivationReport() == null) {
                return InfoMessage.Severity.ERROR;
            }
            return this.maxSeverity;
        }

        public String report() {
            StringBuilder sb = new StringBuilder();
            if (this.projectStandardsAllowed) {
                sb.append("prepare project standards check report:\n");
                if (this.getProjectStandardsCheckReport() != null) {
                    sb.append(this.getProjectStandardsCheckReport().report("\n"));
                } else {
                    sb.append("none");
                }
                sb.append("\n");
            }
            sb.append("prepare sync report:\n");
            if (this.getSynchronisationPreparationReport() != null) {
                sb.append(this.getSynchronisationPreparationReport().report("\n"));
            } else {
                sb.append("none");
            }
            sb.append("\n");
            sb.append("preload report:\n");
            if (this.getBundlePreloadingReport() != null) {
                sb.append(this.getBundlePreloadingReport().report("\n"));
            } else {
                sb.append("none");
            }
            sb.append("\n");
            sb.append("activate check report:\n");
            if (this.getActivationCheckingReport() != null) {
                sb.append("bundleId: ").append(this.getActivationCheckingReport().bundleId).append("\n");
                sb.append(this.getActivationCheckingReport().report("\n"));
            } else {
                sb.append("none");
            }
            sb.append("\n");
            sb.append("activate report:\n");
            if (this.getBundleActivationReport() != null) {
                sb.append("neededAMigration: ").append(this.getBundleActivationReport().neededAMigration).append("\n");
                sb.append(this.getBundleActivationReport().report("\n"));
            } else {
                sb.append("none");
            }
            sb.append("\n");
            return sb.toString();
        }

        @Override
        public void preHookFailure() {
            logger.error((Object)"Error during execution of pre deployment hooks. Bundle not activated.");
            this.deploymentHookExecutionStatus.preHookFailed = true;
        }

        @Override
        public boolean preDeploymentActionsSucceeded() {
            return (!this.projectStandardsAllowed || !AbstractProjectDeploymentManager.hasFatalOrErrorMessages(this.getProjectStandardsCheckReport())) && !AbstractProjectDeploymentManager.hasFatalOrErrorMessages(this.getSynchronisationPreparationReport()) && !AbstractProjectDeploymentManager.hasFatalOrErrorMessages(this.getBundlePreloadingReport()) && !AbstractProjectDeploymentManager.hasFatalOrErrorMessages(this.getActivationCheckingReport());
        }
    }

    public static class ScenarioRunsByNode {
        public final String automationNodeId;
        public final ScenarioReportsService.ScenarioDays scenarioRuns;

        public ScenarioRunsByNode(String automationNodeId, ScenarioReportsService.ScenarioDays scenarioRuns) {
            this.automationNodeId = automationNodeId;
            this.scenarioRuns = scenarioRuns;
        }
    }
}

