/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.projectdeployer.deployments;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.config.InfraStage;
import com.dataiku.dip.deployer.common.datamodel.config.PublishedItem;
import com.dataiku.dip.deployer.common.deployments.AbstractDeploymentsService;
import com.dataiku.dip.deployer.common.deployments.AbstractPublishedPackageInfoForGovernIdentification;
import com.dataiku.dip.deployer.common.infra.AbstractInfrasService;
import com.dataiku.dip.deployer.common.infra.DeploymentInfrasDAO;
import com.dataiku.dip.deployer.common.published.AbstractPublishedItemsService;
import com.dataiku.dip.deployer.projectdeployer.datamodel.actual.AbstractProjectDeploymentHeavyStatus;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.MultiNodeProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.SingleAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.SingleNodeProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.deployments.AbstractProjectDeploymentManager;
import com.dataiku.dip.deployer.projectdeployer.deployments.MultiNodeProjectDeploymentManager;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsDAO;
import com.dataiku.dip.deployer.projectdeployer.deployments.PublishedProjectBundleInfoForGovernIdentification;
import com.dataiku.dip.deployer.projectdeployer.deployments.SingleNodeProjectDeploymentManager;
import com.dataiku.dip.deployer.projectdeployer.infra.AbstractAutomationNodeInfraManager;
import com.dataiku.dip.deployer.projectdeployer.infra.AutomationNodeInfrasDAO;
import com.dataiku.dip.deployer.projectdeployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsDAO;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReport;
import com.dataiku.dip.scheduler.scenarios.TestingStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerDeploymentChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerDeploymentCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerDeploymentDeletedEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.transactions.exceptions.TransactionBadlyFailedError;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectDeploymentsService
extends AbstractDeploymentsService<AbstractProjectDeployment, AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo, AbstractProjectDeploymentInfra> {
    @Autowired
    private ProjectDeploymentsDAO deploymentsDAO;
    @Autowired
    private AutomationNodeInfrasDAO automationNodeInfrasDAO;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private PublishedProjectsDAO publishedProjectsDAO;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private AutomationNodeInfrasService infrasService;
    @Autowired
    private PubSubService pubSub;

    private void addMissingInfrasFromNodeDirectory() throws TransactionBadlyFailedError, IOException {
        NodesDirectoryService nodesDirectoryService = (NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class);
        NodesDirectory nd = nodesDirectoryService.getNodesDirectoryUnsafe_AutoTXN();
        if (nd.enabled) {
            this.getLogger().info((Object)"Nodes directory is enabled");
            NodesDirectory.NodeRef currentNode = nd.getCurrentNode();
            if (currentNode.configureDeployerServer) {
                this.getLogger().info((Object)"Current node is a deployer server, making sure that automation infras are created");
                Set missing = nd.nodes.stream().filter(nr -> nr.nodeType == NodesDirectory.NodeType.DSS_EXECUTION).filter(nr -> nr.singleNodeAsInfrastructure == null || nr.singleNodeAsInfrastructure != false).map(nr -> nr.nodeId).collect(Collectors.toSet());
                this.getLogger().info((Object)("List of all automation nodes in the directory: " + JSON.log(missing)));
                try (RWTransaction rwt = this.transactionService.beginWriteAsDSS();){
                    for (AbstractProjectDeploymentInfra infra : this.getInfrasDAO().list()) {
                        if (!infra.autoconfigureFromNodesDirectory) continue;
                        missing.remove(infra.id);
                    }
                    GeneralSettingsDAO.ProjectDeployerServerSettings projectDeployerServerSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().projectDeployerServerSettings;
                    InfraStage stage = (InfraStage)projectDeployerServerSettings.stages.get(0);
                    if (missing.size() > 0) {
                        this.getLogger().info((Object)("The following nodes are not in the deployment infras, adding them: " + JSON.log(missing)));
                        for (String missingNodeId : missing) {
                            SingleAutomationNodeInfra newInfra = new SingleAutomationNodeInfra(missingNodeId, stage.id, "nodes-directory", null, null, AbstractDeploymentInfra.GovernCheckPolicy.NO_CHECK);
                            newInfra.autoconfigureFromNodesDirectory = true;
                            newInfra.nodeId = missingNodeId;
                            this.getInfrasDAO().save(newInfra);
                        }
                    }
                    if (projectDeployerServerSettings.allowMultiNodeInfrastructures) {
                        this.getLogger().info((Object)"Multi-node infrastructures enabled");
                        for (NodesDirectory.LoadBalancerRef loadBalancer : nd.loadBalancers) {
                            for (String hostname : loadBalancer.targets.keySet()) {
                                List automationNodes = ((Set)loadBalancer.targets.get(hostname)).stream().map(nodeId -> nd.nodes.stream().filter(node -> Objects.equals(node.nodeId, nodeId)).findFirst().orElse(null)).filter(Objects::nonNull).filter(node -> node.nodeType == NodesDirectory.NodeType.DSS_EXECUTION).map(node -> new MultiAutomationNodeInfra.AutomationNodeRef(node.nodeId, node.url, node.externalUrl, node.adminAPIKey)).collect(Collectors.toList());
                                String infraId = loadBalancer.id + ":" + hostname;
                                String automationNodesList = automationNodes.stream().map(n -> n.nodeId).collect(Collectors.joining(", "));
                                MultiAutomationNodeInfra multiAutomationNodeInfra = (MultiAutomationNodeInfra)this.getInfrasDAO().getOrNull(infraId);
                                if (multiAutomationNodeInfra == null) {
                                    if (automationNodes.isEmpty()) continue;
                                    this.getLogger().info((Object)String.format("Creating new multi-node infrastructure \"%s\" with automation nodes [%s] and loadbalancer link %s", infraId, automationNodesList, loadBalancer.link));
                                    multiAutomationNodeInfra = new MultiAutomationNodeInfra(infraId, stage.id, "nodes-directory", AbstractDeploymentInfra.GovernCheckPolicy.NO_CHECK);
                                    multiAutomationNodeInfra.autoconfigureFromNodesDirectory = true;
                                    multiAutomationNodeInfra.automationNodes = automationNodes;
                                    multiAutomationNodeInfra.loadBalancerResourceUrl = loadBalancer.link;
                                    this.getInfrasDAO().save(multiAutomationNodeInfra);
                                    continue;
                                }
                                this.getLogger().info((Object)String.format("Updating multi-node infrastructure \"%s\" with automation nodes [%s] and loadbalancer link %s", infraId, automationNodesList, loadBalancer.link));
                                multiAutomationNodeInfra.automationNodes = automationNodes;
                                multiAutomationNodeInfra.loadBalancerResourceUrl = loadBalancer.link;
                                this.getInfrasDAO().save(multiAutomationNodeInfra);
                            }
                        }
                    }
                    rwt.commit("Add missing automation nodes from nodes directory");
                }
            }
        }
    }

    @PostConstruct
    public void startup() throws TransactionBadlyFailedError, IOException {
        this.addMissingInfrasFromNodeDirectory();
        this.pubSubService.subscribe("nodes-directory-updated", (DSSEventListener)new DSSEventListener<DSSEvent>(){

            public void on(DSSEvent evt) throws Exception {
                ProjectDeploymentsService.this.addMissingInfrasFromNodeDirectory();
            }
        });
    }

    protected ProjectDeploymentsDAO getDeploymentDAO() {
        return this.deploymentsDAO;
    }

    @Override
    protected DeploymentInfrasDAO<AbstractProjectDeploymentInfra> getInfrasDAO() {
        return this.automationNodeInfrasDAO;
    }

    protected PublishedProjectsService getPublishedItemsService() {
        return this.publishedProjectsService;
    }

    protected AutomationNodeInfrasService getInfrasService() {
        return this.infrasService;
    }

    @Override
    public PublishedProjectsDAO getPublishedItemsDAO() {
        return this.publishedProjectsDAO;
    }

    @Override
    protected Set<String> getNeverEverDeployedSet() {
        return AbstractProjectDeploymentManager.neverEverDeployed;
    }

    @Override
    protected void publishDeploymentConfigChangedEventAfterTransaction(String deploymentId, String infrastructureId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new ProjectDeployerDeploymentChangedEvent(deploymentId, infrastructureId));
    }

    @Override
    protected void publishDeploymentDeletedEventAfterTransaction(String deploymentId, String infrastructureId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new ProjectDeployerDeploymentDeletedEvent(deploymentId, infrastructureId));
    }

    @Override
    protected void publishDeploymentCopiedEventAfterTransaction(String deploymentId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new ProjectDeployerDeploymentCreatedEvent(deploymentId));
    }

    protected AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo getDeploymentBasicInfo(AbstractProjectDeployment deployment) throws IOException {
        AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo projectDeploymentBasicInfo = deployment.basicInfoUnsafe();
        this.addAuthorsNames(projectDeploymentBasicInfo);
        if (projectDeploymentBasicInfo.deploymentTag != null && StringUtils.isNotBlank((String)projectDeploymentBasicInfo.deploymentTag.getLastAuthor())) {
            PublicUser puAs;
            PublicUser pu = this.usersService.getPublicUser(projectDeploymentBasicInfo.deploymentTag.getLastAuthor());
            if (pu != null) {
                projectDeploymentBasicInfo.deployedByDisplayName = pu.displayName;
            }
            if (projectDeploymentBasicInfo.deploymentTag.getExtendedProperties().containsKey("deployedAsUser") && (puAs = this.usersService.getPublicUser(projectDeploymentBasicInfo.deploymentTag.getExtendedProperties().get("deployedAsUser").toString())) != null) {
                projectDeploymentBasicInfo.deployedAsDisplayName = puAs.displayName;
            }
        }
        return projectDeploymentBasicInfo;
    }

    @Override
    protected List<AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo> getDeploymentBasicInfoList(List<AbstractProjectDeployment> deployments) throws IOException {
        ArrayList<AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo> infos = new ArrayList<AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo>();
        for (AbstractProjectDeployment deployment : deployments) {
            infos.add(this.getDeploymentBasicInfo(deployment));
        }
        return infos;
    }

    @Override
    public List<AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo> listBasicInfoUnsafe_Check(AuthCtx authCtx) throws IOException {
        List<AbstractProjectDeployment> deployments = this.listDeploymentsUnsafe_Check(authCtx);
        return this.getDeploymentBasicInfoList(deployments);
    }

    @Override
    public List<AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo> listBasicInfoForInfraUnsafe_Check(String infraId, AuthCtx authCtx) throws IOException {
        List<AbstractProjectDeployment> deployments = this.listDeploymentsForInfraUnsafe_Check(infraId, authCtx);
        return this.getDeploymentBasicInfoList(deployments);
    }

    @Override
    public List<AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo> listBasicInfoForItemUnsafe_Check(String publishedItemId, AuthCtx authCtx) throws IOException {
        List<AbstractProjectDeployment> deployments = this.listLastSuccessfulDeploymentsForItemUnsafe_Check(publishedItemId, authCtx);
        return this.getDeploymentBasicInfoList(deployments);
    }

    protected AbstractDeploymentLightStatus.ProjectDeploymentLightStatus getDeploymentLightStatus_NT(AbstractProjectDeployment deployment, AbstractInfraBasicInfo infraBasicInfo, AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo projectBasicInfo, List<PublishedPackageInfo> publishedPackageInfoList, boolean hasFullDeployPermissions, boolean isInfraAdmin) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AbstractDeploymentLightStatus.ProjectDeploymentLightStatus projectDeploymentLightStatus = new AbstractDeploymentLightStatus.ProjectDeploymentLightStatus((AbstractDeploymentBasicInfo)this.getDeploymentBasicInfo(deployment), infraBasicInfo, publishedPackageInfoList, projectBasicInfo, hasFullDeployPermissions, isInfraAdmin);
            return projectDeploymentLightStatus;
        }
    }

    private AbstractProjectDeploymentInfra prepareCreation_Check(AuthCtx authCtx, String deploymentId, String publishedProjectKey, String infraId, String deployedProjectKey) throws IOException, UnauthorizedException {
        this.checkIdValidity(deploymentId, publishedProjectKey, infraId);
        if (!StringUtils.isBlank((String)deployedProjectKey) && !ProjectsService.isValidProjectKey(deployedProjectKey)) {
            throw ErrorContext.iaef((String)"Target project key is invalid: %s", (Object)deployedProjectKey, (Object[])new Object[0]);
        }
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedProjectKey);
        AbstractProjectDeploymentInfra infra = (AbstractProjectDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(infraId);
        this.checkDeployPermissions(infra, item, authCtx);
        return infra;
    }

    public String copy_Check(AuthCtx authCtx, String oldDeploymentId, String newDeploymentId, String newInfraId, String newDeployedProjectKey, String newProjectFolderId) throws UnauthorizedException, IOException {
        AbstractProjectDeployment deployment;
        AbstractProjectDeployment oldDeployment = (AbstractProjectDeployment)this.getDeploymentDAO().getMandatoryUnsafe(oldDeploymentId);
        AbstractProjectDeploymentInfra infra = this.prepareCreation_Check(authCtx, newDeploymentId, oldDeployment.getPublishedItemId(), newInfraId, newDeployedProjectKey);
        if (infra instanceof SingleAutomationNodeInfra) {
            deployment = new SingleNodeProjectDeployment(oldDeployment, newDeploymentId, newInfraId, newDeployedProjectKey, newProjectFolderId, new VersionTag(authCtx.getIdentifier()));
        } else if (infra instanceof MultiAutomationNodeInfra) {
            deployment = new MultiNodeProjectDeployment(oldDeployment, newDeploymentId, newInfraId, newDeployedProjectKey, newProjectFolderId, new VersionTag(authCtx.getIdentifier()));
        } else {
            throw new IllegalArgumentException("Invalid infra type: " + JSON.getType((Object)infra));
        }
        this.finalizeCreation(deployment);
        this.publishDeploymentCopiedEventAfterTransaction(deployment.id);
        return deployment.id;
    }

    public String create_Check(AuthCtx authCtx, String deploymentId, String publishedProjectKey, String infraId, String bundleId, String deployedProjectKey, String projectFolderId) throws UnauthorizedException, IOException {
        AbstractProjectDeployment deployment;
        AbstractProjectDeploymentInfra infra = this.prepareCreation_Check(authCtx, deploymentId, publishedProjectKey, infraId, deployedProjectKey);
        if (infra instanceof SingleAutomationNodeInfra) {
            deployment = new SingleNodeProjectDeployment(deploymentId, infraId, publishedProjectKey, bundleId, deployedProjectKey, projectFolderId, new VersionTag(authCtx.getIdentifier()));
        } else if (infra instanceof MultiAutomationNodeInfra) {
            this.infrasService.checkMultiAutomationNodeInfrastructuresAllowed();
            deployment = new MultiNodeProjectDeployment(deploymentId, infraId, publishedProjectKey, bundleId, deployedProjectKey, "ROOT", new VersionTag(authCtx.getIdentifier()));
        } else {
            throw new IllegalArgumentException("Invalid infra type: " + JSON.getType((Object)infra));
        }
        deployment.setConnectionRemappingSettingsFromInfra(infra);
        this.additionalSaveSteps((AbstractProjectDeployment)null, deployment);
        this.finalizeCreation(deployment);
        this.pubSub.publishAfterTransaction((DSSEvent)new ProjectDeployerDeploymentCreatedEvent(deployment.id));
        return deployment.id;
    }

    @Override
    protected boolean isDeployed(AbstractProjectDeployment deployment) {
        return Objects.nonNull(deployment.deploymentTag);
    }

    @Override
    protected void additionalSaveSteps(AbstractProjectDeployment oldDeployment, AbstractProjectDeployment newDeployment) throws IOException {
        newDeployment.tags = this.publishedProjectsService.getTagsFromBundle_NT(newDeployment.publishedProjectKey, newDeployment.bundleId);
        newDeployment.typeBadges = this.publishedProjectsService.getTypeBadgesFromBundle_NT(newDeployment.publishedProjectKey, newDeployment.bundleId);
    }

    @Override
    protected DSSItemGovernanceStatusList getGovernanceStatus_NT(List<AbstractPublishedPackageInfoForGovernIdentification> publishedPackages) throws IOException, CodedException {
        DSSItemIdentifierList dssItemIdentifierList = new DSSItemIdentifierList();
        for (AbstractPublishedPackageInfoForGovernIdentification publishedPackage : publishedPackages) {
            if (!(publishedPackage instanceof PublishedProjectBundleInfoForGovernIdentification)) {
                throw new AssertionError((Object)("Error: trying to publish something else than a " + PublishedProjectBundleInfoForGovernIdentification.class.getName() + " with " + this.getClass().getName()));
            }
            PublishedProjectBundleInfoForGovernIdentification publishedProjectBundle = (PublishedProjectBundleInfoForGovernIdentification)publishedPackage;
            dssItemIdentifierList.dssItemItentifiers.add(GovernIntegrationService.buildDSSBundleIdentifier(publishedProjectBundle));
        }
        return this.governIntegrationService.getDSSItemsGovernanceStatus(dssItemIdentifierList);
    }

    @Override
    protected String getPublishedItemType() {
        return "bundle";
    }

    private AbstractProjectDeploymentManager getDeploymentManager_NT_Check(@Nonnull AuthCtx authCtx, String deploymentId, boolean readOnly) throws UnauthorizedException, IOException, CodedException {
        PublishedItem publishedItem;
        AbstractInfraBasicInfo infraBasicInfo;
        AbstractProjectDeploymentInfra infra;
        AbstractProjectDeployment deployment;
        try (Transaction ignored = this.transactionService.beginRead();){
            deployment = (AbstractProjectDeployment)this.getDeploymentDAO().getMandatory(deploymentId);
            infra = (AbstractProjectDeploymentInfra)this.automationNodeInfrasDAO.getMandatory(deployment.infraId);
            infraBasicInfo = this.infrasService.getLightStatusUnsafe_Check((String)deployment.infraId, (AuthCtx)authCtx).infraBasicInfo;
            publishedItem = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.getPublishedItemId());
        }
        if (readOnly) {
            this.checkReadPermissions(infra, publishedItem, authCtx);
        } else {
            this.checkDeployPermissions(infra, publishedItem, authCtx);
        }
        if (StringUtils.isBlank((String)deployment.bundleId)) {
            throw ErrorContext.iae((String)"Active bundle id is empty");
        }
        this.doGovernanceCheck_NT(infraBasicInfo, deployment.getPublishedItemId(), Collections.singletonList(deployment.bundleId));
        return ProjectDeploymentsService.getDeploymentManager(authCtx, infra, deployment);
    }

    public FutureResponse<AbstractProjectDeploymentManager.ProjectDeploymentReport> executeOneStepSync_NT_Check(@Nonnull AuthCtx authCtx, String deploymentId) throws Exception {
        return this.getDeploymentManager_NT_Check(authCtx, deploymentId, false).startUpdateDeployment_NT();
    }

    @Override
    public AbstractProjectDeploymentHeavyStatus getHeavyStatus_Unsafe_NT_Check(AuthCtx authCtx, String deploymentId) throws UnauthorizedException, IOException {
        AbstractProjectDeploymentInfra infra;
        PublishedItem publishedItem;
        AbstractProjectDeployment deployment;
        try (Transaction ignored = this.transactionService.beginRead();){
            deployment = (AbstractProjectDeployment)this.deploymentsDAO.getMandatoryUnsafe(deploymentId);
            publishedItem = (PublishedItem)this.publishedProjectsDAO.getMandatoryUnsafe(deployment.getPublishedItemId());
            infra = (AbstractProjectDeploymentInfra)this.automationNodeInfrasDAO.getMandatory(deployment.infraId);
        }
        this.checkReadPermissions(infra, publishedItem, authCtx);
        if (StringUtils.isBlank((String)deployment.bundleId)) {
            throw ErrorContext.iae((String)"Active bundle id is empty");
        }
        return this.listHeavyStatus_NT(authCtx, Lists.newArrayList((Object[])new AbstractProjectDeployment[]{deployment}), infra, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout()).get(0);
    }

    public List<? extends AbstractProjectDeploymentHeavyStatus> listHeavyStatusUnsafe_NT_Check(AuthCtx authCtx, String infraId) throws UnauthorizedException, IOException {
        return this.listHeavyStatusUnsafe_NT_Check(authCtx, infraId, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }

    public List<? extends AbstractProjectDeploymentHeavyStatus> listHeavyStatusUnsafe_NT_Check(AuthCtx authCtx, String infraId, int connectTimeout, int socketTimeout) throws UnauthorizedException, IOException {
        List allDeployments;
        AbstractProjectDeploymentInfra infra;
        try (Transaction ignored = this.transactionService.beginRead();){
            infra = (AbstractProjectDeploymentInfra)this.automationNodeInfrasDAO.getMandatory(infraId);
            if (!AbstractInfrasService.hasReadPermission(infra, authCtx)) {
                throw new UnauthorizedException("Permission denied: unable to view deployments on this infrastructure", "deployment-action-denied");
            }
            allDeployments = this.deploymentsDAO.listUnsafe();
        }
        ArrayList<AbstractProjectDeployment> deployments = new ArrayList<AbstractProjectDeployment>();
        for (AbstractProjectDeployment deployment : allDeployments) {
            PublishedItem publishedProject;
            if (!infra.id.equals(deployment.infraId)) continue;
            try (Transaction ignored = this.transactionService.beginRead();){
                publishedProject = (PublishedItem)this.publishedProjectsDAO.getMandatoryUnsafe(deployment.getPublishedItemId());
            }
            if (!AbstractPublishedItemsService.hasReadPermission(publishedProject, authCtx)) continue;
            deployments.add(deployment);
            if (!StringUtils.isBlank((String)deployment.bundleId)) continue;
            this.getLogger().warnV("Active bundle id is empty for deployment %s", new Object[]{deployment.id});
        }
        return this.listHeavyStatus_NT(authCtx, deployments, infra, connectTimeout, socketTimeout);
    }

    private List<? extends AbstractProjectDeploymentHeavyStatus> listHeavyStatus_NT(AuthCtx authCtx, List<AbstractProjectDeployment> allDeployments, AbstractProjectDeploymentInfra infra, int connectTimeout, int socketTimeout) {
        AbstractAutomationNodeInfraManager manager = infra.getInfraManager(authCtx, connectTimeout, socketTimeout);
        return manager.listHeavyStatus(allDeployments);
    }

    public List<AbstractProjectDeploymentManager.ScenarioRunsByNode> getScenarioRunsWithinDateRange_NT_Check(@Nonnull AuthCtx authCtx, String deploymentId, String fromDate, String toDate) throws UnauthorizedException, IOException, CodedException {
        return this.getDeploymentManager_NT_Check(authCtx, deploymentId, true).retrieveScenarioRunsWithinDateRange_NT(fromDate, toDate);
    }

    public TestingStatus getTestingStatus(AuthCtx authCtx, String deploymentId, @Nullable String bundleId, @Nullable String automationNodeId) throws IOException, UnauthorizedException, CodedException {
        return this.getDeploymentManager_NT_Check(authCtx, deploymentId, true).getTestingStatus(bundleId, automationNodeId);
    }

    public TestingStatus runTestScenarios(AuthCtx authCtx, String deploymentId, @Nullable String automationNodeId) throws CodedException, UnauthorizedException, IOException {
        return this.getDeploymentManager_NT_Check(authCtx, deploymentId, true).runTestScenarios(automationNodeId);
    }

    @VisibleForTesting
    public static AbstractProjectDeploymentManager<? extends AbstractProjectDeploymentManager.ProjectDeploymentReport> getDeploymentManager(AuthCtx authCtx, AbstractProjectDeploymentInfra infra, AbstractProjectDeployment deployment) {
        if (infra instanceof SingleAutomationNodeInfra && deployment instanceof SingleNodeProjectDeployment) {
            return new SingleNodeProjectDeploymentManager(authCtx, (SingleNodeProjectDeployment)deployment, (SingleAutomationNodeInfra)infra);
        }
        if (infra instanceof MultiAutomationNodeInfra && deployment instanceof MultiNodeProjectDeployment) {
            return new MultiNodeProjectDeploymentManager(authCtx, (MultiNodeProjectDeployment)deployment, (MultiAutomationNodeInfra)infra);
        }
        throw ErrorContext.iaef((String)"Unsupported type combination: %s and %s", (Object)infra.getClass().getCanonicalName(), (Object[])new Object[]{deployment.getClass().getCanonicalName()});
    }

    private boolean verifyProjectStandardsPolicy(@Nonnull ProjectStandardsRunReport projectStandardsRunReport, AbstractProjectDeploymentInfra.ProjectStandardsPolicy projectStandardsPolicy) {
        return projectStandardsPolicy.maxSeverity >= projectStandardsRunReport.worstCheckSeverity(projectStandardsPolicy.errorCheckSeverityHandling);
    }

    private InfoMessage.InfoMessages invalidProjectStandardsStatusMessage(@Nonnull AbstractProjectDeploymentInfra.ProjectStandardsCheckPolicy checkPolicy, String message, String bundleId, String publishedProjectKey, String infraId) {
        InfoMessage.InfoMessages report = new InfoMessage.InfoMessages();
        if (AbstractProjectDeploymentInfra.ProjectStandardsCheckPolicy.WARN.equals((Object)checkPolicy)) {
            this.getLogger().warnV(message, new Object[]{bundleId, publishedProjectKey, infraId});
            report.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_PROJECT_STANDARDS_INVALID_STATUS, message, new Object[]{bundleId, publishedProjectKey, infraId});
        } else if (AbstractProjectDeploymentInfra.ProjectStandardsCheckPolicy.PREVENT.equals((Object)checkPolicy)) {
            this.getLogger().errorV(message, new Object[]{bundleId, publishedProjectKey, infraId});
            report.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_PROJECT_STANDARDS_INVALID_STATUS, message, new Object[]{bundleId, publishedProjectKey, infraId});
        }
        return report;
    }

    @Nonnull
    public InfoMessage.InfoMessages verifyProjectStandards(AbstractInfraBasicInfo.AbstractProjectDeploymentInfraBasicInfo infraBasicInfo, AbstractProjectDeployment deployment, AuthCtx authCtx, boolean ignoreWarnings) {
        return this.verifyProjectStandards(infraBasicInfo, deployment.publishedProjectKey, deployment.bundleId, authCtx, ignoreWarnings);
    }

    @Nonnull
    public InfoMessage.InfoMessages verifyProjectStandards(AbstractInfraBasicInfo.AbstractProjectDeploymentInfraBasicInfo infraBasicInfo, String publishedProjectKey, String bundleId, AuthCtx authCtx, boolean ignoreWarnings) {
        InfoMessage.InfoMessages report = new InfoMessage.InfoMessages();
        AbstractProjectDeploymentInfra.ProjectStandardsPolicy projectStandardsPolicy = infraBasicInfo.projectStandardsPolicy;
        String infraId = infraBasicInfo.id;
        if (AbstractProjectDeploymentInfra.ProjectStandardsCheckPolicy.PREVENT.equals((Object)projectStandardsPolicy.checkPolicy) || AbstractProjectDeploymentInfra.ProjectStandardsCheckPolicy.WARN.equals((Object)projectStandardsPolicy.checkPolicy)) {
            boolean hasReport;
            CommonBundleUtils.BundleDetails bundleDetails;
            try {
                bundleDetails = this.publishedProjectsService.getBundleDetails_NT(publishedProjectKey, bundleId, authCtx);
                hasReport = Objects.nonNull(bundleDetails.projectStandardsRunReport);
            }
            catch (Exception e) {
                String message = "Verifying Project Standards: Failed to load the Project Standards report from bundle \"%s\" for project \"%s\"";
                this.getLogger().warnV((Throwable)e, message, new Object[]{bundleId, publishedProjectKey});
                report.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_PROJECT_STANDARDS_VERIFICATION_FAILED, message, new Object[]{bundleId, publishedProjectKey});
                return report;
            }
            this.getLogger().infoV("Verifying Project Standards: Checking that the report for bundle \"%s\" and project \"%s\" meets the deployment configuration policy for infrastructure \"%s\"", new Object[]{bundleId, publishedProjectKey, infraId});
            if (hasReport && !this.verifyProjectStandardsPolicy(bundleDetails.projectStandardsRunReport, projectStandardsPolicy)) {
                if (ignoreWarnings && AbstractProjectDeploymentInfra.ProjectStandardsCheckPolicy.WARN.equals((Object)projectStandardsPolicy.checkPolicy)) {
                    String message = "Project Standards ignored: At least one Project Standards check has not passed, but the result has been ignored due to the deployment configuration policy for infrastructure \"%s\"";
                    this.getLogger().warnV(message, new Object[]{infraId});
                    report.withWarningV((InfoMessage.MessageCode)DeployerCodes.WARN_DEPLOYER_PROJECT_STANDARDS_SKIPPED_STATUS, message, new Object[]{infraId});
                } else {
                    report.mergeFrom(this.invalidProjectStandardsStatusMessage(projectStandardsPolicy.checkPolicy, "Deployment blocked by Project Standards: The bundle \"%s\" for project \"%s\" is not deployable since at least one Project Standards check is above the allowed level of severity per the deployment configuration policy for infrastructure \"%s\"", bundleId, publishedProjectKey, infraId));
                }
            } else if (!hasReport) {
                boolean manuallySkipped;
                boolean isLegacyBundle = Objects.isNull(bundleDetails.exportManifest.projectStandardsSkipped);
                boolean bl = manuallySkipped = !isLegacyBundle && bundleDetails.exportManifest.projectStandardsSkipped != false;
                if (manuallySkipped) {
                    if (projectStandardsPolicy.allowSkippedReports) {
                        String message = "Project Standards passed: The bundle \"%s\" for project \"%s\" can be deployed since skipped reports are allowed per the deployment configuration policy for infrastructure \"%s\"";
                        this.getLogger().infoV(message, new Object[]{bundleId, publishedProjectKey, infraId});
                    } else if (ignoreWarnings && AbstractProjectDeploymentInfra.ProjectStandardsCheckPolicy.WARN.equals((Object)projectStandardsPolicy.checkPolicy)) {
                        String message = "Project Standards ignored: Project Standards was manually skipped during the creation of the bundle \"%s\" for project \"%s\". The verification has also been manually skipped per the deployment configuration policy for infrastructure \"%s\"";
                        this.getLogger().warnV(message, new Object[]{bundleId, publishedProjectKey, infraId});
                        report.withWarningV((InfoMessage.MessageCode)DeployerCodes.WARN_DEPLOYER_PROJECT_STANDARDS_SKIPPED_STATUS, message, new Object[]{bundleId, publishedProjectKey, infraBasicInfo.id});
                    } else {
                        report.mergeFrom(this.invalidProjectStandardsStatusMessage(projectStandardsPolicy.checkPolicy, "Deployment blocked by Project Standards: Project Standards report was manually skipped during the creation of the bundle \"%s\" for project \"%s\" per the deployment configuration policy for infrastructure \"%s\"", bundleId, publishedProjectKey, infraId));
                    }
                } else if (isLegacyBundle) {
                    if (projectStandardsPolicy.allowLegacyBundles) {
                        String message = "Project Standards passed: The bundle \"%s\" for project \"%s\" can be deployed since legacy bundles are allowed per the deployment configuration policy for infrastructure \"%s\"";
                        this.getLogger().infoV(message, new Object[]{bundleId, publishedProjectKey, infraId});
                    } else if (ignoreWarnings && AbstractProjectDeploymentInfra.ProjectStandardsCheckPolicy.WARN.equals((Object)projectStandardsPolicy.checkPolicy)) {
                        String message = "Project Standards ignored: The bundle \"%s\" for project \"%s\" do not contain a Project Standards report to verify since it was created before the Project Standards feature was available. The verification has also been manually skipped per the deployment configuration policy for infrastructure \"%s\"";
                        this.getLogger().warnV(message, new Object[]{bundleId, publishedProjectKey, infraId});
                        report.withWarningV((InfoMessage.MessageCode)DeployerCodes.WARN_DEPLOYER_PROJECT_STANDARDS_SKIPPED_STATUS, message, new Object[]{bundleId, publishedProjectKey, infraId});
                    } else {
                        report.mergeFrom(this.invalidProjectStandardsStatusMessage(projectStandardsPolicy.checkPolicy, "Deployment blocked by Project Standards: The bundle \"%s\" for project \"%s\" does not contain a Project Standards report to verify since it was created before the Project Standards feature was available. Therefore is not deployable per the deployment configuration policy for infrastructure \"%s\"", bundleId, publishedProjectKey, infraId));
                    }
                } else {
                    String message = "Invalid Project Standards report: missing report in bundle while Project Standards was run.";
                    this.getLogger().errorV(message, new Object[0]);
                    report.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_PROJECT_STANDARDS_INVALID_CONFIG, message, new Object[0]);
                }
            } else {
                String message = "Project Standards passed: The bundle \"%s\" for project \"%s\" can be deployed since all Project Standard checks are below the allowed level of severity";
                this.getLogger().infoV(message, new Object[]{bundleId, publishedProjectKey});
            }
        } else if (AbstractProjectDeploymentInfra.ProjectStandardsCheckPolicy.ALLOW.equals((Object)projectStandardsPolicy.checkPolicy)) {
            String message = "Skipping Project Standards: Deploy bundles without verifying Project Standards per the deployment configuration policy for infrastructure \"%s\"";
            this.getLogger().infoV(message, new Object[]{infraId});
        } else {
            String message = "Invalid Project Standards policy \"%s\" for infrastructure \"%s\"";
            this.getLogger().errorV(message, new Object[]{projectStandardsPolicy.checkPolicy, infraId});
            report.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_PROJECT_STANDARDS_INVALID_CONFIG, message, new Object[]{projectStandardsPolicy.checkPolicy, infraId});
        }
        return report;
    }

    @Override
    protected DKULogger getLogger() {
        return DKULogger.getLogger((String)"dku.project-deployments.service");
    }
}

