/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.docextraction.Content;
import com.dataiku.dip.docextraction.DocExtractionServer;
import com.dataiku.dip.docextraction.Extractor;
import com.dataiku.dip.docextraction.IDocumentScreenshotsDrawer;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.kernel.DSSKernelUtils;
import com.dataiku.dip.kernel.KernelPool;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.dataiku.dss.shadelib.org.apache.commons.codec.binary.Hex;
import com.dataiku.dss.shadelib.org.apache.commons.codec.digest.DigestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocExtractionKernelPool {
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    private final KernelPool<DocExtractionServer, KernelDesc, KernelDesc> manager;
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("docextraction-kernel-pool-startstop-%d").build());
    public static final String DOCUMENT_BATCH_SIZE_DOCLING_PROPERTY = "dku.docextraction.structured.doclingDocumentBatchSize";
    public static final String DOCUMENT_PAGES_BATCH_SIZE_DOCLING_PROPERTY = "dku.docextraction.structured.doclingPageBatchSize";
    public static final String DOCUMENT_BATCH_SIZE_RAW_PROPERTY = "dku.docextraction.raw.documentBatchSize";
    public static final String DOCUMENT_PAGES_BATCH_SIZE_RAW_PROPERTY = "dku.docextraction.raw.pageBatchSize";
    public static final String DOCUMENT_CONFIG_OPTIMIZATION_MODE_DOCLING_PROPERTY = "dku.docextraction.structured.doclingConfigOptimizationMode";
    public static final String DOCUMENT_PDF_BACKEND_DOCLING_PROPERTY = "dku.docextraction.structured.doclingPdfBackend";
    public static final String DOCUMENT_IMAGE_CLASSIFICATION_FILTERED_CLASSES = "dku.docextraction.structured.imageClassificationFiltering.classes";
    public static final String DOCUMENT_IMAGE_CLASSIFICATION_FILTERING_THRESHOLD = "dku.docextraction.structured.imageClassificationFiltering.threshold";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.docextraction.pool");

    private static String getGroupKey(String containerConfName, String clusterId, String envName, DocExtractionServer.Settings settings) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        JSON.updateDigest((MessageDigest)digest, (Object)containerConfName);
        JSON.updateDigest((MessageDigest)digest, (Object)clusterId);
        JSON.updateDigest((MessageDigest)digest, (Object)envName);
        JSON.updateDigest((MessageDigest)digest, (Object)settings);
        return "docextraction-" + Hex.encodeHexString((byte[])digest.digest()).substring(0, 10);
    }

    private KernelDesc buildKernelDesc(AuthCtx authCtx, String projectKey, Extractor.Settings settings) throws IOException {
        KernelDesc kernelDesc = new KernelDesc();
        kernelDesc.cruContext = ComputeResourceUsageContext.forDocumentExtractionKernel((AuthCtx)authCtx, (String)projectKey);
        kernelDesc.projectKey = projectKey;
        kernelDesc.authCtx = authCtx;
        kernelDesc.settings = new DocExtractionServer.Settings();
        kernelDesc.settings.memoryLimitPerDocument = IDocumentScreenshotsDrawer.MEMORY_LIMIT_PER_DOCUMENT;
        Params params = AbstractSQLConnection.CustomDatabaseProperty.toParams(settings.dkuProperties);
        Params dkuAppParams = DKUApp.getParams();
        if (settings instanceof Extractor.Settings.Structured) {
            Extractor.Settings.Structured structuredSettings = (Extractor.Settings.Structured)settings;
            kernelDesc.settings.imageHandlingMode = structuredSettings.imageHandlingMode;
            kernelDesc.settings.ocrSettings = structuredSettings.ocrSettings;
            kernelDesc.settings.enableImageClassificationFiltering = structuredSettings.imageValidation;
            kernelDesc.settings.documentBatchSize = DSSKernelUtils.getIntParamWithFallback(params, dkuAppParams, DOCUMENT_BATCH_SIZE_DOCLING_PROPERTY, 4);
            kernelDesc.settings.pageBatchSize = DSSKernelUtils.getIntParamWithFallback(params, dkuAppParams, DOCUMENT_PAGES_BATCH_SIZE_DOCLING_PROPERTY, 8);
        } else {
            kernelDesc.settings.documentBatchSize = DSSKernelUtils.getIntParamWithFallback(params, dkuAppParams, DOCUMENT_BATCH_SIZE_RAW_PROPERTY, 4);
            kernelDesc.settings.pageBatchSize = DSSKernelUtils.getIntParamWithFallback(params, dkuAppParams, DOCUMENT_PAGES_BATCH_SIZE_RAW_PROPERTY, 8);
        }
        kernelDesc.settings.configOptimizationMode = DocExtractionServer.ConfigOptimizationMode.valueOf(DSSKernelUtils.getParamWithFallback(params, dkuAppParams, DOCUMENT_CONFIG_OPTIMIZATION_MODE_DOCLING_PROPERTY, DocExtractionServer.ConfigOptimizationMode.AUTO.toString()));
        kernelDesc.settings.pdfBackend = DSSKernelUtils.getParamWithFallback(params, dkuAppParams, DOCUMENT_PDF_BACKEND_DOCLING_PROPERTY, null);
        kernelDesc.envName = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.embedDocumentsRecipeSettings.getTextExtractionCodeEnv();
        try {
            ContainerExecSelection containerExecSelection = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.embedDocumentsRecipeSettings.documentExtractionContainerExecSelection;
            kernelDesc.containerConfName = new ContainerExecConfigSelector().selectName_autoTXN(projectKey, containerExecSelection, WorkloadType.VISUAL_RECIPES);
            kernelDesc.clusterId = new ClusterSelector().selectForProject(authCtx, projectKey).getClusterId();
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
        this.codeEnvResolutionService.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, kernelDesc.envName);
        kernelDesc.hash = DocExtractionKernelPool.getGroupKey(kernelDesc.containerConfName, kernelDesc.clusterId, kernelDesc.envName, kernelDesc.settings);
        kernelDesc.cruContext = CurrentComputeResourceUsageContext.get();
        kernelDesc.jobContext = JobContext.getCurrentJobContext();
        return kernelDesc;
    }

    public Response structuredExtractWithDocling(AuthCtx authCtx, String projectKey, Extractor.Settings.Structured settings, InputStream fileStream, String fileName, int timeoutInMinutes) throws Exception {
        String docContent = Base64.getEncoder().encodeToString(fileStream.readAllBytes());
        KernelDesc kernelDesc = this.buildKernelDesc(authCtx, projectKey, settings);
        ExtractionCommand.Structured command = new ExtractionCommand.Structured(docContent, fileName, settings);
        CompletableFuture future = this.manager.handle(kernel -> kernel.processAsync(command).orTimeout(timeoutInMinutes, TimeUnit.MINUTES), (Object)kernelDesc, kernelDesc.hash, (Object)command);
        return (Response)DKUCompletableFuture.collectResponse((CompletableFuture)future);
    }

    public Response rawExtract(AuthCtx authCtx, String projectKey, Extractor.Settings.TextFirst settings, InputStream fileStream, String fileName, int timeoutInMinutes) throws IOException {
        String docContent = Base64.getEncoder().encodeToString(fileStream.readAllBytes());
        KernelDesc kernelDesc = this.buildKernelDesc(authCtx, projectKey, settings);
        ExtractionCommand.Raw command = new ExtractionCommand.Raw(docContent, fileName, settings);
        CompletableFuture future = this.manager.handle(kernel -> kernel.processAsync(command).orTimeout(timeoutInMinutes, TimeUnit.MINUTES), (Object)kernelDesc, kernelDesc.hash, (Object)command);
        try {
            return (Response)DKUCompletableFuture.collectResponse((CompletableFuture)future);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public DocExtractionKernelPool() {
        this.manager = new KernelPool((KernelPool.KernelController)new KernelPool.KernelController<DocExtractionServer, KernelDesc, KernelDesc>(){

            @Nonnull
            public DocExtractionServer createKernel(KernelDesc kernelDesc) {
                return new DocExtractionServer(kernelDesc.authCtx, kernelDesc.envName, kernelDesc.projectKey, kernelDesc.containerConfName, kernelDesc.settings);
            }

            @Nonnull
            public CompletableFuture<Void> startKernel(DocExtractionServer kernel, KernelDesc kernelDesc) {
                return DKUCompletableFuture.runAsync(() -> {
                    NDC.push((String)("start-docextraction-kernel: " + kernel.getKernelId()));
                    try {
                        DSSKernelUtils.setKernelContext(kernelDesc.cruContext, kernelDesc.jobContext, logger);
                        kernel.start();
                    }
                    finally {
                        NDC.pop();
                    }
                }, (Executor)DocExtractionKernelPool.this.executorService);
            }

            public int getGlobalMaxKernelCount() {
                return ApplicationConfigurator.getParams().getIntParam("dku.docextraction.structured.maxKernels", Integer.valueOf(10));
            }

            public int getAutoscaleTimeWindowSeconds(KernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam("dku.docextraction.structured.autoscaleWindowSeconds", Integer.valueOf(600));
            }

            public int getHardMaxParallelRequests(KernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam("dku.docextraction.structured.hardMaxRequestsPerKernel", Integer.valueOf(4));
            }

            public int getSoftMaxParallelRequests(KernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam("dku.docextraction.structured.softMaxRequestsPerKernel", Integer.valueOf(4));
            }

            @Nonnull
            public CompletableFuture<Void> killKernel(DocExtractionServer kernel) {
                return CompletableFuture.runAsync(() -> {
                    NDC.push((String)("stop-docextraction-kernel: " + kernel.getKernelId()));
                    try {
                        kernel.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while closing kernel", (Throwable)e);
                    }
                    finally {
                        NDC.pop();
                    }
                }, DocExtractionKernelPool.this.executorService);
            }

            public boolean isAlive(DocExtractionServer kernel) {
                return kernel.isAlive();
            }

            public String getKernelId(DocExtractionServer kernel) {
                return kernel.getKernelId();
            }

            public boolean killKernelOnRequestFailure() {
                return super.killKernelOnRequestFailure();
            }
        }, "docextraction", logger);
    }

    public KernelPool.PoolDump dump(boolean full) {
        return this.manager.dump(full);
    }

    public void killAllRequests() {
        this.manager.killAllRequests();
    }

    public void killAllKernels(KernelPool.DeathReason reason) {
        this.manager.killAllKernels(reason);
    }

    public static class KernelDesc {
        String containerConfName;
        ComputeResourceUsageContext cruContext;
        JobContext jobContext;
        String projectKey;
        String clusterId;
        String hash;
        String envName;
        AuthCtx authCtx;
        DocExtractionServer.Settings settings;
    }

    public static abstract class ExtractionCommand {
        public String documentContent;
        public String fileName;
        public Extractor.ImageHandlingMode imageHandlingMode;
        public Extractor.OCRSettings ocrSettings;
        public boolean saveImgs;

        ExtractionCommand(String documentContent, String fileName, Extractor.Settings.TextFirst settings) {
            this.fileName = fileName;
            this.documentContent = documentContent;
            this.imageHandlingMode = settings.imageHandlingMode;
            if (this.imageHandlingMode == Extractor.ImageHandlingMode.OCR) {
                this.ocrSettings = settings.ocrSettings;
            }
        }

        public static class Raw
        extends ExtractionCommand {
            public final String type = "process-document-raw";

            Raw(String documentContent, String fileName, Extractor.Settings.TextFirst settings) {
                super(documentContent, fileName, settings);
            }
        }

        public static class Structured
        extends ExtractionCommand {
            public final String type = "process-document-structured";

            Structured(String documentContent, String fileName, Extractor.Settings.Structured settings) {
                super(documentContent, fileName, settings);
                this.saveImgs = StringUtils.isNotBlank((String)settings.outputManagedFolderId);
            }
        }
    }

    public static class Response {
        public boolean ok;
        public String error;
        public Content resp;
    }
}

