/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.resolver;

import com.dataiku.dip.dataflow.export.FlowExportService;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.ResolvedResult;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.model.BaseExport;
import java.util.List;

public interface PlaceholderOutput {
    public ResolvedResult.Replacement toResolvedResult(String var1);

    public static abstract class Export<ExportT extends BaseExport>
    implements PlaceholderOutput {
        private ExportT exportSingleton = null;

        protected abstract ExportT prepareExport();

        public abstract BaseExportService<ExportT, ?, ?> getExportService();

        public ExportT getExport() {
            if (this.exportSingleton == null) {
                this.exportSingleton = this.prepareExport();
            }
            return this.exportSingleton;
        }

        @Override
        public ResolvedResult.Export toResolvedResult(String name) {
            if (this.getExportService() instanceof FlowExportService) {
                return new ResolvedResult.Export(name, ResolvedResult.Export.ExportType.FLOW);
            }
            assert (false) : "Unexpected export service used " + this.getExportService().getClass().getCanonicalName();
            return null;
        }
    }

    public static class Table
    implements PlaceholderOutput {
        public final List<List<String>> value;

        public Table(List<List<String>> value) {
            this.value = value;
        }

        @Override
        public ResolvedResult.Replacement toResolvedResult(String name) {
            return new ResolvedResult.JsonTable(name, this.value);
        }
    }

    public static class Text
    implements PlaceholderOutput {
        public final String value;

        public static boolean isValidXMLChar(int codePoint) {
            return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
        }

        public Text(String value) throws PlaceholderExpectedException {
            if (value == null) {
                throw new PlaceholderExpectedException("Text Placeholder output cannot be null");
            }
            if (!value.codePoints().allMatch(Text::isValidXMLChar)) {
                throw new PlaceholderExpectedException("Text placeholder contains invalid XML characters");
            }
            this.value = value;
        }

        @Override
        public ResolvedResult.Replacement toResolvedResult(String name) {
            return new ResolvedResult.JsonText(name, this.value);
        }
    }
}

