/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.exposition.AbstractKubernetesExpositionHandler;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.webapps.backend.NginxUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LoadBalancerExposition {
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "load_balancer";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return LoadBalancerExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            ParamDesc serviceAnnotations = new ParamDesc();
            serviceAnnotations.type = ParamDesc.Type.KEY_VALUE_LIST;
            serviceAnnotations.name = "serviceAnnotations";
            serviceAnnotations.label = "Service annotations";
            ParamDesc port = new ParamDesc();
            port.type = ParamDesc.Type.INT;
            port.name = "port";
            port.label = "Port";
            port.defaultValue = -1;
            ParamDesc internal = new ParamDesc();
            internal.type = ParamDesc.Type.BOOLEAN;
            internal.name = "internal";
            internal.label = "Internal";
            internal.description = "If available in the cloud provider. Dependent on the value of the 'cloud.provider' property on the container config.";
            internal.defaultValue = false;
            ParamDesc loadBalancerIP = new ParamDesc();
            loadBalancerIP.type = ParamDesc.Type.STRING;
            loadBalancerIP.name = "loadBalancerIP";
            loadBalancerIP.label = "Force IP";
            loadBalancerIP.description = "If available in the cloud provider.";
            ParamDesc loadBalancerSourceRanges = new ParamDesc();
            loadBalancerSourceRanges.type = ParamDesc.Type.STRINGS;
            loadBalancerSourceRanges.name = "loadBalancerSourceRanges";
            loadBalancerSourceRanges.label = "Restrict to source IPs";
            loadBalancerSourceRanges.description = "If available in the cloud provider.";
            return new ExpositionDesc().withType(this.getType()).withMeta(new DkuComponentMetadata("Load balancer", "Load balancer from cloud provider (default)", null, null)).withParam(port).withParam(serviceAnnotations).withParam(internal).withParam(loadBalancerIP).withParam(loadBalancerSourceRanges);
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 120000L;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return containerType == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return kind == Exposables.ExposableKind.WEBAPP || kind == Exposables.ExposableKind.API_DEPLOYER;
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            LoadBalancerExpositionParams params = exposition.getParamsAs(LoadBalancerExpositionParams.class);
            return new LoadBalancerExpositionHandler(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
            LoadBalancerExpositionParams params = exposition.getParamsAs(LoadBalancerExpositionParams.class);
            for (ExpositionParams.Annotation annotation : params.serviceAnnotations) {
                annotation.expandParametersInPlace(vc);
            }
        }
    };
    private static Logger logger = Logger.getLogger((String)"dip.webapp.expose");

    private static class LoadBalancerExpositionHandler
    extends AbstractKubernetesExpositionHandler {
        private final LoadBalancerExpositionParams params;
        private int port;
        private List<String> serviceFiles;
        private IStateLabelAggregator stateLabelAggregator;
        private ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
        private boolean closed;

        LoadBalancerExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, LoadBalancerExpositionParams params, ExposedEndpointConsumer endpointConsumer) {
            super(authCtx, projectKey, containerConfig, endpointConsumer);
            this.params = params;
        }

        @Override
        public void cleanup() {
            this.closed = true;
            if (this.serviceFiles != null) {
                logger.info((Object)"Remove loadbalancer service");
                try {
                    KubernetesExecUtils.delete(this.authCtx, this.projectKey, this.containerConfig, true, this.serviceFiles.toArray(new String[0]));
                }
                catch (IOException e) {
                    logger.error((Object)"Could not stop Kubernetes service", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Interrupted while stopping Kubernetes service", (Throwable)e);
                }
            }
        }

        @Override
        public void init(Exposables.Exposable exposable, IStateLabelAggregator stateLabelAggregator) throws IOException {
            this.stateLabelAggregator = stateLabelAggregator;
            super.init(exposable, stateLabelAggregator);
            logger.info((Object)"Add loadbalancer service");
            HashMap<String, String> serviceAnnotations = new HashMap<String, String>(this.annotations);
            for (ExpositionParams.Annotation annotation : this.params.serviceAnnotations) {
                if (!StringUtils.isNotBlank((String)annotation.from)) continue;
                serviceAnnotations.put(annotation.from, StringUtils.defaultIfBlank((String)annotation.to, (String)""));
            }
            if (this.params.internal) {
                String cloudProvider;
                switch (cloudProvider = this.containerConfig.getProperty("cloud.provider", "")) {
                    case "azure": {
                        serviceAnnotations.put("service.beta.kubernetes.io/azure-load-balancer-internal", "true");
                        break;
                    }
                    case "gke": {
                        serviceAnnotations.put("cloud.google.com/load-balancer-type", "Internal");
                        break;
                    }
                    case "aws": {
                        serviceAnnotations.put("service.beta.kubernetes.io/aws-load-balancer-internal", "0.0.0.0/0");
                        break;
                    }
                    default: {
                        logger.warn((Object)("Load balancer not annotated as internal, unknown cloud.provider '" + cloudProvider + "' in config " + this.containerConfig.name));
                    }
                }
            }
            this.port = this.params.port < 0 ? this.exposedPort : this.params.port;
            String loadBalancerIPBlock = StringUtils.isBlank((String)this.params.loadBalancerIP) ? "" : String.format("  loadBalancerIP: %s\n", this.params.loadBalancerIP);
            String string = this.params.loadBalancerSourceRanges.isEmpty() ? "" : "  loadBalancerSourceRanges:\n  - " + Joiner.on((String)"\n  - ").join(this.params.loadBalancerSourceRanges) + "\n";
            File serviceFile = new File(this.tmpDir, "service_" + this.executionId + ".yaml");
            String serviceSnippet = String.format("  type: LoadBalancer\n  ports:\n  - port: %d\n    targetPort: %d\n    protocol: TCP\n%s%s", this.port, this.exposedPort, loadBalancerIPBlock, string);
            String serviceDesc = KubernetesExecUtils.getServiceConf(this.namePrefix, this.executionId, serviceSnippet, this.labels, serviceAnnotations, this.selectors);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("service=\n" + serviceDesc));
            }
            DKUFileUtils.writeFileUTF8((File)serviceFile, (String)serviceDesc);
            this.serviceFiles = Lists.newArrayList((Object[])new String[]{"-f", serviceFile.getAbsolutePath()});
        }

        @Override
        public void start(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            Object[] cmd = KubernetesExecUtils.getKubeCtlApplyCommand(this.authCtx, this.projectKey, this.containerConfig, this.serviceFiles.toArray(new String[0]));
            expositionLog.handle("Running LB " + Joiner.on((String)" ").join(cmd), false);
            new DKUtils.ExecBuilder().withCwd(this.tmpDir).withEnv(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig)).withArgs((String[])cmd).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)expositionLog).withErrorConsumer((DKUtils.ExecSubscription)expositionLog).withTimestamps(true).withLineContext("[lb] ").withCompletionHandler((DKUtils.ExecCompletionHandler)new DKUtils.SimpleExceptionExecCompletionHandler((List)Lists.newArrayList((Object[])cmd)).withLogTailBuilder(smartLogTailBuilder)).exec();
        }

        @Override
        public void waitReady(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            JsonObject obj;
            String host;
            long pollInterval = KubernetesExecUtils.getWebappsPollingPeriodInMillis();
            Closeable ipState = this.stateLabelAggregator.startWaitingOn("Waiting on load balancer IP");
            do {
                Thread.sleep(pollInterval);
                this.status.raw = obj = this.describeLoadBalancer(expositionLog, smartLogTailBuilder);
            } while ((host = LoadBalancerExpositionHandler.getIngressHost(obj)) == null);
            ipState.close();
            NginxUtils.waitForHost(host, this.stateLabelAggregator);
            ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, host, this.port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC);
            this.endpointConsumer.registerPort(endpoint);
            this.status.endpoints.add(endpoint);
            this.status.isHealthy = true;
        }

        private JsonObject describeLoadBalancer(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws IOException, InterruptedException, Exception {
            String serviceId = this.namePrefix + "-service-" + this.executionId;
            ProcessBuilder pollServiceProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.projectKey, this.containerConfig, false, "get", "service", serviceId, "-o", "json"));
            pollServiceProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
            pollServiceProcessBuilder.directory(this.tmpDir);
            logger.info((Object)("Poll service status " + Joiner.on((String)" ").join(pollServiceProcessBuilder.command())));
            expositionLog.handle("Poll LB " + Joiner.on((String)" ").join(pollServiceProcessBuilder.command()), false);
            RegularProcess pollServiceProcess = new RegularProcess(pollServiceProcessBuilder, this.tmpDir);
            pollServiceProcess.start();
            DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
            DKUtils.ExecOutputConsumer pollServiceEoc = new DKUtils.ExecOutputConsumer().withTimestamps(true).withLineContext("[lb] ").withErrorConsumer((DKUtils.ExecSubscription)expositionLog).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)outputCollector);
            pollServiceEoc.start(pollServiceProcess.getInputStream(), pollServiceProcess.getErrorStream(), null);
            int rv = pollServiceProcess.waitFor();
            if (rv != 0) {
                throw new Exception("Unable to get status of service " + serviceId);
            }
            pollServiceEoc.finish();
            JsonObject obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(outputCollector.getCollected()), JsonObject.class);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Service JSON: " + JSON.prettyLog((Object)obj)));
            }
            return obj;
        }

        @Override
        public ExpositionHandler.ExpositionStatus getStatus(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            JsonObject obj;
            String host;
            ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
            if (!this.closed && (host = LoadBalancerExpositionHandler.getIngressHost(obj = this.describeLoadBalancer(expositionLog, smartLogTailBuilder))) != null) {
                ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, host, this.port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC);
                status.endpoints.add(endpoint);
                status.isHealthy = true;
            }
            return status;
        }

        @Override
        public ExposedEndpointConsumer.ExposedEndpoint getExpectedExposedEndpoint() {
            return new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, "${K8S_SERVICE_ADDRESS}", this.port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC);
        }
    }

    public static class LoadBalancerExpositionParams
    implements ExpositionParams {
        public List<ExpositionParams.Annotation> serviceAnnotations = Lists.newArrayList();
        public int port = -1;
        public boolean internal = false;
        public String loadBalancerIP = null;
        public List<String> loadBalancerSourceRanges = Lists.newArrayList();
    }
}

