/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.MetastoreAwareDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.hadoop.HDFSPathUtils;
import com.dataiku.dip.hive.GlueMetastoreUtils;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.MetastoreSynchronizationUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.GlueClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.Column;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.CreateTableRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.DeletePartitionRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetTableRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.GetTableResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.PartitionInput;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.SerDeInfo;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.SkewedInfo;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.StorageDescriptor;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.model.TableInput;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AWSGlueHiveMetastoreSynchronizer
extends HiveMetastoreSynchronizer {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.hive.synchro");
    private final AuthCtx authCtx;
    private final GlueClient client;

    public AWSGlueHiveMetastoreSynchronizer(AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        this.authCtx = authCtx;
        this.client = GlueMetastoreUtils.getClient(authCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InfoMessage.InfoMessages synchronizeOneDataset(Dataset ds, boolean simulate, boolean forceDrop, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        Object tableLock;
        Object object = tableLock = AWSGlueHiveMetastoreSynchronizer.getTableLock(ds.getFullName());
        synchronized (object) {
            return this.synchronizeOneDataset_locked(ds, simulate, forceDrop, reason, warningsContext, lenient);
        }
    }

    public InfoMessage.InfoMessages synchronizeOneDataset_locked(Dataset ds, boolean simulate, boolean forceDrop, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        return this.fullSynchronizeDataset(ds);
    }

    private InfoMessage.InfoMessages fullSynchronizeDataset(Dataset ds) throws Exception {
        InfoMessage.InfoMessages messages;
        block20: {
            messages = new InfoMessage.InfoMessages();
            logger.infoV("Full-synchronizing dataset %s to Glue", new Object[]{ds.getFullName()});
            try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(this.authCtx, ds);){
                MetastoreSynchronizationUtils.SynchronizationRequestedStatus requestedStatus = MetastoreSynchronizationUtils.synchronizationRequested(this.authCtx, ds);
                if (!requestedStatus.requested) {
                    logger.info((Object)("Synchronization not requested(" + requestedStatus.reason + "), doing nothing"));
                    messages.withWarning((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_TABLE_NOT_SYNCHRONIZED, requestedStatus.reason + ", doing nothing");
                    InfoMessage.InfoMessages infoMessages = messages;
                    return infoMessages;
                }
                this.checkCanBeRepresented(ds);
                DeleteTableRequest dtr = this.getDeleteTableRequest(ds);
                try {
                    logger.infoV("Deleting Glue table %s.%s", new Object[]{dtr.databaseName(), dtr.name()});
                    this.client.deleteTable(dtr);
                }
                catch (EntityNotFoundException e) {
                    logger.warn((Object)("Could not delete table, it did not exist: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
                CreateDatabaseRequest cdr = this.getCreateDatabaseRequest(ds);
                try {
                    logger.infoV("Creating Glue database %s", new Object[]{cdr.databaseInput().name()});
                    this.client.createDatabase(cdr);
                }
                catch (AlreadyExistsException e) {
                    logger.warn((Object)("Could not create database, it already exists: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
                CreateTableRequest ctr = this.getCreateTableRequest(ds);
                this.client.createTable(ctr);
                if (!ds.getPartitioningSchema().isPartitioned()) break block20;
                try {
                    List<FilePartition> partitions = FilePartitioner.listPartitions(this.authCtx, ds);
                    assert (partitions != null);
                    ArrayList batches = Lists.newArrayList();
                    ArrayList currentBatch = Lists.newArrayList();
                    for (Partition partition : partitions) {
                        currentBatch.add(partition);
                        if (currentBatch.size() != 100) continue;
                        batches.add(currentBatch);
                        currentBatch = Lists.newArrayList();
                    }
                    if (!currentBatch.isEmpty()) {
                        batches.add(currentBatch);
                    }
                    for (List list : batches) {
                        BatchCreatePartitionRequest.Builder bcprb = BatchCreatePartitionRequest.builder().databaseName(ctr.databaseName()).tableName(ctr.tableInput().name());
                        ArrayList<PartitionInput> partitionInputList = new ArrayList<PartitionInput>();
                        for (Partition p : list) {
                            partitionInputList.add(this.gluePartitionForPartition(handler, p));
                        }
                        bcprb.partitionInputList(partitionInputList);
                        this.client.batchCreatePartition((BatchCreatePartitionRequest)bcprb.build());
                    }
                }
                catch (DataStoreIOException e) {
                    if (e.getCode() == FSProviderCodes.ERR_FSPROVIDER_ROOT_PATH_DOES_NOT_EXIST) {
                        logger.info((Object)"Dataset root path does not exist, not adding partitions");
                        messages.withWarning((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_TABLE_NOT_SYNCHRONIZED, "Dataset root path does not exist, not adding partitions");
                        break block20;
                    }
                    throw e;
                }
            }
        }
        return messages;
    }

    private PartitionInput gluePartitionForPartition(MetastoreAwareDatasetHandler handler, Partition p) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        PartitionInput.Builder gluePartitionBuilder = PartitionInput.builder();
        ArrayList values = Lists.newArrayList();
        for (String dim : handler.getDataset().getPartitioningSchema().getDimensionNames()) {
            values.add(((DimensionValue)p.getDimensionValues().get(dim)).id());
        }
        gluePartitionBuilder.values((Collection)values);
        StorageDescriptor.Builder storageDescriptor = this.getStorageDescriptorWithoutLocation(handler);
        HDFSableDatasetHandler hdfsAbleHandler = (HDFSableDatasetHandler)handler;
        storageDescriptor.location(HDFSPathUtils.concat(hdfsAbleHandler.getFullyQualifiedRootPath(), FilePartitioner.computePartitionRelPathAsFolder(p, handler.getDataset().getPartitioningSchema())));
        gluePartitionBuilder.storageDescriptor((StorageDescriptor)storageDescriptor.build());
        return (PartitionInput)gluePartitionBuilder.build();
    }

    @Override
    public void dropExternalTable(Dataset ds) throws Exception {
        this.client.deleteTable(this.getDeleteTableRequest(ds));
    }

    @Override
    public void dropTableIfExists(Dataset ds) throws Exception {
        try {
            this.dropExternalTable(ds);
        }
        catch (EntityNotFoundException e) {
            logger.warn((Object)("Table did not exist: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    @Override
    public void dropPartitionIfExistsNoFail(Dataset ds, Partition partition) throws Exception {
        logger.infoV("Dropping partition if exists dataset=%s partition=%s", new Object[]{ds.getFullName(), partition});
        SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
        DeletePartitionRequest.Builder dprBuilder = DeletePartitionRequest.builder();
        dprBuilder.databaseName(tableRef.getSchemaNullIfBlank());
        dprBuilder.tableName(tableRef.getTable());
        ArrayList<String> vals = new ArrayList<String>();
        for (String dim : ds.getPartitioningSchema().getDimensionNames()) {
            vals.add(((DimensionValue)partition.getDimensionValues().get(dim)).id());
        }
        dprBuilder.partitionValues(vals);
        try {
            this.client.deletePartition((DeletePartitionRequest)dprBuilder.build());
        }
        catch (EntityNotFoundException e) {
            logger.warn((Object)("Partition did not exist: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeOneDatasetPartition(Dataset dataset, Partition partition, boolean simulate, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        Object tableLock;
        Object object = tableLock = AWSGlueHiveMetastoreSynchronizer.getTableLock(dataset.getFullName());
        synchronized (object) {
            this.synchronizeOneDatasetPartition_locked(dataset, partition, simulate, reason, warningsContext, lenient);
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.client.close();
    }

    private void synchronizeOneDatasetPartition_locked(Dataset dataset, Partition partition, boolean simulate, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            if (!MetastoreSynchronizationUtils.synchronizationRequested((AuthCtx)this.authCtx, (Dataset)dataset).requested) {
                return;
            }
            this.checkCanBeRepresented(dataset);
            SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
            HiveSchemaCompatibility schemaCompatibility = this.isExistingSchemaCompatible(dataset, tableRef);
            if (schemaCompatibility.schemaCompatible) {
                logger.info((Object)"Hive schema is up to date: (re)synchronizing a single partition");
                if (dataset.getPartitioningSchema().isPartitioned()) {
                    BatchCreatePartitionRequest.Builder bcprBuilder = BatchCreatePartitionRequest.builder();
                    bcprBuilder.databaseName(tableRef.getSchemaNullIfBlank());
                    bcprBuilder.tableName(tableRef.getTable());
                    if (partition.isAll()) {
                        List<FilePartition> partitions = FilePartitioner.listPartitions(this.authCtx, dataset);
                        assert (partitions != null);
                        ArrayList<PartitionInput> partitionInputList = new ArrayList<PartitionInput>();
                        for (Partition partition2 : partitions) {
                            partitionInputList.add(this.gluePartitionForPartition(handler, partition2));
                        }
                        bcprBuilder.partitionInputList(partitionInputList);
                    } else {
                        bcprBuilder.partitionInputList(new PartitionInput[]{this.gluePartitionForPartition(handler, partition)});
                    }
                    this.client.batchCreatePartition((BatchCreatePartitionRequest)bcprBuilder.build());
                } else {
                    logger.info((Object)"Dataset not partitioned, nothing to do");
                }
            } else {
                logger.info((Object)"Hive schema is not up to date: (re)synchronize the whole table");
                this.fullSynchronizeDataset(dataset);
            }
        }
    }

    private HiveSchemaCompatibility isExistingSchemaCompatible(Dataset dataset, SQLUtils.SQLTable tableRef) throws Exception {
        GetTableResponse result;
        HiveSchemaCompatibility ret = new HiveSchemaCompatibility();
        GetTableRequest.Builder gtr = GetTableRequest.builder();
        gtr.databaseName(tableRef.getSchemaNullIfBlank());
        gtr.name(tableRef.getTable());
        try {
            result = this.client.getTable((GetTableRequest)gtr.build());
        }
        catch (EntityNotFoundException e) {
            logger.warn((Object)("Table does not exist: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return ret;
        }
        ret.tableExists = true;
        if (result.table().storageDescriptor().columns().size() != dataset.getSchema().getColumns().size()) {
            logger.info((Object)"Nb columns mismatch");
            return ret;
        }
        for (int i = 0; i < result.table().storageDescriptor().columns().size(); ++i) {
            Column glueColumn = (Column)result.table().storageDescriptor().columns().get(i);
            SchemaColumn datasetColumn = (SchemaColumn)dataset.getSchema().getColumns().get(i);
            if (!StringUtils.equalsIgnoreCase((String)glueColumn.name(), (String)datasetColumn.getName())) {
                logger.info((Object)"column name mismatch");
                return ret;
            }
            String expectedHiveType = HiveSchemaHandler.hiveTypeFromSchemaType(datasetColumn);
            if (expectedHiveType.equals(glueColumn.type())) continue;
            logger.info((Object)"column type mismatch");
            return ret;
        }
        ret.schemaCompatible = true;
        return ret;
    }

    private void checkCanBeRepresented(Dataset dataset) {
        boolean rep;
        if (dataset.getPartitioningSchema().isPartitioned() && !(rep = FilePartitioner.isSchemeRepresentableAsFolder(dataset.getPartitioningSchema()))) {
            throw ErrorContext.iaef((String)"Dataset %s cannot be represented in Hive: partition does not map to a folder", (Object)dataset.getFullName(), (Object[])new Object[0]);
        }
    }

    private CreateDatabaseRequest getCreateDatabaseRequest(Dataset dataset) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            SQLUtils.SQLTable tableRef = handler.getResolvedHiveTableRef(true);
            CreateDatabaseRequest createDatabaseRequest = (CreateDatabaseRequest)CreateDatabaseRequest.builder().databaseInput(builder -> builder.name(tableRef.getSchemaNullIfBlank())).build();
            return createDatabaseRequest;
        }
    }

    private DeleteTableRequest getDeleteTableRequest(Dataset dataset) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            SQLUtils.SQLTable tableRef = handler.getResolvedHiveTableRef(true);
            DeleteTableRequest deleteTableRequest = (DeleteTableRequest)DeleteTableRequest.builder().databaseName(tableRef.getSchemaNullIfBlank()).name(tableRef.getTable()).build();
            return deleteTableRequest;
        }
    }

    private CreateTableRequest getCreateTableRequest(Dataset dataset) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            SQLUtils.SQLTable tableRef = handler.getResolvedHiveTableRef(true);
            CreateTableRequest createTableRequest = (CreateTableRequest)CreateTableRequest.builder().databaseName(tableRef.getSchemaNullIfBlank()).tableInput(this.getTableDef(dataset)).build();
            return createTableRequest;
        }
    }

    private TableInput getTableDef(Dataset dataset) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            HDFSableDatasetHandler hdfsAbleHandler = (HDFSableDatasetHandler)handler;
            SQLUtils.SQLTable tableRef = handler.getResolvedHiveTableRef(true);
            TableInput.Builder table = TableInput.builder();
            table.name(tableRef.getTable());
            table.tableType("EXTERNAL_TABLE");
            table.owner("nobody");
            StorageDescriptor.Builder sd = this.getStorageDescriptorWithoutLocation(handler);
            sd.location(hdfsAbleHandler.getFullyQualifiedRootPath());
            table.storageDescriptor((StorageDescriptor)sd.build());
            table.parameters(HiveSchemaHandler.getTablePropertiesMap(this.authCtx, dataset, false));
            if (dataset.getPartitioningSchema().isPartitioned()) {
                ArrayList columns = Lists.newArrayList();
                for (String dim : dataset.getPartitioningSchema().getDimensionNames()) {
                    Column.Builder glueColumnBuilder = Column.builder();
                    glueColumnBuilder.type("string");
                    glueColumnBuilder.name(dim);
                    columns.add((Column)glueColumnBuilder.build());
                }
                table.partitionKeys((Collection)columns);
            } else {
                table.partitionKeys(new ArrayList());
            }
            TableInput tableInput = (TableInput)table.build();
            return tableInput;
        }
    }

    private StorageDescriptor.Builder getStorageDescriptorWithoutLocation(MetastoreAwareDatasetHandler handler) {
        Dataset dataset = handler.getDataset();
        StorageDescriptor.Builder sdBuilder = StorageDescriptor.builder();
        ArrayList<Column> columns = new ArrayList<Column>();
        for (SchemaColumn dssColumn : dataset.getSchema().getColumns()) {
            Column.Builder columnBuilder = Column.builder();
            columnBuilder.type(HiveSchemaHandler.hiveTypeFromSchemaType(dssColumn)).name(dssColumn.getName()).comment(dssColumn.comment);
            columns.add((Column)columnBuilder.build());
        }
        sdBuilder.columns(columns);
        HiveSchemaHandler.HiveRowFormatInfo dssSd = HiveSchemaHandler.getRowFormat(dataset, dataset.getName(), MetastoreInspectionService.MetastoreKind.AWS_GLUE);
        logger.info((Object)("Setting storage descriptor:" + JSON.log((Object)dssSd)));
        sdBuilder.compressed(Boolean.valueOf(dssSd.compressed));
        sdBuilder.inputFormat(dssSd.inputFormat);
        sdBuilder.outputFormat(dssSd.outputFormat);
        sdBuilder.parameters(dssSd.storageParams);
        SerDeInfo serDeInfo = (SerDeInfo)SerDeInfo.builder().serializationLibrary(dssSd.serializationLib).parameters(dssSd.serdeParams).build();
        sdBuilder.serdeInfo(serDeInfo);
        sdBuilder.skewedInfo((SkewedInfo)SkewedInfo.builder().build());
        return sdBuilder;
    }

    public static class HiveSchemaCompatibility {
        public boolean unknown;
        public boolean tableExists;
        public boolean schemaCompatible;
    }
}

