/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SchemaValidator;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.formats.hive.HiveFileFormatConfig;
import com.dataiku.dip.input.formats.hive.SerdeAccessUtils;
import com.dataiku.dip.input.formats.hive.SerdeVisitor;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.serde.ObjectInspectorBuilder;
import com.dataiku.dip.output.FileNamingAbleOutputWriter;
import com.dataiku.dip.output.OptionallyExtensible;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.output.TransactionalizableOutputWriter;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.util.HadoopUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.hproxy.utils.Reflector;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public abstract class HiveFileOutputWriter
extends OutputWriter
implements FileNamingAbleOutputWriter,
OptionallyExtensible<HiveFileOutputWriter>,
TransactionalizableOutputWriter<HiveFileOutputWriter> {
    private static final Logger staticLogger = Logger.getLogger(HiveFileOutputWriter.class);
    private static final Object globalHiveLock3772;
    private final Partition targetPartition;
    private final int targetSplit;
    private final HiveFileFormatConfig config;
    private final WarningsContext warningsContext;
    private final String serdeClass;
    private final DKULogger logger = DKULogger.getLogger((String)((Object)((Object)this)).getClass().getCanonicalName());
    private Object serde;
    private FileSinkOperator.RecordWriter recordWriter;
    private StructObjectInspector rowInspector;
    private int rowCount;
    private int failedCount;
    private final UserGroupInformation ugi;
    private final HDFSProvider provider;
    private final Dataset dataset;
    private final SerdeAccessUtils serdeAccessUtils;
    private FileNamingAbleOutputWriter.FileNamingMode fileNamingMode = FileNamingAbleOutputWriter.FileNamingMode.EXTENT;
    private String fileNaminFixedId;
    private boolean extensible;
    private boolean transactionalMode;
    private String tempOutputPath;
    private String finalOutputPath;

    public HiveFileOutputWriter(HDFSProvider provider, Dataset dataset, Partition targetPartition, int targetSplit, WarningsContext warningsContext, HiveFileFormatConfig config) throws DKUSecurityException, IOException {
        this.provider = provider;
        this.dataset = dataset;
        this.targetPartition = targetPartition;
        this.targetSplit = targetSplit;
        this.warningsContext = warningsContext;
        this.config = (HiveFileFormatConfig)Preconditions.checkNotNull((Object)config);
        this.serdeClass = this.config.getSerdeClass();
        this.ugi = provider.makeUGI();
        this.serdeAccessUtils = new SerdeAccessUtils();
    }

    public HiveFileOutputWriter withExtensible() {
        this.extensible = true;
        return this;
    }

    public HiveFileOutputWriter withTransactionalMode() {
        this.transactionalMode = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ColumnFactory cf) throws Exception {
        if (globalHiveLock3772 == null) {
            this.initImpl(cf);
        } else {
            Object object = globalHiveLock3772;
            synchronized (object) {
                staticLogger.warn((Object)"Hive : HIVE-3772 workaround enabled. Write performance may suffer.");
                this.initImpl(cf);
            }
        }
    }

    public void initImpl(final ColumnFactory cf) throws Exception {
        String relPath = FilePartitioner.getRelPath(this.targetPartition, this.dataset.getPartitioningSchema());
        this.provider.mkdirs(relPath);
        HadoopUtils.fixedUpDoAs(this.ugi, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Object outputName;
                Object serdeObj;
                try {
                    serdeObj = Class.forName(HiveFileOutputWriter.this.serdeClass).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to load Hive SerDe: " + HiveFileOutputWriter.this.serdeClass, e);
                }
                if (!HiveFileOutputWriter.this.serdeAccessUtils.isSerde(serdeObj)) {
                    throw new RuntimeException("Class " + HiveFileOutputWriter.this.serdeClass + " is not a Hive SerDe.");
                }
                HiveFileOutputWriter.this.serde = serdeObj;
                String relPath = FilePartitioner.getRelPath(HiveFileOutputWriter.this.targetPartition, HiveFileOutputWriter.this.dataset.getPartitioningSchema());
                String extension = HiveFileOutputWriter.this.getFileExtension();
                if (HiveFileOutputWriter.this.fileNamingMode == FileNamingAbleOutputWriter.FileNamingMode.FIXED && StringUtils.isNotBlank((String)HiveFileOutputWriter.this.fileNaminFixedId)) {
                    outputName = HiveFileOutputWriter.this.fileNaminFixedId;
                } else if (HiveFileOutputWriter.this.fileNamingMode == FileNamingAbleOutputWriter.FileNamingMode.TIMESTAMP) {
                    outputName = "out-s" + HiveFileOutputWriter.this.targetSplit;
                } else if (HiveFileOutputWriter.this.extensible) {
                    String chunkBaseName = "out-s" + HiveFileOutputWriter.this.targetSplit;
                    if (HiveFileOutputWriter.this.provider.stat(PathUtils.concatLNT((String[])new String[]{relPath, chunkBaseName + "." + extension})) != null) {
                        String extent;
                        int extentId = 0;
                        while (HiveFileOutputWriter.this.provider.stat(extent = PathUtils.concatLNT((String[])new String[]{relPath, (chunkBaseName = "out-s" + HiveFileOutputWriter.this.targetSplit + "-e" + extentId) + "." + extension})) != null) {
                            ++extentId;
                        }
                    }
                    outputName = chunkBaseName;
                } else {
                    outputName = "out-s" + HiveFileOutputWriter.this.targetSplit;
                }
                if (HiveFileOutputWriter.this.transactionalMode) {
                    HiveFileOutputWriter.this.tempOutputPath = PathUtils.concatLNT((String[])new String[]{relPath, "_tmp." + (String)outputName + "." + extension});
                    HiveFileOutputWriter.this.finalOutputPath = PathUtils.concatLNT((String[])new String[]{relPath, (String)outputName + "." + extension});
                } else {
                    HiveFileOutputWriter.this.tempOutputPath = HiveFileOutputWriter.this.finalOutputPath = PathUtils.concatLNT((String[])new String[]{relPath, (String)outputName + "." + extension});
                }
                Schema dssSchema = HiveFileOutputWriter.this.dataset.getSchema();
                JobConf job = HiveFileOutputWriter.this.provider.setupHadoopJobConf(false);
                Properties tableProperties = new Properties();
                tableProperties.putAll((Map<?, ?>)HiveFileOutputWriter.this.config.getTableProperties());
                tableProperties.putAll((Map<?, ?>)HiveFileOutputWriter.this.config.getSerdeProperties());
                String colNames = Joiner.on((String)",").join((Iterable)FluentIterable.from((Iterable)dssSchema.getColumns()).transform((Function)new Function<SchemaColumn, Object>(){

                    public Object apply(SchemaColumn schemaColumn) {
                        return schemaColumn.getName().toLowerCase();
                    }
                }));
                ObjectInspectorBuilder inspectorBuilder = new ObjectInspectorBuilder();
                HiveFileOutputWriter.this.rowInspector = inspectorBuilder.buildRowInspector(cf, dssSchema);
                HiveFileOutputWriter.this.logger.info((Object)("Hive row type: " + HiveFileOutputWriter.this.rowInspector.getTypeName()));
                String colTypes = ObjectInspectorUtils.getFieldTypes((StructObjectInspector)HiveFileOutputWriter.this.rowInspector);
                tableProperties.setProperty("columns.types", colTypes);
                tableProperties.setProperty("columns", colNames);
                HiveFileOutputWriter.this.logger.info((Object)("Initialize Hive serializer " + HiveFileOutputWriter.this.serdeClass));
                HiveFileOutputWriter.this.logger.debug((Object)("Table properties : \n" + JSON.prettyLog((Object)tableProperties)));
                HiveFileOutputWriter.this.serdeAccessUtils.initialize(serdeObj, new Configuration(), tableProperties);
                Path outputWritePath = new Path(HiveFileOutputWriter.this.provider.getPath(HiveFileOutputWriter.this.tempOutputPath));
                HiveFileOutputWriter.this.logger.info((Object)("Write to path " + outputWritePath.toUri().toString()));
                FileOutputFormat.setOutputPath((JobConf)job, (Path)outputWritePath);
                HiveFileOutputWriter.this.logger.info((Object)JSON.prettyLog((Object)dssSchema));
                new SchemaValidator().validate(dssSchema);
                HiveOutputFormat<? extends Writable, ? extends Writable> outputFormat = HiveFileOutputWriter.this.getFileOutputFormat();
                Progressable progressable = new Progressable(){

                    public void progress() {
                    }
                };
                HiveFileOutputWriter.this.recordWriter = outputFormat.getHiveRecordWriter(job, outputWritePath, HiveFileOutputWriter.this.serdeAccessUtils.getSerializedClass(HiveFileOutputWriter.this.serde), true, tableProperties, progressable);
                return null;
            }
        });
    }

    protected void finishedHook() throws IOException, CodedException, DKUSecurityException {
        if (this.transactionalMode) {
            this.logger.infoV("Committing : %s -> %s", new Object[]{this.tempOutputPath, this.finalOutputPath});
            this.provider.moveFile(this.tempOutputPath, this.finalOutputPath);
        }
    }

    protected void cancelledHook() {
    }

    protected abstract String getFileExtension();

    protected abstract HiveOutputFormat<? extends Writable, ? extends Writable> getFileOutputFormat();

    public long writtenBytes() throws IOException {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws Exception {
        if (globalHiveLock3772 == null) {
            this.cancelImpl();
        } else {
            Object object = globalHiveLock3772;
            synchronized (object) {
                this.cancelImpl();
            }
        }
    }

    public void cancelImpl() throws Exception {
        if (this.recordWriter != null) {
            this.recordWriter.close(false);
            this.recordWriter = null;
        }
        this.cancelledHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitRow(Row row) throws Exception {
        if (globalHiveLock3772 == null) {
            this.emitRowImpl(row);
        } else {
            Object object = globalHiveLock3772;
            synchronized (object) {
                this.emitRowImpl(row);
            }
        }
    }

    public void emitRowImpl(final Row row) throws Exception {
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                Writable writable = null;
                try {
                    if (HiveFileOutputWriter.this.config instanceof ORCFileFormatConfig) {
                        SerdeVisitor.inspectObject(row, (ObjectInspector)HiveFileOutputWriter.this.rowInspector);
                    }
                    writable = HiveFileOutputWriter.this.serdeAccessUtils.serialize(HiveFileOutputWriter.this.serde, row, (ObjectInspector)HiveFileOutputWriter.this.rowInspector);
                }
                catch (Exception e) {
                    HiveFileOutputWriter.this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_TYPE, "Unable to write row (" + e.getMessage() + ")", (Throwable)e, HiveFileOutputWriter.this.logger);
                }
                if (writable != null) {
                    HiveFileOutputWriter.this.recordWriter.write(writable);
                    ++HiveFileOutputWriter.this.rowCount;
                } else {
                    ++HiveFileOutputWriter.this.failedCount;
                }
                if ((HiveFileOutputWriter.this.rowCount + HiveFileOutputWriter.this.failedCount) % 100000 == 0) {
                    HiveFileOutputWriter.this.logger.info((Object)("Processed " + HiveFileOutputWriter.this.rowCount + " rows (" + HiveFileOutputWriter.this.failedCount + " failed)"));
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lastRowEmitted() throws Exception {
        if (globalHiveLock3772 == null) {
            this.lastRowEmittedImpl();
        } else {
            Object object = globalHiveLock3772;
            synchronized (object) {
                this.lastRowEmittedImpl();
            }
        }
    }

    public void lastRowEmittedImpl() throws Exception {
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                if (HiveFileOutputWriter.this.recordWriter != null) {
                    HiveFileOutputWriter.this.recordWriter.close(true);
                    HiveFileOutputWriter.this.recordWriter = null;
                }
                HiveFileOutputWriter.this.logger.info((Object)("Processed " + HiveFileOutputWriter.this.rowCount + " rows (" + HiveFileOutputWriter.this.failedCount + " failed)"));
                return null;
            }
        });
        this.finishedHook();
    }

    public void setFileNamingMode(FileNamingAbleOutputWriter.FileNamingMode mode, String fixedId) {
        this.fileNamingMode = mode;
        this.fileNaminFixedId = fixedId;
    }

    public List<String> gatherWritesInProgress() throws IOException, InterruptedException {
        ArrayList ret = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)this.finalOutputPath)) {
            ret.add(this.finalOutputPath);
        }
        if (StringUtils.isNotBlank((String)this.tempOutputPath) && !StringUtils.equals((String)this.tempOutputPath, (String)this.finalOutputPath)) {
            ret.add(this.tempOutputPath);
        }
        return ret;
    }

    public static List<String> gatherPathsWrittenToAndNotCommitted(HDFSProvider provider, int splitId) throws IOException, CodedException, DKUSecurityException {
        FSEnumerationSettings enumerationSettings = FSEnumerationSettings.filesPrefixedBy((String)("_tmp\\.out\\-s" + splitId + "[.-].*")).withHiddenFiles();
        FSEnumerationResult enumeration = provider.enumerateRecursive("/", enumerationSettings);
        ArrayList paths = Lists.newArrayList();
        if (enumeration.isSuccessful() && enumeration.getPaths() != null) {
            for (FSPath path : enumeration.getPaths()) {
                paths.add(path.path());
            }
        }
        return paths;
    }

    static {
        boolean needWorkaround = true;
        try {
            Reflector reflector = new Reflector(HiveFileOutputWriter.class.getClassLoader());
            reflector.getStaticAttribute("org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils", "vLongBytesThreadLocal");
            staticLogger.info((Object)"LazyBinaryUtils.vLongBytesThreadLocal found");
            needWorkaround = false;
        }
        catch (Exception e) {
            staticLogger.warn((Object)"LazyBinaryUtils.vLongBytesThreadLocal not found. Enabled HIVE-3772 workaround.");
        }
        globalHiveLock3772 = needWorkaround ? new Object() : null;
    }
}

