/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.im;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.integrations.ChannelizableIntegrationParams;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.integrations.im.SlackIntegrationHandler;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.j2ts.annotations.UIModel;

@UIModel
abstract class AbstractSlackIntegrationParams
extends ChannelizableIntegrationParams
implements IntegrationParams {
    public SlackIntegrationHandler.SlackMode mode = SlackIntegrationHandler.SlackMode.API;
    public String webhookUrl;
    public String authorizationToken;
    public String channel;
    public boolean useProxy = true;
    public String username;
    public String iconUrl;
    public String iconEmoji;
    public boolean asUser;
    public boolean linkNames;

    AbstractSlackIntegrationParams() {
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (securitySettings.secureSecretKeys) {
            this.authorizationToken = cryptoService.encryptIfNotEncryptedOrEmpty(this.authorizationToken);
        }
    }

    public static class SlackUnifiedMonitoringAlertingIntegrationParams
    extends AbstractSlackIntegrationParams {
        public String message;
        public SlackIntegrationHandler.SlackMessageMode messageMode = SlackIntegrationHandler.SlackMessageMode.TEXT_MESSAGE;
        public String blocks;
    }

    public static class SlackScenarioIntegrationParams
    extends AbstractSlackIntegrationParams {
        public String message;
        public SlackIntegrationHandler.SlackMessageMode messageMode = SlackIntegrationHandler.SlackMessageMode.TEXT_MESSAGE;
        public String blocks;
    }

    public static class SlackFreeFormIntegrationParams
    extends AbstractSlackIntegrationParams {
        public String message;
        public SlackIntegrationHandler.SlackMessageMode messageMode = SlackIntegrationHandler.SlackMessageMode.TEXT_MESSAGE;
        public String blocks;
    }

    public static class SlackProjectIntegrationParams
    extends AbstractSlackIntegrationParams {
        public SerializedProject.MessagingLikeProjectIntegrationSelection selection = new SerializedProject.MessagingLikeProjectIntegrationSelection();
    }
}

