/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.mail;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.AbstractIntegrationEventHandler;
import com.dataiku.dip.integrations.AttachmentService;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationDirectUseEvent;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.integrations.mail.AbstractMailSender;
import com.dataiku.dip.integrations.mail.MailChannelConfiguration;
import com.dataiku.dip.integrations.mail.MailIntegrationParams;
import com.dataiku.dip.integrations.mail.factory.MailSenderFactory;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.scheduler.reports.TemplatesDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertEvent;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.time.Year;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MailIntegrationHandler
extends AbstractIntegrationEventHandler {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private IntegrationChannelsDAO channelsDAO;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private MailSenderFactory mailSenderFactory;
    @Autowired
    private IntegrationChannelPermissionsService integrationChannelPermissionsService;
    private final TemplatesDAO templatesDAO = new TemplatesDAO();
    public static final IntegrationMeta SCENARIO_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "mail-scenario";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return MailIntegrationParams.MailScenarioIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new MailIntegrationHandler(authCtx, permissionCheckContext, messaging.getConfigurationAs(MailIntegrationParams.MailScenarioIntegrationParams.class), TemplatesDAO.TemplateType.SCENARIO);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings security) {
            if (configuration != null && configuration.configuration != null) {
                configuration.configuration.encryptFields(cryptoService, security);
            }
        }
    };
    public static final IntegrationMeta DIRECT_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "mail-direct";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return MailIntegrationParams.FreeFormIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new MailIntegrationHandler(authCtx, permissionCheckContext, messaging.getConfigurationAs(MailIntegrationParams.FreeFormIntegrationParams.class), TemplatesDAO.TemplateType.DIRECT_USAGE);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings security) {
            if (configuration != null && configuration.configuration != null) {
                configuration.configuration.encryptFields(cryptoService, security);
            }
        }
    };
    public static final IntegrationMeta UNIFIED_MONITORING_ALERTING_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "mail-unified-monitoring-alerting";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return MailIntegrationParams.FreeFormIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new MailIntegrationHandler(authCtx, permissionCheckContext, messaging.getConfigurationAs(MailIntegrationParams.FreeFormIntegrationParams.class), TemplatesDAO.TemplateType.DIRECT_USAGE);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings security) {
            if (configuration != null && configuration.configuration != null) {
                configuration.configuration.encryptFields(cryptoService, security);
            }
        }
    };
    private final AuthCtx authCtx;
    private final MailIntegrationParams params;
    private final TemplatesDAO.TemplateType templateType;
    private final IntegrationChannel channel;
    private final String dssEmail;
    private static final Logger logger = Logger.getLogger((String)"dip.sender.mail");

    public MailIntegrationHandler(AuthCtx authCtx, IntegrationMeta.PermissionCheckContext permissionCheckContext, MailIntegrationParams params, TemplatesDAO.TemplateType templateType) throws IOException, DKUSecurityException {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.params = params;
        this.templateType = templateType;
        try (Transaction ignored = this.transactionService.beginRead();){
            this.channel = this.channelsDAO.getMandatory(params.channelId);
            this.dssEmail = this.generalSettingsDAO.read().studioMailAddress;
        }
        if (permissionCheckContext.checkCanUseIntegrationChannel) {
            this.integrationChannelPermissionsService.checkIntegrationChannelUse(authCtx, this.channel);
        }
    }

    @Override
    public void handleEvent(DSSEvent event, InfoMessage.InfoMessages messages) throws Exception {
        VariableLookup lookup;
        String projectKey;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.recipient), (Object)"Recipient not set");
        if (event instanceof IntegrationDirectUseEvent) {
            IntegrationDirectUseEvent directUsageEvent = (IntegrationDirectUseEvent)event;
            projectKey = directUsageEvent.projectKey;
            VariableLookup variableLookup = lookup = directUsageEvent.lookup != null ? directUsageEvent.lookup : new VariableLookup();
            if ("default.ftl".equals(this.params.templateName)) {
                if (lookup.rawGet("currentYear") == null) {
                    lookup.addVariable("currentYear", String.valueOf(Year.now().getValue()));
                }
                if (lookup.rawGet("title") == null) {
                    lookup.addVariable("title", Strings.isNullOrEmpty((String)this.params.subject) ? "DSS notification" : this.params.subject);
                }
            }
        } else if (event instanceof ScenarioReportEvent) {
            ScenarioReportEvent scenarioEvent = (ScenarioReportEvent)event;
            lookup = scenarioEvent.lookup;
            projectKey = scenarioEvent.projectKey;
        } else if (event instanceof UnifiedMonitoringAlertEvent) {
            UnifiedMonitoringAlertEvent unifiedMonitoringAlertEvent = (UnifiedMonitoringAlertEvent)event;
            lookup = unifiedMonitoringAlertEvent.lookup;
            projectKey = null;
        } else {
            throw new IllegalStateException("Unhandled event type: " + String.valueOf(event.getClass()));
        }
        AbstractMailSender sender = this.mailSenderFactory.createMailSenderWithoutPermissionCheck(this.channel);
        MailChannelConfiguration config = sender.getConfiguration();
        String fromField = config.computeFromField(this.authCtx, this.params.sender, this.dssEmail);
        StringSubstitutor substitutor = new StringSubstitutor((StringLookup)lookup);
        fromField = substitutor.replace(fromField);
        String ccField = this.prepareRecipientField("Cc", substitutor.replace(StringUtils.defaultIfBlank((String)this.params.ccRecipient, (String)"")).trim());
        String bccField = this.prepareRecipientField("Bcc", substitutor.replace(StringUtils.defaultIfBlank((String)this.params.bccRecipient, (String)"")).trim());
        String toField = substitutor.replace(this.params.recipient).trim();
        if (toField.startsWith("{")) {
            MailSequenceDefinition sequence = (MailSequenceDefinition)JSON.parse((String)toField, MailSequenceDefinition.class);
            logger.info((Object)"Recipients transformed into sequence ");
            for (MailDefinition mail : sequence.mails) {
                logger.info((Object)("Mail " + JSON.log((Object)mail)));
                lookup.addVariable("mailVariables", mail.variables);
                Session session = sender.newSession();
                sender.send(session, this.prepare(this.params, fromField, mail.to, ccField, bccField, session, lookup, projectKey, messages), messages);
            }
        } else {
            toField = this.prepareRecipientField("To", toField);
            Session session = sender.newSession();
            sender.send(session, this.prepare(this.params, fromField, toField, ccField, bccField, session, lookup, projectKey, messages), messages);
        }
    }

    private String prepareRecipientField(String type, String rawField) {
        if (rawField.startsWith("[")) {
            List array = (List)JSON.parse((String)rawField, (TypeToken)new TypeToken<List<String>>(){});
            rawField = Joiner.on((String)", ").join((Iterable)array);
            logger.info((Object)(type + " recipients transformed into " + rawField));
            return rawField;
        }
        return rawField;
    }

    private Message prepare(MailIntegrationParams params, String fromField, String toField, String ccField, String bccField, Session session, VariableLookup lookup, String projectKey, InfoMessage.InfoMessages messages) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)fromField), (Object)"Sender not set");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)toField), (Object)"Recipient not set");
        StringSubstitutor substitutor = new StringSubstitutor((StringLookup)lookup);
        String subjectField = substitutor.replace(params.subject);
        logger.info((Object)("Prepare mail from " + fromField + " to " + toField));
        MimeMessage mail = new MimeMessage(session);
        mail.setFrom((Address)new InternetAddress(fromField));
        mail.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toField));
        mail.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccField));
        mail.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bccField));
        mail.setSubject(subjectField);
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        for (AttachmentService.MailScenarioAttachment attachment : params.attachments) {
            try {
                this.attachmentService.add(attachment, (Multipart)multipart, this.authCtx, projectKey, lookup);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to process attachment, skipping", (Throwable)e);
                messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)IntegrationEventHandler.ReporterCodes.WARN_REPORTER_ATTACHMENT_FAILURE, (String)("Processing attachment of type " + String.valueOf((Object)attachment.type) + " failed : " + ExceptionUtils.getMessageWithCauses((Throwable)e))));
            }
        }
        File templateFile = null;
        if (params.messageSource == TemplatedContent.MessageSource.TEMPLATE_FILE) {
            templateFile = this.templatesDAO.get(params.templateName, this.templateType);
        }
        MessageContentBuilder.ExpandedTemplate messageBody = new MessageContentBuilder(lookup).buildMessage(params, templateFile);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Expanded message body text to\n" + messageBody.message));
        }
        messageBodyPart.setText(messageBody.message, "utf-8", messageBody.forceSendAsHTML || params.sendAsHTML ? "html" : "plain");
        mail.setContent((Multipart)multipart);
        return mail;
    }

    private static class MailSequenceDefinition {
        public List<MailDefinition> mails = Lists.newArrayList();

        private MailSequenceDefinition() {
        }
    }

    private static class MailDefinition {
        public String to;
        public Map<String, Object> variables = Maps.newHashMap();

        private MailDefinition() {
        }
    }
}

