/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LabelingService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;

    public LabelingTask getLabelingTask(String projectKey, String labelingTaskId) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
        }
        try (Transaction t = this.transactionService.beginRead();){
            LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            return labelingTask;
        }
    }

    public Dataset getMetadataDataset(LabelingTask labelingTask) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.datasetAccessService.getMandatory(labelingTask.getMetadataLoc());
        }
        try (Transaction t = this.transactionService.beginRead();){
            Dataset dataset = this.datasetAccessService.getMandatory(labelingTask.getMetadataLoc());
            return dataset;
        }
    }
}

