/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.util.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LLMAllocationTagsUtils {
    public static final String DKU_ALLOCATION_TAGS_CONTEXT_KEY = "dkuAllocationTags";

    public static void addAllocationTagsToCRU(LLMClient.SingleCompletionQuery query, ComputeResourceUsage cru) {
        JsonArray viaArray;
        JsonElement viaElem;
        String onBehalfOf;
        JsonElement allocationTagsElem;
        if (query.context == null) {
            return;
        }
        if (query.context.has(DKU_ALLOCATION_TAGS_CONTEXT_KEY) && (allocationTagsElem = query.context.get(DKU_ALLOCATION_TAGS_CONTEXT_KEY)).isJsonObject()) {
            JsonObject allocationTags = allocationTagsElem.getAsJsonObject();
            for (Map.Entry entry : allocationTags.entrySet()) {
                cru.withAllocationTag((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        if (query.context.has("dkuOnBehalfOf") && !StringUtils.isBlank((String)(onBehalfOf = JsonUtils.getStringMemberOrNull(query.context, "dkuOnBehalfOf")))) {
            cru.withAllocationTag("DKUOnBehalfOf", onBehalfOf);
        }
        if (query.context.has("dkuLLMMeshVia") && (viaElem = query.context.get("dkuLLMMeshVia")).isJsonArray() && !(viaArray = viaElem.getAsJsonArray()).isEmpty()) {
            cru.withAllocationTag("DKULLMMeshVia", (JsonElement)viaArray);
        }
    }
}

