/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.marshall;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.utils.DKULogger;
import java.util.Locale;
import javax.annotation.Nullable;

public class FinishReasonResponseAdapter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.online.marshall.finish_reason");

    private FinishReasonResponseAdapter() {
    }

    @Nullable
    public static LLMClient.FinishReason adapt(@Nullable String reason) {
        if (reason == null) {
            logger.debug((Object)String.format("Received no finishReason, matching it to '%s'", new Object[]{LLMClient.FinishReason.UNKNOWN}));
            return LLMClient.FinishReason.UNKNOWN;
        }
        switch (reason) {
            case "stop": 
            case "end_turn": 
            case "stop_sequence": 
            case "COMPLETE": 
            case "STOP_SEQUENCE": 
            case "FINISHED": 
            case "STOP_CRITERIA_MET": 
            case "STOP": {
                return LLMClient.FinishReason.STOP;
            }
            case "length": 
            case "max_tokens": 
            case "MAX_TOKENS": 
            case "LENGTH": {
                return LLMClient.FinishReason.LENGTH;
            }
            case "content_filter": 
            case "ERROR_TOXIC": 
            case "CONTENT_FILTERED": 
            case "SAFETY": 
            case "RECITATION": 
            case "guardrail_intervened": 
            case "content_filtered": 
            case "refusal": {
                return LLMClient.FinishReason.CONTENT_FILTER;
            }
            case "tool_calls": 
            case "tool_use": {
                return LLMClient.FinishReason.TOOL_CALLS;
            }
            case "model_length": 
            case "ERROR_LIMIT": 
            case "error": 
            case "ERROR": 
            case "USER_CANCEL": 
            case "RAG_QUERY_WHEN_RAG_DISABLED": 
            case "OTHER": 
            case "UNSPECIFIED": {
                logger.debug((Object)String.format("Received finishReason='%s', mapping it to '%s'", new Object[]{reason, LLMClient.FinishReason.UNKNOWN}));
                return LLMClient.FinishReason.UNKNOWN;
            }
        }
        LLMClient.FinishReason matched = FinishReasonResponseAdapter.matchFinishReason(reason);
        logger.debug((Object)String.format("Received finishReason='%s', matching it to '%s'", new Object[]{reason, matched}));
        return matched;
    }

    private static LLMClient.FinishReason matchFinishReason(String reason) {
        String r = reason.toLowerCase(Locale.ROOT);
        if (r.contains("stop") || r.contains("complete") || r.contains("finish") || r.contains("end")) {
            return LLMClient.FinishReason.STOP;
        }
        if (r.contains("length") || r.contains("tokens")) {
            return LLMClient.FinishReason.LENGTH;
        }
        if (r.contains("content") || r.contains("filter") || r.contains("toxic")) {
            return LLMClient.FinishReason.CONTENT_FILTER;
        }
        if (r.contains("tool")) {
            return LLMClient.FinishReason.TOOL_CALLS;
        }
        return LLMClient.FinishReason.UNKNOWN;
    }
}

