/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.vertex.api;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.llm.online.vertex.api.GeminiQuery;
import com.dataiku.dip.llm.online.vertex.api.GeminiResponse;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GeminiResponseAdapter {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.vertex.gemini");

    public static LLMClient.SimpleCompletionResponse adapt(GeminiResponse.ChatResponses rcrs) {
        List<String> reasoningSummary;
        LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
        if (rcrs.stream().anyMatch(r -> r.candidates.size() > 1)) {
            logger.warn((Object)"Received a response containing multiple candidates. Ignoring all but the first candidate.");
        }
        List<GeminiResponse.ChatCandidate> validCandidates = rcrs.stream().filter(r -> !r.candidates.isEmpty()).map(r -> r.candidates.get(0)).toList();
        ret.text = validCandidates.stream().map(c2 -> c2.content.parts.stream().filter(p -> p.thought == null || p.thought == false).map(p -> p.text).filter(Objects::nonNull).collect(Collectors.joining("\n\n"))).collect(Collectors.joining());
        ret.toolCalls = validCandidates.stream().map(c2 -> c2.content.parts.stream().filter(p -> p.functionCall != null).map(GeminiResponseAdapter::adapt).collect(Collectors.toList())).toList().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List<GeminiQuery.MessagePart> thoughtSignatureMessageParts = validCandidates.stream().flatMap(c2 -> c2.content.parts.stream()).filter(p -> StringUtils.isNotEmpty((String)p.thoughtSignature)).toList();
        if (thoughtSignatureMessageParts.size() > 1) {
            logger.warn((Object)"Multiple thought signatures found in candidates; only using the first one.");
        }
        if (!thoughtSignatureMessageParts.isEmpty()) {
            ret.memoryFragment = new LLMClient.MemoryFragment();
            ret.memoryFragment.llmReasoning = JSON.toJsonObject((Object)thoughtSignatureMessageParts.get(0), (String[])new String[0]);
        }
        if (!(reasoningSummary = validCandidates.stream().map(c2 -> c2.content.parts.stream().filter(p -> p.thought != null && p.thought != false).map(p -> p.text).filter(Objects::nonNull).filter(text -> !text.equals("\n\n")).collect(Collectors.joining("\n\n"))).filter(p -> !p.isEmpty()).toList()).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String reasoning : reasoningSummary) {
                if (reasoning.isEmpty()) continue;
                sb.append(reasoning);
            }
            if (!sb.isEmpty()) {
                LLMClient.SourceItem sourceItem = new LLMClient.SourceItem();
                sourceItem.type = "TEXT";
                sourceItem.text = sb.toString();
                LLMClient.Artifact reasoningArtifact = new LLMClient.Artifact();
                reasoningArtifact.id = rcrs.responseId();
                reasoningArtifact.type = "REASONING";
                reasoningArtifact.parts.add(sourceItem);
                if (ret.artifacts == null) {
                    ret.artifacts = new ArrayList<LLMClient.Artifact>();
                }
                ret.artifacts.add(reasoningArtifact);
            }
        }
        for (GeminiResponse.ChatCandidate c3 : validCandidates) {
            String reason = c3.finishReason;
            if (reason == null) continue;
            ret.finishReason = FinishReasonResponseAdapter.adapt(reason);
        }
        ret.promptTokens = rcrs.stream().mapToInt(r -> r.usageMetadata.promptTokenCount).sum();
        ret.completionTokens = rcrs.stream().mapToInt(r -> r.usageMetadata.candidatesTokenCount).sum();
        LLMClient.SimpleCompletionResponse simpleCompletionResponse = ret;
        simpleCompletionResponse.completionTokens = simpleCompletionResponse.completionTokens + rcrs.stream().mapToInt(r -> r.usageMetadata.thoughtsTokenCount).sum();
        ret.totalTokens = rcrs.stream().mapToInt(r -> r.usageMetadata.totalTokenCount).sum();
        return ret;
    }

    private static LLMClient.AbstractToolCall adapt(GeminiQuery.MessagePart toolCallPart) {
        LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
        function.name = toolCallPart.functionCall.name;
        if (toolCallPart.functionCall.args != null) {
            function.arguments = JSON.json((Object)toolCallPart.functionCall.args);
        }
        LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
        ftc.id = toolCallPart.functionCall.name;
        ftc.function = function;
        if (StringUtils.isNotEmpty((String)toolCallPart.thoughtSignature)) {
            ftc.llmReasoning = new JsonObject();
            ftc.llmReasoning.addProperty("thoughtSignature", toolCallPart.thoughtSignature);
        }
        return ftc;
    }
}

