/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.j2py.annotations.PyModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@PyModel
public abstract class BaseVectorStoreQuerySettings {
    public static final String DKU_TEXT_EMBEDDING_COLUMN = "DKU_TEXT_EMBEDDING_COLUMN";
    public static final int DEFAULT_MAX_DOCUMENTS = 10;
    public boolean enforceDocumentLevelSecurity = false;
    public boolean performFiltering = false;
    public boolean allowDynamicFiltering = false;
    public boolean allowAgentInferredFiltering = false;
    public FilterDesc filter = new FilterDesc();
    public List<ColumnDescription> columnsDescriptions = new ArrayList<ColumnDescription>();
    @Nullable
    public List<String> retrievalColumns = List.of("DKU_TEXT_EMBEDDING_COLUMN");
    public SearchType searchType = SearchType.SIMILARITY;
    public double similarityThreshold = 0.5;
    public int maxDocuments = 10;
    public int mmrK = 20;
    public double mmrDiversity = 0.25;
    public boolean useAdvancedReranking = false;
    public int rrfRankConstant = 60;
    public int rrfRankWindowSize = 4;
    public boolean includeScore;
    public boolean allowEmptyQuery;
    public RAGRerankingSettings reranking = new RAGRerankingSettings();
    public SourcesSettings sourcesSettings = new SourcesSettings();
    public AugmentationFallbackStrategy augmentationFallbackStrategy = AugmentationFallbackStrategy.USE_EMBEDDING;

    public BaseVectorStoreQuerySettings() {
    }

    public BaseVectorStoreQuerySettings(BaseVectorStoreQuerySettings other) {
        this.enforceDocumentLevelSecurity = other.enforceDocumentLevelSecurity;
        this.performFiltering = other.performFiltering;
        this.allowDynamicFiltering = other.allowDynamicFiltering;
        this.allowAgentInferredFiltering = other.allowAgentInferredFiltering;
        this.filter = other.filter;
        this.columnsDescriptions = other.columnsDescriptions;
        this.retrievalColumns = other.retrievalColumns;
        this.searchType = other.searchType;
        this.similarityThreshold = other.similarityThreshold;
        this.maxDocuments = other.maxDocuments;
        this.mmrK = other.mmrK;
        this.mmrDiversity = other.mmrDiversity;
        this.useAdvancedReranking = other.useAdvancedReranking;
        this.rrfRankConstant = other.rrfRankConstant;
        this.rrfRankWindowSize = other.rrfRankWindowSize;
        this.includeScore = other.includeScore;
        this.allowEmptyQuery = other.allowEmptyQuery;
        this.reranking = new RAGRerankingSettings(other.reranking);
        this.sourcesSettings = other.sourcesSettings;
    }

    @PyModel
    public static enum SearchType {
        SIMILARITY,
        SIMILARITY_THRESHOLD,
        MMR,
        HYBRID;

    }

    @PyModel
    public static class RAGRerankingSettings {
        public boolean enabled;
        @Nullable
        public String llmId;
        public int maxDocuments = 5;

        public RAGRerankingSettings() {
        }

        public RAGRerankingSettings(RAGRerankingSettings other) {
            this.enabled = other.enabled;
            this.llmId = other.llmId;
            this.maxDocuments = other.maxDocuments;
        }
    }

    @PyModel
    public static class SourcesSettings {
        public String titleMetadata;
        public String urlMetadata;
        public String thumbnailURLMetadata;
        public String snippetMetadata;
        public SnippetFormat snippetFormat = SnippetFormat.TEXT;
        public List<String> metadataInSources = new ArrayList<String>();
    }

    @PyModel
    public static enum AugmentationFallbackStrategy {
        SKIP,
        FAIL,
        USE_EMBEDDING;

    }

    @PyModel
    public static enum SnippetFormat {
        TEXT,
        MARKDOWN,
        HTML,
        JSON;

    }

    public static class ColumnDescription {
        public String name;
        public String description;
    }
}

