/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.savedmodels;

import com.dataiku.common.rpc.ExternalJSONAPIClient;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.llm.LLMSMMgmtService;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeployment;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeploymentWithStatus;
import com.dataiku.dip.analysis.model.llm.LLMModelSnippetData;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMClientFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class SavedModelVersionDeploymentCRUDService {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.savedmodels.deployment-crud");

    public List<LLMSavedModelVersionDeploymentWithStatus> listDeployments(AuthCtx authCtx, String projectKey, SavedModel sm) throws Exception {
        LLMSMMgmtService.LLMSMStatus status = LLMSMMgmtService.getStatus_NT(sm);
        ArrayList<LLMSavedModelVersionDeploymentWithStatus> deployments = new ArrayList<LLMSavedModelVersionDeploymentWithStatus>();
        for (LLMSMMgmtService.LLMSMVersionHeader versionHeader : status.versions) {
            if (((LLMModelSnippetData)versionHeader.snippet).deployment == null) continue;
            LLMStructuredRef llmStructuredRef = LLMStructuredRef.decodeId(((LLMModelSnippetData)versionHeader.snippet).llmSMInfo.originalLLMId);
            LLMClient llmClient = LLMClientFactory.get(authCtx, projectKey, llmStructuredRef);
            deployments.add(llmClient.newSavedModelDeployer(authCtx).getDeployment(((LLMModelSnippetData)versionHeader.snippet).deployment));
        }
        return deployments;
    }

    public Optional<LLMSavedModelVersionDeploymentWithStatus> getDeployment(AuthCtx authCtx, String projectKey, SavedModel sm, String versionId) throws Exception {
        LLMSMMgmtService.LLMSMStatus status = LLMSMMgmtService.getStatus_NT(sm);
        LLMSMMgmtService.LLMSMVersionHeader versionHeader = status.versions.stream().filter(vh -> vh.versionId.equals(versionId)).findFirst().get();
        if (((LLMModelSnippetData)versionHeader.snippet).deployment == null) {
            return Optional.empty();
        }
        LLMStructuredRef llmStructuredRef = LLMStructuredRef.decodeId(((LLMModelSnippetData)versionHeader.snippet).llmSMInfo.originalLLMId);
        LLMClient llmClient = LLMClientFactory.get(authCtx, projectKey, llmStructuredRef);
        return Optional.of(llmClient.newSavedModelDeployer(authCtx).getDeployment(((LLMModelSnippetData)versionHeader.snippet).deployment));
    }

    public boolean detachDeployment(SavedModel sm, FullModelId fullModelId) {
        LLMSMMgmtService.LLMSMStatus status = LLMSMMgmtService.getStatus_NT(sm);
        LLMSMMgmtService.LLMSMVersionHeader versionHeader = status.versions.stream().filter(vh -> vh.versionId.equals(fullModelId.getSavedModelVersionID())).findFirst().get();
        if (((LLMModelSnippetData)versionHeader.snippet).deployment == null) {
            throw new IllegalArgumentException("No deployment found to detach");
        }
        boolean deletionStatus = fullModelId.getLLMDeploymentFile().delete();
        logger.info((Object)String.format("Deployment %s (%s) detached successfully", new Object[]{((LLMModelSnippetData)versionHeader.snippet).deployment.deploymentId, ((LLMModelSnippetData)versionHeader.snippet).deployment.deploymentType}));
        return deletionStatus;
    }

    private LLMSavedModelVersionDeploymentWithStatus createOrAttachDeployment(AuthCtx authCtx, String projectKey, SavedModel sm, FullModelId fullModelId, String deploymentId, boolean attachOnly) throws Exception {
        LLMSavedModelVersionDeploymentWithStatus deploymentWithStatus;
        LLMStructuredRef llmStructuredRef;
        LLMSMMgmtService.LLMSMStatus status = LLMSMMgmtService.getStatus_NT(sm);
        Optional<LLMSMMgmtService.LLMSMVersionHeader> optVersionHeader = status.versions.stream().filter(vh -> vh.versionId.equals(fullModelId.getSavedModelVersionID())).findFirst();
        if (optVersionHeader.isEmpty()) {
            throw new IllegalArgumentException("Saved model version not found for id " + String.valueOf(fullModelId));
        }
        LLMSMMgmtService.LLMSMVersionHeader versionHeader = optVersionHeader.get();
        if (((LLMModelSnippetData)versionHeader.snippet).deployment != null) {
            throw new IllegalArgumentException("A deployment is already attached. Detach it before attaching a new one.");
        }
        String savedModelConnection = ((LLMModelSnippetData)versionHeader.snippet).llmSMInfo.connection;
        String savedModelSmartId = new AnyLoc(sm.projectKey, sm.id).getSmartName(projectKey);
        LLMSavedModelVersionDeployment.DeploymentType deploymentType = switch (((LLMModelSnippetData)versionHeader.snippet).llmSMInfo.llmType) {
            case LLMStructuredRef.LLMType.SAVED_MODEL_FINETUNED_AZURE_OPENAI -> {
                llmStructuredRef = LLMStructuredRef.forAzureOpenAIFineTunedSavedModelVersion(savedModelConnection, savedModelSmartId, versionHeader.versionId);
                yield LLMSavedModelVersionDeployment.DeploymentType.AZURE;
            }
            case LLMStructuredRef.LLMType.SAVED_MODEL_FINETUNED_BEDROCK -> {
                llmStructuredRef = LLMStructuredRef.forBedrockFineTunedSavedModelVersion(savedModelConnection, savedModelSmartId, versionHeader.versionId);
                yield LLMSavedModelVersionDeployment.DeploymentType.BEDROCK;
            }
            default -> throw new IllegalArgumentException("Unsupported llm type");
        };
        LLMSavedModelVersionDeployment.CreationMethod creationMethod = attachOnly ? LLMSavedModelVersionDeployment.CreationMethod.ATTACHED : LLMSavedModelVersionDeployment.CreationMethod.DEPLOYED;
        LLMSavedModelVersionDeployment newDeployment = new LLMSavedModelVersionDeployment(deploymentId, fullModelId.getSavedModelVersionID(), deploymentType, creationMethod, System.currentTimeMillis(), authCtx.getIdentifier());
        fullModelId.writeLLMSavedModelDeployment(newDeployment);
        LLMClient llmClient = LLMClientFactory.get(authCtx, projectKey, llmStructuredRef);
        if (attachOnly) {
            deploymentWithStatus = llmClient.newSavedModelDeployer(authCtx).getDeployment(newDeployment);
            logger.info((Object)String.format("Deployment %s (%s) attached successfully", new Object[]{newDeployment.deploymentId, newDeployment.deploymentType}));
        } else {
            deploymentWithStatus = llmClient.newSavedModelDeployer(authCtx).createDeployment(newDeployment, ((LLMModelSnippetData)versionHeader.snippet).llmSMInfo.remoteModelId);
            logger.info((Object)String.format("Deployment %s (%s) created successfully", new Object[]{newDeployment.deploymentId, newDeployment.deploymentType}));
        }
        return deploymentWithStatus;
    }

    public LLMSavedModelVersionDeploymentWithStatus attachDeployment(AuthCtx authCtx, String projectKey, SavedModel sm, FullModelId fullModelId, String deploymentId) throws Exception {
        return this.createOrAttachDeployment(authCtx, projectKey, sm, fullModelId, deploymentId, true);
    }

    public LLMSavedModelVersionDeploymentWithStatus createDeployment(AuthCtx authCtx, String projectKey, SavedModel sm, FullModelId fullModelId, String deploymentId) throws Exception {
        return this.createOrAttachDeployment(authCtx, projectKey, sm, fullModelId, deploymentId, false);
    }

    public boolean deleteDeployment(AuthCtx authCtx, String projectKey, SavedModel sm, FullModelId fullModelId) throws Exception {
        LLMSMMgmtService.LLMSMStatus status = LLMSMMgmtService.getStatus_NT(sm);
        LLMSMMgmtService.LLMSMVersionHeader versionHeader = status.versions.stream().filter(vh -> vh.versionId.equals(fullModelId.getSavedModelVersionID())).findFirst().get();
        if (((LLMModelSnippetData)versionHeader.snippet).deployment == null) {
            throw new IllegalArgumentException("No deployment found to delete");
        }
        LLMStructuredRef llmStructuredRef = LLMStructuredRef.decodeId(((LLMModelSnippetData)versionHeader.snippet).llmSMInfo.originalLLMId);
        LLMClient llmClient = LLMClientFactory.get(authCtx, projectKey, llmStructuredRef);
        llmClient.newSavedModelDeployer(authCtx).deleteDeployment(((LLMModelSnippetData)versionHeader.snippet).deployment);
        logger.info((Object)String.format("Deployment %s (%s) deleted successfully", new Object[]{((LLMModelSnippetData)versionHeader.snippet).deployment.deploymentId, ((LLMModelSnippetData)versionHeader.snippet).deployment.deploymentType}));
        return fullModelId.getLLMDeploymentFile().delete();
    }

    public String deployFineTunedModel(AuthCtx authCtx, SavedModel sm, FullModelId fullModelId) throws Exception {
        logger.info((Object)"Deploying fine-tuned model");
        String newDeploymentId = String.format("dku-fted-%s-%s-%s", sm.projectKey, fullModelId.getSavedModelID(), fullModelId.getSavedModelVersionID());
        this.createDeployment(authCtx, sm.projectKey, sm, fullModelId, newDeploymentId);
        logger.info((Object)("Model deployment started: " + newDeploymentId + ", waiting for it to be done"));
        return newDeploymentId;
    }

    public void waitForDeploymentToBeAvailable(AuthCtx authCtx, SavedModel sm, FullModelId fullModelId, String deploymentId) throws Exception {
        logger.info((Object)("Waiting for deployment to be available: " + deploymentId));
        while (true) {
            block7: {
                Thread.sleep(5000L);
                try {
                    Optional<LLMSavedModelVersionDeploymentWithStatus> optDeploymentWithStatus = this.getDeployment(authCtx, sm.projectKey, sm, fullModelId.getSavedModelVersionID());
                    LLMSavedModelVersionDeploymentWithStatus.DeploymentStatus status = optDeploymentWithStatus.isEmpty() ? LLMSavedModelVersionDeploymentWithStatus.DeploymentStatus.NOT_FOUND : optDeploymentWithStatus.get().status;
                    logger.info((Object)("Deployment status: " + String.valueOf((Object)status)));
                    if (status == LLMSavedModelVersionDeploymentWithStatus.DeploymentStatus.AVAILABLE) {
                        logger.info((Object)"Model deployment completed");
                        break;
                    }
                    if (status == LLMSavedModelVersionDeploymentWithStatus.DeploymentStatus.IN_ERROR) {
                        throw new Exception("Failed to deploy fine-tuned model: " + deploymentId);
                    }
                    if (status == LLMSavedModelVersionDeploymentWithStatus.DeploymentStatus.NOT_FOUND) {
                        throw new Exception("Failed to find fine-tuned model deployment: " + deploymentId);
                    }
                }
                catch (ExternalJSONAPIClient.JSONAPIClientException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (!e.getMessage().contains("Connection reset")) break block7;
                    logger.warn((Object)"Connection reset, retrying");
                }
            }
            Thread.sleep(30000L);
        }
    }

    public void deleteVersionsDeployments(AuthCtx authCtx, SavedModel sm, Set<LLMSMMgmtService.LLMSMVersionHeader> versions) throws Exception {
        for (LLMSMMgmtService.LLMSMVersionHeader versionHeader : versions) {
            if (((LLMModelSnippetData)versionHeader.snippet).deployment == null) continue;
            logger.info((Object)("Deleting fine-tuned deployment: " + ((LLMModelSnippetData)versionHeader.snippet).deployment.deploymentId));
            FullModelId fmi = new FullModelId(sm.projectKey, sm.getId(), versionHeader.versionId);
            this.deleteDeployment(authCtx, sm.projectKey, sm, fmi);
        }
    }
}

