/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCheckContext {
    protected final ReadWriteJobsInternalDB jobsDatabaseService;
    private final APITicketService.Ticket ticket;
    public final long timeCheck;
    public final String projectKey;
    protected Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> lastValues = null;

    public AbstractCheckContext(long timeCheck, ReadWriteJobsInternalDB jobsDatabaseService, APITicketService.Ticket ticket, String projectKey) {
        this.timeCheck = timeCheck;
        this.jobsDatabaseService = jobsDatabaseService;
        this.ticket = ticket;
        this.projectKey = projectKey;
    }

    public long getTimeCheck() {
        return this.timeCheck;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> getLastValues() throws Exception {
        this.ensureLastValues();
        return this.lastValues;
    }

    public APITicketService.Ticket getTicket() {
        return this.ticket;
    }

    protected abstract void ensureLastValues() throws Exception;

    public ReadOnlyJobsInternalDB.MetricDataPoint getCurrentValue(String metricId) throws Exception {
        if (StringUtils.isBlank((String)metricId)) {
            return null;
        }
        this.ensureLastValues();
        return this.lastValues.get(metricId);
    }

    public abstract List<ReadOnlyJobsInternalDB.MetricDataPoint> getHistory(String var1) throws Exception;

    public CheckParameters setParamsForPythonChecks() throws Exception {
        throw new Exception("No checks possible on context of type " + this.getClass().getCanonicalName());
    }

    public static class CheckResult {
        public CheckOutcome outcome;
        public String message;
        @Nullable
        public WarningsContext.SerializedThrowable error;
        @Nullable
        public SmartLogTail logTail;

        public CheckResult(CheckOutcome outcome, String message) {
            this.outcome = outcome;
            this.message = message;
        }

        public boolean isError() {
            return this.outcome == CheckOutcome.ERROR;
        }

        public boolean isWarning() {
            return this.outcome == CheckOutcome.WARNING;
        }
    }

    public static class CheckParameters {
        MetricTargetType objectType;
        String partitionId;
        String fullName;

        CheckParameters(MetricTargetType objectType, String partitionId, String fullName) {
            this.objectType = objectType;
            this.partitionId = partitionId;
            this.fullName = fullName;
        }
    }

    public static enum CheckOutcome {
        OK,
        ERROR,
        WARNING,
        EMPTY;


        public static CheckOutcome worstOf(CheckOutcome a, CheckOutcome b) {
            if (a == ERROR || b == ERROR) {
                return ERROR;
            }
            if (a == WARNING || b == WARNING) {
                return WARNING;
            }
            if (a == OK || b == OK) {
                return OK;
            }
            return EMPTY;
        }
    }
}

