/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.automaticbin;

import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.common.automaticbin.ComputedBinningModes;
import com.dataiku.dip.pivot.backend.common.automaticbin.DssEngineAutomaticRequestHandler;
import com.dataiku.dip.pivot.backend.common.highcardinality.PostPruneSafetyChecks;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.SecurityAbortedException;
import com.dataiku.dip.pivot.backend.model.boxplots.PTBoxplotsRequest;

public class BoxplotsAutomaticRequestHandler
extends DssEngineAutomaticRequestHandler<PTBoxplotsRequest> {
    private final AxisDef[] axesDefs;
    private final int maxDrawnBoxPlots;

    public BoxplotsAutomaticRequestHandler(PTBoxplotsRequest request, LinoReader linoReader, int maxDrawnBoxPlots) {
        super(request, linoReader);
        this.axesDefs = request.axes;
        this.maxDrawnBoxPlots = maxDrawnBoxPlots;
    }

    @Override
    protected void checkComputedBinningModes(PTBoxplotsRequest request, ComputedBinningModes result) throws SecurityAbortedException {
        int elems = PostPruneSafetyChecks.getElementCountForAxisForComputedBinningModes(request.axes[0], result, 0);
        PostPruneSafetyChecks.checkSimple(elems, this.maxDrawnBoxPlots);
    }

    @Override
    protected AxisDef[] getAxesDef() {
        return this.axesDefs;
    }
}

