/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractNonImpersonatedSecretProtectedPythonKernel;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;

public class PluginSetupPythonKernel
extends AbstractNonImpersonatedSecretProtectedPythonKernel<ResponderKernelLink> {
    private final APITicketService.Ticket ticket;
    private final String projectKey;

    public PluginSetupPythonKernel(ResponderKernelLink link, String pluginResourceFolderPath, String pluginPythonlibFolderPath, APITicketService.Ticket ticket, String projectKey, String envName) {
        super(ticket.getOriginalUser(), link, null, pluginResourceFolderPath, PluginSetupPythonKernel.makePythonLibs("plugin-lib", pluginPythonlibFolderPath), projectKey, envName);
        this.ticket = ticket;
        this.projectKey = projectKey;
    }

    @Override
    protected String getPythonModule() {
        return "dataiku.customui.server";
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        pb.environment().put("DKU_CURRENT_PROJECT_KEY", this.projectKey);
        return super.createAndStartProcess(pb, cgrouppableProcessType);
    }

    public static class DoRequest {
        public JsonObject payload;
        public PluginSettingsResolver.ResolvedSettings config;
        public List<DoRequestInput> inputs;

        public DoRequest(JsonObject payload, PluginSettingsResolver.ResolvedSettings config, List<DoRequestInput> inputs) {
            this.payload = payload;
            this.inputs = inputs;
            this.config = config;
        }
    }

    public static class DoRequestInput {
        public FlowComputable.FCType type;
        public String role;
        public String fullName;

        public DoRequestInput(String role, FlowComputable.FCType type, String fullName) {
            this.role = role;
            this.type = type;
            this.fullName = fullName;
        }
    }

    public static class StartResponse {
        public boolean ok;
        public String reason;
    }

    public static class StartRequest {
        public String code;

        public StartRequest(String code) {
            this.code = code;
        }
    }
}

