/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.UsedContainerExec;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.BundlePreloader;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.TestBundleInfoDTO;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.projects.importexport.model.ImportedBundleState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.ManagedDatasetConnection;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.ZipUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutomationBundlesService
extends AbstractBundleService {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private LicenseEnforcementService licenseService;
    @Autowired
    private UsersService usersService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.projects.import");

    public String createProjectUsingInitialBundleZipStream(AuthCtx user, InputStream inputStream, String projectFolderId, String projectKey, AbstractProjectDeploymentInfra.PermissionsPropagationPolicy permissionsPropagationPolicy) throws Exception {
        AutoDelete tmpArchiveLocation = DSSTempUtils.getTempFile((String)"bundle-import", (String)"archive", (String)"zip");
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tmpArchiveLocation);
        return this.createProjectUsingInitialBundleArchive(user, (File)tmpArchiveLocation, false, projectFolderId, projectKey, permissionsPropagationPolicy);
    }

    public String createProjectUsingInitialBundleArchive(AuthCtx user, File archive, boolean copyInsteadOfMove, String projectFolderId, String projectKey, AbstractProjectDeploymentInfra.PermissionsPropagationPolicy permissionsPropagationPolicy) throws Exception {
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus features = this.licenseService.getFeaturesStatus();
        if (!features.bundlesAllowed) {
            throw new LicenseRestrictionException("Bundles are not enabled in your license");
        }
        ExportedProject ep = ZipUtils.readFileContentJSON(archive, "export-manifest.json", ExportedProject.class);
        if (ep == null) {
            throw ErrorContext.iae((String)("Export manifest not found: is this a DSS bundle ? file= " + String.valueOf(archive)));
        }
        if (ep.bundleId == null) {
            throw ErrorContext.iae((String)("Export has no bundleId: is this a DSS bundle ? file= " + String.valueOf(archive)));
        }
        if (ep.bundleId == null) {
            throw ErrorContext.iae((String)("Bundle id not found: is this a DSS bundle (or a project export) ? file= " + String.valueOf(archive)));
        }
        SerializedProject bundleProjectSettings = ZipUtils.readFileContentJSON(archive, "project_config/params.json", SerializedProject.class);
        String newProjectKey = StringUtils.isBlank((String)projectKey) ? ep.originalProjectKey : projectKey;
        logger.info((Object)("Creating new project using initial bundle:" + String.valueOf(archive) + " key=" + newProjectKey));
        try (Transaction t = this.transactionService.beginRead();){
            if (t.exists(new RelFile(new String[]{"projects", newProjectKey}))) {
                throw new IllegalArgumentException("Project key " + newProjectKey + " is already used. Please check that you have not already imported this project.");
            }
        }
        File targetArchiveFile = this.copyOrMoveArchive(newProjectKey, ep.bundleId, archive, copyInsteadOfMove);
        ImportedBundleState ibs = new ImportedBundleState();
        ibs.importedBy = user.getIdentifier();
        ibs.importedOn = DKUDateUtils.isoFormatLocalNow();
        JSON.prettyToFile((Object)ibs, (File)new File(targetArchiveFile.getParent(), "import-tag.json"));
        SerializedProject targetProjectSettings = (SerializedProject)JSON.deepCopy((Object)bundleProjectSettings);
        targetProjectSettings.projectType = SerializedProject.ProjectType.BUNDLE_CONTAINER;
        targetProjectSettings.projectKey = newProjectKey;
        targetProjectSettings.bundleContainerSettings = new BundleContainerSettings();
        targetProjectSettings.owner = user.getIdentifier();
        targetProjectSettings.settings.limitedVisibilityEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
        targetProjectSettings.settings.accessRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
        targetProjectSettings.settings.sharingRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
        targetProjectSettings.permissions = new ArrayList<SerializedProject.PermissionItem>();
        switch (permissionsPropagationPolicy) {
            case NONE: {
                logger.infoV("Not propagating permissions from bundle to new project %s.", new Object[]{newProjectKey});
                break;
            }
            case READ_ONLY: 
            case ALL: {
                boolean readOnly = permissionsPropagationPolicy == AbstractProjectDeploymentInfra.PermissionsPropagationPolicy.READ_ONLY;
                this.propagatePermissions(targetProjectSettings, bundleProjectSettings, readOnly);
                break;
            }
        }
        ProjectsJGitService projectsGitService = (ProjectsJGitService)SpringUtils.getBean(ProjectsJGitService.class);
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.projectsService.create(targetProjectSettings, TaggableObjectChangedEvent.ProjectEditSubtype.UNKNOWN, projectFolderId);
            projectsGitService.checkIfHasUncommittedChangedAndRemoveNoiseFromSerialization(targetProjectSettings.projectKey);
            rwt.commit("Imported project " + targetProjectSettings.projectKey + " from bundle");
        }
        projectsGitService.addProjectTagOnProjectImport_NT(user, targetProjectSettings.projectKey);
        return newProjectKey;
    }

    private void propagatePermissions(SerializedProject targetProjectSettings, SerializedProject bundleProjectSettings, boolean readOnly) throws IOException {
        logger.infoV("Propagating %s from bundle to new project %s.", new Object[]{readOnly ? "permissions as readonly" : "all permissions", targetProjectSettings.projectKey});
        try (Transaction ignored = this.transactionService.beginRead();){
            for (SerializedProject.PermissionItem permissionItem : bundleProjectSettings.permissions) {
                SerializedProject.PermissionItem automationPermission;
                if (permissionItem == null) continue;
                if (readOnly) {
                    automationPermission = permissionItem.toReadOnly();
                    if (automationPermission == null) {
                        logger.debugV("Not propagating permission %s as it has no read only equivalent.", new Object[]{JSON.log((Object)permissionItem)});
                        continue;
                    }
                } else {
                    automationPermission = permissionItem;
                }
                if (StringUtils.isNotEmpty((String)permissionItem.group)) {
                    if (this.usersService.getGroup(permissionItem.group) == null) {
                        throw new NotFoundException("Group " + permissionItem.group + " not found");
                    }
                    logger.debugV("Propagating group permission %s%s.", new Object[]{JSON.log((Object)permissionItem), readOnly ? " as read only " + JSON.log((Object)automationPermission) : ""});
                    targetProjectSettings.permissions.add(automationPermission);
                    continue;
                }
                if (StringUtils.isNotEmpty((String)permissionItem.user)) {
                    if (this.usersService.getUser_NoLeak(permissionItem.user) == null) {
                        throw new NotFoundException("User " + permissionItem.user + " not found");
                    }
                    logger.debugV("Propagating user permission %s%s.", new Object[]{JSON.log((Object)permissionItem), readOnly ? " as read only " + JSON.log((Object)automationPermission) : ""});
                    targetProjectSettings.permissions.add(automationPermission);
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)permissionItem.pendingUserEmail)) continue;
                logger.debugV("Not propagating pending permission %s.", new Object[]{JSON.log((Object)permissionItem)});
            }
            if (StringUtils.isNotEmpty((String)bundleProjectSettings.owner)) {
                if (this.usersService.getUser_NoLeak(bundleProjectSettings.owner) == null) {
                    logger.debugV("Owner %s defined in bundle not found. Not adding %s permission.", new Object[]{bundleProjectSettings.owner, readOnly ? "read only" : "admin"});
                } else {
                    SerializedProject.PermissionItem piOwner = new SerializedProject.PermissionItem();
                    piOwner.user = bundleProjectSettings.owner;
                    piOwner.setAdminPermissions();
                    if (readOnly) {
                        piOwner = piOwner.toReadOnly();
                    }
                    logger.debugV("Ensuring owner of design project has %s permission %s.", new Object[]{readOnly ? "read only" : "admin", JSON.log((Object)piOwner)});
                    targetProjectSettings.permissions.add(piOwner);
                }
            }
        }
        logger.infoV("Propagated permissions to %s: %s.", new Object[]{targetProjectSettings.projectKey, JSON.log(targetProjectSettings.permissions)});
    }

    public String importBundleZipStream(AuthCtx authCtx, String projectKey, InputStream inputStream, boolean allowProjectKeyMismatch) throws IOException {
        AutoDelete tmpArchiveLocation = DSSTempUtils.getTempFile((String)"bundle-import", (String)"archive", (String)"zip");
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tmpArchiveLocation);
        return this.importBundleArchive(authCtx, projectKey, (File)tmpArchiveLocation, false, allowProjectKeyMismatch);
    }

    public String importBundleArchive(AuthCtx authCtx, String projectKey, File archive, boolean copyInsteadOfMove, boolean allowProjectKeyMismatch) throws IOException {
        ExportedProject ep = ZipUtils.readFileContentJSON(archive, "export-manifest.json", ExportedProject.class);
        logger.info((Object)("Importing new bundle from archive=" + String.valueOf(archive) + " project=" + projectKey));
        if (!projectKey.equals(ep.originalProjectKey)) {
            if (allowProjectKeyMismatch) {
                logger.infoV("Bundle project key (%s) and project key (%s) mismatch allowed", new Object[]{ep.originalProjectKey, projectKey});
            } else {
                throw ErrorContext.iaef((String)"Invalid bundle bundleProjectKey=%s projectKey=%s", (Object)ep.originalProjectKey, (Object[])new Object[]{projectKey});
            }
        }
        try (Transaction t = this.transactionService.beginRead();){
            if (!t.exists(new RelFile(new String[]{"projects", projectKey}))) {
                throw new NotFoundException("Project key " + projectKey + " does not exist");
            }
        }
        File targetArchiveFile = this.copyOrMoveArchive(projectKey, ep.bundleId, archive, copyInsteadOfMove);
        ImportedBundleState ibs = new ImportedBundleState();
        ibs.importedBy = authCtx.getIdentifier();
        ibs.importedOn = DKUDateUtils.isoFormatLocalNow();
        JSON.prettyToFile((Object)ibs, (File)new File(targetArchiveFile.getParent(), "import-tag.json"));
        return ep.bundleId;
    }

    public List<TestBundleInfoDTO> listTestBundleInfoDTO(String projectKey, String activeBundleId) throws IOException {
        CommonBundleUtils.BundleInfoList infoList = this.listImported(projectKey);
        ArrayList<TestBundleInfoDTO> testBundleInfoDTOList = new ArrayList<TestBundleInfoDTO>();
        for (CommonBundleUtils.BundleInfoBase infoBase : infoList.bundles) {
            CommonBundleUtils.ImportedBundle importedInfoBase = (CommonBundleUtils.ImportedBundle)infoBase;
            testBundleInfoDTOList.add(new TestBundleInfoDTO(importedInfoBase.bundleId, projectKey, importedInfoBase.importState.importedOn, importedInfoBase.exportManifest.exportUserInfo.exportedOn, importedInfoBase.bundleId.equals(activeBundleId)));
        }
        return testBundleInfoDTOList;
    }

    public CommonBundleUtils.BundleInfoList listImported(String projectKey) throws IOException {
        CommonBundleUtils.BundleInfoList ret = new CommonBundleUtils.BundleInfoList();
        File bundlesFolder = ApplicationConfigurator.getFile((String[])new String[]{"imported_bundles", projectKey});
        if (!bundlesFolder.isDirectory()) {
            return ret;
        }
        for (File candidate : bundlesFolder.listFiles()) {
            File bundleFile;
            if (!candidate.isDirectory() || !(bundleFile = DKUFileUtils.getWithin((File)candidate, (String[])new String[]{"dss-bundle-" + projectKey + "-" + candidate.getName() + ".zip"})).isFile()) continue;
            CommonBundleUtils.ImportedBundle ib = new CommonBundleUtils.ImportedBundle();
            new CommonBundleUtils().summarizeFromArchive(bundleFile, ib);
            File importTagFile = new File(bundleFile.getParent(), "import-tag.json");
            if (importTagFile.isFile()) {
                ib.importState = (ImportedBundleState)JSON.parseFile((File)importTagFile, ImportedBundleState.class);
            }
            ret.bundles.add(ib);
        }
        return ret;
    }

    public CommonBundleUtils.BundleDetails getBundleDetails(String projectKey, String bundleId) throws IOException {
        return CommonBundleUtils.getDetailsFromArchive(this.getBundleArchive(projectKey, bundleId));
    }

    private File copyOrMoveArchive(String projectKey, String bundleId, File archive, boolean copyInsteadOfMove) throws IOException {
        String filename = "dss-bundle-" + projectKey + "-" + bundleId + ".zip";
        File targetBundlePath = ApplicationConfigurator.getFile((String[])new String[]{"imported_bundles", projectKey, bundleId});
        if (targetBundlePath.isDirectory()) {
            logger.warn((Object)("Bundle path already existed, removing: " + String.valueOf(targetBundlePath)));
            DKUFileUtils.forceDelete((File)targetBundlePath);
        }
        DKUFileUtils.mkdirs((File)targetBundlePath);
        File targetFile = new File(targetBundlePath, filename);
        if (copyInsteadOfMove) {
            FileUtils.copyFile((File)archive, (File)targetFile);
        } else {
            FileUtils.moveFile((File)archive, (File)targetFile);
        }
        return targetFile;
    }

    public BundleContainerSettings getBundleContainerSettings(String projectKey) throws IOException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        if (sp.bundleContainerSettings == null) {
            return new BundleContainerSettings();
        }
        return sp.bundleContainerSettings;
    }

    /*
     * WARNING - void declaration
     */
    public BundleContainerSettingsExtended getBundleContainerSettingsExt(AuthCtx authCtx, String projectKey) throws Exception {
        void var5_9;
        BundleContainerSettingsExtended ret = new BundleContainerSettingsExtended();
        ret.settings = this.getBundleContainerSettings(projectKey);
        for (DSSConnection dSSConnection : this.connectionsDAO.list().values()) {
            if (!dSSConnection.isFreelyUsableBy(authCtx)) continue;
            ManagedDatasetConnection mdc = new ManagedDatasetConnection();
            mdc.name = dSSConnection.name;
            mdc.description = dSSConnection.description;
            mdc.type = dSSConnection.getType();
            mdc.sql = dSSConnection.isProperSQL();
            ret.availableConnections.add(mdc);
        }
        for (ContainerExecRuntimeConfig containerExecRuntimeConfig : new ClusterSelector().selectGlobal().getContainerSettings().executionConfigs) {
            if (!containerExecRuntimeConfig.isFreelyUsableBy(authCtx)) continue;
            ret.availableContainerExecConfs.add(containerExecRuntimeConfig);
        }
        List<CommonBundleUtils.BundleInfoBase> bundles = this.listImported((String)projectKey).bundles;
        Object var5_8 = null;
        SimpleDateFormat sdf = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        for (CommonBundleUtils.BundleInfoBase bundle : bundles) {
            CommonBundleUtils.ImportedBundle importedBundle = (CommonBundleUtils.ImportedBundle)bundle;
            if (importedBundle.importState == null || var5_9 != null && !sdf.parse(importedBundle.importState.importedOn).after(sdf.parse(var5_9.importState.importedOn))) continue;
            CommonBundleUtils.ImportedBundle importedBundle2 = importedBundle;
        }
        if (var5_9 != null) {
            CommonBundleUtils.BundleDetails bundleDetails = this.getBundleDetails(projectKey, var5_9.bundleId);
            ret.usedByLastBundle = Lists.newArrayList(bundleDetails.exportManifest.requiredConnections.values());
            ret.containerExecConfsUsedByLastBundle = Lists.newArrayList(bundleDetails.exportManifest.usedContainerExecConfs);
        }
        return ret;
    }

    public void saveBundleContainerSettings(String projectKey, BundleContainerSettings settings) throws Exception {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        sp.bundleContainerSettings = settings;
        this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
    }

    public void deleteAllForProject(String projectKey) throws IOException {
        File folder = ApplicationConfigurator.getFile((String[])new String[]{"imported_bundles", projectKey});
        if (folder.isDirectory()) {
            DKUFileUtils.forceDelete((File)folder);
        }
    }

    @Override
    public File getBundleDirectory(String projectKey, String bundleId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"imported_bundles", projectKey, bundleId});
    }

    public FutureResponse<BundlePreloader.BundlePreloadingReport> startPreloadBundle_NT(AuthCtx user, String projectKey, String bundleId) throws Exception {
        BundlePreloadingFutureThread baft = new BundlePreloadingFutureThread(user, projectKey, bundleId);
        return this.futureService.runFuture(baft, 0L, new TypeToken<FutureResponse<BundlePreloader.BundlePreloadingReport>>(){});
    }

    public static class BundleContainerSettingsExtended {
        BundleContainerSettings settings;
        List<ManagedDatasetConnection> availableConnections = new ArrayList<ManagedDatasetConnection>();
        List<DatasetConnectionUtils.UsedConnection> usedByLastBundle = new ArrayList<DatasetConnectionUtils.UsedConnection>();
        List<ContainerExecRuntimeConfig> availableContainerExecConfs = new ArrayList<ContainerExecRuntimeConfig>();
        List<UsedContainerExec> containerExecConfsUsedByLastBundle = new ArrayList<UsedContainerExec>();
    }

    public class BundlePreloadingFutureThread
    extends SimpleFutureThread<BundlePreloader.BundlePreloadingReport> {
        private final String projectKey;
        private final String bundleId;
        private final DKUtils.SmartLogTailBuilder logTailBuilder;

        public BundlePreloadingFutureThread(AuthCtx user, String projectKey, String bundleId) {
            super(user);
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.projectKey = projectKey;
            this.bundleId = bundleId;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "preload_bundle";
            fp.targets.add(new FuturePayload.FuturePayloadTarget(this.projectKey, this.bundleId, ITaggingService.TaggableType.PROJECT.name(), null));
            fp.displayName = "Preload bundle " + this.projectKey;
            return fp;
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }

        @Override
        public BundlePreloader.BundlePreloadingReport compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Preloading bundle");){
                BundleContainerSettings containerSettings = null;
                try (Transaction t = AutomationBundlesService.this.transactionService.beginRead();){
                    containerSettings = AutomationBundlesService.this.projectsService.getOrNullUnsafe((String)this.projectKey).bundleContainerSettings;
                }
                File bundleArchive = AutomationBundlesService.this.getBundleArchive(this.projectKey, this.bundleId);
                File bundlePath = AutomationBundlesService.this.getBundleDirectory(this.projectKey, this.bundleId);
                File unzippedBundlePath = new File(bundlePath, "extracted");
                if (!unzippedBundlePath.isDirectory()) {
                    DKUFileUtils.mkdirs((File)unzippedBundlePath);
                    ZipUnzipDir.extractFolder(bundleArchive, unzippedBundlePath, false);
                }
                BundlePreloader preloader = new BundlePreloader(this.owner, containerSettings, unzippedBundlePath, this.projectKey, this.logTailBuilder);
                BundlePreloader.BundlePreloadingReport bundlePreloadingReport = preloader.run();
                return bundlePreloadingReport;
            }
        }
    }
}

