/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveExecutionConfig;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveConfHelper {
    @Autowired
    private VariablesService variablesService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.hive.conf");

    public HiveConfHelper() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public List<SimpleKeyValue> getResolvedConf(AuthCtx authCtx, String projectKey, HiveRecipeMeta.HiveRecipeParams params) throws IOException, DKUSecurityException {
        HiveExecutionConfig baseConf = this.getSelectedExecConf(authCtx, projectKey, params.inheritConf, false);
        return this.getResolvedConf(projectKey, baseConf.conf.getAsSimpleKeyValueList(), params.hiveconf);
    }

    public List<SimpleKeyValue> getResolvedConf(AuthCtx authCtx, String projectKey, String configToUse, List<SimpleKeyValue> override) throws IOException, DKUSecurityException {
        HiveExecutionConfig baseConf = this.getSelectedExecConf(authCtx, projectKey, configToUse, false);
        return this.getResolvedConf(projectKey, baseConf.conf.getAsSimpleKeyValueList(), override);
    }

    public List<SimpleKeyValue> getResolvedHiveRuntimeConf(AuthCtx authCtx, String projectKey, List<SimpleKeyValue> override) throws IOException, DKUSecurityException {
        HiveExecutionConfig baseConf = this.getSelectedExecConf(authCtx, projectKey, null, true);
        return this.getResolvedConf(projectKey, baseConf.conf.getAsSimpleKeyValueList(), override);
    }

    private HiveExecutionConfig getSelectedExecConf(AuthCtx authCtx, String projectKey, String configToUse, boolean forHiveRuntime) throws IOException, DKUSecurityException {
        HiveSettings hs = new ClusterSelector().selectForProject(authCtx, projectKey).getHiveSettings();
        if (forHiveRuntime) {
            configToUse = hs.configForHiveRuntime;
        }
        HiveExecutionConfig found = null;
        for (HiveExecutionConfig hec : hs.executionConfigs) {
            if (hec.name == null || !hec.name.equals(configToUse)) continue;
            found = hec;
            break;
        }
        logger.infoV("Resolving HiveConf configToUse=%s configToUseResolved=%s", new Object[]{configToUse, JSON.log(found)});
        if (found == null) {
            if (hs.executionConfigs.size() == 0) {
                logger.warn((Object)"No valid Hive execution config");
                found = new HiveExecutionConfig();
                found.conf = found.conf.getOverriden(hs.executionConfigsGenericOverrides);
            } else {
                logger.warnV("Hive execution config %s not found, falling back to first one", new Object[]{configToUse});
                found = hs.executionConfigs.get(0);
            }
        }
        return found;
    }

    private List<SimpleKeyValue> getResolvedConf(String projectKey, List<SimpleKeyValue> baseConf, List<SimpleKeyValue> override) {
        LinkedHashMap<String, String> resolvedConfig = new LinkedHashMap<String, String>();
        for (SimpleKeyValue base : baseConf) {
            if (StringUtils.isBlank((String)base.key)) continue;
            resolvedConfig.put(base.key, base.value == null ? "" : base.value);
        }
        if (override != null) {
            for (SimpleKeyValue overriden : override) {
                if (StringUtils.isBlank((String)overriden.key)) continue;
                resolvedConfig.put(overriden.key, overriden.value == null ? "" : overriden.value);
            }
        }
        ArrayList<SimpleKeyValue> ret = new ArrayList<SimpleKeyValue>();
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        for (Map.Entry e : resolvedConfig.entrySet()) {
            String resolvedValue = vc.expandAllowUnresolved((String)e.getValue());
            ret.add(new SimpleKeyValue((String)e.getKey(), resolvedValue));
        }
        return ret;
    }
}

