/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.eda.worksheets.cards.PCACard;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.common.MultipleOutputDatasetsRecipeCreator;
import com.dataiku.dip.recipes.eda.EDARecipeParams;
import com.dataiku.dip.recipes.eda.PCARecipePayloadParams;
import com.dataiku.dip.recipes.eda.PCARecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NullChecker;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PCARecipeCreator
extends MultipleOutputDatasetsRecipeCreator {
    public PCARecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta, false);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data) throws Exception {
        boolean useDefaultParameters;
        JsonElement flag = data.get("useDefaultParameters");
        boolean bl = useDefaultParameters = flag != null && flag.getAsBoolean();
        if (useDefaultParameters) {
            PCARecipePayloadParams initialPayload = new PCARecipePayloadParams();
            return JSON.json((Object)initialPayload);
        }
        JsonObject cardJson = data.getAsJsonObject("card");
        PCACard pcaCard = (PCACard)JSON.parse((JsonElement)cardJson, PCACard.class);
        NullChecker.checkObject((Object)pcaCard);
        List<String> columns = pcaCard.columns.stream().map(c2 -> c2.name).collect(Collectors.toList());
        PCARecipePayloadParams initialPayload = new PCARecipePayloadParams(columns);
        NullChecker.checkObject((Object)initialPayload);
        return JSON.json((Object)initialPayload);
    }

    @Override
    protected RecipeParams makeInitialParams(SerializedRecipe sr, JsonObject creationData) throws Exception {
        String originWorksheetId = null;
        if (creationData.has("originWorksheetId")) {
            JsonElement originWorksheetIdJson = creationData.get("originWorksheetId");
            originWorksheetId = originWorksheetIdJson.getAsString();
        }
        StreamableDatasetSelection datasetSelection = StreamableDatasetSelection.full();
        if (creationData.has("datasetSelection")) {
            JsonObject selectionJson = creationData.getAsJsonObject("datasetSelection");
            datasetSelection = (StreamableDatasetSelection)((Object)JSON.parse((JsonElement)selectionJson, StreamableDatasetSelection.class));
        }
        ContainerExecSelection containerSelection = new ContainerExecSelection();
        if (creationData.has("containerSelection")) {
            JsonObject selectionJson = creationData.getAsJsonObject("containerSelection");
            containerSelection = (ContainerExecSelection)JSON.parse((JsonElement)selectionJson, ContainerExecSelection.class);
        }
        EDARecipeParams params = new EDARecipeParams(originWorksheetId, datasetSelection, containerSelection);
        NullChecker.checkObject((Object)params);
        return params;
    }

    @Override
    protected void setOutputSchemas_T(SerializedRecipe sr, String payload, Map<String, List<Dataset>> outputDatasetsByRole) throws Exception {
        FlowRecipe fr = new FlowRecipe(sr);
        RecipeRunnableSubgraph subgraph = this.recipesValidationService.getSampleSubgraph(fr);
        JobActivity activity = new JobActivity(subgraph);
        PCARecipeSchemaComputer schemaComputer = new PCARecipeSchemaComputer(this.authCtx, activity);
        schemaComputer.setPayload(payload);
        for (Map.Entry<String, List<Dataset>> entry : outputDatasetsByRole.entrySet()) {
            String role = entry.getKey();
            for (Dataset outputDataset : entry.getValue()) {
                outputDataset.setSchema(schemaComputer.getOutputSchema_T(role));
            }
        }
    }
}

