/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.nlp.common.EmbeddingRecipePayloadBaseParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.rag_embedding.RAGEmbeddingRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EmbedDocumentsRecipeCreator
extends RAGEmbeddingRecipeCreator {
    public static DKULogger logger = DKULogger.getLogger(EmbedDocumentsRecipeCreator.class);
    @Autowired
    private ManagedFoldersService managedFoldersService;

    public EmbedDocumentsRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected EmbeddingRecipePayloadBaseParams createDefaultPayload() {
        return new EmbedDocumentsRecipePayloadParams();
    }

    @Override
    protected RecipeParams makeInitialParams(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        String embeddingLLMId = null;
        if (creationData.has("embeddingLLMId")) {
            JsonElement selectionJson = creationData.get("embeddingLLMId");
            embeddingLLMId = selectionJson.getAsString();
        }
        EmbedDocumentsRecipeCreationSettings embedDocumentsRecipeCreationSettings = (EmbedDocumentsRecipeCreationSettings)JSON.parse((JsonElement)creationData, EmbedDocumentsRecipeCreationSettings.class);
        EmbedDocumentsRecipeParams params = new EmbedDocumentsRecipeParams();
        EnrichedLLMStructuredRef embeddingModelRef = this.llmRefEnricherService.getEnrichedLLMRef(embeddingLLMId, this.authCtx, recipe.projectKey);
        params.initializeWithDefaultRules(embeddingModelRef, embedDocumentsRecipeCreationSettings.VLMId);
        return params;
    }

    @Override
    protected void setRetrievableKnowledgeFields(SerializedRecipe recipe, JsonObject creationData, RetrievableKnowledge rk) throws Exception {
        EmbedDocumentsRecipeCreationSettings embedDocumentsRecipeCreationSettings = (EmbedDocumentsRecipeCreationSettings)JSON.parse((JsonElement)creationData, EmbedDocumentsRecipeCreationSettings.class);
        if (embedDocumentsRecipeCreationSettings.managedFolderId != null) {
            rk.managedFolderId = embedDocumentsRecipeCreationSettings.managedFolderId;
        } else {
            try {
                ManagedFolder folder = this.createOutputFolder(recipe, embedDocumentsRecipeCreationSettings.zone);
                rk.managedFolderId = folder.getFullId();
            }
            catch (Exception e) {
                logger.warn((Object)"Output folder cannot be created automatically", (Throwable)e);
            }
        }
        rk.multimodalColumn = "DKU_MULTIMODAL_CONTENT";
    }

    private ManagedFolder createOutputFolder(SerializedRecipe recipe, String zone) throws Exception {
        SerializedRecipe.RecipeInput recipeInput = recipe.getInputsForRole("main").get(0);
        AnyLoc inputFolderLoc = recipeInput.getLoc(recipe.projectKey);
        ManagedFolder inputFolder = this.managedFoldersService.getMandatory(inputFolderLoc.getProjectKey(), inputFolderLoc.getId());
        String name = inputFolder.name + "_embedded_images";
        StringTransmogrifier transmogrifier = new StringTransmogrifier(" ");
        for (ManagedFolder mf : this.managedFoldersService.list(recipe.projectKey)) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(mf.name);
        }
        String outputFolderName = transmogrifier.transmogrify(name);
        GeneralSettingsDAO.DocExtractionRecipesSettings embedDocumentsRecipeSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.embedDocumentsRecipeSettings;
        ManagedFoldersService.ManagedFolderCreationSettings creationSettings = new ManagedFoldersService.ManagedFolderCreationSettings();
        creationSettings.connectionId = embedDocumentsRecipeSettings != null && StringUtils.isNotEmpty((String)embedDocumentsRecipeSettings.defaultOutputFolderConnectionId) ? embedDocumentsRecipeSettings.defaultOutputFolderConnectionId : inputFolder.params.connection;
        creationSettings.zone = zone;
        ManagedFolder outputFolder = this.managedFoldersService.create(recipe.projectKey, outputFolderName, creationSettings, this.authCtx);
        String commonSuffix = "${projectKey}/${odbId}";
        String embedDocsSuffix = "embedded_documents/" + commonSuffix;
        if (outputFolder.params.path != null && outputFolder.params.path.endsWith(commonSuffix)) {
            outputFolder.params.path = outputFolder.params.path.substring(0, outputFolder.params.path.length() - commonSuffix.length()) + embedDocsSuffix;
        }
        logger.info((Object)("Output folder created with path: " + outputFolder.params.path));
        this.managedFoldersService.save(outputFolder, false, false);
        recipe.addOutput("images", outputFolder.id, false);
        return outputFolder;
    }

    public static class EmbedDocumentsRecipeCreationSettings
    extends RAGEmbeddingRecipeCreator.RAGEmbeddingRecipeCreationSettings {
        public String VLMId;
        public String managedFolderId;
    }
}

