/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.evaluation;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractPythonRecipeRunner;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.nlp.evaluation.GenAIEvaluationRecipeParams;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractGenAIEvaluationRecipePythonRunner
extends AbstractPythonRecipeRunner {
    @Nonnull
    protected final AutoDelete contextDir;
    @Nullable
    protected final String inputDatasetSmartName;
    @Nullable
    protected final String outputDatasetSmartName;
    @Nullable
    protected final String metricsDatasetSmartName;
    @Nullable
    protected final File modelEvaluationFolder;
    @Nonnull
    protected final File additionalLogsDir;
    @Nonnull
    protected final File mainLogFile;
    protected final int ragasMaxWorkers;

    public AbstractGenAIEvaluationRecipePythonRunner(@Nonnull JobActivity activity, @Nonnull AutoDelete contextDir, @Nullable String inputDatasetSmartName, @Nullable String outputDatasetSmartName, @Nullable String metricsDatasetSmartName, @Nullable File modelEvaluationFolder, @Nonnull File additionalLogsDir, @Nonnull File mainLogFile, int ragasMaxWorkers) {
        super(activity);
        this.contextDir = contextDir;
        this.inputDatasetSmartName = inputDatasetSmartName;
        this.outputDatasetSmartName = outputDatasetSmartName;
        this.metricsDatasetSmartName = metricsDatasetSmartName;
        this.modelEvaluationFolder = modelEvaluationFolder;
        this.additionalLogsDir = additionalLogsDir;
        this.mainLogFile = mainLogFile;
        this.ragasMaxWorkers = ragasMaxWorkers;
    }

    @Override
    public void init() throws Exception {
    }

    protected abstract DKULogger getLogger();

    protected abstract String getEvalType();

    protected abstract String getPythonModule();

    protected abstract RemoteRunsRegistry.ExecutionType getExecutionType();

    @Override
    public void run() throws Exception {
        boolean hasModelEvaluationStore;
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        FilesystemACLUtils.grantFSFullACLs(authCtx, this.projectKey, new File[]{this.contextDir});
        GenAIEvaluationRecipeParams params = this.recipe.getModel().getParamsAs(GenAIEvaluationRecipeParams.class);
        String envName = new CodeEnvSelector().selectForPythonRecipe(this.recipe.getProjectKey(), params.getCodeEnvSelection());
        CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
        ContainerExecSelection containerSelection = this.recipe.getModel().getParamsAs(ContainerRecipeParams.class).getContainerSelection();
        ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().selectForML_autoTXN(authCtx, this.recipe.getProjectKey(), containerSelection, MLTask.BackendType.PY_MEMORY);
        this.getLogger().infoV("Run %s evaluation in code env %s and container %s", new Object[]{this.getEvalType(), StringUtils.defaultIfBlank((String)envName, (String)"built-in"), containerConfig == null ? "local" : containerConfig.name});
        boolean bl = hasModelEvaluationStore = this.modelEvaluationFolder != null;
        if (containerConfig == null) {
            this.executeModule(envName, (File)this.contextDir, this.getPythonModule(), this.contextDir.getAbsolutePath(), hasModelEvaluationStore ? this.modelEvaluationFolder.getAbsolutePath() : "", this.inputDatasetSmartName, this.outputDatasetSmartName != null ? this.outputDatasetSmartName : "", this.metricsDatasetSmartName != null ? this.metricsDatasetSmartName : "", Integer.toString(this.ragasMaxWorkers));
        } else {
            ArrayList<String> readableAndWritablePaths = new ArrayList<String>(List.of(this.contextDir.getAbsolutePath()));
            if (hasModelEvaluationStore) {
                readableAndWritablePaths.add(this.modelEvaluationFolder.getAbsolutePath());
            }
            JsonObject payload = this.getPayload(this.inputDatasetSmartName);
            switch (containerConfig.type) {
                case DOCKER: {
                    this.executeDockerCodeRecipe(codeEnvRef, containerConfig, null, this.mainLogFile, this.contextDir, this.getExecutionType(), payload.toString(), Collections.emptyMap(), readableAndWritablePaths, readableAndWritablePaths);
                    break;
                }
                case KUBERNETES: {
                    this.executeKubernetesCodeRecipe(codeEnvRef, containerConfig, null, this.mainLogFile, this.additionalLogsDir, this.contextDir, this.getExecutionType(), payload.toString(), Collections.emptyMap(), readableAndWritablePaths, readableAndWritablePaths, () -> RecipeCodes.ERR_RECIPE_ML_EVALUATION_K8S_OOM);
                }
            }
        }
    }

    @Nonnull
    private JsonObject getPayload(String inputDatasetSmartName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("inputDatasetSmartName", inputDatasetSmartName);
        payload.addProperty("ragasMaxWorkers", (Number)this.ragasMaxWorkers);
        if (this.outputDatasetSmartName != null) {
            payload.addProperty("outputDatasetSmartName", this.outputDatasetSmartName);
        }
        if (this.metricsDatasetSmartName != null) {
            payload.addProperty("metricsDatasetSmartName", this.metricsDatasetSmartName);
        }
        if (this.modelEvaluationFolder != null) {
            payload.addProperty("modelEvaluationFolder", this.modelEvaluationFolder.getAbsolutePath());
        }
        return payload;
    }
}

