/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.requestcenter;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.DesignNodeCodeEnvsAccessService;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.TrialToken;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.requestcenter.RequestsInternalDB;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.PermissionsWatchersService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.AccessGrantedEvent;
import com.dataiku.dip.server.notifications.backend.AccessRequestEvent;
import com.dataiku.dip.server.notifications.backend.CodeEnvChangedEvent;
import com.dataiku.dip.server.notifications.backend.CodeEnvRequestEvent;
import com.dataiku.dip.server.notifications.backend.CodeEnvRequestGrantedEvent;
import com.dataiku.dip.server.notifications.backend.InstanceAccessGrantedEvent;
import com.dataiku.dip.server.notifications.backend.InstanceAccessRequestEvent;
import com.dataiku.dip.server.notifications.backend.PendingRequestsUpdatedEvent;
import com.dataiku.dip.server.notifications.backend.PluginChangedEvent;
import com.dataiku.dip.server.notifications.backend.PluginRequestEvent;
import com.dataiku.dip.server.notifications.backend.PluginRequestGrantedEvent;
import com.dataiku.dip.server.notifications.backend.ProfileUpgradeApprovedEvent;
import com.dataiku.dip.server.notifications.backend.ProfileUpgradeRequestEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.UserChangedEvent;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.server.services.licensing.TrialTokenAcquisitionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RequestsService {
    @Autowired
    private RequestsInternalDB requestsDB;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PluginStoreService pluginStoreService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private PermissionsWatchersService permissionsWatchersService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private DesignNodeCodeEnvsAccessService designNodeCodeEnvsAccessService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private static final String AUTOMATIC_APPROVAL_MESSAGE_FOR_PERMISSION_CHANGE = "Approved automatically: a permission update allowed this user to access this object";
    private static final String AUTOMATIC_APPROVAL_MESSAGE_FOR_APP_EXECUTE_ALL = "Approved automatically: application execution was allowed to all users";
    private static final String AUTOMATIC_APPROVAL_MESSAGE_FOR_PLUGIN = "Approved automatically: plugin was installed";
    private static final String AUTOMATIC_APPROVAL_MESSAGE_FOR_CODE_ENV = "Approved automatically: code env was created";
    private static final String AUTOMATIC_REJECTION_MESSAGE_FOR_OBJECT_DELETION = "Rejected automatically: source object was deleted";
    private static final String AUTOMATIC_REJECTION_MESSAGE_FOR_TARGET_PROJECT_DELETION = "Rejected automatically: target project was deleted";
    private static final String AUTOMATIC_REJECTION_MESSAGE_FOR_REQUESTS_FROM_DELETED_USERS = "Rejected automatically: requesting user was deleted";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.requests");

    public String createRequestId() {
        return SecretKeyGenerator.generate((int)8);
    }

    private void updatePendingRequestsForTargetUsers(Request request) {
        try {
            List<String> targetUsers = this.getRequestTargets_NT(request.requestType, request.objectType, request.objectProjectKey, true);
            targetUsers.forEach(usr -> this.pubSub.publish(new PendingRequestsUpdatedEvent((String)usr)));
        }
        catch (Exception e) {
            logger.info((Object)"Failed to update pending requests for users");
        }
    }

    @PostConstruct
    public void init() {
        this.pubSub.subscribe("project-permissions-changed", evt -> {
            try {
                this.handlePermissionChange(evt.diff);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close implicitly validated request", (Throwable)e);
            }
        });
        this.pubSub.subscribe("plugin-changed", evt -> {
            try {
                if (evt.action == PluginChangedEvent.ActionType.INSTALLED) {
                    this.approveRequestsForPlugin(evt.pluginId);
                } else if (evt.action == PluginChangedEvent.ActionType.DELETED) {
                    this.deleteRequestsForPlugins(evt.pluginId);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close implicitly the plugin request", (Throwable)e);
            }
        });
        this.pubSub.subscribe("code-env-changed", evt -> {
            try {
                if (evt.action == CodeEnvChangedEvent.ActionType.CREATED) {
                    this.approveRequestsForCodeEnv(evt.envName);
                } else if (evt.action == CodeEnvChangedEvent.ActionType.DELETED) {
                    this.deleteRequestsForCodeEnv(evt.envName);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close implicitly the code-env request", (Throwable)e);
            }
        });
        this.pubSub.subscribe("object-change", evt -> {
            if (evt.action.category == TaggableObjectChangedEvent.ActionCategory.DELETED) {
                try {
                    this.handleTaggableObjectDeletion(evt.objectType, evt.projectKey, evt.objectId);
                }
                catch (CodedSQLException e) {
                    logger.warn((Object)("Failed to close implicitly rejected object share request on deletion of source object " + evt.projectKey + "." + evt.objectId), (Throwable)e);
                }
            }
        });
        this.pubSub.subscribe("user-edited", evt -> {
            if (evt.action == UserChangedEvent.ActionType.DELETED) {
                try {
                    this.rejectRequestsFromUser_NT(evt.getUserLogin());
                }
                catch (CodedSQLException e) {
                    logger.warn((Object)("Failed to close implicitly rejected requests on deletion of user " + evt.getUserLogin()), (Throwable)e);
                }
            }
        });
    }

    public RequestsSearchResponse search(AuthCtx authCtx, Map<String, List<String>> facets, int offset, int limit) throws SQLException {
        RequestsSearchResponse response = new RequestsSearchResponse();
        RequestsAclContext aclContext = this.getRequestsACLContext_NT(authCtx);
        RequestsInternalDB.PreparedWhereConditions conditions = this.requestsDB.buildPreparedWhereConditions(aclContext, facets);
        response.results = this.requestsDB.getAllRequests(conditions, offset, limit);
        this.enrichRequests(response.results);
        response.aggregations = this.requestsDB.buildAggregation(facets, conditions);
        return response;
    }

    public Request getRequestOrNull(String requestId) throws CodedSQLException {
        Request requestOrNull = this.requestsDB.getRequestOrNull(requestId);
        if (requestOrNull != null) {
            this.enrichRequest(requestOrNull);
        }
        return requestOrNull;
    }

    public Request getLatestPendingRequestForRequestType(String user, Request.RequestType requestType, boolean mandatory) throws NotFoundException, CodedSQLException {
        return this.requestsDB.getLatestPendingRequestForRequestType(user, requestType, mandatory);
    }

    public Request getLatestProjectObjectRequestForUser(String user, String objectProjectKey, Request.RequestObjectType objectType, String objectId, boolean mandatory) throws CodedSQLException, NotFoundException {
        return this.requestsDB.getLatestProjectObjectRequestForUser(user, objectProjectKey, objectType, objectId, mandatory);
    }

    public Request getLatestObjectRequestForUser(String user, Request.RequestObjectType objectType, String objectId, boolean mandatory) throws CodedSQLException, NotFoundException {
        return this.requestsDB.getLatestObjectRequestForUser(user, objectType, objectId, mandatory);
    }

    public void approve(Request request, String closingUser, String closingMessage) throws SQLException {
        this.requestsDB.closeRequest(request.requestId, Request.RequestStatus.APPROVED, closingUser, closingMessage);
        this.updatePendingRequestsForTargetUsers(request);
    }

    public void reject(Request request, String closingUser, String closingMessage) throws SQLException {
        this.requestsDB.closeRequest(request.requestId, Request.RequestStatus.REJECTED, closingUser, closingMessage);
        this.updatePendingRequestsForTargetUsers(request);
    }

    public String create(String login, Request.RequestType requestType, Request.RequestObjectType objectType, Request.RequestDetails requestDetails, String requestMessage) throws CodedSQLException {
        return this.create(login, requestType, objectType, null, null, requestDetails, requestMessage);
    }

    public String create(String login, Request.RequestType requestType, Request.RequestObjectType objectType, String objectProjectKey, String objectId, Request.RequestDetails requestDetails, String requestMessage) throws CodedSQLException {
        Request request = new Request();
        request.requestId = this.createRequestId();
        request.requesterLogin = login;
        request.createdOn = System.currentTimeMillis();
        request.status = Request.RequestStatus.PENDING;
        request.requestMessage = requestMessage;
        request.objectType = objectType;
        request.objectProjectKey = objectProjectKey;
        request.objectId = objectId;
        request.requestDetails = requestDetails;
        request.requestType = requestType;
        this.requestsDB.createRequest(request);
        if (request.requestType.isSharingRequest() || request.requestType.isAccessRequest()) {
            this.pubSub.publish(new AccessRequestEvent(request));
        } else if (request.requestType.isPluginRequest()) {
            this.pubSub.publish(new PluginRequestEvent(request));
        } else if (request.requestType.isCodeEnvRequest()) {
            this.pubSub.publish(new CodeEnvRequestEvent(request));
        } else if (request.requestType.isInstanceAccessRequest()) {
            this.pubSub.publish(new InstanceAccessRequestEvent(request));
        } else if (request.requestType.isProfileUpgradeRequest()) {
            this.pubSub.publish(new ProfileUpgradeRequestEvent(request));
        } else {
            throw new NotImplementedException("create request of type : " + String.valueOf((Object)request.requestType));
        }
        this.updatePendingRequestsForTargetUsers(request);
        return request.requestId;
    }

    public List<String> getAdminUsers(List<UsersDAO.User> allUsers) throws IOException {
        Set adminGroups = this.usersService.listGroupsFull().stream().filter(UsersDAO.GroupPermissions::isAdmin).map(g -> g.name).collect(Collectors.toSet());
        List<String> adminUsers = allUsers.stream().filter(user -> user.groups.stream().anyMatch(adminGroups::contains)).map(user -> user.login).collect(Collectors.toList());
        return adminUsers;
    }

    public List<String> getRequestTargets_NT(Request.RequestType requestType, Request.RequestObjectType objectType, String objectProjectKey) throws IOException {
        return this.getRequestTargets_NT(requestType, objectType, objectProjectKey, false);
    }

    public List<String> getRequestTargets_NT(Request.RequestType requestType, Request.RequestObjectType objectType, String objectProjectKey, boolean includeAllAdmins) throws IOException {
        List<String> adminUsers;
        List<UsersDAO.User> allUsers;
        try (Transaction ignored = this.transactionService.beginRead();){
            allUsers = this.usersService.listUsersInternalEnabledOnly();
            adminUsers = this.getAdminUsers(allUsers);
        }
        if (requestType.isPluginRequest() || requestType.isCodeEnvRequest() || requestType.isInstanceAccessRequest() || requestType.isProfileUpgradeRequest()) {
            return adminUsers;
        }
        if (requestType.isAccessRequest() || requestType.isSharingRequest()) {
            SerializedProject project;
            ignored = this.transactionService.beginRead();
            try {
                project = this.projectsService.getMandatory(objectProjectKey);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            return this.getRequestTargets(project, allUsers, requestType, objectType.toTaggableType().get(), includeAllAdmins, adminUsers);
        }
        throw new NotImplementedException("cannot list users that will receive a notification for request of type : " + String.valueOf((Object)requestType));
    }

    @VisibleForTesting
    List<String> getRequestTargets(SerializedProject project, List<UsersDAO.User> allUsers, Request.RequestType requestType, ITaggingService.TaggableType objectType, boolean includeAllAdmins, List<String> adminUsers) {
        ArrayList authorizedGroups = new ArrayList();
        ArrayList<String> authorizedUsers = new ArrayList<String>();
        authorizedUsers.add(project.owner);
        project.permissions.stream().filter(permission -> this.hasCorrectPermission((SerializedProject.PermissionItem)permission, requestType, objectType)).forEach(permission -> {
            if (permission.group != null) {
                authorizedGroups.add(permission.group);
            } else if (permission.user != null) {
                authorizedUsers.add(permission.user);
            }
        });
        return allUsers.stream().filter(user -> {
            if (authorizedUsers.contains(user.login)) return true;
            if (user.groups.stream().anyMatch(authorizedGroups::contains)) return true;
            if (!includeAllAdmins) return false;
            if (!adminUsers.contains(user.login)) return false;
            return true;
        }).map(user -> user.login).collect(Collectors.toList());
    }

    private boolean hasCorrectPermission(SerializedProject.PermissionItem permission, Request.RequestType requestType, ITaggingService.TaggableType type) {
        if (permission == null) {
            return false;
        }
        if (ITaggingService.TaggableType.PROJECT.equals((Object)type)) {
            switch (requestType) {
                case PROJECT_READ: 
                case PROJECT_WRITE: {
                    return PermissionsService.permissionItemIncludes(permission, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS) && PermissionsService.permissionItemIncludes(permission, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                }
                case PROJECT_EXECUTE_APP: {
                    return PermissionsService.permissionItemIncludes(permission, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS) && PermissionsService.permissionItemIncludes(permission, Privileges.ProjectLevelPrivilegeType.EXECUTE_APP);
                }
            }
            return false;
        }
        return PermissionsService.permissionItemIncludes(permission, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
    }

    public boolean authorizedToReadRequest(AuthCtx authCtx, Request request) throws DKUSecurityException {
        boolean authorizedToRead = false;
        if (request == null) {
            return false;
        }
        if (request.objectProjectKey != null) {
            authorizedToRead = true;
            SerializedProject project = this.projectsService.getMandatoryUnsafe_RethrowException(request.objectProjectKey);
            for (Privileges.ProjectLevelPrivilegeType requiredPrivilege : request.requestType.getProjectLevelRequiredRights()) {
                authorizedToRead &= this.permissionsService.hasProjectPrivilege(authCtx, project, requiredPrivilege);
            }
        } else if (request.requestType.isPluginRequest() || request.requestType.isCodeEnvRequest() || request.requestType.isInstanceAccessRequest() || request.requestType.isProfileUpgradeRequest()) {
            authorizedToRead = authCtx.isAdmin();
        }
        return authorizedToRead;
    }

    public void checkRequestUnanswered(Request request) {
        if (!Request.RequestStatus.PENDING.equals((Object)request.status)) {
            throw new IllegalArgumentException("Request has already been answered");
        }
    }

    public void checkResponseAllowed(AuthCtx authCtx, Request request, RequestResponse response) throws IOException, DKUSecurityException {
        if (response instanceof ProjectAccessRequestResponse) {
            ProjectAccessRequestResponse projectAccessResponse = (ProjectAccessRequestResponse)response;
            SerializedProject sp = this.projectsService.getMandatoryUnsafe_RethrowException(request.objectProjectKey);
            if (Request.RequestType.PROJECT_READ.equals((Object)projectAccessResponse.selectedPermission) && !this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                throw new UnauthorizedException("You do not have read permission on this project, cannot grant it to another user", "project-access-request-approval-denied");
            }
            if (Request.RequestType.PROJECT_WRITE.equals((Object)projectAccessResponse.selectedPermission) && !this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                throw new UnauthorizedException("You do not have write permission on this project, cannot grant it to another user", "project-access-request-approval-denied");
            }
        }
    }

    public void checkRequestEnabledForType(String login, String objectId, String objectProjectKey, Request.RequestType permissionType) throws IOException {
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        switch (permissionType) {
            case PROJECT_READ: 
            case PROJECT_WRITE: {
                SerializedProject sp = this.projectsService.getOrNullUnsafe(objectProjectKey);
                if (sp != null && this.projectsService.isAccessRequestsEnabled(sp, generalSettings)) break;
                throw new IllegalArgumentException("Failed to create access request for project " + objectProjectKey + ", project doesn't exist or project access requests are disabled");
            }
            case PROJECT_EXECUTE_APP: {
                AppManifest manifest = this.appsService.getAppTemplateManifestOrNullForProject_T(objectProjectKey);
                if (manifest != null && this.appsService.isAccessRequestsEnabled(manifest, generalSettings)) break;
                throw new IllegalArgumentException("Failed to create access request for application " + objectId + ", application doesn't exist or access requests are disabled");
            }
            case OBJECT_SHARE: {
                SerializedProject sp = this.projectsService.getOrNullUnsafe(objectProjectKey);
                if (sp != null && ProjectsService.isObjectSharingRequestEnabled(sp, generalSettings)) break;
                throw new IllegalArgumentException("Failed to create sharing request for object " + objectId + ", project " + objectProjectKey + " doesn't exist or object sharing requests are disabled");
            }
            case INSTALL_PLUGIN: 
            case UPDATE_PLUGIN: {
                if (!generalSettings.pluginInstallRequestsEnabled) {
                    throw new IllegalArgumentException("Failed to create plugin request for object " + objectId + ", plugin requests are disabled");
                }
                if (this.pluginStoreService.exists(objectId)) break;
                throw new IllegalArgumentException("Failed to create plugin request for object " + objectId + ", plugin " + objectId + " doesn't exist in store");
            }
            case INSTALL_CODE_ENV: {
                if (generalSettings.codeEnvInstallRequestsEnabled) break;
                throw new IllegalArgumentException("Failed to create code env request for object " + objectId + ", code env requests are disabled");
            }
            case INSTANCE_ACCESS: {
                boolean trialExpiredOrValid;
                UsersDAO.User user = this.usersDAO.getMandatory(login);
                Pair<LicenseEnforcementService.TrialTokenStatus, String> trialStatusAndResultingProfile = UsersService.computeTrialStatusAndResultingUserProfile(generalSettings, user);
                LicenseEnforcementService.TrialTokenStatus status = (LicenseEnforcementService.TrialTokenStatus)trialStatusAndResultingProfile.first;
                String resultingProfile = this.licenseEnforcementService.getUserProfileByNameOrFallback((String)((String)trialStatusAndResultingProfile.second)).profile;
                boolean bl = trialExpiredOrValid = status.expired || status.valid;
                if (!"NONE".equals(resultingProfile) && !trialExpiredOrValid) {
                    throw new IllegalArgumentException("Failed to create instance access request: you are not allowed to request access");
                }
                if (generalSettings.licensingSettings.noneUsersCallToActionBehavior == GeneralSettingsDAO.NoneUsersCallToActionBehavior.ALLOW_REQUEST_ACCESS || generalSettings.licensingSettings.noneUsersCallToActionBehavior == GeneralSettingsDAO.NoneUsersCallToActionBehavior.ALLOW_START_TRIAL && trialExpiredOrValid && generalSettings.licensingSettings.allowRequestAccessWithStartedTrial) break;
                throw new IllegalArgumentException("Failed to create instance access request: you are not allowed to request access");
            }
            case PROFILE_UPGRADE: {
                UsersDAO.User user = this.usersDAO.getMandatory(login);
                if (generalSettings.licensingSettings == null || !generalSettings.licensingSettings.allowProfileUpgradeRequests) {
                    throw new IllegalArgumentException("Failed to create profile upgrade request: profile upgrade requests are disabled ");
                }
                Pair<LicenseEnforcementService.TrialTokenStatus, String> trialStatusAndResultingProfile = UsersService.computeTrialStatusAndResultingUserProfile(generalSettings, user);
                if (!((LicenseEnforcementService.TrialTokenStatus)trialStatusAndResultingProfile.first).valid) break;
                throw new IllegalArgumentException("Failed to create profile upgrade request: you are currently in trial and cannot request an upgrade");
            }
            default: {
                throw new NotImplementedException("Unhandled request permission type " + String.valueOf((Object)permissionType));
            }
        }
    }

    public void checkUserHasNoPendingRequestForType(String user, Request.RequestType requestType) throws NotFoundException, CodedSQLException {
        Request latestRequest = this.getLatestPendingRequestForRequestType(user, requestType, false);
        if (latestRequest != null) {
            throw new IllegalArgumentException("You already have a pending " + requestType.toHumanReadableString() + " request.");
        }
    }

    public void checkUserHasNoRequestOnObjectWithStatus(String user, Request.RequestObjectType objectType, Request.RequestType requestType, String objectId, String objectProjectKey, Request.RequestStatus status) throws NotFoundException, CodedSQLException {
        if (requestType.isAccessRequest()) {
            Request latestRequest = this.getLatestProjectObjectRequestForUser(user, objectProjectKey, objectType, objectId, false);
            if (latestRequest != null && status.equals((Object)latestRequest.status)) {
                switch (status) {
                    case PENDING: {
                        throw new IllegalArgumentException("There is already a pending access request for " + objectId + " in project " + objectProjectKey);
                    }
                    case APPROVED: {
                        throw new IllegalArgumentException("Access to " + objectId + " in project " + objectProjectKey + " has already been granted");
                    }
                    case REJECTED: {
                        throw new IllegalArgumentException("Access request to " + objectId + " in project " + objectProjectKey + " has already been rejected");
                    }
                }
            }
        } else if (requestType.isPluginRequest()) {
            Request latestRequest = this.getLatestObjectRequestForUser(user, objectType, objectId, false);
            if (latestRequest != null && status.equals((Object)latestRequest.status)) {
                switch (status) {
                    case PENDING: {
                        throw new IllegalArgumentException("There is already a pending request for plugin " + objectId);
                    }
                    case APPROVED: {
                        throw new IllegalArgumentException("The plugin " + objectId + " is already available");
                    }
                    case REJECTED: {
                        throw new IllegalArgumentException("The request for plugin " + objectId + " has already been rejected");
                    }
                }
            }
        } else if (requestType.isCodeEnvRequest()) {
            Request latestRequest = this.getLatestObjectRequestForUser(user, objectType, objectId, false);
            if (latestRequest != null && status.equals((Object)latestRequest.status)) {
                switch (status) {
                    case PENDING: {
                        throw new IllegalArgumentException("There is already a pending request for code env with name " + objectId);
                    }
                    case APPROVED: {
                        throw new IllegalArgumentException("The code env with name " + objectId + " is already available");
                    }
                    case REJECTED: {
                        throw new IllegalArgumentException("The request for the code env with name " + objectId + " has already been rejected");
                    }
                }
            }
        } else if (requestType.isInstanceAccessRequest()) {
            Request latestRequest = this.getLatestObjectRequestForUser(user, objectType, objectId, false);
            if (latestRequest != null && status.equals((Object)latestRequest.status)) {
                switch (status) {
                    case PENDING: {
                        throw new IllegalArgumentException("There is already a pending access request");
                    }
                    case APPROVED: {
                        throw new IllegalArgumentException("An access request was already sent and approved");
                    }
                    case REJECTED: {
                        throw new IllegalArgumentException("An access request was already sent");
                    }
                }
            }
        } else if (requestType.isProfileUpgradeRequest()) {
            Request latestRequest = this.getLatestObjectRequestForUser(user, objectType, objectId, false);
            if (latestRequest != null && status.equals((Object)latestRequest.status)) {
                switch (status) {
                    case PENDING: {
                        throw new IllegalArgumentException("There is already a pending upgrade request");
                    }
                    case APPROVED: {
                        throw new IllegalArgumentException("An upgrade request was already sent and approved");
                    }
                    case REJECTED: {
                        throw new IllegalArgumentException("An upgrade request was already sent");
                    }
                }
            }
        } else {
            throw new NotImplementedException("Cannot check user permission for type : " + String.valueOf((Object)requestType));
        }
    }

    public void performChangesForApprovedRequest_NT(AuthCtx authCtx, Request request, RequestResponse requestResponse) throws LimitsStatusComputer.LicenseLimitException, IOException, CodedException, CodedSQLException {
        TransactionContext.assertNoAttachedTransaction();
        switch (request.requestType) {
            case PROJECT_READ: 
            case PROJECT_WRITE: 
            case PROJECT_EXECUTE_APP: {
                this.grantProjectAccess_NT(authCtx, request, requestResponse);
                break;
            }
            case OBJECT_SHARE: {
                this.shareObjectToTargetProject_NT(authCtx, request);
                break;
            }
            case INSTANCE_ACCESS: {
                this.grantInstanceAccess_NT(authCtx, request, requestResponse);
                break;
            }
            case INSTALL_CODE_ENV: {
                this.processCodeEnvRequest(request, requestResponse);
                break;
            }
            case PROFILE_UPGRADE: {
                this.upgradeUserProfile_NT(authCtx, request, requestResponse);
                break;
            }
            default: {
                throw new NotImplementedException("Unsupported permission type: " + String.valueOf((Object)request.requestType));
            }
        }
    }

    protected void upgradeUserProfile_NT(AuthCtx authCtx, Request request, RequestResponse requestResponse) throws IOException, CodedException {
        UserDiff userDiff;
        String userLogin;
        String selectedUserProfile;
        if (requestResponse instanceof ProfileUpgradeResponse) {
            selectedUserProfile = ((ProfileUpgradeResponse)requestResponse).selectedUserProfile;
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                UsersDAO.User user = this.usersDAO.getMandatory(request.requesterLogin);
                userLogin = user.login;
                user.userProfile = selectedUserProfile;
                user.trialToken = null;
                userDiff = this.usersService.saveUser(user, false, UsersService.UserSaveContext.buildDefaultWithoutPassword(), authCtx);
                t.commit(String.format("Approved %s request for %s %s with profile %s", new Object[]{request.requestType.toHumanReadableString(), request.objectType, request.objectId, selectedUserProfile}));
            }
        } else {
            throw new IllegalArgumentException("Cannot approve profile upgrade request, invalid request response");
        }
        this.auditTrailService.generic("request-center-upgrade-user-profile").with("login", userLogin).withAll(userDiff.getDiff()).emit();
        this.pubSub.publish(new ProfileUpgradeApprovedEvent(request, selectedUserProfile));
    }

    private void grantProjectAccess_NT(AuthCtx authCtx, Request request, RequestResponse requestResponse) throws LimitsStatusComputer.LicenseLimitException, IOException, CodedException {
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (!(requestResponse instanceof ProjectAccessRequestResponse)) {
                throw new IllegalArgumentException("Cannot approve access request, invalid request response");
            }
            PermissionsWatcher pw = this.permissionsWatchersService.startProjectWatch(request.objectProjectKey);
            this.addProjectPermissionForUserOrGroup(request.objectProjectKey, (ProjectAccessRequestResponse)requestResponse);
            pw.stop();
            t.commit(String.format("Approved %s request for %s %s", new Object[]{request.requestType.toHumanReadableString(), request.objectType, request.objectId}));
        }
        this.pubSub.publish(new AccessGrantedEvent(request));
    }

    public void processCodeEnvRequest(Request request, RequestResponse requestResponse) throws IOException, CodedSQLException {
        Request.CodeEnvRequestDetails details = (Request.CodeEnvRequestDetails)request.requestDetails;
        CodeEnvRequestResponse response = (CodeEnvRequestResponse)requestResponse;
        try {
            this.designNodeCodeEnvsAccessService.checkDesignEnvExists(details.envLang, response.targetName);
        }
        catch (CodedIOException e) {
            throw new IllegalArgumentException("Code env " + response.targetName + " does not exist for " + details.envLang.getLanguageInfo() + " language. Plugin environments cannot be used.");
        }
        this.performChangesForCodeEnvApprovedRequest(request, response.targetName);
    }

    private void performChangesForCodeEnvApprovedRequest(Request request, String targetName) throws CodedSQLException {
        Request.CodeEnvRequestDetails codeEnvRequestDetails = (Request.CodeEnvRequestDetails)request.requestDetails;
        if (codeEnvRequestDetails.source != Request.CodeEnvRequestDetails.CodeEnvRequestSource.MANUAL) {
            throw new IllegalArgumentException("The request cannot be validated manually");
        }
        codeEnvRequestDetails.targetName = targetName;
        this.requestsDB.updateCodeEnvTargetName(request.requestId, targetName);
        this.pubSub.publish(new CodeEnvRequestGrantedEvent(request));
    }

    private void shareObjectToTargetProject_NT(AuthCtx authCtx, Request request) throws LimitsStatusComputer.LicenseLimitException, IOException, CodedException {
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (!request.requestType.isSharingRequest()) {
                throw new IllegalArgumentException("Failed to approve sharing request, invalid request details");
            }
            this.exposedObjectsService.addExposedObject(request.objectProjectKey, request.objectType.toTaggableType().get(), request.objectId, ((Request.ObjectSharingRequestDetails)request.requestDetails).sharingTargetProject);
            t.commit(String.format("Approved %s request for %s %s", new Object[]{request.requestType.toHumanReadableString(), request.objectType, request.objectId}));
        }
        this.pubSub.publish(new AccessGrantedEvent(request));
    }

    protected void grantInstanceAccess_NT(AuthCtx authCtx, Request request, RequestResponse requestResponse) throws IOException, CodedException {
        if (requestResponse instanceof InstanceAccessResponse) {
            LicenseStatusService.LicensingStatus licensingStatus;
            GeneralSettingsDAO.GeneralSettings generalSettings;
            UsersDAO.User user;
            InstanceAccessResponse instanceAccessResponse = (InstanceAccessResponse)requestResponse;
            try (Transaction ignored = this.transactionService.beginRead();){
                user = this.usersDAO.getMandatory(request.requesterLogin);
                generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
                licensingStatus = this.licenseService.getLicensingStatus();
            }
            if (instanceAccessResponse.selectedProfileType == SelectedProfileType.TRIAL) {
                if (!"NONE".equals(user.userProfile)) {
                    throw new IllegalArgumentException("User profile doesn't allow to start a trial");
                }
                this.generalSettingsService.checkTrialsEnabled(generalSettings, licensingStatus);
                logger.info((Object)("Attempting to acquire a trial token for user " + user.login + " with profile " + instanceAccessResponse.selectedUserProfile));
                TrialTokenAcquisitionService acquisitionService = (TrialTokenAcquisitionService)SpringUtils.getBean(TrialTokenAcquisitionService.class);
                user.userProfile = instanceAccessResponse.selectedUserProfile;
                TrialToken token = acquisitionService.fetchForUser(user);
                logger.info((Object)"Successfully acquired trial token");
                this.saveUserProfileAndTrialToken_NT(authCtx, user, instanceAccessResponse, token, true);
            } else if (instanceAccessResponse.selectedProfileType == SelectedProfileType.REGULAR) {
                if (!"NONE".equals(user.userProfile) && user.trialToken == null) {
                    throw new IllegalArgumentException("User profile doesn't allow converting to regular user");
                }
                this.saveUserProfileAndTrialToken_NT(authCtx, user, instanceAccessResponse, null, false);
            }
            this.pubSub.publish(new InstanceAccessGrantedEvent(request));
            this.usersService.sendWelcomeEmail(user);
            return;
        }
        throw new IllegalArgumentException("Cannot approve access request, invalid request response");
    }

    private void saveUserProfileAndTrialToken_NT(AuthCtx authCtx, UsersDAO.User user, InstanceAccessResponse instanceAccessResponse, TrialToken token, boolean reAcquireUser) throws IOException, CodedException {
        UserDiff userDiff;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (reAcquireUser) {
                user = this.usersDAO.getMandatory(user.login);
            }
            PermissionsWatcher pw = this.permissionsWatchersService.startUserWatch(user.login);
            user.userProfile = instanceAccessResponse.selectedUserProfile;
            user.trialToken = token;
            userDiff = this.usersService.saveUser(user, false, UsersService.UserSaveContext.buildDefaultWithoutPassword(), authCtx);
            pw.stop();
            t.commit(String.format("Approved %s request for user %s", Request.RequestType.INSTANCE_ACCESS.toHumanReadableString(), user.login));
        }
        this.auditTrailService.generic("request-center-save-user-profile-and-trial-token").with("login", user.login).withAll(userDiff.getDiff()).emit();
    }

    @VisibleForTesting
    public SerializedProject.PermissionItem buildPermissionItem(UserGroupItem userOrGroup, Request.RequestType permission) {
        if (permission == null) {
            throw new IllegalArgumentException("Permission level is not specified");
        }
        if (userOrGroup == null) {
            throw new IllegalArgumentException("User or group not specified");
        }
        if (userOrGroup.type == null) {
            throw new IllegalArgumentException("Invalid userOrGroup object: user type not specified (must be USER or GROUP)");
        }
        if (StringUtils.isBlank((String)userOrGroup.name)) {
            throw new IllegalArgumentException(String.format("Invalid userOrGroup object: %s name not specified", userOrGroup.type.toString().toLowerCase()));
        }
        SerializedProject.PermissionItem permissionItem = new SerializedProject.PermissionItem();
        switch (userOrGroup.type) {
            case GROUP: {
                permissionItem.group = userOrGroup.name;
                break;
            }
            case USER: {
                permissionItem.user = userOrGroup.name;
                break;
            }
            default: {
                throw new NotImplementedException("Wrong type for user type: " + String.valueOf((Object)userOrGroup.type));
            }
        }
        switch (permission) {
            case PROJECT_WRITE: {
                permissionItem.writeProjectContent = true;
                break;
            }
            case PROJECT_READ: {
                permissionItem.readProjectContent = true;
                break;
            }
            case PROJECT_EXECUTE_APP: {
                permissionItem.executeApp = true;
                break;
            }
            default: {
                throw new NotImplementedException("Cannot add permission: " + String.valueOf((Object)permission) + "for user");
            }
        }
        return permissionItem;
    }

    @VisibleForTesting
    public void addProjectPermissionForUserOrGroup(String projectKey, ProjectAccessRequestResponse requestResponse) throws LimitsStatusComputer.LicenseLimitException, IOException, CodedException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        SerializedProject.PermissionItem permissionItem = this.buildPermissionItem(requestResponse.selectedUserOrGroup, requestResponse.selectedPermission);
        boolean alreadyExists = false;
        for (SerializedProject.PermissionItem perm : sp.permissions) {
            boolean userHasPermissionItem;
            if (perm == null) continue;
            boolean groupHasPermissionItem = permissionItem.group != null && permissionItem.group.equals(perm.group);
            boolean bl = userHasPermissionItem = permissionItem.user != null && permissionItem.user.equals(perm.user);
            if (!userHasPermissionItem && !groupHasPermissionItem) continue;
            perm.addPermissionsFrom(permissionItem);
            alreadyExists = true;
            break;
        }
        if (!alreadyExists) {
            sp.permissions.add(permissionItem);
        }
        this.projectsService.setPermissions(sp);
    }

    private void enrichRequests(List<Request> requests) {
        for (Request request : requests) {
            this.enrichRequest(request);
        }
    }

    private void enrichRequest(Request request) {
        if (request != null && request.objectType != null && request.objectType.needsNameEnrichment()) {
            try (Transaction ignored = this.transactionService.beginRead();){
                Optional<ITaggingService.TaggableType> taggableType = request.objectType.toTaggableType();
                if (taggableType.isPresent()) {
                    TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getOrNullUnsafe(request.objectProjectKey, taggableType.get(), request.objectId);
                    if (to != null) {
                        request.objectDisplayName = to.getDisplayName();
                        if (to.getTaggableType().equals((Object)ITaggingService.TaggableType.SAVED_MODEL)) {
                            request.savedModelMLCategory = ((SavedModel)to).getMLCategory();
                        }
                    }
                } else if (request.objectType == Request.RequestObjectType.PLUGIN) {
                    this.pluginStoreService.getStorePluginDesc(request.objectId).ifPresent(plugin -> {
                        request.objectDisplayName = plugin.meta.label;
                    });
                } else if (request.objectType == Request.RequestObjectType.CODE_ENV) {
                    Request.CodeEnvRequestDetails codeEnvRequestDetails = (Request.CodeEnvRequestDetails)request.requestDetails;
                    request.objectDisplayName = codeEnvRequestDetails.isManual() ? codeEnvRequestDetails.targetName : request.objectId;
                }
            }
            catch (IOException e) {
                logger.info((Object)("Couldn't enrich request for object " + request.objectId), (Throwable)e);
            }
        }
    }

    protected RequestsAclContext getRequestsACLContext_NT(AuthCtx authCtx) throws SQLException {
        RequestsAclContext res = new RequestsAclContext();
        List<String> allRequestsProjects = this.requestsDB.getAllRequestsProjects();
        if (authCtx.isAdmin()) {
            res.projectsWithAdminRights.addAll(allRequestsProjects);
            res.includeGlobalObjects = true;
        } else {
            for (String projectKey : allRequestsProjects) {
                if (projectKey == null) continue;
                try {
                    Transaction ignored = this.transactionService.beginRead();
                    try {
                        SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
                        if (this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.ADMIN)) {
                            res.projectsWithAdminRights.add(projectKey);
                            continue;
                        }
                        if (this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS)) {
                            if (this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                                res.projectsWithEditPermissionsAndRead.add(projectKey);
                            } else if (this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.EXECUTE_APP)) {
                                res.projectsWithEditPermissionsAndExecuteApp.add(projectKey);
                            }
                        }
                        if (!this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS)) continue;
                        res.projectsWithManageExposedElements.add(projectKey);
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to read project permissions", (Throwable)e);
                }
            }
            res.includeGlobalObjects = false;
        }
        return res;
    }

    private void handlePermissionChange(PermissionsWatcher.ProjectsPermissionChanges diff) throws Exception {
        HashMap<String, Optional> appsIdCache = new HashMap<String, Optional>();
        ArrayList<AutomaticallyClosedRequestInfo> changes = new ArrayList<AutomaticallyClosedRequestInfo>();
        for (PermissionsWatcher.ProjectPermissionChange change : diff.changes) {
            if (change.after == null || change.after.equals(change.before)) continue;
            if (PermissionsService.permissionChangeAddsGrant(change, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS)) {
                changes.add(new AutomaticallyClosedRequestInfo(Request.RequestType.PROJECT_READ, Request.RequestObjectType.PROJECT, change.projectKey, change.projectKey, change.user));
            }
            if (!PermissionsService.permissionChangeAddsGrant(change, Privileges.ProjectLevelPrivilegeType.EXECUTE_APP)) continue;
            Optional appIdOpt = appsIdCache.computeIfAbsent(change.projectKey, key -> {
                AppManifest manifest = null;
                try (Transaction t = this.transactionService.beginRead();){
                    manifest = this.appsService.getAppTemplateManifestOrNullForProject_T(change.projectKey);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to read app manifest", (Throwable)e);
                }
                return manifest == null ? Optional.empty() : Optional.of(manifest.id);
            });
            appIdOpt.ifPresent(appId -> changes.add(new AutomaticallyClosedRequestInfo(Request.RequestType.PROJECT_EXECUTE_APP, Request.RequestObjectType.APP, change.projectKey, (String)appId, change.user)));
        }
        if (!changes.isEmpty()) {
            logger.info((Object)("Closing access requests implicitly validated by permission change: " + JSON.log(changes)));
            List<Request> requestsToClose = this.requestsDB.getPendingRequestsForPermissionChange(changes);
            this.closeImplicitlyAnsweredRequestsAndEmitAudit(requestsToClose, Request.RequestStatus.APPROVED, AUTOMATIC_APPROVAL_MESSAGE_FOR_PERMISSION_CHANGE);
        }
    }

    private void handleTaggableObjectDeletion(ITaggingService.TaggableType objectType, String projectKey, String objectId) throws SQLException {
        if (Request.RequestObjectType.supportsShareRequest(objectType)) {
            List<Request> requestsToClose = this.requestsDB.getPendingRequestsForProjectObject(Request.RequestType.OBJECT_SHARE, Request.RequestObjectType.fromTaggableType(objectType), projectKey, objectId);
            this.closeImplicitlyAnsweredRequestsAndEmitAudit(requestsToClose, Request.RequestStatus.REJECTED, AUTOMATIC_REJECTION_MESSAGE_FOR_OBJECT_DELETION);
            logger.info((Object)("Closed " + requestsToClose.size() + " requests for object " + projectKey + "." + objectId));
        }
    }

    public void approveRequestsForApplication_NT(String projectKey, String appId) throws SQLException {
        List<Request> requestsToClose = this.requestsDB.getPendingRequestsForProjectObject(Request.RequestType.PROJECT_EXECUTE_APP, Request.RequestObjectType.APP, projectKey, appId);
        this.closeImplicitlyAnsweredRequestsAndEmitAudit(requestsToClose, Request.RequestStatus.APPROVED, AUTOMATIC_APPROVAL_MESSAGE_FOR_APP_EXECUTE_ALL);
        logger.info((Object)("Closed " + requestsToClose.size() + " requests for application " + appId));
    }

    public void approveRequestsForPlugin(String pluginId) throws SQLException {
        List<Request> requestsToClose = this.requestsDB.getPendingRequestsForObject(Request.RequestObjectType.PLUGIN, pluginId);
        this.closeImplicitlyAnsweredRequestsAndEmitAudit(requestsToClose, Request.RequestStatus.APPROVED, AUTOMATIC_APPROVAL_MESSAGE_FOR_PLUGIN);
        logger.info((Object)("Closed " + requestsToClose.size() + " requests for plugin " + pluginId));
        requestsToClose.forEach(req -> this.pubSub.publish(new PluginRequestGrantedEvent((Request)req)));
    }

    public void approveRequestsForCodeEnv(String envName) throws SQLException {
        List<Request> requestsToClose = this.filterOutManualCodeEnvRequests(this.requestsDB.getPendingRequestsForObject(Request.RequestObjectType.CODE_ENV, envName));
        this.closeImplicitlyAnsweredRequestsAndEmitAudit(requestsToClose, Request.RequestStatus.APPROVED, AUTOMATIC_APPROVAL_MESSAGE_FOR_CODE_ENV);
        logger.info((Object)("Closed " + requestsToClose.size() + " requests for code env " + envName));
        requestsToClose.forEach(req -> this.pubSub.publish(new CodeEnvRequestGrantedEvent((Request)req)));
    }

    private List<Request> filterOutManualCodeEnvRequests(List<Request> requests) {
        return requests.stream().filter(request -> !((Request.CodeEnvRequestDetails)request.requestDetails).isManual()).collect(Collectors.toList());
    }

    public void rejectRequestsForTargetProject_NT(String targetProjectKey) throws SQLException {
        List<Request> requestsToClose = this.requestsDB.getPendingShareRequestsForTargetProject(targetProjectKey);
        this.closeImplicitlyAnsweredRequestsAndEmitAudit(requestsToClose, Request.RequestStatus.REJECTED, AUTOMATIC_REJECTION_MESSAGE_FOR_TARGET_PROJECT_DELETION);
        logger.info((Object)("Closed " + requestsToClose.size() + " share requests targeting project " + targetProjectKey));
    }

    public void rejectRequestsFromUser_NT(String login) throws SQLException {
        List<Request> requestsToClose = this.requestsDB.getPendingRequestsFromUser(login);
        this.closeImplicitlyAnsweredRequestsAndEmitAudit(requestsToClose, Request.RequestStatus.REJECTED, AUTOMATIC_REJECTION_MESSAGE_FOR_REQUESTS_FROM_DELETED_USERS);
        logger.info((Object)("Closed " + requestsToClose.size() + " requests from user " + login));
    }

    public void deleteRequestsForProject(String projectKey) throws CodedSQLException {
        List<Request> requestsToClose = this.requestsDB.getRequestsForProject(projectKey);
        for (Request request : requestsToClose) {
            this.auditTrailService.generic("requests-center-request-delete").with("requestId", request.requestId).with("requesterLogin", request.requesterLogin).with("requestType", request.requestType.toString()).with("objectProjectKey", request.objectProjectKey).with("objectType", request.objectType.toString()).with("objectId", request.objectId).emit();
        }
        this.requestsDB.deleteRequestsForProject(projectKey);
    }

    public void deleteRequestsForPlugins(String pluginId) throws CodedSQLException {
        List<Request> requestsToClose = this.requestsDB.getRequestsForPlugin(pluginId);
        this.requestsDB.deleteRequestsForPlugin(pluginId);
        for (Request request : requestsToClose) {
            this.auditTrailService.generic("requests-center-request-delete").with("requestId", request.requestId).with("requesterLogin", request.requesterLogin).with("requestType", request.requestType.toString()).with("objectType", request.objectType.toString()).with("objectId", request.objectId).emit();
        }
    }

    public void deleteRequestsForCodeEnv(String envName) throws CodedSQLException {
        List<Request> requestsToClose = this.filterOutManualCodeEnvRequests(this.requestsDB.getRequestsForCodeEnv(envName));
        this.requestsDB.deleteRequestsForCodeEnv(requestsToClose);
        for (Request request : requestsToClose) {
            this.auditTrailService.generic("requests-center-request-delete").with("requestId", request.requestId).with("requesterLogin", request.requesterLogin).with("requestType", request.requestType.toString()).with("objectType", request.objectType.toString()).with("objectId", request.objectId).emit();
        }
    }

    private void closeImplicitlyAnsweredRequestsAndEmitAudit(List<Request> requestsToClose, Request.RequestStatus requestStatus, String closingMessage) throws SQLException {
        this.requestsDB.closeImplicitlyAnsweredRequests(requestsToClose, requestStatus, closingMessage);
        for (Request request : requestsToClose) {
            this.auditTrailService.generic(this.getAuditMessageForStatus(requestStatus)).with("requestId", request.requestId).with("requesterLogin", request.requesterLogin).with("requestType", request.requestType.toString()).with("objectProjectKey", request.objectProjectKey).with("objectType", request.objectType.toString()).with("objectId", request.objectId).with("closingMessage", closingMessage).emit();
        }
    }

    private String getAuditMessageForStatus(Request.RequestStatus requestStatus) {
        switch (requestStatus) {
            case APPROVED: {
                return "requests-center-request-approve";
            }
            case REJECTED: {
                return "requests-center-request-reject";
            }
        }
        throw new IllegalArgumentException("Unexpected status " + String.valueOf((Object)requestStatus));
    }

    public static class RequestsSearchResponse {
        public List<Request> results = new ArrayList<Request>();
        public Map<String, List<JsonObject>> aggregations = new HashMap<String, List<JsonObject>>();
    }

    public static class RequestsAclContext {
        List<String> projectsWithAdminRights = new ArrayList<String>();
        List<String> projectsWithEditPermissionsAndRead = new ArrayList<String>();
        List<String> projectsWithEditPermissionsAndExecuteApp = new ArrayList<String>();
        List<String> projectsWithManageExposedElements = new ArrayList<String>();
        boolean includeGlobalObjects;
    }

    public static class ProjectAccessRequestResponse
    extends RequestResponse {
        public static final String TYPE = "ProjectAccessResponse";
        public Request.RequestType selectedPermission;
        public UserGroupItem selectedUserOrGroup;
    }

    @PolyJSON(value={@Mapping(value=EmptyRequestResponse.class, type="EmptyResponse"), @Mapping(value=SharingObjectRequestResponse.class, type="SharingObjectResponse"), @Mapping(value=ProjectAccessRequestResponse.class, type="ProjectAccessResponse"), @Mapping(value=PluginRequestResponse.class, type="PluginResponse"), @Mapping(value=InstanceAccessResponse.class, type="InstanceAccessResponse"), @Mapping(value=CodeEnvRequestResponse.class, type="CodeEnvResponse"), @Mapping(value=ProfileUpgradeResponse.class, type="ProfileUpgradeResponse")})
    public static abstract class RequestResponse {
    }

    public static class ProfileUpgradeResponse
    extends RequestResponse {
        public static final String TYPE = "ProfileUpgradeResponse";
        public String selectedUserProfile;
    }

    public static class CodeEnvRequestResponse
    extends RequestResponse {
        public static final String TYPE = "CodeEnvResponse";
        public Request.RequestType requestType;
        public String targetName;
    }

    public static class InstanceAccessResponse
    extends RequestResponse {
        public static final String TYPE = "InstanceAccessResponse";
        public String selectedUserProfile;
        public SelectedProfileType selectedProfileType;
    }

    public static enum SelectedProfileType {
        REGULAR,
        TRIAL;

    }

    public static class UserGroupItem {
        public String name;
        public UserType type;

        public UserGroupItem(String name, UserType type) {
            this.name = name;
            this.type = type;
        }
    }

    public static enum UserType {
        USER,
        GROUP;

    }

    public static class AutomaticallyClosedRequestInfo {
        public final Request.RequestType permissionType;
        public final Request.RequestObjectType objectType;
        public final String objectProjectKey;
        public final String objectId;
        public final String userLogin;

        public AutomaticallyClosedRequestInfo(Request.RequestType permissionType, Request.RequestObjectType objectType, String objectProjectKey, String objectId, String userLogin) {
            this.permissionType = permissionType;
            this.objectType = objectType;
            this.objectProjectKey = objectProjectKey;
            this.objectId = objectId;
            this.userLogin = userLogin;
        }
    }

    public static class PluginRequestResponse
    extends RequestResponse {
        public static final String TYPE = "PluginResponse";
        public Request.RequestType requestType;
    }

    public static class SharingObjectRequestResponse
    extends RequestResponse {
        public static final String TYPE = "SharingObjectResponse";
    }

    public static class EmptyRequestResponse
    extends RequestResponse {
        public static final String TYPE = "EmptyResponse";
    }
}

