/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.html.HtmlEscapers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class ProjectLogsDetector
implements SanityCheckDetectorBase {
    private final int maxJobs = DKUApp.getParams().getIntParam("dku.sanitycheck.projects.jobLogsMaxFiles", Integer.valueOf(1000));
    private final int maxScenarioLogsFiles = DKUApp.getParams().getIntParam("dku.sanitycheck.projects.scenarioLogsMaxFiles", Integer.valueOf(1000));
    private final int maxStreamingLogsFiles = DKUApp.getParams().getIntParam("dku.sanitycheck.projects.streamingLogsMaxFiles", Integer.valueOf(1000));
    private final long maxAgeInMillis = (long)(DKUApp.getParams().getIntParam("dku.sanitycheck.projects.maxAgeInDays", Integer.valueOf(60)) * 24 * 60 * 60) * 1000L;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.jobhistorydetector");

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        File projectFolder;
        Iterator iterator;
        ArrayList<String> foundProjects;
        Stream<Path> projects;
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        int maxNbOfProjectsToDisplay = DKUApp.getParams().getIntParam("dku.sanitycheck.projects.maxNbOfProjectsToDisplay", Integer.valueOf(25));
        long maxAgeInDays = this.maxAgeInMillis / 86400000L;
        if (!exclusionList.contains(Codes.WARN_PROJECT_LARGE_JOB_HISTORY.getCode()) && DKUApp.exists((String)"jobs")) {
            try {
                projects = Files.list(DKUApp.getFile((String)"jobs").toPath());
                try {
                    foundProjects = new ArrayList<String>();
                    iterator = projects.map(Path::toFile).filter(this::hasOldOrTooManyJobLogs).iterator();
                    while (iterator.hasNext()) {
                        projectFolder = (File)iterator.next();
                        foundProjects.add(projectFolder.getName());
                        if (foundProjects.size() <= maxNbOfProjectsToDisplay) continue;
                        logger.debug((Object)"Job logs detector - Too many projects found, stopping execution.");
                        foundProjects.add("...");
                        break;
                    }
                    if (!foundProjects.isEmpty()) {
                        messages.withHTMLAndExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_PROJECT_LARGE_JOB_HISTORY, String.format("<p>There are projects in your instance that contain job logs older than <b>%d days</b> or with more than <b>%d job log folders</b>.<br>Consider running the <strong>'Clear job logs'</strong> macro on your projects.</p>", maxAgeInDays, this.maxJobs), "List of the projects", String.format("<pre>%s</pre>", HtmlEscapers.htmlEscaper().escape(String.join((CharSequence)"\n", foundProjects))));
                    }
                }
                finally {
                    if (projects != null) {
                        projects.close();
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error while parsing job logs", (Throwable)e);
                messages.addMessage(this.createFatalMessage(e));
            }
        }
        if (!exclusionList.contains(Codes.WARN_PROJECT_LARGE_SCENARIO_HISTORY.getCode()) && DKUApp.exists((String)"scenarios")) {
            try {
                projects = Files.list(DKUApp.getFile((String)"scenarios").toPath());
                try {
                    foundProjects = new ArrayList();
                    iterator = projects.map(Path::toFile).filter(this::hasOldOrTooManyScenarioLogs).iterator();
                    while (iterator.hasNext()) {
                        projectFolder = (File)iterator.next();
                        foundProjects.add(projectFolder.getName());
                        if (foundProjects.size() <= maxNbOfProjectsToDisplay) continue;
                        logger.debug((Object)"Scenario run logs detector - Too many projects found, stopping execution.");
                        foundProjects.add("...");
                        break;
                    }
                    if (!foundProjects.isEmpty()) {
                        messages.withHTMLAndExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_PROJECT_LARGE_SCENARIO_HISTORY, String.format("<p>There are projects in your instance that contain scenario run logs older than <b>%d days</b> or with more than <b>%d scenario run log folders</b>.<br>Consider running the <strong>'Clear scenario run logs'</strong> macro on your projects.</p>", maxAgeInDays, this.maxScenarioLogsFiles), "List of the projects", String.format("<pre>%s</pre>", HtmlEscapers.htmlEscaper().escape(String.join((CharSequence)"\n", foundProjects))));
                    }
                }
                finally {
                    if (projects != null) {
                        projects.close();
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error while parsing scenario runs logs", (Throwable)e);
                messages.addMessage(this.createFatalMessage(e));
            }
        }
        if (!exclusionList.contains(Codes.WARN_PROJECT_LARGE_STREAMING_HISTORY.getCode()) && DKUApp.exists((String)"streaming-logs")) {
            try {
                projects = Files.list(DKUApp.getFile((String)"streaming-logs").toPath());
                try {
                    foundProjects = new ArrayList();
                    iterator = projects.map(Path::toFile).filter(this::hasOldOrTooManyContinuousJobLogs).iterator();
                    while (iterator.hasNext()) {
                        projectFolder = (File)iterator.next();
                        foundProjects.add(projectFolder.getName());
                        if (foundProjects.size() <= maxNbOfProjectsToDisplay) continue;
                        logger.debug((Object)"Streaming logs detector - Too many projects found, stopping execution.");
                        foundProjects.add("...");
                        break;
                    }
                    if (!foundProjects.isEmpty()) {
                        messages.withHTMLAndExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_PROJECT_LARGE_STREAMING_HISTORY, String.format("<p>There are projects in your instance that contain streaming logs older than <b>%d days</b> or with more than <b>%d log folders</b>.<br>Consider running the <strong>'Clear continuous activities logs'</strong> macro on your projects.</p>", maxAgeInDays, this.maxStreamingLogsFiles), "List of the projects", String.format("<pre>%s</pre>", HtmlEscapers.htmlEscaper().escape(String.join((CharSequence)"\n", foundProjects))));
                    }
                }
                finally {
                    if (projects != null) {
                        projects.close();
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error while parsing streaming logs", (Throwable)e);
                messages.addMessage(this.createFatalMessage(e));
            }
        }
        return messages;
    }

    private boolean hasOldOrTooManyJobLogs(File project) {
        File[] jobs = project.listFiles();
        if (jobs == null) {
            return false;
        }
        if (jobs.length > this.maxJobs) {
            return true;
        }
        return Arrays.stream(jobs).anyMatch(this::isTooOld);
    }

    private boolean hasOldOrTooManyScenarioLogs(File project) {
        int count = 0;
        File[] scenarios = project.listFiles();
        if (scenarios == null) {
            return false;
        }
        for (File scenario : scenarios) {
            File[] runs = scenario.listFiles();
            if (runs == null) continue;
            if ((count += runs.length) > this.maxScenarioLogsFiles) {
                return true;
            }
            if (!Arrays.stream(runs).anyMatch(this::isTooOld)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOldOrTooManyContinuousJobLogs(File project) {
        int count = 0;
        File[] recipes = project.listFiles();
        if (recipes == null) {
            return false;
        }
        for (File recipe : recipes) {
            File r = new File(recipe, "runs");
            File[] runs = r.listFiles();
            if (runs == null) continue;
            for (File run : runs) {
                File[] attempts = run.listFiles();
                if (attempts == null) continue;
                if ((count += attempts.length) > this.maxStreamingLogsFiles) {
                    return true;
                }
                if (!Arrays.stream(attempts).anyMatch(this::isTooOld)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTooOld(File folder) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(folder.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (fileAttributes.creationTime().toMillis() < System.currentTimeMillis() - this.maxAgeInMillis) {
                return true;
            }
        }
        catch (IOException e) {
            logger.errorV((Throwable)e, "Unable to read attributes of folder '%s'", new Object[]{folder.getAbsolutePath()});
        }
        return false;
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_PROJECT_LARGE_JOB_HISTORY("Projects - Too old or too many job logs", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_PROJECT_LARGE_SCENARIO_HISTORY("Projects - Too old or too many scenario run logs", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_PROJECT_LARGE_STREAMING_HISTORY("Projects - Too old or too many continuous activities logs", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

