/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.scheduler.reports.MessageLookupBuilder;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SetProjectVariablesStepRunner
implements StepRunner {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return SetProjectVariablesStepParams.class;
        }

        @Override
        public String getType() {
            return "set_project_vars";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new SetProjectVariablesStepRunner(step.getParamsAs(SetProjectVariablesStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "Set project-level variables";
        }

        @Override
        public String buildId(Step step) {
            SetProjectVariablesStepParams params = step.getParamsAs(SetProjectVariablesStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("set_project_vars");
            if (params != null) {
                for (Map.Entry e : params.variables.entrySet()) {
                    sb.append("_");
                    sb.append((String)e.getKey());
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final SetProjectVariablesStepParams params;
    private static final int MAX_LOG_LENGTH = 50;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.definevars");

    public SetProjectVariablesStepRunner(SetProjectVariablesStepParams params) {
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        String scenarioName = stepRun.getScenarioRun().getScenario().getName();
        String projectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
        if (!StringUtils.isBlank((String)this.params.projectKey)) {
            projectKey = this.params.projectKey;
        }
        DSSAuthCtx runAsUser = stepRun.getScenarioRun().getRunAsUser();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)runAsUser);){
            this.projectsService.checkPerm(runAsUser, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            RelFile rf = new RelFile(new String[]{"projects", projectKey, "variables.json"});
            JsonObject projectVariables = (JsonObject)t.readObjectDefault(rf, JsonObject.class);
            if (this.params.evaluateValues) {
                MessageLookupBuilder lookupBuilder = new MessageLookupBuilder();
                VariableLookup lookup = lookupBuilder.buildForVariablesStep(stepRun.getScenarioRun());
                Gson gson = new Gson();
                for (SimpleKeyValue skv : this.params.definitions) {
                    logger.infoV("Update variable %s = %s", new Object[]{this.sanitizeForLogging(skv.key), this.sanitizeForLogging(skv.value)});
                    Object evaluated = lookup.typedGetResolved(skv.value);
                    logger.infoV(" --> Evaluated to %s (%s)", new Object[]{this.sanitizeForLogging(evaluated), evaluated == null ? "null" : evaluated.getClass()});
                    if (evaluated == null) continue;
                    projectVariables.add(skv.key, gson.toJsonTree(evaluated));
                }
            } else {
                for (Map.Entry e : this.params.variables.entrySet()) {
                    logger.infoV("Update variable %s = %s", new Object[]{this.sanitizeForLogging((String)e.getKey()), this.sanitizeForLogging((JsonElement)e.getValue())});
                    projectVariables.add((String)e.getKey(), (JsonElement)e.getValue());
                }
            }
            logger.trace(() -> "Finally flush " + JSON.log((Object)projectVariables));
            t.writeStringUTF8(rf, JSON.prettyUnescapeHtml((Object)projectVariables));
            t.commit("Updated project variables for project " + projectKey + " from scenario " + scenarioName);
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    private <T> String sanitizeForLogging(T value) {
        return value == null ? "null" : value.toString().substring(0, Math.min(value.toString().length(), 50));
    }

    public static class SetProjectVariablesStepParams
    implements StepParams {
        public String projectKey;
        public JsonObject variables = new JsonObject();
        public List<SimpleKeyValue> definitions = new ArrayList<SimpleKeyValue>();
        public boolean evaluateValues = false;
    }
}

