/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.semanticsearch;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datacollections.DataCollectionsByItem;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ItemMetadata {
    static final DKULogger logger = DKULogger.getLogger(ItemMetadata.class);

    private ItemMetadata() {
    }

    public static class IndexedTableMetadata {
        public String id;
        public String connectionType;
        public String name;
        public String connection;
        public List<IndexedTableColumn> columns;
        public boolean partitioned;

        public IndexedTableMetadata(LuceneResponseWrapper.Hit tableHit) {
            this.id = tableHit._id;
            this.connectionType = (String)tableHit._source.get("connectionType");
            this.name = (String)tableHit._source.get("name");
            this.connection = (String)tableHit._source.get("connection");
            this.columns = (List)new Gson().fromJson((JsonElement)((JsonArray)tableHit._source.get("columns")), new TypeToken<List<IndexedTableColumn>>(){}.getType());
            this.partitioned = (Boolean)tableHit._source.get("partitioned");
        }

        public static List<IndexedTableMetadata> from(List<LuceneResponseWrapper.Hit> indexedTableHits) {
            return indexedTableHits.stream().map(IndexedTableMetadata::new).toList();
        }
    }

    public static class IndexedTableColumn {
        public String name;
        public String remarks;
        public String type;
    }

    public static class DatasetMetadata {
        public String datasetName;
        public String userDescription;
        public List<DatasetColumn> columns;
        public String sourceType;
        public String projectKey;
        public String dataSteward;
        public List<String> tags;
        public String connectionName;
        public Boolean isInDataCollection;
        public boolean partitioned;

        public DatasetMetadata(SerializedDataset sd, String dataSteward, boolean isInDataCollection) {
            this.datasetName = sd.name;
            this.userDescription = DatasetMetadata.buildUserDescription(sd);
            this.columns = DatasetMetadata.buildSchema(sd);
            this.sourceType = sd.getSubtype();
            this.projectKey = sd.getProjectKey();
            this.dataSteward = dataSteward;
            this.tags = sd.tags;
            this.connectionName = sd.getParams().getConnection();
            this.isInDataCollection = isInDataCollection;
            this.partitioned = sd.isPartitioned();
        }

        public static List<DatasetMetadata> from(List<SerializedDataset> datasets, DataCollectionsByItem dataCollectionsByItem, Map<String, String> dataStewardByDataset) {
            return datasets.stream().map(d -> {
                try {
                    return new DatasetMetadata((SerializedDataset)d, (String)dataStewardByDataset.get(d.getFullName()), dataCollectionsByItem.isDatasetInAnyDataCollection(d.projectKey, d.name));
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to generate dataset metadata", (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).toList();
        }

        private static String buildUserDescription(SerializedDataset sd) {
            if (sd.shortDesc != null && sd.description != null) {
                return "Short version:\n" + sd.shortDesc + "\n---\nLong version:\n" + sd.description;
            }
            if (sd.shortDesc != null) {
                return sd.shortDesc;
            }
            if (sd.description != null) {
                return sd.description;
            }
            return null;
        }

        private static List<DatasetColumn> buildSchema(SerializedDataset sd) {
            if (sd.getSchema() == null || sd.getSchema().getColumns() == null) {
                return Collections.emptyList();
            }
            return sd.getSchema().getColumns().stream().map(schemaCol -> new DatasetColumn(schemaCol.getName(), schemaCol.getTypeString(), schemaCol.getMeaning(), schemaCol.comment)).toList();
        }
    }

    public static class DatasetColumn {
        public String name;
        public String type;
        public String meaning;
        public String comment;

        public DatasetColumn() {
        }

        public DatasetColumn(String name, String type, String meaning, String comment) {
            this.name = name;
            this.type = type;
            this.meaning = meaning;
            this.comment = comment;
        }
    }
}

