/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.admin;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerOverrideMask;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvLanguages;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.containers.exec.BaseImageBuilder;
import com.dataiku.dip.containers.exec.BaseImagesPusher;
import com.dataiku.dip.containers.exec.ContainerExecConfigTestService;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesNamespacesService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminContainerExecController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ContainerExecConfigTestService containerExecConfigTestService;
    @Autowired
    private KubernetesNamespacesService k8sNamespacesService;
    private static final Logger logger = Logger.getLogger((String)"dku.admin.container-exec");

    @AuditedCall(value={"msgType", "admin-push-container-base-images"})
    @RequestMapping(value={"/api/admin/container-exec/push-base-images"})
    public void pushBaseImages(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        AdminContainerExecController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<BaseImagesPusher.ImagePushResult>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected BaseImagesPusher.ImagePushResult compute() throws Exception {
                BaseImagesPusher bip = new BaseImagesPusher();
                SpringUtils.getInstance().autowire((Object)bip);
                return bip.tagAndPushAll(this.logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"push_container_exec_base_images", (String)"Push container-exec base images");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<BaseImagesPusher.ImagePushResult>>(){}));
    }

    @AuditedCall(value={"msgType", "admin-apply-kubernetes-policies"})
    @RequestMapping(value={"/api/admin/container-exec/apply-kubernetes-policies"})
    public void applyKubernetesPolicies(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        AdminContainerExecController.writeJSON((HttpServletResponse)resp, this.k8sNamespacesService.applyAllPolicies(authCtx));
    }

    @AuditedCall(value={"msgType", "admin-test-container-exec-conf"})
    @RequestMapping(value={"/api/admin/container-exec/test-conf"})
    public void testContainerConfiguration(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam(required=false, defaultValue="false") boolean clusterDefinedConfig, @RequestParam(required=false) String clusterId, @RequestParam(required=false) String genericOverridesData) throws Exception {
        ContainerExecRuntimeConfig containerConfig;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            containerConfig = (ContainerExecRuntimeConfig)JSON.parse((String)data, ContainerExecRuntimeConfig.class);
            if (StringUtils.isNotBlank((String)clusterId) && !"__builtin__".equals(clusterId)) {
                if (clusterDefinedConfig) {
                    ContainerExecRuntimeConfig baseConfig = new ClusterSelector().selectGlobal().getContainerSettings().getByNameOrNull(containerConfig.name);
                    if (StringUtils.isNotBlank((String)genericOverridesData)) {
                        ContainerExecRuntimeConfig genericOverrides = (ContainerExecRuntimeConfig)JSON.parse((String)data, ContainerExecRuntimeConfig.class);
                        baseConfig = ContainerOverrideMask.getOverriden(baseConfig, genericOverrides);
                    }
                    containerConfig = ContainerOverrideMask.getOverriden(baseConfig, containerConfig);
                } else {
                    containerConfig = new ClusterSelector().selectForCluster(authCtx, "__builtin__", clusterId, containerConfig).getContainerSettings().getByNameOrNull(containerConfig.name);
                }
            } else {
                if (clusterDefinedConfig) {
                    throw new IllegalArgumentException("Cluster not specified for cluster-level overrides test");
                }
                containerConfig.noImplicitK8sClusterAndNoDefaultClusterId = !ApplicationConfigurator.getGeneralSettings().useImplicitK8sCluster;
            }
        }
        AdminContainerExecController.writeJSON((HttpServletResponse)resp, this.containerExecConfigTestService.testContainerConfig(authCtx, containerConfig));
    }

    @AuditedCall(value={"msgType", "admin-install-container-jupyter-support"})
    @RequestMapping(value={"/api/admin/container-exec/install-jupyter-support"})
    public void installJupyterSupport(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        AdminContainerExecController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvUpdateResult>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected CodeEnvModel.EnvUpdateResult compute() throws Exception {
                CodeEnvModel.AbstractEnvDesc desc;
                AutoDelete log;
                CodeEnvModel.EnvUpdateResult ret = new CodeEnvModel.EnvUpdateResult();
                DKUtils.SmartLogTailBuilder tailBuilder = new DKUtils.SmartLogTailBuilder();
                try {
                    log = FlowJobUtils.getJobTempFile("remote-kernels", "install-py", "log");
                    try {
                        DKUFileUtils.mkdirsParent((File)log);
                        desc = new CodeEnvModel.AbstractEnvDesc(){};
                        desc.allContainerConfs = true;
                        desc.allSparkKubernetesConfs = true;
                        CodeEnvLanguages.installJupyterSupport(authCtx, CodeEnvLanguages.REMOTE_PYTHON, desc, null, null, null, tailBuilder, (File)log, null);
                    }
                    finally {
                        if (log != null) {
                            log.close();
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Jupyter support installation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                try {
                    log = FlowJobUtils.getJobTempFile("remote-kernels", "install-r", "log");
                    try {
                        DKUFileUtils.mkdirsParent((File)log);
                        desc = new CodeEnvModel.AbstractEnvDesc(){};
                        desc.allContainerConfs = true;
                        desc.allSparkKubernetesConfs = true;
                        CodeEnvLanguages.installJupyterSupport(authCtx, CodeEnvLanguages.REMOTE_R, desc, null, null, null, tailBuilder, (File)log, null);
                    }
                    finally {
                        if (log != null) {
                            log.close();
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Jupyter support installation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"install_remote_jupyter_support", (String)"(Re)Install Jupyter kernels for container configs");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvUpdateResult>>(){}));
    }

    @AuditedCall(value={"msgType", "admin-remove-container-jupyter-support"})
    @RequestMapping(value={"/api/admin/container-exec/remove-jupyter-support"})
    public void removeJupyterSupport(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        AdminContainerExecController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvUpdateResult>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected CodeEnvModel.EnvUpdateResult compute() throws Exception {
                CodeEnvModel.AbstractEnvDesc desc;
                AutoDelete log;
                CodeEnvModel.EnvUpdateResult ret = new CodeEnvModel.EnvUpdateResult();
                DKUtils.SmartLogTailBuilder tailBuilder = new DKUtils.SmartLogTailBuilder();
                try {
                    log = FlowJobUtils.getJobTempFile("remote-kernels", "remove-py", "log");
                    try {
                        DKUFileUtils.mkdirsParent((File)log);
                        desc = new CodeEnvModel.AbstractEnvDesc(){};
                        desc.allContainerConfs = true;
                        desc.allSparkKubernetesConfs = true;
                        CodeEnvLanguages.removeJupyterSupport(authCtx, CodeEnvLanguages.REMOTE_PYTHON, desc, null, null, null, tailBuilder, (File)log);
                    }
                    finally {
                        if (log != null) {
                            log.close();
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Jupyter support removal failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_REMOVAL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                try {
                    log = FlowJobUtils.getJobTempFile("remote-kernels", "remove-R", "log");
                    try {
                        DKUFileUtils.mkdirsParent((File)log);
                        desc = new CodeEnvModel.AbstractEnvDesc(){};
                        desc.allContainerConfs = true;
                        desc.allSparkKubernetesConfs = true;
                        CodeEnvLanguages.removeJupyterSupport(authCtx, CodeEnvLanguages.REMOTE_R, desc, null, null, null, tailBuilder, (File)log);
                    }
                    finally {
                        if (log != null) {
                            log.close();
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Jupyter support removal failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_REMOVAL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"install_remote_jupyter_support", (String)"(Re)Install Jupyter kernels for container configs");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvUpdateResult>>(){}));
    }

    @AuditedCall(value={"msgType", "admin-get-container-base-images-defaults"})
    @RequestMapping(value={"/api/admin/container-exec/get-base-image-defaults"}, method={RequestMethod.GET})
    @ResponseBody
    public BaseImageBuilder.BaseImageBuildOptions getBaseImageDefaultOptions(HttpServletRequest req, HttpServletResponse resp, @RequestParam ContainerExecUtils.BaseImageType type) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        return ContainerExecImagesHelper.getLatestOptions(type);
    }

    @AuditedCall(value={"msgType", "admin-build-container-base-images"})
    @RequestMapping(value={"/api/admin/container-exec/build-base-image"}, method={RequestMethod.POST})
    public void buildBaseImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam ContainerExecUtils.BaseImageType type, @RequestParam String options, @RequestParam(required=false) boolean pushAfterBuild) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        BaseImageBuilder.BaseImageBuildOptions buildOptions = new BaseImageBuilder.BaseImageBuildOptions(type);
        if (StringUtils.isNotBlank((String)options)) {
            buildOptions = (BaseImageBuilder.BaseImageBuildOptions)JSON.parse((String)options, BaseImageBuilder.BaseImageBuildOptions.class);
        }
        BaseImageBuilder builder = new BaseImageBuilder(type, buildOptions, pushAfterBuild);
        AdminContainerExecController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(builder.getBuildFuture(authCtx), 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){}));
    }
}

