/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.deployer;

import com.dataiku.dip.deployer.common.engine.DeploymentHooksService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/deployer"})
public class DeployerController
extends DIPInternalControllerBase {
    @Autowired
    TransactionService transactionService;
    @Autowired
    UIAuthService authService;
    @Autowired
    DeploymentHooksService deploymentHooksService;

    @AuditedCall(value={"msgType", "deployment-hooks-check-code-compiles"})
    @RequestMapping(value={"/hooks/check-code-compiles"}, method={RequestMethod.POST})
    public void checkCodeCompiles(HttpServletRequest req, HttpServletResponse resp, @RequestParam String code, @RequestParam(required=false) String codeEnvName) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        DeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentHooksService.checkCodeCompiles_NT_Check(user, code, StringUtils.nullIfBlank((String)codeEnvName)));
    }
}

