/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.enterpriseassetlibrary;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetLibraryCodes;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.projects.Desc;
import com.dataiku.dip.projects.InstallationResult;
import com.dataiku.dip.projects.TutorialsService;
import com.dataiku.dip.projects.importexport.ProjectImporter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseAssetLibraryService;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseProject;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseProjectsService {
    @Autowired
    EnterpriseAssetLibraryService enterpriseAssetLibraryService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TutorialsService tutorialsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private PubSubService pubSub;
    private static final Logger logger = Logger.getLogger((String)"dku.enterpriseassetlibrary");

    public FutureResponse<InstallationResult> createProject(AuthCtx user, String collectionId, String id, String projectFolderId) throws Exception {
        CreateEnterpriseProjectFutureThread ft = new CreateEnterpriseProjectFutureThread(collectionId, id, projectFolderId, (DSSAuthCtx)user);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<InstallationResult>>(){});
    }

    private static FuturePayload buildFuturePayload(String projectId) {
        FuturePayload fp = new FuturePayload();
        fp.action = "create_project";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectId, projectId, projectId, "ENTERPRISE_PROJECT", "PROJECT"));
        fp.displayName = "Installing project";
        return fp;
    }

    private class CreateEnterpriseProjectFutureThread
    extends FutureThread<InstallationResult> {
        private final InstallationResult result;
        private final String collectionId;
        private final String projectId;
        private final String projectFolderId;
        private final FuturePayload futurePayload;

        public CreateEnterpriseProjectFutureThread(String collectionId, String projectId, String projectFolderId, DSSAuthCtx authCtx) {
            super(authCtx);
            this.result = new InstallationResult();
            this.collectionId = collectionId;
            this.projectId = projectId;
            this.projectFolderId = projectFolderId;
            this.futurePayload = EnterpriseProjectsService.buildFuturePayload(projectId);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public InstallationResult getResult() {
            return this.result;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() {
            File archive;
            String projectKey;
            EnterpriseProject desc;
            InstallationResult ret = this.result;
            try {
                desc = this.getDesc(this.projectId);
                StringTransmogrifier st2 = new StringTransmogrifier();
                try (Transaction t = EnterpriseProjectsService.this.transactionService.beginRead();){
                    for (String s : EnterpriseProjectsService.this.projectsService.listProjectKeys()) {
                        st2.addAlreadyTransmogrified(s);
                    }
                }
                projectKey = st2.transmogrify(this.projectId);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to setup the project's creation", (Throwable)ex);
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                ret.errorMessage = "Could not setup the project creation";
                return;
            }
            try {
                archive = this.getArchive(desc);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to retrieve the project's archive", (Throwable)ex);
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                ret.errorMessage = "Could not retrieve the project's files";
                return;
            }
            ProjectImporter.ProjectImportSettings importSettings = new ProjectImporter.ProjectImportSettings();
            importSettings.targetProjectKey = projectKey;
            importSettings.targetProjectFolderId = this.projectFolderId;
            ProjectImporter pi = new ProjectImporter(this.owner, archive, importSettings, true);
            this.processImport(ret, desc, pi, this.owner, projectKey, this.projectId);
        }

        private void processImport(InstallationResult ret, Desc desc, ProjectImporter pi, DSSAuthCtx owner, String targetProjectKey, String projectId) {
            try {
                ProjectImporter.ProjectImportResult projectImportResult = pi.importProject(owner);
                if (projectImportResult.success) {
                    try (RWTransaction t = EnterpriseProjectsService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)owner);){
                        SerializedProject sp = EnterpriseProjectsService.this.projectsService.getMandatory(targetProjectKey);
                        sp.name = desc.name + " for " + EnterpriseProjectsService.this.usersService.getUserOrNull_NoLeak((String)owner.getAssociatedDSSUserMand()).displayName;
                        sp.tutorialProject = false;
                        sp.tutorialId = null;
                        GeneralSettingsDAO.ProjectStatus sandboxStatus = EnterpriseProjectsService.this.generalSettingsService.getProjectStatusWithName(GeneralSettingsDAO.DEFAULT_PROJECT_STATUS.SANDBOX.projectStatus.name);
                        if (sandboxStatus != null) {
                            sp.projectStatus = sandboxStatus.name;
                        }
                        EnterpriseProjectsService.this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.UNKNOWN);
                        EnterpriseProjectsService.this.flowGraphService.invalidateCache();
                        EnterpriseProjectsService.this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, targetProjectKey, targetProjectKey, owner, TaggableObjectChangedEvent.ActionType.PROJECT_CREATE));
                        t.commit("Created from Enterprise project " + projectId);
                    }
                } else {
                    throw new Exception("Enterprise project installation failed:\n " + JSON.log((Object)((Object)projectImportResult)));
                }
                ret.projectKey = targetProjectKey;
                ret.success = true;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to install the Enterprise project", (Throwable)ex);
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                ret.errorMessage = "Could not install the Enterprise project";
            }
        }

        private EnterpriseProject getDesc(String id) throws Exception {
            try (Transaction t = EnterpriseProjectsService.this.transactionService.retrieveOrBeginRead();){
                for (EnterpriseProject project : EnterpriseProjectsService.this.enterpriseAssetLibraryService.getProjects(this.collectionId).values()) {
                    if (!Objects.equals(project.id, id)) continue;
                    EnterpriseProject enterpriseProject = project;
                    return enterpriseProject;
                }
            }
            throw new IllegalArgumentException("Unknown project " + id);
        }

        private File getArchive(EnterpriseProject desc) throws CodedException, LicenseRestrictionException {
            File f = EnterpriseProjectsService.this.enterpriseAssetLibraryService.getProjectArchiveFile(this.collectionId, desc.id, desc.version);
            if (!f.exists()) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_PROJECT_NOT_INSTALLED, "Archive for " + desc.id + " not found : " + String.valueOf(f));
            }
            return f;
        }
    }
}

