/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.MentionEnabledEvent;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.transactions.git.GitModel;

public class CommitEvent
extends BackendEvent
implements ProjectEvent,
UserEvent,
EventWithHumanReadableString,
MentionEnabledEvent {
    public static final String NAME = "commit";
    private final String message;
    private final String projectKey;
    private final String projectName;
    private GitModel.GitAuthor user;
    private String revision;

    @Override
    public String getMessage() {
        return this.message;
    }

    public CommitEvent(String message, String projectKey, GitModel.GitAuthor user, String revision) {
        this.message = message;
        this.projectKey = projectKey;
        this.projectName = projectKey;
        this.user = user;
        this.revision = revision;
    }

    @Override
    public String getUserLogin() {
        return this.user.name;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        String shortHash = this.revision.substring(0, 7);
        String markupTypeMsg = this.projectKey != null ? markup.text("project ") + markup.project(this.projectKey, this.projectName) + markup.text(".") : markup.text("config:");
        return String.format("%s committed %s [%s] %s", markup.user(this.user.name, null), markupTypeMsg, markup.text(shortHash), markup.text(this.message));
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }
}

