/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.PrestoSQLDialect;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.TrinoSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WindowQueryGenerator {
    protected ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    protected WindowRecipePayloadParams params;
    protected Dataset source;
    protected SQLUtils.SQLTable sqlTable;
    protected PartitioningScheme sourcePartitionScheme;
    protected List<Partition> sourcePartitions;
    protected PartitioningScheme targetPartitionScheme;
    protected Dataset outputDataset;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.window");

    public WindowQueryGenerator(WindowRecipePayloadParams params, Dataset source, SQLUtils.SQLTable sqlTable, Dataset outputDataset) {
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkNotNull((Object)source);
        this.outputDataset = outputDataset;
        this.params = params;
        this.source = source;
        this.sqlTable = sqlTable;
    }

    public void setPartitioning(PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme) {
        this.sourcePartitionScheme = sourcePartitionScheme;
        this.sourcePartitions = sourcePartitions;
        this.targetPartitionScheme = targetPartitionScheme;
        logger.info((Object)("Set partitioning: \nSource partition col: " + String.valueOf(sourcePartitionScheme) + "\nTarget partition col: " + String.valueOf(targetPartitionScheme)));
        logger.info((Object)("sourcePartitions: " + JSON.prettyLog(sourcePartitions)));
    }

    public String generateSQL(SQLDialect dialect, boolean forceOutputColumnNameOverride) {
        return this.generateQuery(dialect, forceOutputColumnNameOverride).toSQL(dialect);
    }

    public SelectQueryBuilder generateQuery(SQLDialect dialect, boolean forceOutputColumnNameOverride) {
        if (this.params == null) {
            throw ErrorContext.iae((String)"No paramters given to window query generator");
        }
        Schema inputSchema = this.source.getSchema();
        SelectQueryBuilder innerQuery = new SelectQueryBuilder();
        SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()), this.source.getSchema());
        FilterDesc preFilter = this.params.preFilter;
        if (this.sourcePartitionScheme != null && this.sqlTable.isTrueTable()) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(this.sourcePartitionScheme, this.source, this.sourcePartitions, dialect);
            innerQuery.where(partitionFilterExpression);
        }
        if (preFilter.distinct) {
            SelectQueryBuilder subQuery = new SelectQueryBuilder();
            subQuery.from(this.sqlTable, null);
            if (dialect instanceof HiveSQLDialect && !(dialect instanceof PrestoSQLDialect)) {
                for (SchemaColumn sc : inputSchema.columns) {
                    subQuery.select(sc.getName());
                }
            }
            subQuery.selectDistinct();
            innerQuery.from(subQuery, "dku__subquery");
            preFilter = (FilterDesc)JSON.deepCopy((Object)preFilter);
            preFilter.distinct = false;
        } else {
            innerQuery.from(this.sqlTable, null);
        }
        QueryGenerationUtils.preFilter(innerQuery, preFilter, dialect, this.source, false);
        SelectQueryBuilder query = new SelectQueryBuilder();
        if (this.params.computedColumns == null || this.params.computedColumns.isEmpty()) {
            query = innerQuery;
        } else {
            innerQuery = QueryGenerationUtils.computedColumns(innerQuery, this.params.computedColumns, dialect, this.source.getSchema());
            query.from(innerQuery, "dku__subquery");
        }
        HashSet partitionColumnNames = this.targetPartitionScheme != null ? new HashSet(this.targetPartitionScheme.getDimensionNames()) : Sets.newHashSet();
        List<WindowRecipePayloadParams.WindowValue> resolvedWindowValues = this.params.getResolvedWindowValues(inputSchema);
        for (WindowRecipePayloadParams.WindowValue value : resolvedWindowValues) {
            if (value.column == null || !value.value) continue;
            ExpressionBuilder column = ExpressionUtils.getAdjustedColumn(this.ef.col(value.column), value.column, this.source, dialect);
            if (partitionColumnNames.contains(value.column)) {
                SchemaColumn sc = this.outputDataset.getSchema().getColumnOrDefault(value.column, Type.STRING);
                query.select(this.ef.dstPartitionId(sc, this.targetPartitionScheme.getDimension(value.column)), value.column);
                partitionColumnNames.remove(value.column);
                continue;
            }
            query.select(column, value.column);
        }
        boolean unboudedWindowsRequired = !(dialect instanceof PostgreSQLDialect);
        int concatCount = 0;
        for (WindowRecipePayloadParams.WindowValue input : resolvedWindowValues) {
            concatCount += input.concat ? 1 : 0;
        }
        boolean needsTwoStepConcat = concatCount > 0 && (dialect instanceof HiveSQLDialect && !(dialect instanceof TrinoSQLDialect) || dialect instanceof SparkSQLDialect);
        HashMap secondStepConcatenations = Maps.newHashMap();
        if (this.params.windows != null) {
            for (int w = 0; w < this.params.windows.size(); ++w) {
                WindowRecipePayloadParams.WindowDesc windowDesc = this.params.windows.get(w);
                String prefix = StringUtils.isNotBlank((String)windowDesc.prefix) ? windowDesc.prefix + "_" : "";
                QueryAst.Window window = this.makeWindow(windowDesc, this.source, dialect, query.getCurrentMainAlias());
                QueryAst.Window unboundedWindow = null;
                if (unboudedWindowsRequired) {
                    unboundedWindow = SelectQueryBuilder.unboundedWindow(window);
                }
                if (StringUtils.isNotBlank((String)windowDesc.name)) {
                    query.select(this.ef.cmt(windowDesc.name));
                } else if (this.params.windows.size() > 1 && this.params.hasNonTrivialAggregation()) {
                    query.select(this.ef.cmt("Window " + (w + 1)));
                }
                for (WindowRecipePayloadParams.WindowValue input : resolvedWindowValues) {
                    if (StringUtils.isNotBlank((String)input.column)) {
                        ExpressionBuilder lag;
                        String as;
                        ExpressionBuilder diff;
                        WindowRecipePayloadParams.DateDiffUnit unit;
                        String as2;
                        ExpressionBuilder lead;
                        ExpressionBuilder column = ExpressionUtils.getAdjustedColumn(this.ef.col(input.column), input.column, this.source, dialect);
                        String prefixedCol = prefix + input.column;
                        SchemaColumn schemaCol = ExpressionUtils.getSchemaColumn(input.column, inputSchema, this.params.computedColumns);
                        if (input.min) {
                            ExpressionBuilder min = ExpressionUtils.min(column, schemaCol.getType(), window);
                            query.select(min, safeSuffixer.addSuffix(prefixedCol, "_min"));
                        }
                        if (input.max) {
                            ExpressionBuilder max = ExpressionUtils.max(column, schemaCol.getType(), window);
                            query.select(max, safeSuffixer.addSuffix(prefixedCol, "_max"));
                        }
                        if (input.count) {
                            query.select(column.count().over(window), safeSuffixer.addSuffix(prefixedCol, "_count"));
                        }
                        if (input.countDistinct) {
                            query.select(column.countDistinct().over(window), safeSuffixer.addSuffix(prefixedCol, "_distinct"));
                        }
                        if (input.avg) {
                            query.select(ExpressionUtils.getColAsFloatingPoint(input.column, schemaCol).avg().over(window), safeSuffixer.addSuffix(prefixedCol, "_avg"));
                        }
                        if (input.stddev) {
                            query.select(ExpressionUtils.getColAsFloatingPoint(input.column, schemaCol).stdDevSamp().over(window), safeSuffixer.addSuffix(prefixedCol, "_stddev"));
                        }
                        if (input.sum) {
                            ExpressionBuilder expr = ExpressionUtils.getColAsNumeric(input.column, schemaCol);
                            expr = expr.castForAggregateIfNeeded(dialect, schemaCol.getType());
                            query.select(expr.sum().over(window), safeSuffixer.addSuffix(prefixedCol, "_sum"));
                        }
                        if (input.concat) {
                            String concatName = safeSuffixer.addSuffix(prefixedCol, "_concat");
                            ExpressionBuilder agg = needsTwoStepConcat ? (input.concatDistinct ? column.collectStringSet() : column.collectStringList()) : column.aggConcat(input.concatSeparator, input.concatDistinct);
                            secondStepConcatenations.put(concatName, input);
                            query.select(agg.over(window), concatName);
                        }
                        if (input.first) {
                            query.select(column.firstValue(input.firstLastNotNull).over(window), safeSuffixer.addSuffix(prefixedCol, "_first"));
                        }
                        if (input.last) {
                            query.select(column.lastValue(input.firstLastNotNull).over(window), safeSuffixer.addSuffix(prefixedCol, "_last"));
                        }
                        if (input.lead) {
                            for (int leadValue : input.getLeadValues()) {
                                lead = column.lead(leadValue).over(unboudedWindowsRequired ? unboundedWindow : window);
                                as2 = safeSuffixer.addSuffix(prefixedCol, "_lead" + String.valueOf(leadValue != 1 || input.getLeadValues().length > 1 ? Integer.valueOf(leadValue) : ""));
                                query.select(lead, as2);
                            }
                        }
                        if (input.leadDiff) {
                            for (int leadValue : input.getLeadValues()) {
                                lead = column.lead(leadValue).over(unboudedWindowsRequired ? unboundedWindow : window);
                                unit = input.dateDiffUnit != null ? input.dateDiffUnit : WindowRecipePayloadParams.DateDiffUnit.DAY;
                                diff = ExpressionUtils.diff(column, lead, schemaCol.getType(), unit.toString());
                                as = safeSuffixer.addSuffix(prefixedCol, "_lead_diff" + String.valueOf(leadValue != 1 || input.getLeadValues().length > 1 ? Integer.valueOf(leadValue) : ""));
                                query.select(diff, as);
                            }
                        }
                        if (input.lag) {
                            for (int lagValue : input.getLagValues()) {
                                lag = column.lag(lagValue).over(unboudedWindowsRequired ? unboundedWindow : window);
                                as2 = safeSuffixer.addSuffix(prefixedCol, "_lag" + String.valueOf(lagValue != 1 || input.getLagValues().length > 1 ? Integer.valueOf(lagValue) : ""));
                                query.select(lag, as2);
                            }
                        }
                        if (!input.lagDiff) continue;
                        for (int lagValue : input.getLagValues()) {
                            lag = column.lag(lagValue).over(unboudedWindowsRequired ? unboundedWindow : window);
                            unit = input.dateDiffUnit != null ? input.dateDiffUnit : WindowRecipePayloadParams.DateDiffUnit.DAY;
                            diff = ExpressionUtils.diff(column, lag, schemaCol.getType(), unit.toString());
                            as = safeSuffixer.addSuffix(prefixedCol, "_lag_diff" + String.valueOf(lagValue != 1 || input.getLagValues().length > 1 ? Integer.valueOf(lagValue) : ""));
                            query.select(diff, as);
                        }
                        continue;
                    }
                    assert (dialect != null);
                    dialect.failIfInvalidColumnIdentifier(input.customName);
                    query.select(this.ef.expr(input.customExpr, "$window", window), prefix + input.customName);
                }
                if (this.params.rank) {
                    query.select(this.ef.rank().over(unboudedWindowsRequired ? unboundedWindow : window), prefix + "rank");
                }
                if (this.params.denseRank) {
                    query.select(this.ef.denseRank().over(unboudedWindowsRequired ? unboundedWindow : window), prefix + "denserank");
                }
                if (this.params.rowNumber) {
                    query.select(this.ef.rowNumber().over(unboudedWindowsRequired ? unboundedWindow : window), prefix + "rownumber");
                }
                if (this.params.cumeDist) {
                    query.select(this.ef.cumeDist().over(unboudedWindowsRequired ? unboundedWindow : window), prefix + "cumedist");
                }
                if (!this.params.ntile) continue;
                for (Object ntileValue : (Object)this.params.getNtileValues()) {
                    query.select(this.ef.ntile((int)ntileValue).over(unboudedWindowsRequired ? unboundedWindow : window), prefix + "ntile" + (int)ntileValue);
                }
            }
        }
        if (this.targetPartitionScheme != null) {
            for (String col : this.targetPartitionScheme.getDimensionNames()) {
                if (!partitionColumnNames.contains(col)) continue;
                SchemaColumn sc = this.outputDataset.getSchema().getColumnOrDefault(col, Type.STRING);
                query.select(this.ef.dstPartitionId(sc, this.targetPartitionScheme.getDimension(col)), col);
            }
        }
        if (needsTwoStepConcat) {
            SelectQueryBuilder queryWithConcat = new SelectQueryBuilder();
            for (String selected : query.getSelectedItemsAliases()) {
                if (secondStepConcatenations.containsKey(selected)) {
                    queryWithConcat.select(this.ef.col(selected).arrayToString(((WindowRecipePayloadParams.WindowValue)secondStepConcatenations.get((Object)selected)).concatSeparator), selected);
                    continue;
                }
                queryWithConcat.select(this.ef.col(selected), selected);
            }
            queryWithConcat.from(query, "__twostep_concat");
            query = queryWithConcat;
        }
        query = QueryGenerationUtils.postFilter(query, this.params.postFilter, dialect, false);
        query = QueryGenerationUtils.applyOverrides(query, this.params.outputColumnNameOverrides, dialect, forceOutputColumnNameOverride);
        query = QueryGenerationUtils.applyInsertIntoCasts(query, dialect, this.outputDataset);
        return query;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    QueryAst.Window makeWindow(WindowRecipePayloadParams.WindowDesc windowDesc, Dataset dataset, SQLDialect dialect, String mainAlias) {
        ArrayList<ExpressionBuilder> partitioningColumns = new ArrayList<ExpressionBuilder>();
        ArrayList<QueryAst.OrderType> orders = new ArrayList<QueryAst.OrderType>();
        ArrayList<ExpressionBuilder> orderColumns = new ArrayList<ExpressionBuilder>();
        if (windowDesc.enablePartitioning && windowDesc.partitioningColumns != null) {
            for (String colName : windowDesc.partitioningColumns) {
                if (dialect instanceof MySQLDialect && StringUtils.isNotBlank((String)mainAlias)) {
                    partitioningColumns.add(this.ef.col(mainAlias, colName));
                    continue;
                }
                partitioningColumns.add(this.ef.col(colName));
            }
        }
        if (windowDesc.enableOrdering && windowDesc.orders != null) {
            for (WindowRecipePayloadParams.Order order : windowDesc.orders) {
                orders.add(order.desc ? QueryAst.OrderType.DESC : QueryAst.OrderType.ASC);
                if (dialect instanceof MySQLDialect && StringUtils.isNotBlank((String)mainAlias)) {
                    orderColumns.add(this.ef.col(mainAlias, order.column));
                    continue;
                }
                orderColumns.add(this.ef.col(order.column));
            }
        }
        Object limitStart = null;
        QueryAst.WindowFrameDirection limitStartDirection = null;
        Object limitEnd = null;
        QueryAst.WindowFrameDirection limitEndDirection = null;
        WindowRecipePayloadParams.DateDiffUnit dateDiffUnit = null;
        QueryAst.WindowFrameMode frameMode = null;
        if (windowDesc.enableLimits) {
            if (windowDesc.windowLimitMode == WindowRecipePayloadParams.WindowLimitMode.RANGE) {
                limitStartDirection = QueryAst.WindowFrameDirection.PRECEDING;
                limitEndDirection = QueryAst.WindowFrameDirection.FOLLOWING;
                frameMode = QueryAst.WindowFrameMode.RANGE;
                if (!windowDesc.enableOrdering || windowDesc.orders == null || windowDesc.orders.size() <= 0) throw new IllegalArgumentException("Order required for value range window frame");
                SchemaColumn schemaColumn = ExpressionUtils.getSchemaColumn(windowDesc.orders.get((int)0).column, dataset.getSchema(), this.params.computedColumns);
                Type orderColType = schemaColumn.getType();
                if (orderColType.isInteger() || orderColType.isTemporal()) {
                    long i;
                    if (windowDesc.limitPreceding) {
                        i = Math.round(windowDesc.windowLowerBound);
                        limitStart = i == 0L ? "CURRENT ROW" : "" + Math.abs(i);
                        QueryAst.WindowFrameDirection windowFrameDirection = limitStartDirection = i < 0L ? QueryAst.WindowFrameDirection.FOLLOWING : QueryAst.WindowFrameDirection.PRECEDING;
                    }
                    if (windowDesc.limitFollowing) {
                        i = Math.round(windowDesc.windowUpperBound);
                        limitEnd = i == 0L ? "CURRENT ROW" : "" + Math.abs(i);
                        limitEndDirection = i < 0L ? QueryAst.WindowFrameDirection.PRECEDING : QueryAst.WindowFrameDirection.FOLLOWING;
                    }
                } else {
                    double d;
                    if (!orderColType.isFloatingPoint()) throw new NotImplementedException("Window frame not implemented for type " + orderColType.toString());
                    if (windowDesc.limitPreceding) {
                        d = windowDesc.windowLowerBound;
                        limitStart = (double)Math.round(d) == d ? (d == 0.0 ? "CURRENT ROW" : "" + Math.abs((long)d)) : (d == 0.0 ? "CURRENT ROW" : "" + Math.abs(d));
                        QueryAst.WindowFrameDirection windowFrameDirection = limitStartDirection = d < 0.0 ? QueryAst.WindowFrameDirection.FOLLOWING : QueryAst.WindowFrameDirection.PRECEDING;
                    }
                    if (windowDesc.limitFollowing) {
                        d = windowDesc.windowUpperBound;
                        limitEnd = (double)Math.round(d) == d ? (d == 0.0 ? "CURRENT ROW" : "" + Math.abs((long)d)) : (d == 0.0 ? "CURRENT ROW" : "" + Math.abs(d));
                        limitEndDirection = d < 0.0 ? QueryAst.WindowFrameDirection.PRECEDING : QueryAst.WindowFrameDirection.FOLLOWING;
                    }
                }
                if (orderColType.isTemporal()) {
                    dateDiffUnit = windowDesc.windowDateRangeUnit != null ? windowDesc.windowDateRangeUnit : WindowRecipePayloadParams.DateDiffUnit.DAY;
                }
            } else if (windowDesc.windowLimitMode == WindowRecipePayloadParams.WindowLimitMode.ROWS) {
                frameMode = QueryAst.WindowFrameMode.ROWS;
                limitStart = windowDesc.limitPreceding ? "" + Math.abs(windowDesc.precedingRows) : null;
                limitStartDirection = windowDesc.precedingRows < 0 ? QueryAst.WindowFrameDirection.FOLLOWING : QueryAst.WindowFrameDirection.PRECEDING;
                limitEnd = windowDesc.limitFollowing ? "" + Math.abs(windowDesc.followingRows) : null;
                QueryAst.WindowFrameDirection windowFrameDirection = limitEndDirection = windowDesc.followingRows < 0 ? QueryAst.WindowFrameDirection.PRECEDING : QueryAst.WindowFrameDirection.FOLLOWING;
            }
        }
        if (dialect instanceof RedshiftSQLDialect && windowDesc.enableOrdering && windowDesc.orders != null && windowDesc.orders.size() > 0 && frameMode == null) {
            frameMode = QueryAst.WindowFrameMode.ROWS;
        }
        QueryAst.Window window = SelectQueryBuilder.window(partitioningColumns, orderColumns, orders);
        window.withFrame(frameMode, (String)limitStart, limitStartDirection, (String)limitEnd, limitEndDirection, dateDiffUnit);
        return window;
    }
}

