/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.mec.ModelComparisonsCRUDService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;

public class IndexableTypeUtils {
    private static IndexableType getFromTaggableType(ITaggingService.TaggableType taggableType) {
        Preconditions.checkNotNull((Object)((Object)taggableType), (Object)"No TaggableType provided to obtain IndexableType");
        return switch (taggableType) {
            default -> throw new IncompatibleClassChangeError();
            case ITaggingService.TaggableType.AGENT_TOOL -> IndexableType.AGENT_TOOL;
            case ITaggingService.TaggableType.ANALYSIS -> IndexableType.ANALYSIS;
            case ITaggingService.TaggableType.DASHBOARD -> IndexableType.DASHBOARD;
            case ITaggingService.TaggableType.DATASET -> IndexableType.DATASET;
            case ITaggingService.TaggableType.INSIGHT -> IndexableType.INSIGHT;
            case ITaggingService.TaggableType.MANAGED_FOLDER -> IndexableType.MANAGED_FOLDER;
            case ITaggingService.TaggableType.PROJECT -> IndexableType.PROJECT;
            case ITaggingService.TaggableType.WORKSPACE -> IndexableType.WORKSPACE;
            case ITaggingService.TaggableType.RECIPE -> IndexableType.RECIPE;
            case ITaggingService.TaggableType.REPORT -> IndexableType.REPORT;
            case ITaggingService.TaggableType.SAVED_MODEL, ITaggingService.TaggableType.MODEL_EVALUATION_STORE, ITaggingService.TaggableType.GENAI_EVALUATION_STORE, ITaggingService.TaggableType.MODEL_COMPARISON, ITaggingService.TaggableType.GENAI_COMPARISON -> throw new IllegalArgumentException("This method is not specific enough to be called for " + String.valueOf((Object)taggableType));
            case ITaggingService.TaggableType.WEB_APP -> IndexableType.WEB_APP;
            case ITaggingService.TaggableType.ARTICLE -> IndexableType.ARTICLE;
            case ITaggingService.TaggableType.STATISTICS_WORKSHEET -> IndexableType.STATISTICS_WORKSHEET;
            case ITaggingService.TaggableType.SQL_NOTEBOOK, ITaggingService.TaggableType.SEARCH_NOTEBOOK, ITaggingService.TaggableType.JUPYTER_NOTEBOOK -> IndexableType.NOTEBOOK;
            case ITaggingService.TaggableType.SCENARIO -> IndexableType.SCENARIO;
            case ITaggingService.TaggableType.FLOW_ZONE -> IndexableType.FLOW_ZONE;
            case ITaggingService.TaggableType.LABELING_TASK -> IndexableType.LABELING_TASK;
            case ITaggingService.TaggableType.DATA_COLLECTION -> IndexableType.DATA_COLLECTION;
            case ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE -> IndexableType.KNOWLEDGE_BANK;
            case ITaggingService.TaggableType.PROMPT_STUDIO -> IndexableType.PROMPT_STUDIO;
            case ITaggingService.TaggableType.SEMANTIC_MODEL -> IndexableType.SEMANTIC_MODEL;
            case ITaggingService.TaggableType.CODE_STUDIO -> IndexableType.CODE_STUDIO;
            case ITaggingService.TaggableType.LAMBDA_SERVICE -> IndexableType.LAMBDA_SERVICE;
            case ITaggingService.TaggableType.AGENT_REVIEW -> IndexableType.AGENT_REVIEW;
            case ITaggingService.TaggableType.WORKSPACE_LINK, ITaggingService.TaggableType.WORKSPACE_STORY, ITaggingService.TaggableType.STREAMING_ENDPOINT, ITaggingService.TaggableType.API_DEPLOYER_DEPLOYMENT, ITaggingService.TaggableType.API_DEPLOYER_INFRA, ITaggingService.TaggableType.API_DEPLOYER_SERVICE, ITaggingService.TaggableType.PROJECT_DEPLOYER_INFRA, ITaggingService.TaggableType.PROJECT_DEPLOYER_PROJECT, ITaggingService.TaggableType.PROJECT_DEPLOYER_DEPLOYMENT, ITaggingService.TaggableType.CODE_STUDIO_TEMPLATE, ITaggingService.TaggableType.ENTERPRISE_ASSET_COLLECTION, ITaggingService.TaggableType.ENTERPRISE_ASSET -> throw new IllegalArgumentException("TaggableType " + String.valueOf((Object)taggableType) + " is not indexable");
        };
    }

    public static IndexableType getFromTaggableObject(TaggableObjectsService.TaggableObject to) {
        if (to.getTaggableType() == ITaggingService.TaggableType.SAVED_MODEL) {
            return ((SavedModel)to).getIndexableType();
        }
        if (to.getTaggableType() == ITaggingService.TaggableType.MODEL_EVALUATION_STORE) {
            return ((ModelEvaluationStore)to).getIndexableType();
        }
        if (to.getTaggableType() == ITaggingService.TaggableType.MODEL_COMPARISON) {
            return ((ModelComparison)to).getIndexableType();
        }
        return IndexableTypeUtils.getFromTaggableType(to.getTaggableType());
    }

    public static IndexableType getIndexableTypeFromTaggableObjectRef(TaggableObjectsService.TaggableObjectRef tor, SavedModelsDAO savedModelsDAO, ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService, ModelComparisonsCRUDService modelComparisonsCRUDService) throws IOException {
        if (tor.getType() == ITaggingService.TaggableType.SAVED_MODEL) {
            SavedModel sm = (SavedModel)savedModelsDAO.getMandatory(tor.projectKey, tor.id);
            return sm.getIndexableType();
        }
        if (tor.getType() == ITaggingService.TaggableType.MODEL_EVALUATION_STORE) {
            ModelEvaluationStore mes = modelEvaluationStoresCRUDService.getMandatory(tor.projectKey, tor.id);
            return mes.getIndexableType();
        }
        if (tor.getType() == ITaggingService.TaggableType.MODEL_COMPARISON) {
            ModelComparison mc = modelComparisonsCRUDService.getMandatory(tor.projectKey, tor.id);
            return mc.getIndexableType();
        }
        return IndexableTypeUtils.getFromTaggableType(tor.getType());
    }

    public static List<IndexableType> getPossibleIndexableTypes(ITaggingService.TaggableType taggableType) {
        if (taggableType == ITaggingService.TaggableType.SAVED_MODEL) {
            return List.of(IndexableType.AGENT, IndexableType.GEN_AI_MODEL, IndexableType.SAVED_MODEL);
        }
        if (taggableType == ITaggingService.TaggableType.MODEL_EVALUATION_STORE) {
            return List.of(IndexableType.MODEL_EVALUATION_STORE, IndexableType.GENAI_EVALUATION_STORE);
        }
        if (taggableType == ITaggingService.TaggableType.MODEL_COMPARISON) {
            return List.of(IndexableType.MODEL_COMPARISON, IndexableType.GENAI_COMPARISON);
        }
        return List.of(IndexableTypeUtils.getFromTaggableType(taggableType));
    }
}

