/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.model;

import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.variables.VariablesContext;
import org.apache.log4j.Logger;

public class ProcessorScriptStep
extends ScriptStep {
    private static final long serialVersionUID = -1L;
    public String type;
    public StepParams params;
    private static final Logger logger = Logger.getLogger((String)"dku.processorscriptstep");

    public ProcessorScriptStep() {
    }

    private ProcessorScriptStep(String type) {
        this.type = type;
    }

    public static ProcessorScriptStep ofType(ProcessorMeta<?, ?> processorMeta) {
        return new ProcessorScriptStep(processorMeta.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorScriptStep that = (ProcessorScriptStep)o;
        if (this.disabled != that.disabled) {
            return false;
        }
        if (this.preview != that.preview) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.preview ? 1 : 0);
        result = 31 * result + (this.disabled ? 1 : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public ProcessorScriptStep withParams(StepParams params) {
        this.params = params;
        return this;
    }

    public ProcessorScriptStep withPreview(boolean preview) {
        this.preview = preview;
        return this;
    }

    @Override
    public ScriptStep expand(VariablesContext vc, int i) {
        ProcessorScriptStep step = (ProcessorScriptStep)super.expand(vc, i);
        if (step.params != null) {
            try {
                ProcessorMeta<?, ?> meta = BaseProcessorsFactory.getMeta(this);
                step.params = meta.expandParams(step.params, vc);
            }
            catch (Exception e) {
                logger.warn((Object)"Cannot expand step : unknown type", (Throwable)e);
            }
        }
        return step;
    }

    public RecipeLineage getUpdatedRecipeLineage(RecipeLineage previousRecipeLineage) {
        try {
            ProcessorMeta<?, ?> meta = BaseProcessorsFactory.getMeta(this);
            this.params.validate();
            return meta.getUpdatedRecipeLineage(this, previousRecipeLineage);
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Prepare recipe: Failed to update column relations for step '%s': %s", this.type, e.getMessage()));
            previousRecipeLineage.setUncertain(true);
            return previousRecipeLineage;
        }
    }
}

