/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SchemaValidator;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.input.formats.hive.HiveFileFormatConfig;
import com.dataiku.dip.input.formats.hive.SerdeAccessUtils;
import com.dataiku.dip.input.formats.hive.SerdeVisitor;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatConfig;
import com.dataiku.dip.input.formats.hive.serde.ObjectInspectorBuilder;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;

public class HiveOutputFormatAdapter
extends FileOutputFormat<Void, RowWithFactories> {
    private final DKULogger logger = DKULogger.getLogger(HiveOutputFormatAdapter.class);
    private final DatasetConfig outputConf;
    private final HiveOutputFormat<? extends Writable, ? extends Writable> outputFormat;
    private final HiveFileFormatConfig formatParams;
    private final Schema outputSchema;
    private final String outputFileExtension;
    private final WarningsContext warningsContext;
    private final SerdeAccessUtils serdeAccessUtils;

    public HiveOutputFormatAdapter(DatasetConfig outputConf, WarningsContext warningsContext) {
        this.formatParams = (HiveFileFormatConfig)outputConf.dataset.getFormatParams();
        this.outputConf = outputConf;
        this.outputSchema = outputConf.dataset.getSchema();
        this.outputFormat = this.createOutputFormat();
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
        this.outputFileExtension = this.getFileExtension();
        this.serdeAccessUtils = new SerdeAccessUtils();
    }

    private HiveOutputFormat<? extends Writable, ? extends Writable> createOutputFormat() {
        if (this.formatParams instanceof RCFileFormatConfig) {
            return new RCFileOutputFormat();
        }
        if (this.formatParams instanceof ORCFileFormatConfig) {
            return new OrcOutputFormat();
        }
        if (this.formatParams instanceof SequenceFileFormatConfig) {
            return new HiveSequenceFileOutputFormat();
        }
        throw new RuntimeException("Unsupported format config : " + this.formatParams.getClass().getName());
    }

    private String getFileExtension() {
        if (this.formatParams instanceof RCFileFormatConfig) {
            return ".rc";
        }
        if (this.formatParams instanceof ORCFileFormatConfig) {
            ORCFileFormatConfig orcConfig = (ORCFileFormatConfig)this.formatParams;
            if (orcConfig.compressionMethod == ORCFileFormatConfig.CompressionMethod.SNAPPY) {
                return ".snappy.orc";
            }
            if (orcConfig.compressionMethod == ORCFileFormatConfig.CompressionMethod.ZLIB) {
                return ".gz.orc";
            }
            return ".orc";
        }
        if (this.formatParams instanceof SequenceFileFormatConfig) {
            return ".seq";
        }
        throw new RuntimeException("Unsupported format config : " + this.formatParams.getClass().getName());
    }

    public RecordWriter<Void, RowWithFactories> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        new SchemaValidator().validate(this.outputSchema);
        return new InternalRecordWriter(taskAttemptContext);
    }

    private class InternalRecordWriter
    extends RecordWriter<Void, RowWithFactories> {
        private final TaskAttemptContext taskAttemptContext;
        private boolean initialized = false;
        private Object serde;
        private StructObjectInspector rowInspector;
        private FileSinkOperator.RecordWriter recordWriter;

        public InternalRecordWriter(TaskAttemptContext taskAttemptContext) {
            this.taskAttemptContext = taskAttemptContext;
        }

        public void write(Void aVoid, RowWithFactories mrRow) throws IOException, InterruptedException {
            this.lazyInit(mrRow);
            Writable writable = null;
            try {
                if (HiveOutputFormatAdapter.this.formatParams instanceof ORCFileFormatConfig) {
                    SerdeVisitor.inspectObject(mrRow.getRow(), (ObjectInspector)this.rowInspector);
                }
                writable = HiveOutputFormatAdapter.this.serdeAccessUtils.serialize(this.serde, mrRow.getRow(), (ObjectInspector)this.rowInspector);
            }
            catch (Exception e) {
                HiveOutputFormatAdapter.this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_TYPE, "Unable to write row (" + e.getMessage() + ")", (Throwable)e, HiveOutputFormatAdapter.this.logger);
            }
            if (writable != null) {
                this.recordWriter.write(writable);
            }
        }

        private void lazyInit(RowWithFactories mrRow) throws IOException {
            if (!this.initialized) {
                Object serdeObj;
                this.initialized = true;
                Object cf = mrRow == null ? new StreamColumnFactory() : mrRow.getColumnFactory();
                String serdeClass = HiveOutputFormatAdapter.this.formatParams.getSerdeClass();
                try {
                    serdeObj = Class.forName(serdeClass).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to load Hive SerDe: " + serdeClass, e);
                }
                if (!HiveOutputFormatAdapter.this.serdeAccessUtils.isSerde(serdeObj)) {
                    throw new RuntimeException("Class " + serdeClass + " is not a Hive SerDe.");
                }
                this.serde = serdeObj;
                Properties tableProperties = new Properties();
                tableProperties.putAll((Map<?, ?>)HiveOutputFormatAdapter.this.formatParams.getSerdeProperties());
                tableProperties.putAll((Map<?, ?>)HiveOutputFormatAdapter.this.formatParams.getTableProperties());
                String colNames = Joiner.on((String)",").join((Iterable)FluentIterable.from((Iterable)HiveOutputFormatAdapter.this.outputSchema.getColumns()).transform((Function)new Function<SchemaColumn, Object>(){

                    public Object apply(SchemaColumn schemaColumn) {
                        return schemaColumn.getName().toLowerCase();
                    }
                }));
                ObjectInspectorBuilder inspectorBuilder = new ObjectInspectorBuilder();
                this.rowInspector = inspectorBuilder.buildRowInspector((ColumnFactory)cf, HiveOutputFormatAdapter.this.outputSchema);
                HiveOutputFormatAdapter.this.logger.info((Object)("Hive row type: " + this.rowInspector.getTypeName()));
                String colTypes = ObjectInspectorUtils.getFieldTypes((StructObjectInspector)this.rowInspector);
                tableProperties.setProperty("columns.types", colTypes);
                tableProperties.setProperty("columns", colNames);
                try {
                    HiveOutputFormatAdapter.this.serdeAccessUtils.initialize(this.serde, new Configuration(), tableProperties);
                }
                catch (SerDeException e) {
                    throw new IOException(e.getMessage(), e);
                }
                Progressable progressable = new Progressable(){

                    public void progress() {
                    }
                };
                JobConf conf = new JobConf(this.taskAttemptContext.getConfiguration());
                Path workPath = HiveOutputFormatAdapter.this.getDefaultWorkFile(this.taskAttemptContext, HiveOutputFormatAdapter.this.outputFileExtension);
                HiveOutputFormatAdapter.this.logger.info((Object)("Work file : " + String.valueOf(workPath)));
                org.apache.hadoop.mapred.FileOutputFormat.setOutputPath((JobConf)conf, (Path)workPath);
                this.recordWriter = HiveOutputFormatAdapter.this.outputFormat.getHiveRecordWriter(conf, workPath, HiveOutputFormatAdapter.this.serdeAccessUtils.getSerializedClass(this.serde), true, tableProperties, progressable);
            }
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.lazyInit(null);
            this.recordWriter.close(false);
        }
    }
}

